/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.async.api.EventHandler;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.config.NodesStore;
import com.tc.config.ReloadConfigChangeContext;
import com.tc.config.TopologyChangeListener;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.exception.TCRuntimeException;
import com.tc.exception.TCShutdownServerException;
import com.tc.l2.L2DebugLogging;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.operatorevent.OperatorEventsNodeConnectionListener;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.SecurityInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.DefaultZapNodeRequestProcessor;
import com.tc.net.groups.DiscoveryStateMachine;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.GroupMessage;
import com.tc.net.groups.GroupMessageListener;
import com.tc.net.groups.GroupResponse;
import com.tc.net.groups.GroupZapNodeMessage;
import com.tc.net.groups.GroupZapNodeMessageFactory;
import com.tc.net.groups.MessageID;
import com.tc.net.groups.Node;
import com.tc.net.groups.RouteGroupMessagesToSink;
import com.tc.net.groups.TCGroupHandshakeMessage;
import com.tc.net.groups.TCGroupMember;
import com.tc.net.groups.TCGroupMemberDiscovery;
import com.tc.net.groups.TCGroupMemberDiscoveryStatic;
import com.tc.net.groups.TCGroupMemberImpl;
import com.tc.net.groups.TCGroupMessageWrapper;
import com.tc.net.groups.ZapNodeRequestProcessor;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.L2ReconnectConfigImpl;
import com.tc.net.protocol.delivery.OOONetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelEventType;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.HydrateHandler;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.NullMessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.DefaultConnectionIdFactory;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.HealthCheckerConfigImpl;
import com.tc.net.protocol.transport.NullConnectionPolicy;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForGroupComm;
import com.tc.net.utils.L2Utils;
import com.tc.object.config.schema.L2Config;
import com.tc.object.session.SessionManagerImpl;
import com.tc.object.session.SessionProvider;
import com.tc.objectserver.handler.ReceiveGroupMessageHandler;
import com.tc.objectserver.handler.TCGroupHandshakeMessageHandler;
import com.tc.objectserver.handler.TCGroupMemberDiscoveryHandler;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SimpleSequence;
import com.tc.util.version.Version;
import com.tc.util.version.VersionCompatibility;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class TCGroupManagerImpl
implements GroupManager<AbstractGroupMessage>,
ChannelManagerEventListener,
TopologyChangeListener {
    private static final TCLogger logger = TCLogging.getLogger(TCGroupManagerImpl.class);
    public static final String HANDSHAKE_STATE_MACHINE_TAG = "TcGroupCommHandshake";
    private final ReconnectConfig l2ReconnectConfig;
    private final String version;
    private final TCSecurityManager securityManager;
    private final ServerID thisNodeID;
    private final int groupPort;
    private final ConnectionPolicy connectionPolicy;
    private final CopyOnWriteArrayList<GroupEventsListener> groupListeners = new CopyOnWriteArrayList();
    private final Map<String, GroupMessageListener<? extends GroupMessage>> messageListeners = new ConcurrentHashMap<String, GroupMessageListener<? extends GroupMessage>>();
    private final Map<MessageID, GroupResponse<AbstractGroupMessage>> pendingRequests = new ConcurrentHashMap<MessageID, GroupResponse<AbstractGroupMessage>>();
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final ConcurrentHashMap<MessageChannel, ServerID> channelToNodeID = new ConcurrentHashMap();
    private final ConcurrentHashMap<ServerID, TCGroupMember> members = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TCGroupMember> nodenameToMembers = new ConcurrentHashMap();
    private final Timer handshakeTimer = new Timer("TC Group Manager Handshake timer", true);
    private final Set<NodeID> zappedSet = Collections.synchronizedSet(new HashSet());
    private final StageManager stageManager;
    private final boolean isUseOOOLayer;
    private final AtomicBoolean alreadyJoined = new AtomicBoolean(false);
    private final WeightGeneratorFactory weightGeneratorFactory;
    private CommunicationsManager communicationsManager;
    private NetworkListener groupListener;
    private TCGroupMemberDiscovery discover;
    private ZapNodeRequestProcessor zapNodeRequestProcessor = new DefaultZapNodeRequestProcessor(logger);
    private Stage<HydrateContext> hydrateStage;
    private Stage<TCGroupMessageWrapper> receiveGroupMessageStage;
    private Stage<TCGroupHandshakeMessage> handshakeMessageStage;
    private Stage<DiscoveryStateMachine> discoveryStage;

    public TCGroupManagerImpl(L2ConfigurationSetupManager configSetupManager, StageManager stageManager, ServerID thisNodeID, Node thisNode, NodesStore nodesStore, TCSecurityManager securityManager, WeightGeneratorFactory weightGenerator) {
        this(configSetupManager, (ConnectionPolicy)new NullConnectionPolicy(), stageManager, thisNodeID, thisNode, nodesStore, securityManager, weightGenerator);
    }

    public TCGroupManagerImpl(L2ConfigurationSetupManager configSetupManager, ConnectionPolicy connectionPolicy, StageManager stageManager, ServerID thisNodeID, Node thisNode, NodesStore nodesStore, TCSecurityManager securityManager, WeightGeneratorFactory weightGenerator) {
        TCSocketAddress socketAddress;
        this.connectionPolicy = connectionPolicy;
        this.stageManager = stageManager;
        this.thisNodeID = thisNodeID;
        this.securityManager = securityManager;
        this.l2ReconnectConfig = new L2ReconnectConfigImpl();
        this.isUseOOOLayer = this.l2ReconnectConfig.getReconnectEnabled();
        this.version = this.getVersion();
        L2Config l2DSOConfig = configSetupManager.dsoL2Config();
        this.groupPort = l2DSOConfig.tsaGroupPort().getValue();
        this.weightGeneratorFactory = weightGenerator;
        try {
            int groupConnectPort = this.groupPort;
            groupConnectPort = TCPropertiesImpl.getProperties().getInt("l2.nha.tcgroupcomm.l2proxytoport", this.groupPort);
            socketAddress = new TCSocketAddress(l2DSOConfig.tsaGroupPort().getBind(), groupConnectPort);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException((Throwable)e);
        }
        this.init(socketAddress);
        Assert.assertNotNull((Object)thisNodeID);
        this.setDiscover(new TCGroupMemberDiscoveryStatic(this, thisNode));
        nodesStore.registerForTopologyChange(this);
        this.registerForGroupEvents(new OperatorEventsNodeConnectionListener(nodesStore));
    }

    protected String getVersion() {
        return ProductInfo.getInstance().version();
    }

    @Override
    public boolean isNodeConnected(NodeID sid) {
        TCGroupMember m = this.members.get(sid);
        return m != null && m.getChannel().isOpen();
    }

    public TCGroupManagerImpl(ConnectionPolicy connectionPolicy, String hostname, int port, int groupPort, StageManager stageManager, TCSecurityManager securityManager, WeightGeneratorFactory weightGenerator) {
        this.connectionPolicy = connectionPolicy;
        this.stageManager = stageManager;
        this.securityManager = securityManager;
        this.l2ReconnectConfig = new L2ReconnectConfigImpl();
        this.isUseOOOLayer = this.l2ReconnectConfig.getReconnectEnabled();
        this.groupPort = groupPort;
        this.version = this.getVersion();
        this.weightGeneratorFactory = weightGenerator;
        this.thisNodeID = new ServerID(new Node(hostname, port).getServerNodeName(), UUID.getUUID().toString().getBytes());
        logger.info((Object)("Creating server nodeID: " + this.thisNodeID));
        this.init(new TCSocketAddress(TCSocketAddress.WILDCARD_ADDR, groupPort));
    }

    private void init(TCSocketAddress socketAddress) {
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        this.createTCGroupManagerStages();
        NetworkStackHarnessFactory networkStackHarnessFactory = this.getNetworkStackHarnessFactory();
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        this.initMessageRouter((TCMessageRouter)messageRouter);
        HashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        this.initMessageTypeClassMapping(messageTypeClassMapping);
        this.communicationsManager = new CommunicationsManagerImpl("L2_L2", (MessageMonitor)new NullMessageMonitor(), (TCMessageRouter)messageRouter, networkStackHarnessFactory, this.connectionPolicy, L2Utils.getOptimalCommWorkerThreads(), (HealthCheckerConfig)new HealthCheckerConfigImpl(tcProperties.getPropertiesFor("l2.healthcheck.l2"), "TCGroupManager"), this.thisNodeID, (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForGroupComm(), messageTypeClassMapping, Collections.emptyMap(), this.securityManager);
        this.groupListener = this.communicationsManager.createListener(socketAddress, true, (ConnectionIDFactory)new DefaultConnectionIdFactory());
        this.groupListener.getChannelManager().addEventListener((ChannelManagerEventListener)this);
        this.registerForMessages(GroupZapNodeMessage.class, new ZapNodeRequestRouter());
    }

    private NetworkStackHarnessFactory getNetworkStackHarnessFactory() {
        if (this.isUseOOOLayer) {
            return new OOONetworkStackHarnessFactory((OnceAndOnlyOnceProtocolNetworkLayerFactory)new OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl(), this.l2ReconnectConfig);
        }
        return new PlainNetworkStackHarnessFactory();
    }

    private void createTCGroupManagerStages() {
        int maxStageSize = 5000;
        this.hydrateStage = this.stageManager.createStage("group_hydrate_message_stage", HydrateContext.class, (EventHandler)new HydrateHandler(), 1, maxStageSize);
        this.receiveGroupMessageStage = this.stageManager.createStage("receive_group_message_stage", TCGroupMessageWrapper.class, (EventHandler)new ReceiveGroupMessageHandler(this), 1, maxStageSize);
        this.handshakeMessageStage = this.stageManager.createStage("group_handshake_message_stage", TCGroupHandshakeMessage.class, (EventHandler)new TCGroupHandshakeMessageHandler(this), 1, maxStageSize);
        this.discoveryStage = this.stageManager.createStage("group_discovery_stage", DiscoveryStateMachine.class, (EventHandler)new TCGroupMemberDiscoveryHandler(this), 1, maxStageSize);
    }

    private Map<TCMessageType, Class<? extends TCMessage>> initMessageTypeClassMapping(Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping) {
        messageTypeClassMapping.put(TCMessageType.GROUP_HANDSHAKE_MESSAGE, TCGroupHandshakeMessage.class);
        messageTypeClassMapping.put(TCMessageType.GROUP_WRAPPER_MESSAGE, TCGroupMessageWrapper.class);
        return messageTypeClassMapping;
    }

    private void initMessageRouter(TCMessageRouter messageRouter) {
        messageRouter.routeMessageType(TCMessageType.GROUP_WRAPPER_MESSAGE, this.receiveGroupMessageStage.getSink(), this.hydrateStage.getSink());
        messageRouter.routeMessageType(TCMessageType.GROUP_HANDSHAKE_MESSAGE, this.handshakeMessageStage.getSink(), this.hydrateStage.getSink());
    }

    protected Sink<DiscoveryStateMachine> getDiscoveryHandlerSink() {
        return this.discoveryStage.getSink();
    }

    private void handshake(MessageChannel channel) {
        this.getOrCreateHandshakeStateMachine(channel);
    }

    public void receivedHandshake(TCGroupHandshakeMessage msg) {
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("Received group handshake message from " + msg.getChannel());
        }
        MessageChannel channel = msg.getChannel();
        Assert.assertNotNull((Object)channel);
        TCGroupHandshakeStateMachine stateMachine = this.getOrCreateHandshakeStateMachine(channel);
        stateMachine.execute(msg);
    }

    @Override
    public NodeID getLocalNodeID() {
        return this.getNodeID();
    }

    private ServerID getNodeID() {
        return this.thisNodeID;
    }

    private void membersClear() {
        this.members.clear();
        this.nodenameToMembers.clear();
    }

    private void membersAdd(TCGroupMember member) {
        ServerID nodeID = member.getPeerNodeID();
        this.members.put(nodeID, member);
        this.nodenameToMembers.put(nodeID.getName(), member);
    }

    private void membersRemove(TCGroupMember member) {
        ServerID nodeID = member.getPeerNodeID();
        this.members.remove(nodeID);
        this.nodenameToMembers.remove(nodeID.getName());
    }

    private void removeIfMemberReconnecting(ServerID newNodeID) {
        MessageChannel channel;
        TCGroupMember oldMember = this.nodenameToMembers.get(newNodeID.getName());
        if (oldMember != null && oldMember.getPeerNodeID() != newNodeID && !(channel = oldMember.getChannel()).isConnected()) {
            this.closeMember(oldMember);
            logger.warn((Object)("Removed old member " + oldMember + " for " + newNodeID));
        }
    }

    public void stop(long timeout) throws TCTimeoutException {
        this.isStopped.set(true);
        this.stageManager.stopAll();
        this.discover.stop(timeout);
        this.groupListener.stop(timeout);
        this.communicationsManager.shutdown();
        for (TCGroupMember m : this.members.values()) {
            this.notifyAnyPendingRequests(m);
        }
        this.membersClear();
        this.channelToNodeID.clear();
    }

    public boolean isStopped() {
        return this.isStopped.get();
    }

    @Override
    public void registerForGroupEvents(GroupEventsListener listener) {
        this.groupListeners.add(listener);
    }

    private void fireNodeEvent(TCGroupMember member, boolean joined) {
        ServerID newNode = member.getPeerNodeID();
        member.setReady(joined);
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("fireNodeEvent: joined = " + joined + ", node = " + newNode + ", channel: " + member.getChannel());
        }
        for (GroupEventsListener listener : this.groupListeners) {
            if (joined) {
                listener.nodeJoined((NodeID)newNode);
                continue;
            }
            listener.nodeLeft((NodeID)newNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddMember(TCGroupMember member) {
        if (this.isStopped.get()) {
            this.closeMember(member);
            return false;
        }
        ConcurrentHashMap<ServerID, TCGroupMember> concurrentHashMap = this.members;
        synchronized (concurrentHashMap) {
            if (null != this.members.get(member.getPeerNodeID())) {
                return false;
            }
            member.setTCGroupManager(this);
            this.membersAdd(member);
        }
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo(this.getNodeID() + " added " + member);
        }
        return true;
    }

    @Override
    public NodeID join(Node thisNode, NodesStore nodesStore) throws GroupException {
        Assert.assertNotNull((Object)thisNode);
        if (!this.alreadyJoined.compareAndSet(false, true)) {
            throw new GroupException("Already Joined");
        }
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("Starting discover... thisNode: " + thisNode + ", otherNodes: " + Arrays.asList(nodesStore.getAllNodes()));
        }
        this.discover.setupNodes(thisNode, nodesStore.getAllNodes());
        this.discover.start();
        try {
            this.groupListener.start(new HashSet());
        }
        catch (IOException e) {
            throw new GroupException(e);
        }
        return this.getNodeID();
    }

    @Override
    public void topologyChanged(ReloadConfigChangeContext reloadContext) {
        for (Node nodeAdded : reloadContext.getNodesAdded()) {
            this.discover.addNode(nodeAdded);
        }
        for (Node nodeRemoved : reloadContext.getNodesRemoved()) {
            this.discover.removeNode(nodeRemoved);
        }
    }

    @Override
    public void closeMember(ServerID serverID) {
        TCGroupMember member = this.getMember((NodeID)serverID);
        if (member != null) {
            logger.info((Object)("Closing down member for " + serverID + " - " + member));
            this.closeMember(member);
        } else {
            logger.warn((Object)("Closing down member for " + serverID + " - member doesn't exist."));
        }
    }

    private void closeMember(TCGroupMember member) {
        Assert.assertNotNull((Object)member);
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("Closing member: " + member);
        }
        if (this.isStopped.get()) {
            this.shutdownMember(member);
            return;
        }
        member.setTCGroupManager(null);
        TCGroupMember m = this.members.get(member.getPeerNodeID());
        if (m != null && m.getChannel() == member.getChannel()) {
            this.membersRemove(member);
            if (member.isJoinedEventFired()) {
                this.fireNodeEvent(member, false);
            }
            member.setJoinedEventFired(false);
            this.notifyAnyPendingRequests(member);
        }
        this.shutdownMember(member);
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo(this.getNodeID() + " removed " + member);
        }
    }

    private void shutdownMember(TCGroupMember member) {
        member.setReady(false);
        this.removeChannelFromNodeIDMap(member.getChannel());
        member.close();
    }

    private void removeChannelFromNodeIDMap(MessageChannel channel) {
        this.channelToNodeID.remove(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAnyPendingRequests(TCGroupMember member) {
        Map<MessageID, GroupResponse<AbstractGroupMessage>> map = this.pendingRequests;
        synchronized (map) {
            for (GroupResponse<AbstractGroupMessage> groupResponse : this.pendingRequests.values()) {
                GroupResponseImpl response = (GroupResponseImpl)groupResponse;
                response.notifyMemberDead(member);
            }
        }
    }

    @Override
    public void sendAll(AbstractGroupMessage msg) {
        this.sendAll(msg, (Set<? extends NodeID>)this.members.keySet());
    }

    @Override
    public void sendAll(AbstractGroupMessage msg, Set<? extends NodeID> nodeIDs) {
        boolean debug = msg instanceof L2StateMessage;
        for (TCGroupMember m : this.members.values()) {
            if (!nodeIDs.contains(m.getPeerNodeID())) {
                if (!debug || !TCGroupManagerImpl.isDebugLogging()) continue;
                TCGroupManagerImpl.debugInfo("Not sending msg to " + m.getPeerNodeID() + ", " + msg + ", channel: " + m.getChannel());
                continue;
            }
            if (m.isReady()) {
                if (debug && TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugInfo("Sending msg to " + m.getPeerNodeID() + ", " + msg + ", channel: " + m.getChannel());
                }
                m.sendIgnoreNotReady(msg);
                continue;
            }
            logger.warn((Object)("Ignored sending msg to a not ready member=" + m + ", msg=" + msg));
        }
    }

    @Override
    public void sendTo(NodeID node, AbstractGroupMessage msg) throws GroupException {
        Runnable sentCallback = null;
        this.internalSendTo(node, msg, sentCallback);
    }

    @Override
    public void sendToWithSentCallback(NodeID node, AbstractGroupMessage msg, Runnable sentCallback) throws GroupException {
        this.internalSendTo(node, msg, sentCallback);
    }

    private void internalSendTo(NodeID node, AbstractGroupMessage msg, Runnable sentCallback) throws GroupException {
        TCGroupMember member = this.getMember(node);
        if (member != null && member.isReady()) {
            if (msg instanceof L2StateMessage && TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("Sending msg to " + node + ", msg: " + msg + ", channel: " + member.getChannel());
            }
        } else {
            throw new GroupException("Send to " + (member == null ? "non-exist" : "not ready") + " member of " + node);
        }
        member.send(msg, sentCallback);
    }

    @Override
    public AbstractGroupMessage sendToAndWaitForResponse(NodeID nodeID, AbstractGroupMessage msg) throws GroupException {
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("Sending to " + nodeID + " and Waiting for Response : " + msg.getMessageID());
        }
        GroupResponseImpl groupResponse = new GroupResponseImpl(this);
        MessageID msgID = msg.getMessageID();
        TCGroupMember m = this.getMember(nodeID);
        if (m == null || !m.isReady()) {
            String errorMsg = "Node " + nodeID + " not present in the group. Ignoring Message : " + msg;
            logger.error((Object)errorMsg);
            throw new GroupException(errorMsg);
        }
        GroupResponse<AbstractGroupMessage> old = this.pendingRequests.put(msgID, groupResponse);
        Assert.assertNull(old);
        groupResponse.sendTo(m, msg);
        groupResponse.waitForResponses(this.getNodeID());
        this.pendingRequests.remove(msgID);
        return groupResponse.getResponse(nodeID);
    }

    @Override
    public GroupResponse<AbstractGroupMessage> sendAllAndWaitForResponse(AbstractGroupMessage msg) throws GroupException {
        return this.sendAllAndWaitForResponse(msg, (Set<? extends NodeID>)this.members.keySet());
    }

    @Override
    public GroupResponse<AbstractGroupMessage> sendAllAndWaitForResponse(AbstractGroupMessage msg, Set<? extends NodeID> nodeIDs) throws GroupException {
        if (TCGroupManagerImpl.isDebugLogging()) {
            TCGroupManagerImpl.debugInfo("Sending to ALL and Waiting for Response : " + msg.getMessageID());
        }
        GroupResponseImpl groupResponse = new GroupResponseImpl(this);
        MessageID msgID = msg.getMessageID();
        GroupResponse<AbstractGroupMessage> old = this.pendingRequests.put(msgID, groupResponse);
        Assert.assertNull(old);
        groupResponse.sendAll(msg, nodeIDs);
        groupResponse.waitForResponses(this.getNodeID());
        this.pendingRequests.remove(msgID);
        return groupResponse;
    }

    private void openChannel(ConnectionInfo info, ChannelEventListener listener, String username, char[] password) throws TCTimeoutException, UnknownHostException, MaxConnectionsExceededException, IOException, CommStackMismatchException {
        if (this.isStopped.get()) {
            return;
        }
        SessionManagerImpl sessionProvider = new SessionManagerImpl(new SessionManagerImpl.SequenceFactory(){

            public Sequence newSequence() {
                return new SimpleSequence();
            }
        });
        this.communicationsManager.addClassMapping(TCMessageType.GROUP_WRAPPER_MESSAGE, TCGroupMessageWrapper.class);
        this.communicationsManager.addClassMapping(TCMessageType.GROUP_HANDSHAKE_MESSAGE, TCGroupHandshakeMessage.class);
        ClientMessageChannel channel = this.communicationsManager.createClientChannel((SessionProvider)sessionProvider, 0, 10000, false);
        channel.addListener(listener);
        channel.open(Collections.singleton(info), username, password);
        this.handshake((MessageChannel)channel);
    }

    public void openChannel(String hostname, int port, ChannelEventListener listener) throws TCTimeoutException, UnknownHostException, MaxConnectionsExceededException, IOException, CommStackMismatchException {
        char[] password;
        SecurityInfo securityInfo;
        String username;
        String string = username = this.securityManager == null ? null : this.securityManager.getIntraL2Username();
        if (this.isSecured()) {
            securityInfo = new SecurityInfo(true, this.securityManager.getIntraL2Username());
            password = this.securityManager.getPasswordForTC(securityInfo.getUsername(), hostname, port);
        } else {
            password = null;
            securityInfo = new SecurityInfo();
        }
        this.openChannel(new ConnectionInfo(hostname, port, securityInfo), listener, username, password);
    }

    private boolean isSecured() {
        return this.securityManager != null;
    }

    public void channelCreated(MessageChannel aChannel) {
        if (this.isStopped.get()) {
            aChannel.close();
            return;
        }
        this.handshake(aChannel);
    }

    public void channelRemoved(MessageChannel channel) {
        TCGroupHandshakeStateMachine stateMachine = this.getHandshakeStateMachine(channel);
        if (stateMachine != null) {
            stateMachine.disconnected();
        }
    }

    void receivedNodeID(MessageChannel channel, ServerID nodeID) {
        this.channelToNodeID.put(channel, nodeID);
    }

    private TCGroupMember getMember(MessageChannel channel) {
        ServerID nodeID = this.channelToNodeID.get(channel);
        if (nodeID == null) {
            return null;
        }
        TCGroupMember m = this.members.get(nodeID);
        return m != null && m.getChannel() == channel ? m : null;
    }

    private TCGroupMember getMember(NodeID nodeID) {
        return this.members.get(nodeID);
    }

    public Collection<TCGroupMember> getMembers() {
        return Collections.unmodifiableCollection(this.members.values());
    }

    public void setDiscover(TCGroupMemberDiscovery discover) {
        this.discover = discover;
    }

    public TCGroupMemberDiscovery getDiscover() {
        return this.discover;
    }

    public Timer getHandshakeTimer() {
        return this.handshakeTimer;
    }

    public void shutdown() {
        try {
            this.stop(1000L);
        }
        catch (TCTimeoutException e) {
            logger.warn((Object)("Timeout at shutting down " + (Object)((Object)e)));
        }
    }

    int size() {
        return this.members.size();
    }

    public void messageReceived(AbstractGroupMessage message, MessageChannel channel) {
        if (this.isStopped.get()) {
            channel.close();
            return;
        }
        TCGroupMember m = this.getMember(channel);
        if (channel.isClosed()) {
            logger.warn((Object)(this.getNodeID() + " recd msg " + message.getMessageID() + " From closed " + channel + " Msg : " + message));
            return;
        }
        if (m == null) {
            TCGroupHandshakeStateMachine stateMachine = this.getHandshakeStateMachine(channel);
            String errInfo = "Received message for non-exist member from " + channel.getRemoteAddress() + " to " + channel.getLocalAddress() + "; Node: " + this.channelToNodeID.get(channel) + "; " + stateMachine + "; msg: " + message;
            if (stateMachine != null && stateMachine.isFailureState()) {
                logger.warn((Object)errInfo);
                return;
            }
            throw new RuntimeException(errInfo);
        }
        ServerID from = m.getPeerNodeID();
        MessageID requestID = message.inResponseTo();
        message.setMessageOrginator((NodeID)from);
        if (requestID.isNull() || !this.notifyPendingRequests(requestID, message, from)) {
            this.fireMessageReceivedEvent(from, (GroupMessage)message);
        }
    }

    private boolean notifyPendingRequests(MessageID requestID, AbstractGroupMessage gmsg, ServerID nodeID) {
        GroupResponseImpl response = (GroupResponseImpl)this.pendingRequests.get(requestID);
        if (response != null) {
            response.addResponseFrom(nodeID, gmsg);
            return true;
        }
        return false;
    }

    private static void validateExternalizableClass(Class<? extends GroupMessage> msgClass) {
        String name = msgClass.getName();
        try {
            Constructor<? extends GroupMessage> cons = msgClass.getDeclaredConstructor(new Class[0]);
            if ((cons.getModifiers() & 1) == 0) {
                throw new AssertionError((Object)(name + " : public no arg constructor not found"));
            }
        }
        catch (NoSuchMethodException ex) {
            throw new AssertionError((Object)(name + " : public no arg constructor not found"));
        }
    }

    @Override
    public <N extends AbstractGroupMessage> void registerForMessages(Class<? extends N> msgClass, GroupMessageListener<N> listener) {
        TCGroupManagerImpl.validateExternalizableClass(msgClass);
        GroupMessageListener<N> prev = this.messageListeners.put(msgClass.getName(), listener);
        if (prev != null) {
            logger.warn((Object)("Previous listener removed : " + prev));
        }
    }

    @Override
    public <N extends AbstractGroupMessage> void routeMessages(Class<? extends N> msgClass, Sink<N> sink) {
        this.registerForMessages(msgClass, new RouteGroupMessagesToSink<N>(msgClass.getName(), sink));
    }

    private void fireMessageReceivedEvent(ServerID from, GroupMessage msg) {
        GroupMessageListener<? extends GroupMessage> listener = this.messageListeners.get(msg.getClass().getName());
        if (listener == null) {
            String errorMsg = "No Route for " + msg + " from " + from;
            errorMsg = errorMsg + " " + msg.getClass().getName() + " " + this.messageListeners.keySet();
            logger.error((Object)errorMsg);
            throw new AssertionError((Object)errorMsg);
        }
        listener.messageReceived((NodeID)from, (GroupMessage)msg);
    }

    @Override
    public void setZapNodeRequestProcessor(ZapNodeRequestProcessor processor) {
        this.zapNodeRequestProcessor = processor;
    }

    @Override
    public void zapNode(NodeID nodeID, int type, String reason) {
        this.zappedSet.add(nodeID);
        TCGroupMember m = this.getMember(nodeID);
        if (m == null) {
            logger.warn((Object)"Ignoring Zap node request since Member is null");
        } else if (!this.zapNodeRequestProcessor.acceptOutgoingZapNodeRequest(nodeID, type, reason)) {
            logger.warn((Object)("Ignoreing Zap node request since " + this.zapNodeRequestProcessor + " asked us to : " + nodeID + " type = " + type + " reason = " + reason));
        } else {
            long[] weights = this.zapNodeRequestProcessor.getCurrentNodeWeights();
            logger.warn((Object)("Zapping node : " + nodeID + " type = " + type + " reason = " + reason + " my weight = " + Arrays.toString(weights)));
            AbstractGroupMessage msg = GroupZapNodeMessageFactory.createGroupZapNodeMessage(type, reason, weights);
            try {
                this.sendTo(nodeID, msg);
            }
            catch (GroupException e) {
                logger.error((Object)("Error sending ZapNode Request to " + nodeID + " msg = " + msg));
            }
        }
    }

    private boolean isZappedNode(NodeID nodeID) {
        return this.zappedSet.contains(nodeID);
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(TCGroupManagerImpl.class.getSimpleName()).append(" [ ");
        strBuffer.append("Channel to NodeId Map: {");
        for (Map.Entry<MessageChannel, ServerID> entry : this.channelToNodeID.entrySet()) {
            strBuffer.append(entry.getKey()).append(" -> ").append(entry.getValue()).append("  ");
        }
        strBuffer.append("}\n\t");
        strBuffer.append("members: {");
        for (Map.Entry<Object, Object> entry : this.members.entrySet()) {
            strBuffer.append(entry.getKey()).append(" -> ").append(entry.getValue()).append("  ");
        }
        strBuffer.append("}\n\t");
        strBuffer.append("zappedSet: {").append(this.zappedSet).append(" ").append("} ]");
        out.indent().print((Object)strBuffer.toString()).flush();
        return out;
    }

    private synchronized TCGroupHandshakeStateMachine getOrCreateHandshakeStateMachine(MessageChannel channel) {
        TCGroupHandshakeStateMachine stateMachine = (TCGroupHandshakeStateMachine)channel.getAttachment(HANDSHAKE_STATE_MACHINE_TAG);
        if (stateMachine == null) {
            if (TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("Creating handshake state machine for channel: " + channel);
            }
            stateMachine = new TCGroupHandshakeStateMachine(this, channel, this.getNodeID(), this.weightGeneratorFactory, this.version);
            channel.addAttachment(HANDSHAKE_STATE_MACHINE_TAG, (Object)stateMachine, false);
            channel.addListener((ChannelEventListener)new HandshakeChannelEventListener(stateMachine));
            stateMachine.start();
        }
        Assert.assertNotNull((Object)stateMachine);
        return stateMachine;
    }

    private synchronized TCGroupHandshakeStateMachine getHandshakeStateMachine(MessageChannel channel) {
        TCGroupHandshakeStateMachine stateMachine = (TCGroupHandshakeStateMachine)channel.getAttachment(HANDSHAKE_STATE_MACHINE_TAG);
        return stateMachine;
    }

    void addZappedNode(NodeID nodeID) {
        this.zappedSet.add(nodeID);
    }

    @Override
    public boolean isServerConnected(String nodeName) {
        return this.discover.isServerConnected(nodeName);
    }

    private static void debugInfo(String message) {
        L2DebugLogging.log(logger, L2DebugLogging.LogLevel.INFO, message, null);
    }

    private static boolean isDebugLogging() {
        return L2DebugLogging.isDebugLogging();
    }

    private static void debugWarn(String message) {
        L2DebugLogging.log(logger, L2DebugLogging.LogLevel.WARN, message, null);
    }

    private static class TCGroupHandshakeStateMachine {
        private final HandshakeState STATE_NODEID = new NodeIDState();
        private final HandshakeState STATE_TRY_ADD_MEMBER = new TryAddMemberState();
        private final HandshakeState STATE_ACK_OK = new AckOkState();
        private final HandshakeState STATE_SUCCESS = new SuccessState();
        private final HandshakeState STATE_FAILURE = new FailureState();
        private static final long HANDSHAKE_TIMEOUT = TCPropertiesImpl.getProperties().getLong("l2.nha.tcgroupcomm.handshake.timeout");
        private final TCGroupManagerImpl manager;
        private final MessageChannel channel;
        private final ServerID localNodeID;
        private final WeightGeneratorFactory weightGeneratorFactory;
        private final String version;
        private HandshakeState current;
        private ServerID peerNodeID;
        private TimerTask timerTask;
        private TCGroupMember member;
        private boolean stateTransitionInProgress;

        public TCGroupHandshakeStateMachine(TCGroupManagerImpl manager, MessageChannel channel, ServerID localNodeID, WeightGeneratorFactory weightGeneratorFactory, String version) {
            this.manager = manager;
            this.channel = channel;
            this.localNodeID = localNodeID;
            this.weightGeneratorFactory = weightGeneratorFactory;
            this.version = version;
            this.stateTransitionInProgress = false;
        }

        public final void start() {
            this.switchToState(this.initialState());
        }

        public synchronized boolean isFailureState() {
            return this.current == this.STATE_FAILURE;
        }

        public void execute(TCGroupHandshakeMessage msg) {
            if (TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("[TCGroupHandshakeStateMachine]: Executing state machine, currentState=" + this.current + ", msg: " + msg + ", channel: " + this.channel);
            }
            this.current.execute(msg);
        }

        protected HandshakeState initialState() {
            return this.STATE_NODEID;
        }

        private String stateInfo(HandshakeState state) {
            String info = " switching to state: " + state + " channel: " + this.channel;
            if (this.member != null) {
                return this.member.toString() + info;
            }
            if (this.peerNodeID == null) {
                return this.localNodeID.toString() + info;
            }
            return this.peerNodeID.toString() + " -> " + this.localNodeID.toString() + info;
        }

        public String toString() {
            return "TCGroupHandshakeStateMachine: " + this.stateInfo(this.current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void switchToState(HandshakeState state) {
            Assert.assertNotNull((Object)state);
            if (TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("[TCGroupHandshakeStateMachine]: Attempting to switch state (" + this.current + "->" + state + "): " + this.stateInfo(state));
            }
            TCGroupHandshakeStateMachine tCGroupHandshakeStateMachine = this;
            synchronized (tCGroupHandshakeStateMachine) {
                if (this.current == this.STATE_FAILURE) {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugWarn("Ignored switching to " + state + " as current is " + this.current + ", " + this.stateInfo(state));
                    }
                    return;
                }
                this.current = state;
                this.waitForStateTransitionToComplete();
                this.stateTransitionInProgress = true;
            }
            if (TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("[TCGroupHandshakeStateMachine]: Entering state: " + state + ", for channel: " + this.channel);
            }
            state.enter();
            this.notifyStateTransitionComplete();
        }

        private synchronized void notifyStateTransitionComplete() {
            this.stateTransitionInProgress = false;
            this.notifyAll();
        }

        private void waitForStateTransitionToComplete() {
            while (this.stateTransitionInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        MessageChannel getChannel() {
            return this.channel;
        }

        private synchronized void setTimerTask(long timeout) {
            TimerTask task;
            this.timerTask = task = new TimerTask(){

                @Override
                public void run() {
                    this.handshakeTimeout();
                }
            };
            Timer timer = this.manager.getHandshakeTimer();
            timer.purge();
            timer.schedule(task, timeout);
        }

        private synchronized void cancelTimerTask() {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handshakeTimeout() {
            this.cancelTimerTask();
            TCGroupHandshakeStateMachine tCGroupHandshakeStateMachine = this;
            synchronized (tCGroupHandshakeStateMachine) {
                if (this.current == this.STATE_SUCCESS) {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Handshake successed. Ignore timeout " + this.stateInfo(this.current));
                    }
                    return;
                }
                logger.warn((Object)("Group member handshake timeout. " + this.stateInfo(this.current)));
            }
            this.switchToState(this.STATE_FAILURE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnected() {
            TCGroupHandshakeStateMachine tCGroupHandshakeStateMachine = this;
            synchronized (tCGroupHandshakeStateMachine) {
                if (TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugWarn("[TCGroupHandshakeStateMachine]: Group member handshake disconnected. " + this.stateInfo(this.current) + ", for channel: " + this.channel);
                }
            }
            this.switchToState(this.STATE_FAILURE);
        }

        private class FailureState
        extends HandshakeState {
            public FailureState() {
                super("Failure");
            }

            @Override
            public void enter() {
                TCGroupHandshakeStateMachine.this.cancelTimerTask();
                if (TCGroupHandshakeStateMachine.this.member != null) {
                    TCGroupHandshakeStateMachine.this.member.abortMemberAdding();
                    TCGroupHandshakeStateMachine.this.manager.closeMember(TCGroupHandshakeStateMachine.this.member);
                } else {
                    TCGroupHandshakeStateMachine.this.manager.removeChannelFromNodeIDMap(TCGroupHandshakeStateMachine.this.channel);
                    TCGroupHandshakeStateMachine.this.channel.close();
                }
            }
        }

        private class SuccessState
        extends HandshakeState {
            public SuccessState() {
                super("Success");
            }

            @Override
            public void enter() {
                TCGroupHandshakeStateMachine.this.cancelTimerTask();
                TCGroupHandshakeStateMachine.this.manager.fireNodeEvent(TCGroupHandshakeStateMachine.this.member, true);
                TCGroupHandshakeStateMachine.this.member.setJoinedEventFired(true);
                if (TCGroupHandshakeStateMachine.this.manager.isZappedNode((NodeID)TCGroupHandshakeStateMachine.this.member.getPeerNodeID())) {
                    logger.info((Object)("Aborting previously zapped node " + TCGroupHandshakeStateMachine.this.member));
                    TCGroupHandshakeStateMachine.this.manager.zapNode((NodeID)TCGroupHandshakeStateMachine.this.member.getPeerNodeID(), 1, "Aborting the zapped node");
                }
            }
        }

        private class AckOkState
        extends HandshakeState {
            public AckOkState() {
                super("Ack-Ok");
            }

            @Override
            public void enter() {
                TCGroupHandshakeStateMachine.this.member.setReady(true);
                TCGroupHandshakeStateMachine.this.member.notifyMemberAdded();
                this.ackOk();
            }

            @Override
            public void execute(TCGroupHandshakeMessage msg) {
                if (msg.isAckMessage()) {
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_SUCCESS);
                } else {
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_FAILURE);
                }
            }

            private void ackOk() {
                TCGroupHandshakeMessage msg = (TCGroupHandshakeMessage)TCGroupHandshakeStateMachine.this.channel.createMessage(TCMessageType.GROUP_HANDSHAKE_MESSAGE);
                if (TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugInfo("Send ack message to " + TCGroupHandshakeStateMachine.this.member);
                }
                msg.initializeAck();
                msg.send();
            }
        }

        private class TryAddMemberState
        extends HandshakeState {
            public TryAddMemberState() {
                super("Try-Add-Member");
            }

            @Override
            public void enter() {
                this.createMember();
                if (TCGroupHandshakeStateMachine.this.member.isHighPriorityNode()) {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Try-Add-Member: Adding high priority member: " + TCGroupHandshakeStateMachine.this.member);
                    }
                    TCGroupHandshakeStateMachine.this.member.memberAddingInProcess();
                    boolean isAdded = TCGroupHandshakeStateMachine.this.manager.tryAddMember(TCGroupHandshakeStateMachine.this.member);
                    if (!isAdded) {
                        TCGroupHandshakeStateMachine.this.member.abortMemberAdding();
                    }
                    this.signalToJoin(isAdded);
                } else if (TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugInfo("Try-Add-Member ignoring member as not high priority: " + TCGroupHandshakeStateMachine.this.member);
                }
            }

            @Override
            public void execute(TCGroupHandshakeMessage msg) {
                boolean isOkToJoin = msg.isOkMessage();
                if (!TCGroupHandshakeStateMachine.this.member.isHighPriorityNode()) {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Try-Add-Member: Adding not-high priority member: " + TCGroupHandshakeStateMachine.this.member);
                    }
                    if (isOkToJoin) {
                        isOkToJoin = TCGroupHandshakeStateMachine.this.manager.tryAddMember(TCGroupHandshakeStateMachine.this.member);
                        if (isOkToJoin) {
                            TCGroupHandshakeStateMachine.this.member.memberAddingInProcess();
                        } else {
                            logger.warn((Object)"Unexpected bad handshake, abort connection.");
                        }
                    }
                    this.signalToJoin(isOkToJoin);
                } else if (TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugInfo("Try-Add-Member not adding member as its highPriority: " + TCGroupHandshakeStateMachine.this.member);
                }
                if (isOkToJoin) {
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_ACK_OK);
                } else {
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_FAILURE);
                }
            }

            private void createMember() {
                Assert.assertNotNull((Object)TCGroupHandshakeStateMachine.this.localNodeID);
                Assert.assertNotNull((Object)TCGroupHandshakeStateMachine.this.peerNodeID);
                TCGroupHandshakeStateMachine.this.member = new TCGroupMemberImpl(TCGroupHandshakeStateMachine.this.localNodeID, TCGroupHandshakeStateMachine.this.peerNodeID, TCGroupHandshakeStateMachine.this.channel);
            }

            private void signalToJoin(boolean ok) {
                Assert.assertNotNull((Object)TCGroupHandshakeStateMachine.this.member);
                TCGroupHandshakeMessage msg = (TCGroupHandshakeMessage)TCGroupHandshakeStateMachine.this.channel.createMessage(TCMessageType.GROUP_HANDSHAKE_MESSAGE);
                if (ok) {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Send ok message to " + TCGroupHandshakeStateMachine.this.member);
                    }
                    msg.initializeOk();
                } else {
                    if (TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Send deny message to " + TCGroupHandshakeStateMachine.this.member);
                    }
                    msg.initializeDeny();
                }
                msg.send();
            }
        }

        private class NodeIDState
        extends HandshakeState {
            public NodeIDState() {
                super("Read-Peer-NodeID");
            }

            @Override
            public void enter() {
                TCGroupHandshakeStateMachine.this.setTimerTask(HANDSHAKE_TIMEOUT);
                this.writeNodeIDMessage();
            }

            @Override
            public void execute(TCGroupHandshakeMessage msg) {
                this.setPeerNodeID(msg);
                if (!new VersionCompatibility().isCompatibleServerServer(new Version(TCGroupHandshakeStateMachine.this.version), new Version(msg.getVersion()))) {
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_FAILURE);
                    if (this.checkWeights(msg)) {
                        logger.error((Object)("Node " + TCGroupHandshakeStateMachine.this.peerNodeID + " has an incompatible version " + msg.getVersion()));
                        return;
                    }
                    throw new TCShutdownServerException("Version incompatible with the rest of the cluster.");
                }
                if (!TCGroupHandshakeStateMachine.this.manager.getDiscover().isValidClusterNode((NodeID)TCGroupHandshakeStateMachine.this.peerNodeID)) {
                    logger.warn((Object)("Drop connection from non-member node " + TCGroupHandshakeStateMachine.this.peerNodeID));
                    TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_FAILURE);
                    return;
                }
                TCGroupHandshakeStateMachine.this.manager.removeIfMemberReconnecting(TCGroupHandshakeStateMachine.this.peerNodeID);
                TCGroupHandshakeStateMachine.this.switchToState(TCGroupHandshakeStateMachine.this.STATE_TRY_ADD_MEMBER);
            }

            void setPeerNodeID(TCGroupHandshakeMessage msg) {
                TCGroupHandshakeStateMachine.this.peerNodeID = msg.getNodeID();
                TCGroupHandshakeStateMachine.this.manager.receivedNodeID(TCGroupHandshakeStateMachine.this.channel, TCGroupHandshakeStateMachine.this.peerNodeID);
            }

            void writeNodeIDMessage() {
                TCGroupHandshakeMessage msg = (TCGroupHandshakeMessage)TCGroupHandshakeStateMachine.this.channel.createMessage(TCMessageType.GROUP_HANDSHAKE_MESSAGE);
                msg.initializeNodeID(TCGroupHandshakeStateMachine.this.localNodeID, TCGroupHandshakeStateMachine.this.version, TCGroupHandshakeStateMachine.this.weightGeneratorFactory.generateWeightSequence());
                if (TCGroupManagerImpl.isDebugLogging()) {
                    TCGroupManagerImpl.debugInfo("Sending group nodeID message to " + TCGroupHandshakeStateMachine.this.channel);
                }
                msg.send();
            }

            boolean checkWeights(TCGroupHandshakeMessage msg) {
                long[] myWeights = TCGroupHandshakeStateMachine.this.weightGeneratorFactory.generateWeightSequence();
                for (int i = 0; i < myWeights.length; ++i) {
                    if (myWeights[i] > msg.getWeights()[i]) {
                        return true;
                    }
                    if (msg.getWeights()[i] <= myWeights[i]) continue;
                    return false;
                }
                return false;
            }
        }

        private abstract class HandshakeState {
            private final String name;

            public HandshakeState(String name) {
                this.name = name;
            }

            public void enter() {
            }

            public void execute(TCGroupHandshakeMessage handshakeMessage) {
            }

            public String toString() {
                return this.name;
            }
        }
    }

    private static class HandshakeChannelEventListener
    implements ChannelEventListener {
        private final TCGroupHandshakeStateMachine stateMachine;

        HandshakeChannelEventListener(TCGroupHandshakeStateMachine stateMachine) {
            this.stateMachine = stateMachine;
        }

        public void notifyChannelEvent(ChannelEvent event) {
            if (event.getChannel() == this.stateMachine.getChannel() && (event.getType() == ChannelEventType.TRANSPORT_DISCONNECTED_EVENT || event.getType() == ChannelEventType.CHANNEL_CLOSED_EVENT)) {
                this.stateMachine.disconnected();
            }
        }
    }

    private final class ZapNodeRequestRouter
    implements GroupMessageListener<GroupZapNodeMessage> {
        private ZapNodeRequestRouter() {
        }

        @Override
        public void messageReceived(NodeID fromNode, GroupZapNodeMessage zapMsg) {
            TCGroupManagerImpl.this.zapNodeRequestProcessor.incomingZapNodeRequest(zapMsg.messageFrom(), zapMsg.getZapNodeType(), zapMsg.getReason(), zapMsg.getWeights());
        }
    }

    private static class GroupResponseImpl
    implements GroupResponse<AbstractGroupMessage> {
        private final Set<ServerID> waitFor = new HashSet<ServerID>();
        private final List<AbstractGroupMessage> responses = new ArrayList<AbstractGroupMessage>();
        private final TCGroupManagerImpl manager;

        GroupResponseImpl(TCGroupManagerImpl manager) {
            this.manager = manager;
        }

        @Override
        public synchronized List<AbstractGroupMessage> getResponses() {
            Assert.assertTrue((boolean)this.waitFor.isEmpty());
            return this.responses;
        }

        @Override
        public synchronized AbstractGroupMessage getResponse(NodeID nodeID) {
            Assert.assertTrue((boolean)this.waitFor.isEmpty());
            for (AbstractGroupMessage msg : this.responses) {
                if (!nodeID.equals(msg.messageFrom())) continue;
                return msg;
            }
            logger.warn((Object)("Missing response message from " + nodeID));
            return null;
        }

        public synchronized void sendTo(TCGroupMember member, AbstractGroupMessage msg) throws GroupException {
            if (!member.isReady()) {
                throw new GroupException("Send to a not ready member " + member);
            }
            Assert.assertNotNull((Object)member.getPeerNodeID());
            this.waitFor.add(member.getPeerNodeID());
            Runnable sentCallback = null;
            member.send(msg, sentCallback);
        }

        public synchronized void sendAll(AbstractGroupMessage msg, Set<? extends NodeID> nodeIDs) {
            boolean debug = msg instanceof L2StateMessage;
            for (TCGroupMember m : this.manager.getMembers()) {
                if (!nodeIDs.contains(m.getPeerNodeID())) {
                    if (!debug || !TCGroupManagerImpl.isDebugLogging()) continue;
                    TCGroupManagerImpl.debugInfo("Not sending msg to " + m.getPeerNodeID() + ", msg: " + msg + ", channel: " + m.getChannel());
                    continue;
                }
                if (m.isReady()) {
                    Assert.assertNotNull((Object)m.getPeerNodeID());
                    this.waitFor.add(m.getPeerNodeID());
                    if (debug && TCGroupManagerImpl.isDebugLogging()) {
                        TCGroupManagerImpl.debugInfo("Sending msg to " + m.getPeerNodeID() + ", msg: " + msg + ", channel: " + m.getChannel());
                    }
                    m.sendIgnoreNotReady(msg);
                    continue;
                }
                logger.warn((Object)("SendAllAndWait to a not ready member " + m));
            }
        }

        public synchronized void addResponseFrom(ServerID nodeID, AbstractGroupMessage gmsg) {
            if (!this.waitFor.remove(nodeID)) {
                String message = "Recd response from a member not in list : " + nodeID + " : waiting For : " + this.waitFor + " msg : " + gmsg;
                logger.error((Object)message);
                throw new AssertionError((Object)message);
            }
            if (gmsg instanceof L2StateMessage && TCGroupManagerImpl.isDebugLogging()) {
                TCGroupManagerImpl.debugInfo("Received msg from: " + nodeID + ", msg: " + gmsg);
            }
            this.responses.add(gmsg);
            this.notifyAll();
        }

        public synchronized void notifyMemberDead(TCGroupMember member) {
            logger.warn((Object)("Remove dead member from waitFor response list, dead member: " + member.getPeerNodeID()));
            this.waitFor.remove(member.getPeerNodeID());
            this.notifyAll();
        }

        public synchronized void waitForResponses(ServerID sender) throws GroupException {
            long start = System.currentTimeMillis();
            while (!this.waitFor.isEmpty() && !this.manager.isStopped()) {
                try {
                    this.wait(5000L);
                    long end = System.currentTimeMillis();
                    if (this.waitFor.isEmpty() || end - start <= 5000L) continue;
                    logger.warn((Object)(sender + " Still waiting for response from " + this.waitFor + ". Waited for " + (end - start) + " ms"));
                }
                catch (InterruptedException e) {
                    throw new GroupException(e);
                }
            }
        }
    }
}

