/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.l2.L2DebugLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.DiscoveryStateMachine;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.Node;
import com.tc.net.groups.TCGroupManagerImpl;
import com.tc.net.groups.TCGroupMemberDiscovery;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.ThreadUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TCGroupMemberDiscoveryStatic
implements TCGroupMemberDiscovery {
    private static final TCLogger logger = TCLogging.getLogger(TCGroupMemberDiscoveryStatic.class);
    private static final long DISCOVERY_INTERVAL_MS = TCPropertiesImpl.getProperties().getLong("l2.nha.tcgroupcomm.discovery.interval");
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean stopAttempt = new AtomicBoolean(false);
    private final Map<String, DiscoveryStateMachine> nodeStateMap = new ConcurrentHashMap<String, DiscoveryStateMachine>();
    private final TCGroupManagerImpl manager;
    private final Node local;
    private Integer joinedNodes = 0;
    private final HashSet<String> nodeThreadConnectingSet = new HashSet();

    public TCGroupMemberDiscoveryStatic(TCGroupManagerImpl manager, Node local) {
        this.manager = manager;
        this.local = local;
    }

    @Override
    public void setupNodes(Node local, Node[] nodes) {
        Assert.assertEquals((Object)this.local, (Object)local);
        for (Node node : nodes) {
            DiscoveryStateMachine stateMachine = new DiscoveryStateMachine(node);
            DiscoveryStateMachine old = this.nodeStateMap.put(this.getNodeName(node), stateMachine);
            Assert.assertNull((Object)("Duplicate nodes specified in config, please check " + this.getNodeName(node)), (Object)old);
            stateMachine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(Node node) {
        DiscoveryStateMachine stateMachine = new DiscoveryStateMachine(node);
        stateMachine.start();
        DiscoveryStateMachine old = this.nodeStateMap.put(this.getNodeName(node), stateMachine);
        Assert.assertNull((Object)("Duplicate nodes specified in config, please check " + this.getNodeName(node)), (Object)old);
        if (stateMachine.isTimeToConnect()) {
            stateMachine.connecting();
            this.discoveryPut(stateMachine);
        }
        TCGroupMemberDiscoveryStatic tCGroupMemberDiscoveryStatic = this;
        synchronized (tCGroupMemberDiscoveryStatic) {
            this.notifyAll();
        }
    }

    @Override
    public void removeNode(Node node) {
        DiscoveryStateMachine old = this.nodeStateMap.remove(this.getNodeName(node));
        Assert.assertNotNull((Object)"Tried removing node which was not present", (Object)old);
    }

    private String getNodeName(Node node) {
        return node.getServerNodeName();
    }

    @Override
    public boolean isValidClusterNode(NodeID nodeID) {
        String nodeName = ((ServerID)nodeID).getName();
        return this.nodeStateMap.get(nodeName) != null;
    }

    private void discoveryPut(DiscoveryStateMachine stateMachine) {
        this.manager.getDiscoveryHandlerSink().addSingleThreaded((Object)stateMachine);
    }

    @Override
    public void discoveryHandler(DiscoveryStateMachine stateMachine) {
        Assert.assertNotNull((Object)stateMachine);
        Node node = stateMachine.getNode();
        String serverNodeName = node.getServerNodeName();
        if (stateMachine.isMemberInGroup() || this.stopAttempt.get()) {
            return;
        }
        if (!this.addNodeToConnectingSet(serverNodeName)) {
            logger.warn((Object)("Discovery for " + node + " is in progress. skipping it."));
            return;
        }
        TCGroupMemberDiscoveryStatic.debugInfo("Added node to connecting set: " + node);
        try {
            TCGroupMemberDiscoveryStatic.debugInfo(this.getLocalNodeID().toString() + " opening channel to " + node);
            this.manager.openChannel(node.getHost(), node.getGroupPort(), stateMachine);
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.connected();
        }
        catch (TCTimeoutException e) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.connectTimeout();
            stateMachine.loggerWarn("Node:" + node + " not up. " + e.getMessage());
        }
        catch (UnknownHostException e) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.unknownHost();
            stateMachine.loggerWarn("Node:" + node + " not up. Unknown host.");
        }
        catch (MaxConnectionsExceededException e) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.maxConnExceed();
            stateMachine.loggerWarn("Node:" + node + " not up. " + e.getMessage());
        }
        catch (CommStackMismatchException e) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.commStackMismatch();
            stateMachine.loggerWarn("Node:" + node + " not up. " + e.getMessage());
        }
        catch (IOException e) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.connetIOException();
            stateMachine.loggerWarn("Node:" + node + " not up. IOException occured:" + e.getMessage());
        }
        catch (Throwable t) {
            this.removeNodeFromConnectingSet(serverNodeName);
            stateMachine.throwableException();
            stateMachine.loggerWarn("Node:" + node + " not up. Exception occured:" + t.getMessage());
        }
    }

    NodeID getLocalNodeID() {
        return this.manager.getLocalNodeID();
    }

    @Override
    public void start() throws GroupException {
        if (this.nodeStateMap.isEmpty()) {
            throw new GroupException("No nodes");
        }
        if (this.running.getAndSet(true)) {
            throw Assert.failure((Object)"Not to start discovert second time");
        }
        this.manager.registerForGroupEvents(this);
        this.openChannels();
        Thread discover = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TCGroupMemberDiscoveryStatic.this.stopAttempt.get()) {
                    TCGroupMemberDiscoveryStatic.this.openChannels();
                    ThreadUtil.reallySleep((long)DISCOVERY_INTERVAL_MS);
                    TCGroupMemberDiscoveryStatic.this.pauseDiscovery();
                }
                TCGroupMemberDiscoveryStatic.this.running.set(false);
            }
        }, "Static Member discovery");
        discover.setDaemon(true);
        discover.start();
    }

    protected void openChannels() {
        for (DiscoveryStateMachine stateMachine : this.nodeStateMap.values()) {
            if (this.local.equals(stateMachine.getNode()) || !stateMachine.isTimeToConnect()) continue;
            stateMachine.connecting();
            this.discoveryPut(stateMachine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNodeToConnectingSet(String nodeName) {
        Node node = this.local;
        synchronized (node) {
            return this.nodeThreadConnectingSet.add(nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeFromConnectingSet(String nodeName) {
        Node node = this.local;
        synchronized (node) {
            this.nodeThreadConnectingSet.remove(nodeName);
            if (this.nodeThreadConnectingSet.isEmpty()) {
                this.local.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillNoConnecting(long timeout) {
        Node node = this.local;
        synchronized (node) {
            if (!this.nodeThreadConnectingSet.isEmpty()) {
                try {
                    this.local.wait(timeout);
                    if (!this.nodeThreadConnectingSet.isEmpty()) {
                        logger.debug((Object)"Timeout occurred while waiting for connecting completed");
                    }
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"Interrupted while waiting for connecting completed");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void stop(long timeout) {
        this.stopAttempt.set(true);
        this.waitTillNoConnecting(timeout);
    }

    @Override
    public Node getLocalNode() {
        return this.local;
    }

    @Override
    public synchronized void nodeJoined(NodeID nodeID) {
        String nodeName = ((ServerID)nodeID).getName();
        this.nodeStateMap.get(nodeName).nodeJoined();
        Integer n = this.joinedNodes;
        Integer n2 = this.joinedNodes = Integer.valueOf(this.joinedNodes + 1);
    }

    @Override
    public synchronized void nodeLeft(NodeID nodeID) {
        Integer n = this.joinedNodes;
        Integer n2 = this.joinedNodes = Integer.valueOf(this.joinedNodes - 1);
        String nodeName = ((ServerID)nodeID).getName();
        this.nodeStateMap.get(nodeName).nodeLeft();
        this.notifyAll();
    }

    public synchronized void pauseDiscovery() {
        boolean interrupted = false;
        try {
            while (this.joinedNodes == this.nodeStateMap.size() - 1 && !this.stopAttempt.get()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isServerConnected(String nodeName) {
        DiscoveryStateMachine dsm = this.nodeStateMap.get(nodeName);
        if (dsm == null) {
            return false;
        }
        return dsm.isMemberInGroup();
    }

    private static void debugInfo(String message) {
        L2DebugLogging.log(logger, L2DebugLogging.LogLevel.INFO, message, null);
    }
}

