/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.utils;

import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class L2Utils {
    private static final int MAX_DEFAULT_COMM_THREADS = 16;
    private static final int MAX_DEFAULT_STAGE_THREADS = 16;
    private static final int MAX_ENTITY_PROCESSOR_THREADS = 128;
    public static final long MIN_COMMS_DIRECT_MEMORY_REQUIREMENT = 0x400000L;
    public static final long MAX_COMMS_DIRECT_MEMORY_REQUIREMENT = 0x10000000L;

    public static int getOptimalCommWorkerThreads() {
        int def = Math.min(Runtime.getRuntime().availableProcessors(), 16);
        return TCPropertiesImpl.getProperties().getInt("l2.tccom.workerthreads", def);
    }

    public static int getOptimalStageWorkerThreads() {
        int def = Math.min(Runtime.getRuntime().availableProcessors(), 16);
        return TCPropertiesImpl.getProperties().getInt("l2.seda.stage.workerthreads", def);
    }

    public static int getOptimalApplyStageWorkerThreads(boolean usesDisk) {
        int cpus = Runtime.getRuntime().availableProcessors();
        int threadsCount = usesDisk ? L2Utils.calculateOptimalThreadsCount(cpus, 30L, 70L, 0.75) : L2Utils.calculateOptimalThreadsCount(cpus, 0L, 100L, 0.75);
        return TCPropertiesImpl.getProperties().getInt("server.entity.processor.threads", Math.min(threadsCount, 128));
    }

    public static int calculateOptimalThreadsCount(int cpus, long wait, long compute, double targetUtilization) {
        Assert.assertTrue((compute > 0L ? 1 : 0) != 0);
        Assert.assertTrue((wait >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((cpus > 0 ? 1 : 0) != 0);
        Assert.assertTrue((targetUtilization > 0.0 && targetUtilization <= 1.0 ? 1 : 0) != 0);
        BigDecimal cpusCount = new BigDecimal(cpus);
        BigDecimal waitTime = new BigDecimal(wait);
        BigDecimal computeTime = new BigDecimal(compute);
        BigDecimal utilization = new BigDecimal(targetUtilization);
        int threadsCount = cpusCount.multiply(utilization).multiply(BigDecimal.ONE.add(waitTime.divide(computeTime, 1, RoundingMode.HALF_UP))).setScale(0, RoundingMode.HALF_UP).intValue();
        return wait == 0L ? threadsCount + 1 : threadsCount;
    }

    public static long getMaxDirectMemmoryConsumable() {
        long totalDirectMemeoryNeeded;
        int totalCommsThreads = L2Utils.getOptimalCommWorkerThreads() * 2;
        boolean poolingEnabled = TCPropertiesImpl.getProperties().getBoolean("tc.bytebuffer.pooling.enabled");
        int directMemoryCommonPool = TCPropertiesImpl.getProperties().getInt("tc.bytebuffer.common.pool.maxcount", 3000);
        int directMemoryThreadLocalPool = TCPropertiesImpl.getProperties().getInt("tc.bytebuffer.threadlocal.pool.maxcount", 2000);
        if (poolingEnabled) {
            totalDirectMemeoryNeeded = totalCommsThreads * directMemoryThreadLocalPool * 4096 + directMemoryCommonPool * 4096;
        } else {
            int maxPossbileMessageBytesSend = TCPropertiesImpl.getProperties().getBoolean("tc.messages.grouping.enabled") ? TCPropertiesImpl.getProperties().getInt("tc.messages.grouping.maxSizeKiloBytes") * 1024 : 1024;
            totalDirectMemeoryNeeded = totalCommsThreads * maxPossbileMessageBytesSend * 4;
        }
        totalDirectMemeoryNeeded = totalDirectMemeoryNeeded < 0x400000L ? 0x400000L : totalDirectMemeoryNeeded;
        return totalDirectMemeoryNeeded > 0x10000000L ? 0x10000000L : totalDirectMemeoryNeeded;
    }
}

