/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.core.impl;

import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.TCSocketAddress;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.objectserver.core.api.ITopologyEventCollector;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.PlatformClientFetchedEntity;
import org.terracotta.monitoring.PlatformConnectedClient;
import org.terracotta.monitoring.PlatformEntity;
import org.terracotta.monitoring.PlatformMonitoringConstants;
import org.terracotta.monitoring.ServerState;

public class ManagementTopologyEventCollector
implements ITopologyEventCollector {
    private static final TCLogger LOGGER = TCLogging.getLogger(ManagementTopologyEventCollector.class);
    private final IMonitoringProducer serviceInterface;
    private final Set<ClientID> connectedClients;
    private final Set<EntityID> entities;
    private final Map<ClientID, Collection<EntityDescriptor>> incomingReleases;
    private final Map<ClientID, Collection<ResolvedDescriptors>> incomingFetches;
    private boolean isActiveState;

    public ManagementTopologyEventCollector(IMonitoringProducer serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.connectedClients = new HashSet<ClientID>();
        this.entities = new HashSet<EntityID>();
        this.incomingReleases = new HashMap<ClientID, Collection<EntityDescriptor>>();
        this.incomingFetches = new HashMap<ClientID, Collection<ResolvedDescriptors>>();
        this.isActiveState = false;
        if (null != this.serviceInterface) {
            this.serviceInterface.addNode(new String[0], "platform", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "clients", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "entities", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "fetched", null);
        }
    }

    @Override
    public synchronized void serverDidEnterState(State state, long activateTime) {
        String stateValue;
        this.isActiveState = StateManager.ACTIVE_COORDINATOR.getName().equals(state.getName());
        boolean syncing = false;
        boolean standby = false;
        if (!this.isActiveState && !(syncing = StateManager.PASSIVE_SYNCING.equals((Object)state))) {
            standby = StateManager.PASSIVE_STANDBY.equals((Object)state);
        }
        String string = this.isActiveState ? "ACTIVE" : (standby ? "PASSIVE" : (stateValue = syncing ? "SYNCHRONIZING" : "UNINITIALIZED"));
        if (null != this.serviceInterface) {
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState(stateValue, System.currentTimeMillis(), activateTime));
        }
        LOGGER.debug((Object)("server entered state " + state + " at " + activateTime));
    }

    @Override
    public synchronized void clientDidConnect(MessageChannel channel, ClientID client) {
        Assert.assertFalse((boolean)this.connectedClients.contains(client));
        this.connectedClients.add(client);
        Collection<ResolvedDescriptors> earlyFetches = this.incomingFetches.remove(client);
        if (null != this.serviceInterface) {
            TCSocketAddress localAddress = channel.getLocalAddress();
            TCSocketAddress remoteAddress = channel.getRemoteAddress();
            ClientHandshakeMonitoringInfo minfo = (ClientHandshakeMonitoringInfo)channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT);
            Assert.assertNotNull((Object)minfo);
            PlatformConnectedClient clientDescription = new PlatformConnectedClient(minfo.getUuid(), minfo.getName(), localAddress.getAddress(), localAddress.getPort(), remoteAddress.getAddress(), remoteAddress.getPort(), (long)minfo.getPid() & 0xFFFFFFFFL);
            String nodeName = this.clientIdentifierForService(client);
            this.serviceInterface.addNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName, (Serializable)clientDescription);
            if (earlyFetches != null && !earlyFetches.isEmpty()) {
                for (ResolvedDescriptors ed : earlyFetches) {
                    String fetchIdentifier = this.fetchIdentifierForService(client, ed.id, ed.getClientInstanceID());
                    boolean didAdd = this.serviceInterface.addNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier, (Serializable)new PlatformClientFetchedEntity(this.clientIdentifierForService(client), this.entityIdentifierForService(ed.getEntityID()), (ClientDescriptor)new ClientDescriptorImpl(client, ed.getClientInstanceID())));
                    if (didAdd) continue;
                    LOGGER.warn((Object)("unbalanced client connect " + fetchIdentifier));
                }
            }
        }
        LOGGER.debug((Object)("client did connect " + channel));
    }

    @Override
    public synchronized void clientDidDisconnect(ClientID client) {
        Assert.assertTrue((boolean)this.connectedClients.contains(client));
        this.connectedClients.remove(client);
        if (null != this.serviceInterface && !this.incomingReleases.containsKey(client)) {
            String nodeName = this.clientIdentifierForService(client);
            this.serviceInterface.removeNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName);
        }
        LOGGER.debug((Object)("client did disconnect " + client));
    }

    @Override
    public synchronized void entityWasCreated(EntityID id, long consumerID, boolean isActive) {
        Assert.assertTrue((isActive == this.isActiveState ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.entities.contains(id));
        this.addEntityToTracking(id, consumerID, isActive);
        LOGGER.debug((Object)("entity created " + id));
    }

    @Override
    public synchronized void entityWasDestroyed(EntityID id) {
        Assert.assertTrue((boolean)this.entities.contains(id));
        this.removeEntityFromTracking(id);
        LOGGER.debug((Object)("entity destroyed " + id));
    }

    @Override
    public synchronized void entityWasReloaded(EntityID id, long consumerID, boolean isActive) {
        this.addEntityToTracking(id, consumerID, isActive);
        LOGGER.debug((Object)("entity reloaded " + id));
    }

    @Override
    public synchronized void clientDidFetchEntity(ClientID client, EntityID entity, ClientInstanceID instance) {
        if (null != this.serviceInterface) {
            String clientIdentifier = this.clientIdentifierForService(client);
            String entityIdentifier = this.entityIdentifierForService(entity);
            PlatformClientFetchedEntity record = new PlatformClientFetchedEntity(clientIdentifier, entityIdentifier, (ClientDescriptor)new ClientDescriptorImpl(client, instance));
            if (this.connectedClients.contains(client)) {
                String fetchIdentifier = this.fetchIdentifierForService(client, entity, instance);
                boolean didAdd = this.serviceInterface.addNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier, (Serializable)record);
                if (!didAdd) {
                    LOGGER.warn((Object)("unbalanced client fetch " + fetchIdentifier));
                }
            } else {
                Collection set = this.incomingFetches.computeIfAbsent(client, c -> new HashSet());
                set.add(new ResolvedDescriptors(entity, instance));
            }
        }
        LOGGER.debug((Object)("client " + client + " fetched " + instance));
    }

    @Override
    public synchronized void clientDidReleaseEntity(ClientID client, EntityID entity, ClientInstanceID instance) {
        String fetchIdentifier;
        boolean didRemove;
        if (null != this.serviceInterface && !(didRemove = this.serviceInterface.removeNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier = this.fetchIdentifierForService(client, entity, instance)))) {
            LOGGER.warn((Object)("unbalanced client release " + fetchIdentifier));
        }
        if (this.incomingReleases.containsKey(client)) {
            Collection<EntityDescriptor> expected = this.incomingReleases.get(client);
            Assert.assertTrue((boolean)expected.removeIf(des -> des.getEntityID().equals((Object)entity)));
            if (expected.isEmpty()) {
                this.incomingReleases.remove(client);
                if (null != this.serviceInterface) {
                    String nodeName = this.clientIdentifierForService(client);
                    this.serviceInterface.removeNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName);
                }
            }
        }
        LOGGER.debug((Object)("client " + client + " released " + entity));
    }

    public synchronized void expectedReleases(ClientID cid, Collection<EntityDescriptor> releases) {
        if (null != this.serviceInterface && !releases.isEmpty()) {
            this.incomingReleases.put(cid, releases);
        }
    }

    private void addEntityToTracking(EntityID id, long consumerID, boolean isActive) {
        this.entities.add(id);
        if (null != this.serviceInterface) {
            String entityClassName = id.getClassName();
            String entityName = id.getEntityName();
            PlatformEntity record = new PlatformEntity(entityClassName, entityName, consumerID, isActive);
            String entityIdentifier = this.entityIdentifierForService(id);
            this.serviceInterface.addNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier, (Serializable)record);
        }
    }

    private void removeEntityFromTracking(EntityID id) {
        this.entities.remove(id);
        if (null != this.serviceInterface) {
            String entityIdentifier = this.entityIdentifierForService(id);
            this.serviceInterface.removeNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier);
        }
    }

    private String clientIdentifierForService(ClientID id) {
        return "" + id.toLong();
    }

    private String entityIdentifierForService(EntityID id) {
        return id.getClassName() + id.getEntityName();
    }

    private String fetchIdentifierForService(ClientID client, EntityID entity, ClientInstanceID cid) {
        return this.clientIdentifierForService(client) + "_" + this.entityIdentifierForService(entity) + "_" + cid.getID();
    }

    private static class ResolvedDescriptors {
        private final EntityID id;
        private final ClientInstanceID instance;

        public ResolvedDescriptors(EntityID entityID, ClientInstanceID instance) {
            this.id = entityID;
            this.instance = instance;
        }

        public ClientInstanceID getClientInstanceID() {
            return this.instance;
        }

        public EntityID getEntityID() {
            return this.id;
        }
    }
}

