/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityReceivedResponse;
import com.tc.entity.VoltronEntityRetiredResponse;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.Retiree;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.api.ServerEntityResponse;
import com.tc.util.Assert;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.terracotta.exception.EntityException;

public abstract class AbstractServerEntityRequestResponse
implements ServerEntityRequest,
ServerEntityResponse,
Retiree {
    private final ServerEntityAction action;
    private final TransactionID transaction;
    private final TransactionID oldest;
    private final ClientID src;
    private boolean isComplete = false;
    private boolean isRetired = false;
    private boolean alsoRetire = false;
    private volatile Future<Void> transactionOrderPersistenceFuture;

    public AbstractServerEntityRequestResponse(ServerEntityAction action, TransactionID transaction, TransactionID oldest, ClientID src) {
        this.action = action;
        this.transaction = transaction;
        this.oldest = oldest;
        this.src = src;
    }

    public abstract Optional<MessageChannel> getReturnChannel();

    public void autoRetire(boolean auto) {
        this.alsoRetire = auto;
    }

    @Override
    public TransactionID getTransaction() {
        if (this.transaction == null) {
            return TransactionID.NULL_ID;
        }
        return this.transaction;
    }

    @Override
    public TransactionID getOldestTransactionOnClient() {
        if (this.oldest == null) {
            return TransactionID.NULL_ID;
        }
        return this.oldest;
    }

    @Override
    public Set<NodeID> replicateTo(Set<NodeID> current) {
        return current;
    }

    @Override
    public ClientID getNodeID() {
        return this.src;
    }

    @Override
    public ServerEntityAction getAction() {
        return this.action;
    }

    @Override
    public synchronized void failure(EntityException e) {
        if (this.isComplete()) {
            throw new AssertionError((Object)"Error after successful complete");
        }
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityAppliedResponse message = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
            message.setFailure(this.transaction, e, this.alsoRetire);
            message.send();
        });
        this.isComplete = true;
        this.notifyAll();
    }

    @Override
    public synchronized void received() {
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityReceivedResponse message = (VoltronEntityReceivedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE);
            if (this.transactionOrderPersistenceFuture != null) {
                try {
                    this.transactionOrderPersistenceFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Caught exception while persisting transaction order", e);
                }
            }
            message.setTransactionID(this.transaction);
            message.send();
        });
    }

    @Override
    public synchronized void complete() {
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityAppliedResponse actionResponse = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
            switch (this.action) {
                case FETCH_ENTITY: 
                case CREATE_ENTITY: 
                case DESTROY_ENTITY: 
                case RELEASE_ENTITY: {
                    actionResponse.setSuccess(this.transaction, new byte[0], this.alsoRetire);
                    actionResponse.send();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected action in complete() " + (Object)((Object)this.action));
                }
            }
        });
        this.isComplete = true;
        this.notifyAll();
    }

    @Override
    public synchronized void complete(byte[] value) {
        this.getReturnChannel().ifPresent(channel -> {
            switch (this.action) {
                case INVOKE_ACTION: 
                case FETCH_ENTITY: 
                case RECONFIGURE_ENTITY: {
                    VoltronEntityAppliedResponse actionResponse = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
                    actionResponse.setSuccess(this.transaction, value, this.alsoRetire);
                    actionResponse.send();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected action in complete(byte[]) " + (Object)((Object)this.action));
                }
            }
        });
        this.isComplete = true;
        this.notifyAll();
    }

    public void setTransactionOrderPersistenceFuture(Future<Void> transactionOrderPersistenceFuture) {
        this.transactionOrderPersistenceFuture = transactionOrderPersistenceFuture;
    }

    @Override
    public synchronized void retired() {
        Assert.assertTrue((Object)"Double-retire", (!this.isRetired() ? 1 : 0) != 0);
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityRetiredResponse response = (VoltronEntityRetiredResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE);
            response.setTransactionID(this.transaction);
            response.send();
        });
        this.isRetired = true;
        this.notifyAll();
    }

    protected boolean isComplete() {
        return this.isComplete;
    }

    protected boolean isRetired() {
        return this.isRetired;
    }
}

