/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.TCServerRestartException;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.net.NodeID;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ActivePassiveAckWaiter {
    private final Set<NodeID> start;
    private final Set<NodeID> receivedPending;
    private final Set<NodeID> receivedByComplete;
    private final Set<NodeID> completedPending;
    private final Map<NodeID, ReplicationResultCode> results;
    private final PassiveReplicationBroker parent;

    public ActivePassiveAckWaiter(Set<NodeID> allPassiveNodes, PassiveReplicationBroker parent) {
        this.start = Collections.unmodifiableSet(allPassiveNodes);
        this.receivedPending = new HashSet<NodeID>(allPassiveNodes);
        this.completedPending = new HashSet<NodeID>(allPassiveNodes);
        this.receivedByComplete = new HashSet<NodeID>();
        this.results = new HashMap<NodeID, ReplicationResultCode>();
        this.parent = parent;
    }

    public synchronized void waitForReceived() {
        try {
            while (!this.receivedPending.isEmpty()) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public synchronized void waitForCompleted() {
        try {
            while (!this.completedPending.isEmpty()) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public boolean verifyLifecycleResult(boolean success) {
        if (this.results.entrySet().stream().anyMatch(e -> e.getValue() == (success ? ReplicationResultCode.FAIL : ReplicationResultCode.SUCCESS))) {
            boolean zapped = false;
            for (Map.Entry<NodeID, ReplicationResultCode> r : this.results.entrySet()) {
                if (r.getValue() != ReplicationResultCode.FAIL) continue;
                this.parent.zapAndWait(r.getKey());
                zapped = true;
            }
            if (!success) {
                throw new TCServerRestartException("inconsistent lifecycle");
            }
            return zapped;
        }
        return false;
    }

    public synchronized boolean isCompleted() {
        return this.completedPending.isEmpty();
    }

    public synchronized void didReceiveOnPassive(NodeID onePassive) {
        boolean didContain = this.receivedPending.remove(onePassive);
        if (!didContain) {
            Assert.assertTrue((Object)(onePassive + " " + this.toString()), (boolean)this.receivedByComplete.contains(onePassive));
        }
        if (this.receivedPending.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized boolean didCompleteOnPassive(NodeID onePassive, boolean isNormalComplete, ReplicationResultCode payload) {
        boolean didContainInReceived = this.receivedPending.remove(onePassive);
        if (didContainInReceived) {
            this.receivedByComplete.add(onePassive);
        }
        boolean didContainInCompleted = this.completedPending.remove(onePassive);
        if (isNormalComplete) {
            Assert.assertTrue((boolean)didContainInCompleted);
            this.results.put(onePassive, payload);
        }
        boolean isDoneWaiting = this.completedPending.isEmpty();
        if (didContainInReceived && this.receivedPending.isEmpty() || isDoneWaiting) {
            this.notifyAll();
        }
        return isDoneWaiting;
    }

    public String toString() {
        return "ActivePassiveAckWaiter{start=" + this.start + ", receivedPending=" + this.receivedPending + ", receivedByComplete=" + this.receivedByComplete + ", completedPending=" + this.completedPending + ", results=" + this.results + '}';
    }
}

