/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.l2.msg.ReplicationAckTuple;
import com.tc.l2.msg.ReplicationMessageAck;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handler.ReplicationSender;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class ActiveToPassiveReplication
implements PassiveReplicationBroker,
GroupEventsListener {
    private static final TCLogger logger = TCLogging.getLogger(PassiveReplicationBroker.class);
    private final Iterable<NodeID> passives;
    private boolean activated = false;
    private final Set<NodeID> passiveNodes = new CopyOnWriteArraySet<NodeID>();
    private final Set<NodeID> standByNodes = new HashSet<NodeID>();
    private final ConcurrentHashMap<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter> waiters = new ConcurrentHashMap();
    private final ReplicationSender replicationSender;
    private final Executor passiveSyncPool = Executors.newCachedThreadPool();
    private final EntityPersistor persistor;
    private final GroupManager serverCheck;
    private final ProcessTransactionHandler snapshotter;

    public ActiveToPassiveReplication(ProcessTransactionHandler snapshotter, Iterable<NodeID> passives, EntityPersistor persistor, ReplicationSender replicationSender, GroupManager serverMatch) {
        this.replicationSender = replicationSender;
        this.passives = passives;
        this.persistor = persistor;
        this.serverCheck = serverMatch;
        this.snapshotter = snapshotter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zapAndWait(NodeID node) {
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            logger.warn((Object)("ZAPPING " + node + " due to inconsistent lifecycle result"));
            try {
                if (this.standByNodes.contains(node)) {
                    this.serverCheck.zapNode(node, 2, "inconsistent lifecycle");
                }
                while (this.standByNodes.contains(node)) {
                    this.standByNodes.wait();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void enterActiveState() {
        Assert.assertFalse((boolean)this.activated);
        this.primePassives();
        this.activated = true;
    }

    private void primePassives() {
        this.passives.forEach(i -> {
            if (this.prime((NodeID)i)) {
                this.passiveNodes.add((NodeID)i);
            }
        });
    }

    private boolean prime(NodeID node) {
        if (!this.passiveNodes.contains(node)) {
            logger.info((Object)("Starting message sequence on " + node));
            this.replicationSender.addPassive(node, SyncReplicationActivity.createStartMessage());
            return true;
        }
        return false;
    }

    public void startPassiveSync(NodeID newNode) {
        Assert.assertTrue((boolean)this.activated);
        if (this.prime(newNode)) {
            this.passiveNodes.add(newNode);
        } else {
            Assert.assertTrue((Object)"passive node unable to prime and not in the list of passives", (boolean)this.passiveNodes.contains(newNode));
        }
        logger.info((Object)("Starting sync to " + newNode));
        this.executePassiveSync(newNode);
    }

    private void executePassiveSync(final NodeID newNode) {
        this.passiveSyncPool.execute(new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)("starting sync for " + newNode));
                Iterable<ManagedEntity> e = ActiveToPassiveReplication.this.snapshotter.snapshotEntityList(new Consumer<List<ManagedEntity>>(){

                    @Override
                    public void accept(List<ManagedEntity> sortedEntities) {
                        ArrayList<SyncReplicationActivity.EntityCreationTuple> tuplesForCreation = new ArrayList<SyncReplicationActivity.EntityCreationTuple>();
                        for (ManagedEntity e : sortedEntities) {
                            SyncReplicationActivity.EntityCreationTuple data = e.startSync();
                            if (data == null) continue;
                            tuplesForCreation.add(data);
                        }
                        ActiveToPassiveReplication.this.replicateActivity(SyncReplicationActivity.createStartSyncMessage((SyncReplicationActivity.EntityCreationTuple[])tuplesForCreation.toArray(new SyncReplicationActivity.EntityCreationTuple[tuplesForCreation.size()])), Collections.singleton(newNode)).waitForCompleted();
                    }
                });
                for (ManagedEntity entity : e) {
                    logger.debug((Object)("starting sync for entity " + newNode + "/" + entity.getID()));
                    entity.sync(newNode);
                    logger.debug((Object)("ending sync for entity " + newNode + "/" + entity.getID()));
                }
                logger.debug((Object)("ending sync " + newNode));
                ActiveToPassiveReplication.this.replicateActivity(SyncReplicationActivity.createEndSyncMessage((byte[])ActiveToPassiveReplication.this.replicateEntityPersistor()), Collections.singleton(newNode)).waitForCompleted();
            }
        });
    }

    private byte[] replicateEntityPersistor() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream data = new ObjectOutputStream(out);
            this.persistor.serialize(data);
            data.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void batchAckReceived(ReplicationMessageAck context) {
        NodeID messageFrom = context.messageFrom();
        for (ReplicationAckTuple tuple : context.getBatch()) {
            if (ReplicationResultCode.RECEIVED == tuple.result) {
                ActivePassiveAckWaiter waiter = this.waiters.get(tuple.respondTo);
                if (null == waiter) continue;
                waiter.didReceiveOnPassive(messageFrom);
                continue;
            }
            boolean isNormalComplete = true;
            this.internalAckCompleted(tuple.respondTo, messageFrom, tuple.result, isNormalComplete);
        }
    }

    private void internalAckCompleted(SyncReplicationActivity.ActivityID activityID, NodeID passive, ReplicationResultCode payload, boolean isNormalComplete) {
        boolean shouldDiscardWaiter;
        ActivePassiveAckWaiter waiter = this.waiters.get(activityID);
        if (null != waiter && (shouldDiscardWaiter = waiter.didCompleteOnPassive(passive, isNormalComplete, payload))) {
            this.waiters.remove(activityID);
        }
    }

    @Override
    public Set<NodeID> passives() {
        return this.passiveNodes;
    }

    @Override
    public ActivePassiveAckWaiter replicateActivity(SyncReplicationActivity activity, Set<NodeID> all) {
        HashSet<NodeID> copy = new HashSet<NodeID>(all);
        copy.retainAll(this.passives());
        ActivePassiveAckWaiter waiter = new ActivePassiveAckWaiter(copy, this);
        if (!copy.isEmpty()) {
            SyncReplicationActivity.ActivityID activityID = activity.getActivityID();
            this.waiters.put(activityID, waiter);
            boolean isLocalFlush = SyncReplicationActivity.ActivityType.FLUSH_LOCAL_PIPELINE == activity.getActivityType();
            for (NodeID node : copy) {
                boolean didSend = false;
                if (!isLocalFlush) {
                    didSend = this.replicationSender.replicateMessage(node, activity);
                }
                if (didSend) continue;
                boolean isNormalComplete = true;
                this.internalAckCompleted(activityID, node, null, isNormalComplete);
            }
        }
        return waiter;
    }

    public void removePassive(NodeID nodeID) {
        this.passiveNodes.remove(nodeID);
        if (this.activated) {
            boolean isNormalComplete = false;
            this.waiters.forEach((key, value) -> this.internalAckCompleted((SyncReplicationActivity.ActivityID)key, nodeID, null, isNormalComplete));
            this.replicationSender.removePassive(nodeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeJoined(NodeID nodeID) {
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            this.standByNodes.add(nodeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeLeft(NodeID nodeID) {
        this.removePassive(nodeID);
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            this.standByNodes.remove(nodeID);
            this.standByNodes.notifyAll();
        }
    }
}

