/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.entity.VoltronEntityMessage;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientEntityStateManagerImpl
implements ClientEntityStateManager {
    private final Map<ClientDescriptorImpl, EntityID> clientStates = new ConcurrentHashMap<ClientDescriptorImpl, EntityID>();
    private static final TCLogger logger = TCLogging.getLogger(ClientEntityStateManagerImpl.class);

    @Override
    public boolean addReference(ClientDescriptorImpl instance, EntityID eid) {
        EntityID check = this.clientStates.put(instance, eid);
        Assert.assertNull((Object)check);
        logger.debug((Object)("Adding reference:" + instance + " " + eid));
        return true;
    }

    @Override
    public boolean removeReference(ClientDescriptorImpl descriptor) {
        EntityID eid = this.clientStates.remove(descriptor);
        Assert.assertNotNull((Object)eid);
        logger.debug((Object)("Removing reference:" + descriptor + " " + eid));
        return true;
    }

    @Override
    public boolean verifyNoReferences(EntityID eid) {
        return !this.clientStates.values().stream().anyMatch(led -> led.equals((Object)eid));
    }

    @Override
    public List<VoltronEntityMessage> clientDisconnected(ClientID client) {
        ArrayList<VoltronEntityMessage> msgs = new ArrayList<VoltronEntityMessage>();
        this.clientStates.entrySet().stream().filter(e -> ((ClientDescriptorImpl)e.getKey()).getNodeID().equals((Object)client)).forEach(e -> msgs.add(new ReferenceMessage(client, false, EntityDescriptor.createDescriptorForFetch((EntityID)((EntityID)e.getValue()), (long)0L, (ClientInstanceID)((ClientDescriptorImpl)e.getKey()).getClientInstanceID()), null)));
        return msgs;
    }
}

