/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.TCShutdownServerException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ManagementKeyCallback;
import com.tc.objectserver.core.api.ITopologyEventCollector;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.ManagedEntityImpl;
import com.tc.objectserver.entity.PlatformEntity;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.ServerEntityFactory;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.services.ToStringStateDumper;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.StateDumper;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class EntityManagerImpl
implements EntityManager {
    private static final TCLogger LOGGER = TCLogging.getLogger(EntityManagerImpl.class);
    private final ConcurrentMap<EntityID, FetchID> entities = new ConcurrentHashMap<EntityID, FetchID>();
    private final ConcurrentMap<FetchID, ManagedEntity> entityIndex = new ConcurrentHashMap<FetchID, ManagedEntity>();
    private final ConcurrentMap<String, EntityServerService<EntityMessage, EntityResponse>> entityServices = new ConcurrentHashMap<String, EntityServerService<EntityMessage, EntityResponse>>();
    private final ClassLoader creationLoader;
    private final TerracottaServiceProviderRegistry serviceRegistry;
    private final ClientEntityStateManager clientEntityStateManager;
    private final ITopologyEventCollector eventCollector;
    private final ManagementKeyCallback flushLocalPipeline;
    private final RequestProcessor processorPipeline;
    private boolean shouldCreateActiveEntities;
    private final Semaphore snapshotLock = new Semaphore(1);
    private final Comparator<ManagedEntity> consumerIdSorter = new Comparator<ManagedEntity>(){

        @Override
        public int compare(ManagedEntity o1, ManagedEntity o2) {
            long secondID;
            long firstID = o1.getConsumerID();
            Assert.assertTrue((firstID != (secondID = o2.getConsumerID()) ? 1 : 0) != 0);
            return firstID > secondID ? 1 : -1;
        }
    };

    public EntityManagerImpl(TerracottaServiceProviderRegistry serviceRegistry, ClientEntityStateManager clientEntityStateManager, ITopologyEventCollector eventCollector, RequestProcessor processor, ManagementKeyCallback flushLocalPipeline) {
        this.serviceRegistry = serviceRegistry;
        this.clientEntityStateManager = clientEntityStateManager;
        this.eventCollector = eventCollector;
        this.processorPipeline = processor;
        this.shouldCreateActiveEntities = false;
        this.creationLoader = Thread.currentThread().getContextClassLoader();
        this.flushLocalPipeline = flushLocalPipeline;
        ManagedEntity platform = this.createPlatformEntity();
        this.entities.put(platform.getID(), new FetchID(0L));
        this.entityIndex.put(new FetchID(0L), platform);
    }

    private ManagedEntity createPlatformEntity() {
        return new PlatformEntity(this.processorPipeline);
    }

    @Override
    public ClassLoader getEntityLoader() {
        return this.creationLoader;
    }

    @Override
    public void enterActiveState() {
        Assert.assertFalse((boolean)this.shouldCreateActiveEntities);
        this.serviceRegistry.notifyServerDidBecomeActive();
        this.shouldCreateActiveEntities = true;
        try {
            ArrayList sortingList = new ArrayList(this.entityIndex.values());
            Collections.sort(sortingList, this.consumerIdSorter);
            for (ManagedEntity entity : sortingList) {
                entity.promoteEntity();
            }
        }
        catch (ConfigurationException ce) {
            LOGGER.warn((Object)"failure to promote all entities.  Server is crashing", (Throwable)ce);
            throw new TCShutdownServerException("failure to promote all entities.  Server is crashing");
        }
        this.processorPipeline.enterActiveState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedEntity createEntity(EntityID id, long version, long consumerID, boolean canDelete) throws EntityException {
        Assert.assertTrue((version > 0L ? 1 : 0) != 0);
        EntityServerService<EntityMessage, EntityResponse> service = this.getVersionCheckedService(id, version);
        this.snapshotLock.acquireUninterruptibly();
        try {
            ManagedEntity temp;
            FetchID current = this.entities.compute(id, (eid, fetch) -> this.shouldCreateActiveEntities ? Optional.ofNullable(fetch).orElse(new FetchID(consumerID)) : new FetchID(consumerID));
            ManagedEntity managedEntity = temp = this.entityIndex.computeIfAbsent(current, fetch -> new ManagedEntityImpl(id, version, consumerID, this.flushLocalPipeline, this.serviceRegistry.subRegistry(consumerID), this.clientEntityStateManager, this.eventCollector, this.processorPipeline, service, this.shouldCreateActiveEntities, canDelete));
            return managedEntity;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    @Override
    public void loadExisting(EntityID entityID, long recordedVersion, long consumerID, boolean canDelete, byte[] configuration) throws EntityException {
        Assert.assertTrue((recordedVersion > 0L ? 1 : 0) != 0);
        EntityServerService<EntityMessage, EntityResponse> service = this.getVersionCheckedService(entityID, recordedVersion);
        FetchID set = new FetchID(consumerID);
        Object checkNull = this.entities.put(entityID, set);
        Assert.assertNull((Object)checkNull);
        ManagedEntityImpl temp = new ManagedEntityImpl(entityID, recordedVersion, consumerID, this.flushLocalPipeline, this.serviceRegistry.subRegistry(consumerID), this.clientEntityStateManager, this.eventCollector, this.processorPipeline, service, this.shouldCreateActiveEntities, canDelete);
        checkNull = this.entityIndex.put(set, temp);
        Assert.assertNull((Object)checkNull);
        try {
            temp.loadEntity(configuration);
        }
        catch (ConfigurationException ce) {
            LOGGER.warn((Object)"failure to load an existing entity.  Server is crashing", (Throwable)ce);
            throw new TCShutdownServerException("failure to load an existing entity.  Server is crashing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDestroyed(FetchID id) {
        this.snapshotLock.acquireUninterruptibly();
        try {
            ManagedEntity e = this.entityIndex.computeIfPresent(id, (fetch, entity) -> {
                if (entity.isRemoveable()) {
                    this.entities.remove(entity.getID(), fetch);
                    return null;
                }
                return entity;
            });
            if (e == null) {
                LOGGER.debug((Object)("removed " + id));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    @Override
    public Optional<ManagedEntity> getEntity(EntityDescriptor descriptor) throws EntityException {
        if (descriptor.isIndexed()) {
            return this.getEntity(descriptor.getFetchID());
        }
        return this.getEntity(descriptor.getEntityID(), descriptor.getClientSideVersion());
    }

    private Optional<ManagedEntity> getEntity(FetchID idx) {
        Assert.assertFalse((boolean)idx.isNull());
        return Optional.ofNullable(this.entityIndex.get(idx));
    }

    private Optional<ManagedEntity> getEntity(EntityID id, long version) throws EntityException {
        Assert.assertNotNull((Object)id);
        if (EntityID.NULL_ID == id) {
            return Optional.empty();
        }
        FetchID fetch = (FetchID)this.entities.get(id);
        ManagedEntity entity = null;
        if (fetch != null) {
            entity = (ManagedEntity)this.entityIndex.get(fetch);
            if (version > 0L && entity.getVersion() != version) {
                throw new EntityVersionMismatchException(id.getClassName(), id.getEntityName(), entity.getVersion(), version);
            }
        }
        return Optional.ofNullable(entity);
    }

    @Override
    public Collection<ManagedEntity> getAll() {
        return new ArrayList<ManagedEntity>(this.entityIndex.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ManagedEntity> snapshot(Consumer<List<ManagedEntity>> runFirst) {
        this.snapshotLock.acquireUninterruptibly();
        try {
            ArrayList<ManagedEntity> sortingList = new ArrayList<ManagedEntity>(this.entityIndex.values());
            Collections.sort(sortingList, this.consumerIdSorter);
            if (runFirst != null) {
                runFirst.accept(sortingList);
            }
            ArrayList<ManagedEntity> arrayList = sortingList;
            return arrayList;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    private EntityServerService<EntityMessage, EntityResponse> getVersionCheckedService(EntityID entityID, long version) throws EntityVersionMismatchException, EntityNotProvidedException {
        Assert.assertTrue((version > 0L ? 1 : 0) != 0);
        String typeName = entityID.getClassName();
        Object service = (EntityServerService)this.entityServices.get(typeName);
        if (service == null) {
            try {
                service = ServerEntityFactory.getService(typeName, this.creationLoader);
            }
            catch (ClassNotFoundException notfound) {
                throw new EntityNotProvidedException(typeName, entityID.getEntityName());
            }
            Assert.assertNotNull((Object)service);
            EntityServerService<EntityMessage, EntityResponse> oldService = this.entityServices.putIfAbsent(typeName, (EntityServerService<EntityMessage, EntityResponse>)service);
            Assert.assertNull(oldService);
        }
        Assert.assertNotNull((Object)service);
        long serviceVersion = service.getVersion();
        if (serviceVersion != version) {
            throw new EntityVersionMismatchException(typeName, entityID.getEntityName(), serviceVersion, version);
        }
        return service;
    }

    @Override
    public void resetReferences() {
        for (ManagedEntity me : this.entityIndex.values()) {
            me.resetReferences(0);
        }
    }

    public MessageCodec<? extends EntityMessage, ? extends EntityResponse> getMessageCodec(EntityDescriptor eid) {
        ManagedEntity e = (ManagedEntity)this.entityIndex.get(eid.getFetchID());
        if (e != null) {
            return e.getCodec();
        }
        return null;
    }

    public String toString() {
        return "EntityManagerImpl{entities=" + this.entities.keySet() + '}';
    }

    public void dumpStateTo(StateDumper stateDumper) {
        for (Map.Entry entry : this.entities.entrySet()) {
            EntityID entityID = (EntityID)entry.getKey();
            ((ManagedEntity)this.entityIndex.get(entry.getValue())).dumpStateTo(stateDumper.subStateDumper(entityID.getClassName() + ":" + entityID.getEntityName()));
        }
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        ToStringStateDumper dump = new ToStringStateDumper("entities");
        this.dumpStateTo(dump);
        return out.println((Object)dump);
    }
}

