/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.EntityBusyException;
import com.tc.exception.EntityReferencedException;
import com.tc.exception.TCServerRestartException;
import com.tc.exception.TCShutdownServerException;
import com.tc.exception.VoltronWrapperException;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ManagementKeyCallback;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.core.api.ITopologyEventCollector;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.BarrierCompletion;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.ManagedEntitySyncInterop;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.ServerEntityRequestImpl;
import com.tc.objectserver.entity.SimpleCompletion;
import com.tc.objectserver.handler.RetirementManager;
import com.tc.properties.TCPropertiesImpl;
import com.tc.services.InternalServiceRegistry;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.StateDumpable;
import org.terracotta.entity.StateDumper;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityUserException;
import org.terracotta.exception.PermanentEntityException;
import org.terracotta.exception.RuntimeEntityException;

public class ManagedEntityImpl
implements ManagedEntity {
    private static final TCLogger logger = TCLogging.getLogger(ManagedEntityImpl.class);
    private final RequestProcessor executor;
    private final RetirementManager retirementManager;
    private final EntityID id;
    private final FetchID fetchID;
    private final long version;
    private final long consumerID;
    private final InternalServiceRegistry registry;
    private final ClientEntityStateManager clientEntityStateManager;
    private final ITopologyEventCollector eventCollector;
    private final EntityServerService<EntityMessage, EntityResponse> factory;
    private final ManagementKeyCallback flushLocalPipeline;
    private boolean isInActiveState;
    private int clientReferenceCount = 0;
    private final boolean canDelete;
    private volatile boolean isDestroyed;
    private final MessageCodec<EntityMessage, EntityResponse> codec;
    private final SyncMessageCodec<EntityMessage> syncCodec;
    private volatile ActiveServerEntity<EntityMessage, EntityResponse> activeServerEntity;
    private volatile ConcurrencyStrategy<EntityMessage> concurrencyStrategy;
    private volatile ExecutionStrategy<EntityMessage> executionStrategy;
    private final DefermentQueue<SchedulingRunnable> runnables = new DefermentQueue(TCPropertiesImpl.getProperties().getInt("server.entity.deferment.queue.size", 1024));
    private volatile PassiveServerEntity<EntityMessage, EntityResponse> passiveServerEntity;
    private final ReadWriteLock reconnectAccessLock = new ReentrantReadWriteLock();
    private final ManagedEntitySyncInterop interop = new ManagedEntitySyncInterop();
    private byte[] constructorInfo;
    private ManagedEntity createParent;

    ManagedEntityImpl(EntityID id, long version, long consumerID, ManagementKeyCallback flushLocalPipeline, InternalServiceRegistry registry, ClientEntityStateManager clientEntityStateManager, ITopologyEventCollector eventCollector, RequestProcessor process, EntityServerService<EntityMessage, EntityResponse> factory, boolean isInActiveState, boolean canDelete) {
        this.id = id;
        this.isDestroyed = true;
        this.version = version;
        this.consumerID = consumerID;
        this.fetchID = new FetchID(consumerID);
        this.flushLocalPipeline = flushLocalPipeline;
        this.registry = registry;
        this.clientEntityStateManager = clientEntityStateManager;
        this.eventCollector = eventCollector;
        this.factory = factory;
        this.executor = process;
        this.retirementManager = new RetirementManager();
        this.isInActiveState = isInActiveState;
        this.canDelete = canDelete;
        this.clientReferenceCount = canDelete ? 0 : -1;
        registry.setOwningEntity(this);
        this.codec = factory.getMessageCodec();
        this.syncCodec = factory.getSyncMessageCodec();
    }

    @Override
    public EntityID getID() {
        return this.id;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    private ResultCapture createManagedEntityResponse(Runnable received, Consumer<byte[]> completion, Consumer<EntityException> exception, Object debug, boolean lifecycle) {
        return new ResultCapture(received, completion, exception, debug, lifecycle);
    }

    @Override
    public SimpleCompletion addRequestMessage(ServerEntityRequest request, MessagePayload data, Runnable received, Consumer<byte[]> completion, Consumer<EntityException> exception) {
        ResultCapture resp;
        switch (request.getAction()) {
            case LOCAL_FLUSH: 
            case ORDER_PLACEHOLDER_ONLY: 
            case MANAGED_ENTITY_GC: {
                resp = this.createManagedEntityResponse(received, completion, exception, request, false);
                this.processLegacyNoopMessage(request, resp);
                break;
            }
            case LOCAL_FLUSH_AND_SYNC: {
                Assert.fail((String)"LOCAL_FLUSH_AND_SYNC should be filtered before reaching this point");
                resp = null;
                break;
            }
            case CREATE_ENTITY: 
            case DESTROY_ENTITY: 
            case FETCH_ENTITY: 
            case RECONFIGURE_ENTITY: 
            case RELEASE_ENTITY: {
                resp = this.createManagedEntityResponse(received, completion, exception, request, true);
                this.processLifecycleEntity(request, data, resp);
                break;
            }
            case INVOKE_ACTION: {
                resp = this.createManagedEntityResponse(received, completion, exception, request, false);
                this.processInvokeRequest(request, resp, data, data.getConcurrency());
                break;
            }
            case RECEIVE_SYNC_CREATE_ENTITY: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                resp = this.createManagedEntityResponse(received, completion, exception, request, false);
                this.processSyncCreateMessage(request, resp, data);
                break;
            }
            case RECEIVE_SYNC_ENTITY_START_SYNCING: 
            case RECEIVE_SYNC_ENTITY_END: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                resp = this.createManagedEntityResponse(received, completion, exception, request, false);
                this.processSyncStartEndMessage(request, resp, data);
                break;
            }
            case RECEIVE_SYNC_ENTITY_KEY_START: 
            case RECEIVE_SYNC_ENTITY_KEY_END: 
            case RECEIVE_SYNC_PAYLOAD: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                resp = this.createManagedEntityResponse(received, completion, exception, request, false);
                this.processSyncPayloadOtherMessage(request, resp, data, data.getConcurrency());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request " + request);
            }
        }
        return resp;
    }

    private void processLifecycleEntity(ServerEntityRequest create, MessagePayload data, ResultCapture resp) {
        boolean schedule = true;
        if (this.isInActiveState) {
            switch (create.getAction()) {
                case CREATE_ENTITY: 
                case DESTROY_ENTITY: 
                case RECONFIGURE_ENTITY: {
                    if (data.canBeBusy()) {
                        schedule = this.interop.tryStartLifecycle();
                        break;
                    }
                    this.interop.startLifecycle();
                    break;
                }
                case FETCH_ENTITY: 
                case RELEASE_ENTITY: {
                    if (data.canBeBusy()) {
                        schedule = this.interop.tryStartReference();
                        break;
                    }
                    this.interop.startReference();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unexpected");
                }
            }
        }
        if (schedule) {
            this.scheduleInOrder(create, resp, data, () -> this.invokeLifecycleOperation(create, data, resp), 0);
        } else {
            resp.failure((EntityException)new EntityBusyException(this.id.getClassName(), this.id.getEntityName(), "entity is busy in sync, retry"));
        }
    }

    private void processLegacyNoopMessage(ServerEntityRequest request, ResultCapture resp) {
        this.scheduleInOrder(request, resp, MessagePayload.emptyPayload(), resp::complete, Integer.MIN_VALUE);
    }

    private synchronized SchedulingRunnable scheduleInOrder(ServerEntityRequest request, ResultCapture results, MessagePayload payload, Runnable r, int ckey) {
        if (this.isInActiveState) {
            Assert.assertTrue((boolean)Thread.currentThread().getName().contains("voltron_message_stage"));
        } else {
            Assert.assertTrue((Thread.currentThread().getName().contains("passive_replication_stage") || Thread.currentThread().getName().contains("l2_state_change_stage") ? 1 : 0) != 0);
        }
        SchedulingRunnable next = new SchedulingRunnable(request, payload, r, ckey);
        if (this.isActive()) {
            results.setWaitFor(next);
        }
        for (SchedulingRunnable msg : this.runnables) {
            msg.start();
        }
        if (!this.runnables.offer(next)) {
            next.start();
        } else if (Thread.currentThread().getName().contains("l2_state_change_stage")) {
            for (SchedulingRunnable sr : ((DefermentQueue)this.runnables).queue) {
                logger.fatal((Object)(this.runnables + " " + this.id + " " + sr));
            }
            Assert.fail();
        }
        return next;
    }

    @Override
    public synchronized boolean clearQueue() {
        while (!this.runnables.isEmpty()) {
            SchedulingRunnable sr = this.runnables.checkDeferred();
            if (sr != null) {
                sr.start();
            }
            ((DefermentQueue)this.runnables).pause();
        }
        return true;
    }

    private void processInvokeRequest(ServerEntityRequest request, ResultCapture response, MessagePayload message, int key) {
        if (this.isInActiveState) {
            key = this.concurrencyStrategy.concurrencyKey(message.decodeRawMessage(raw -> this.codec.decodeMessage(raw)));
        }
        int locked = key;
        this.scheduleInOrder(request, response, message, () -> this.invoke(request, response, message, locked), locked);
    }

    private void processSyncCreateMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action == ServerEntityAction.RECEIVE_SYNC_CREATE_ENTITY ? 1 : 0) != 0);
        this.scheduleInOrder(sync, response, syncPayload, () -> this.invokeLifecycleOperation(sync, syncPayload, response), 0);
    }

    private void processSyncStartEndMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action == ServerEntityAction.RECEIVE_SYNC_ENTITY_START_SYNCING || action == ServerEntityAction.RECEIVE_SYNC_ENTITY_END ? 1 : 0) != 0);
        this.scheduleInOrder(sync, response, syncPayload, () -> this.invokeLifecycleOperation(sync, syncPayload, response), 0);
    }

    private void processSyncPayloadOtherMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload, int concurrencyKey) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_CREATE_ENTITY ? 1 : 0) != 0);
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_ENTITY_START_SYNCING ? 1 : 0) != 0);
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_ENTITY_END ? 1 : 0) != 0);
        if (action == ServerEntityAction.RECEIVE_SYNC_PAYLOAD) {
            this.scheduleInOrder(sync, response, syncPayload, () -> this.invoke(sync, response, syncPayload, concurrencyKey), concurrencyKey);
        } else {
            this.scheduleInOrder(sync, response, syncPayload, () -> this.invoke(sync, response, null, concurrencyKey), concurrencyKey);
        }
    }

    public void dumpStateTo(StateDumper stateDumper) {
        if (this.activeServerEntity != null) {
            if (this.activeServerEntity instanceof StateDumpable) {
                ((StateDumpable)this.activeServerEntity).dumpStateTo(stateDumper);
            } else {
                stateDumper.dumpState(this.getID().toString(), this.activeServerEntity.toString());
            }
        }
        if (this.passiveServerEntity != null) {
            if (this.passiveServerEntity instanceof StateDumpable) {
                ((StateDumpable)this.passiveServerEntity).dumpStateTo(stateDumper);
            } else {
                stateDumper.dumpState(this.getID().toString(), this.passiveServerEntity.toString());
            }
        }
    }

    private <R> R runWithHelper(CodecHelper<R> helper) throws EntityUserException {
        R message = null;
        try {
            message = helper.run();
        }
        catch (MessageCodecException deserializationException) {
            throw new EntityUserException(this.getID().getClassName(), this.getID().getEntityName(), (Throwable)deserializationException);
        }
        catch (RuntimeException e) {
            MessageCodecException deserializationException = new MessageCodecException("Runtime exception in deserializer", (Throwable)e);
            throw new EntityUserException(this.getID().getClassName(), this.getID().getEntityName(), (Throwable)deserializationException);
        }
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeLifecycleOperation(ServerEntityRequest request, MessagePayload payload, ResultCapture resp) {
        Lock read = this.reconnectAccessLock.readLock();
        logger.info((Object)("Client:" + request.getNodeID() + " Invoking lifecycle " + (Object)((Object)request.getAction()) + " on " + this.getID()));
        read.lock();
        try {
            switch (request.getAction()) {
                case CREATE_ENTITY: {
                    this.createEntity(resp, payload.getRawPayload());
                    return;
                }
                case FETCH_ENTITY: {
                    this.getEntity(request, resp, payload.getRawPayload());
                    return;
                }
                case RELEASE_ENTITY: {
                    this.releaseEntity(request, resp);
                    return;
                }
                case RECONFIGURE_ENTITY: {
                    this.reconfigureEntity(resp, payload.getRawPayload());
                    return;
                }
                case DESTROY_ENTITY: {
                    this.destroyEntity(request, resp);
                    return;
                }
                case RECEIVE_SYNC_CREATE_ENTITY: {
                    this.resetReferences(payload.getReferenceCount());
                    this.receiveSyncCreateEntity(resp, payload.getRawPayload());
                    return;
                }
                case RECEIVE_SYNC_ENTITY_START_SYNCING: {
                    resp.complete();
                    this.receiveSyncEntityStartSyncing();
                    return;
                }
                case RECEIVE_SYNC_ENTITY_END: {
                    this.receiveSyncEntityEnd(resp);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown request " + request);
                }
            }
        }
        catch (ConfigurationException ce) {
            EntityConfigurationException wrapper = new EntityConfigurationException(this.id.getClassName(), this.id.getEntityName(), (Throwable)ce);
            logger.error((Object)"configuration error during a lifecyle operation ", (Throwable)wrapper);
            resp.failure((EntityException)wrapper);
            return;
        }
        catch (TCShutdownServerException shutdown) {
            throw shutdown;
        }
        catch (TCServerRestartException shutdown) {
            throw shutdown;
        }
        catch (Exception e) {
            EntityUserException wrapper = new EntityUserException(this.id.getClassName(), this.id.getEntityName(), (Throwable)e);
            logger.error((Object)"caught exception during invoke ", (Throwable)wrapper);
            throw new RuntimeException(wrapper);
        }
        finally {
            read.unlock();
            if (this.isInActiveState) {
                this.interop.finishLifecycle();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invoke(ServerEntityRequest request, ResultCapture response, MessagePayload message, int concurrencyKey) {
        if (request.requiresReceived()) {
            response.waitForReceived();
        }
        response.received();
        Lock read = this.reconnectAccessLock.readLock();
        try {
            read.lock();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((Object)((Object)request.getAction()) + " on " + this.getID() + "/" + concurrencyKey + " with " + message));
            }
            switch (request.getAction()) {
                case INVOKE_ACTION: {
                    this.performAction(request, response, message);
                    return;
                }
                case REQUEST_SYNC_ENTITY: {
                    this.performSync(response, request.replicateTo(this.executor.passives()), concurrencyKey);
                    return;
                }
                case RECEIVE_SYNC_ENTITY_KEY_START: {
                    this.receiveSyncEntityKeyStart(response, concurrencyKey);
                    return;
                }
                case RECEIVE_SYNC_ENTITY_KEY_END: {
                    this.receiveSyncEntityKeyEnd(response, concurrencyKey);
                    return;
                }
                case RECEIVE_SYNC_PAYLOAD: {
                    this.receiveSyncEntityPayload(response, message);
                    return;
                }
                case LOCAL_FLUSH: 
                case ORDER_PLACEHOLDER_ONLY: 
                case LOCAL_FLUSH_AND_SYNC: {
                    throw new IllegalArgumentException("Flow-only request observed in invoke path: " + request);
                }
                default: {
                    throw new IllegalArgumentException("Unknown request " + request);
                }
            }
        }
        catch (Exception e) {
            EntityUserException wrapper = new EntityUserException(this.id.getClassName(), this.id.getEntityName(), (Throwable)e);
            logger.error((Object)"caught exception during invoke ", (Throwable)wrapper);
            throw new RuntimeException(wrapper);
        }
        finally {
            read.unlock();
        }
    }

    private void receiveSyncCreateEntity(ResultCapture response, byte[] constructor) {
        if (this.passiveServerEntity != null) {
            throw new AssertionError((Object)("not null " + this.getID()));
        }
        Assert.assertNull(this.passiveServerEntity);
        try {
            this.createEntity(response, constructor);
        }
        catch (ConfigurationException ce) {
            throw new TCShutdownServerException("unable to create entity on passive sync " + this.id);
        }
    }

    private void receiveSyncEntityStartSyncing() {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.startSyncEntity();
    }

    private void receiveSyncEntityEnd(ResultCapture response) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.endSyncEntity();
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityKeyStart(ResultCapture response, int concurrencyKey) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.startSyncConcurrencyKey(concurrencyKey);
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityKeyEnd(ResultCapture response, int concurrencyKey) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.endSyncConcurrencyKey(concurrencyKey);
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityPayload(ResultCapture response, MessagePayload message) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.invoke(message.decodeRawMessage(raw -> this.syncCodec.decode(message.getConcurrency(), raw)));
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public boolean isActive() {
        return this.isInActiveState;
    }

    @Override
    public boolean isRemoveable() {
        return this.isDestroyed && this.runnables.isEmpty() && ((DefermentQueue)this.runnables).deferCleared;
    }

    private void destroyEntity(ServerEntityRequest request, ResultCapture response) {
        ActiveServerEntity<EntityMessage, EntityResponse> commonServerEntity = this.isInActiveState ? this.activeServerEntity : this.passiveServerEntity;
        EntityDescriptor entityDescriptor = EntityDescriptor.createDescriptorForLifecycle((EntityID)this.id, (long)this.version);
        if (this.isDestroyed) {
            response.failure((EntityException)new EntityNotFoundException(entityDescriptor.getEntityID().getClassName(), entityDescriptor.getEntityID().getEntityName()));
        } else if (null != commonServerEntity) {
            if (!this.canDelete) {
                Assert.assertTrue((this.clientReferenceCount < 0 ? 1 : 0) != 0);
                response.failure((EntityException)new VoltronWrapperException((RuntimeEntityException)new PermanentEntityException(entityDescriptor.getEntityID().getClassName(), entityDescriptor.getEntityID().getEntityName())));
            } else if (this.clientReferenceCount == 0) {
                Assert.assertTrue((!this.isInActiveState || this.clientEntityStateManager.verifyNoReferences(entityDescriptor.getEntityID()) ? 1 : 0) != 0);
                Assert.assertFalse((boolean)this.isDestroyed);
                commonServerEntity.destroy();
                this.retirementManager.entityWasDestroyed();
                if (this.isInActiveState) {
                    this.activeServerEntity = null;
                } else {
                    this.passiveServerEntity = null;
                }
                this.isDestroyed = true;
                this.eventCollector.entityWasDestroyed(this.id);
                response.complete();
            } else {
                Assert.assertTrue((!this.isInActiveState || !this.clientEntityStateManager.verifyNoReferences(entityDescriptor.getEntityID()) ? 1 : 0) != 0);
                response.failure((EntityException)new EntityReferencedException(entityDescriptor.getEntityID().getClassName(), entityDescriptor.getEntityID().getEntityName()));
            }
        }
    }

    private void reconfigureEntity(ResultCapture reconfigureEntityRequest, byte[] constructorInfo) throws ConfigurationException {
        byte[] oldconfig = this.constructorInfo;
        if (this.isDestroyed || this.activeServerEntity == null && this.passiveServerEntity == null) {
            reconfigureEntityRequest.failure((EntityException)new EntityNotFoundException(this.getID().getClassName(), this.getID().getEntityName()));
            return;
        }
        this.constructorInfo = constructorInfo;
        if (this.isInActiveState) {
            if (null == this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " does not exists.");
            }
            this.activeServerEntity = (ActiveServerEntity)this.factory.reconfigureEntity((ServiceRegistry)this.registry, this.activeServerEntity, constructorInfo);
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
        } else {
            if (null == this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " does not exists.");
            }
            this.passiveServerEntity = (PassiveServerEntity)this.factory.reconfigureEntity((ServiceRegistry)this.registry, this.passiveServerEntity, this.constructorInfo);
            Assert.assertNull(this.concurrencyStrategy);
            Assert.assertNull(this.executionStrategy);
        }
        reconfigureEntityRequest.complete(oldconfig);
        this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, this.isInActiveState);
    }

    void setCreateParent(ManagedEntity create) {
        this.createParent = create;
    }

    private void createEntity(ResultCapture response, byte[] constructorInfo) throws ConfigurationException {
        if (this.createParent != null && !this.createParent.isDestroyed()) {
            response.failure((EntityException)new EntityAlreadyExistsException(this.getID().getClassName(), this.getID().getEntityName()));
            return;
        }
        if (!(this.isDestroyed || this.activeServerEntity == null && this.passiveServerEntity == null)) {
            response.failure((EntityException)new EntityAlreadyExistsException(this.getID().getClassName(), this.getID().getEntityName()));
            return;
        }
        this.constructorInfo = constructorInfo;
        if (this.isInActiveState) {
            if (null != this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " already exists.");
            }
            ActiveServerEntity tmpEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
            tmpEntity.createNew();
            this.activeServerEntity = tmpEntity;
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
        } else {
            if (null != this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " already exists.");
            }
            PassiveServerEntity tmpEntity = this.factory.createPassiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
            tmpEntity.createNew();
            this.passiveServerEntity = tmpEntity;
            Assert.assertNull(this.concurrencyStrategy);
        }
        this.isDestroyed = false;
        this.eventCollector.entityWasCreated(this.id, this.consumerID, this.isInActiveState);
        response.complete();
    }

    private void performSync(ResultCapture response, final Set<NodeID> passives, final int concurrencyKey) {
        if (!this.isDestroyed) {
            if (this.isInActiveState) {
                if (null == this.activeServerEntity) {
                    throw new IllegalStateException("Actions on a non-existent entity.");
                }
                PassiveSynchronizationChannel<EntityMessage> syncChannel = new PassiveSynchronizationChannel<EntityMessage>(){

                    public void synchronizeToPassive(EntityMessage payload) {
                        for (NodeID passive : passives) {
                            try {
                                byte[] message = (byte[])ManagedEntityImpl.this.runWithHelper(() -> ManagedEntityImpl.this.syncCodec.encode(concurrencyKey, payload));
                                ManagedEntityImpl.this.executor.scheduleSync(SyncReplicationActivity.createPayloadMessage((EntityID)ManagedEntityImpl.this.id, (long)ManagedEntityImpl.this.version, (FetchID)ManagedEntityImpl.this.fetchID, (int)concurrencyKey, (byte[])message, (String)""), passive).waitForReceived();
                            }
                            catch (EntityUserException eu) {
                                throw new RuntimeException(eu);
                            }
                        }
                    }
                };
                this.activeServerEntity.synchronizeKeyToPassive((PassiveSynchronizationChannel)syncChannel, concurrencyKey);
            } else {
                throw new IllegalStateException("syncing a passive entity");
            }
        }
        response.complete();
    }

    private void performAction(ServerEntityRequest wrappedRequest, ResultCapture response, MessagePayload message) {
        Assert.assertNotNull((Object)message);
        EntityMessage em = message.decodeRawMessage(raw -> this.codec.decodeMessage(raw));
        if (this.isInActiveState) {
            if (null == this.activeServerEntity) {
                throw new IllegalStateException("Actions on a non-existent entity.");
            }
            try {
                int concurrencyKey = this.concurrencyStrategy.concurrencyKey(em);
                this.retirementManager.registerWithMessage(em, concurrencyKey);
                ExecutionStrategy.Location loc = this.executionStrategy.getExecutionLocation(em);
                if (loc.runOnActive()) {
                    EntityResponse resp = this.activeServerEntity.invoke((ClientDescriptor)new ClientDescriptorImpl(wrappedRequest.getNodeID(), wrappedRequest.getClientInstance()), em);
                    byte[] er = this.runWithHelper(() -> this.codec.encodeResponse(resp));
                    response.complete(er);
                }
                response.complete(new byte[0]);
            }
            catch (EntityUserException e) {
                response.failure((EntityException)((Object)e));
                throw new RuntimeException(e);
            }
        } else {
            if (null == this.passiveServerEntity) {
                throw new IllegalStateException("Actions on a non-existent entity.");
            }
            this.passiveServerEntity.invoke(em);
            response.complete();
            Assert.assertFalse((boolean)this.isInActiveState);
        }
    }

    public MessageCodec<?, ?> getCodec() {
        return this.codec;
    }

    @Override
    public RetirementManager getRetirementManager() {
        return this.retirementManager;
    }

    @Override
    public void loadEntity(byte[] configuration) {
        try {
            this.loadExisting(configuration);
        }
        catch (ConfigurationException ce) {
            throw new TCShutdownServerException("unable to create entity on passive sync " + this.id);
        }
    }

    private void getEntity(ServerEntityRequest getEntityRequest, ResultCapture response, byte[] extendedData) {
        if (this.isDestroyed) {
            response.failure((EntityException)new EntityNotFoundException(this.id.getClassName(), this.id.getEntityName()));
        } else {
            if (this.canDelete) {
                ++this.clientReferenceCount;
                Assert.assertTrue((this.clientReferenceCount > 0 ? 1 : 0) != 0);
            }
            if (this.isInActiveState) {
                ClientID clientID = getEntityRequest.getNodeID();
                ClientDescriptorImpl descriptor = new ClientDescriptorImpl(clientID, getEntityRequest.getClientInstance());
                boolean added = this.clientEntityStateManager.addReference(descriptor, this.id);
                Assert.assertTrue((boolean)added);
                this.eventCollector.clientDidFetchEntity(clientID, this.id, getEntityRequest.getClientInstance());
                this.activeServerEntity.connected((ClientDescriptor)descriptor);
                if (getEntityRequest.getTransaction().equals((Object)TransactionID.NULL_ID)) {
                    this.activeServerEntity.handleReconnect((ClientDescriptor)descriptor, extendedData);
                }
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.constructorInfo.length + 8);
            buffer.putLong(this.consumerID);
            buffer.put(this.constructorInfo);
            response.complete(buffer.array());
        }
    }

    private void releaseEntity(ServerEntityRequest request, ResultCapture response) {
        if (this.isDestroyed) {
            response.failure((EntityException)new EntityNotFoundException(this.id.getClassName(), this.id.getEntityName()));
        } else {
            if (this.canDelete) {
                --this.clientReferenceCount;
                Assert.assertTrue((this.clientReferenceCount >= 0 ? 1 : 0) != 0);
            }
            if (this.isInActiveState) {
                ClientID clientID = request.getNodeID();
                ClientDescriptorImpl clientInstance = new ClientDescriptorImpl(clientID, request.getClientInstance());
                boolean removed = this.clientEntityStateManager.removeReference(clientInstance);
                Assert.assertTrue((boolean)removed);
                this.activeServerEntity.disconnected((ClientDescriptor)clientInstance);
                this.eventCollector.clientDidReleaseEntity(clientID, this.id, request.getClientInstance());
            }
            response.complete();
        }
    }

    @Override
    public void resetReferences(int count) {
        this.clientReferenceCount = count;
    }

    @Override
    public void promoteEntity() throws ConfigurationException {
        Assert.assertFalse((boolean)this.isInActiveState);
        Assert.assertNull(this.activeServerEntity);
        this.isInActiveState = true;
        this.clientReferenceCount = 0;
        if (!this.isDestroyed) {
            if (null != this.passiveServerEntity) {
                this.activeServerEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
                this.concurrencyStrategy = this.factory.getConcurrencyStrategy(this.constructorInfo);
                this.executionStrategy = this.factory.getExecutionStrategy(this.constructorInfo);
                this.activeServerEntity.loadExisting();
                this.passiveServerEntity = null;
                this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, true);
            } else {
                throw new IllegalStateException("no entity to promote");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(NodeID passive) {
        PassiveSyncServerEntityRequest req = new PassiveSyncServerEntityRequest(passive);
        BarrierCompletion opComplete = new BarrierCompletion();
        this.executor.scheduleRequest(this.id, this.version, this.fetchID, new ServerEntityRequestImpl(ClientInstanceID.NULL_ID, ServerEntityAction.LOCAL_FLUSH_AND_SYNC, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, false, Collections.emptySet()), MessagePayload.emptyPayload(), () -> {
            Assert.assertTrue((boolean)this.isInActiveState);
            if (!this.isDestroyed) {
                this.executor.scheduleSync(SyncReplicationActivity.createStartEntityMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID, (byte[])this.constructorInfo, (int)(this.canDelete ? this.clientReferenceCount : -1)), passive).waitForCompleted();
            }
            opComplete.complete();
        }, true, 0).waitForCompleted();
        opComplete.waitForCompletion();
        this.interop.syncStarted();
        try {
            if (!this.isDestroyed) {
                for (Integer concurrency : this.concurrencyStrategy.getKeysForSynchronization()) {
                    Assert.assertTrue((concurrency > 0 ? 1 : 0) != 0);
                    BarrierCompletion sectionComplete = new BarrierCompletion();
                    this.executor.scheduleRequest(this.id, this.version, this.fetchID, req, MessagePayload.emptyPayload(), () -> this.invoke(req, new ResultCapture(null, result -> sectionComplete.complete(), null, null, false), MessagePayload.emptyPayload(), concurrency), true, concurrency).waitForCompleted();
                    sectionComplete.waitForCompletion();
                    this.executor.scheduleSync(SyncReplicationActivity.createEndEntityKeyMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID, (int)concurrency), passive).waitForCompleted();
                }
                this.executor.scheduleSync(SyncReplicationActivity.createEndEntityMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID), passive).waitForCompleted();
            }
        }
        finally {
            this.interop.syncFinished();
        }
    }

    @Override
    public SyncReplicationActivity.EntityCreationTuple startSync() {
        this.interop.startSync();
        this.clearQueue();
        if (!this.isDestroyed) {
            return new SyncReplicationActivity.EntityCreationTuple(this.id, this.version, this.consumerID, this.constructorInfo, this.canDelete);
        }
        return null;
    }

    @Override
    public long getConsumerID() {
        return this.consumerID;
    }

    private void loadExisting(byte[] constructorInfo) throws ConfigurationException {
        this.constructorInfo = constructorInfo;
        if (this.isInActiveState) {
            if (null != this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " already exists.");
            }
            this.activeServerEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, constructorInfo);
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
            this.activeServerEntity.loadExisting();
            this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, this.isInActiveState);
        } else {
            if (null != this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " already exists.");
            }
            this.passiveServerEntity = this.factory.createPassiveEntity((ServiceRegistry)this.registry, constructorInfo);
            Assert.assertNull(this.concurrencyStrategy);
        }
        this.isDestroyed = false;
    }

    private static class ResultCapture
    implements SimpleCompletion {
        private final Runnable received;
        private final Consumer<byte[]> result;
        private final Consumer<EntityException> error;
        private SchedulingRunnable setOnce;
        private boolean done = false;
        private final boolean lifecycle;
        private final Object debugID;
        private final SetOnceFlag receivedSent = new SetOnceFlag();

        private ResultCapture(Runnable received, Consumer<byte[]> result, Consumer<EntityException> error, Object debugID, boolean lifecycle) {
            this.received = received;
            this.result = result;
            this.error = error;
            this.lifecycle = lifecycle;
            this.debugID = debugID;
        }

        public void setWaitFor(SchedulingRunnable waitFor) {
            Assert.assertNull((Object)this.setOnce);
            this.setOnce = waitFor;
        }

        public synchronized void finish() {
            Assert.assertFalse((boolean)this.done);
            this.done = true;
            this.notify();
        }

        public void waitForReceived() {
            if (this.setOnce != null) {
                ActivePassiveAckWaiter waiter = this.setOnce.waitForPassives();
                waiter.waitForReceived();
            }
        }

        @Override
        public void waitForCompletion() {
            this.waitForCompletion(0L, TimeUnit.MILLISECONDS);
        }

        public synchronized void waitForCompletion(long timeout, TimeUnit units) {
            boolean interrupted = false;
            while (!this.done) {
                try {
                    this.wait(units.toMillis(timeout));
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        public void received() {
            this.receivedSent.set();
            if (this.received != null) {
                this.received.run();
            }
        }

        public void complete() {
            if (!this.receivedSent.isSet()) {
                this.received();
            }
            if (this.result != null) {
                if (this.setOnce != null) {
                    ActivePassiveAckWaiter waiter = this.setOnce.waitForPassives();
                    waiter.waitForCompleted();
                    if (this.lifecycle && waiter.verifyLifecycleResult(true)) {
                        logger.warn((Object)("ZAP occurred while processing " + this.debugID));
                    }
                }
                this.result.accept(null);
            }
            this.finish();
        }

        public void complete(byte[] value) {
            if (!this.receivedSent.isSet()) {
                this.received();
            }
            if (this.result != null) {
                if (this.setOnce != null) {
                    ActivePassiveAckWaiter waiter = this.setOnce.waitForPassives();
                    waiter.waitForCompleted();
                    if (this.lifecycle && waiter.verifyLifecycleResult(true)) {
                        logger.warn((Object)("ZAP occurred while processing " + this.debugID));
                    }
                }
                this.result.accept(value);
            }
            this.finish();
        }

        public void failure(EntityException ee) {
            if (!this.receivedSent.isSet()) {
                this.received();
            }
            if (this.error != null) {
                if (this.setOnce != null) {
                    ActivePassiveAckWaiter waiter = this.setOnce.waitForPassives();
                    waiter.waitForCompleted();
                    if (this.lifecycle && waiter.verifyLifecycleResult(false)) {
                        logger.warn((Object)("ZAP occurred while processing " + this.debugID));
                    }
                }
                this.error.accept(ee);
            }
            this.finish();
        }
    }

    private static class DefermentQueue<T>
    implements Iterable<T> {
        private final LinkedList<T> queue = new LinkedList();
        private final int limit;
        private volatile boolean deferCleared = true;

        public DefermentQueue(int limit) {
            this.limit = limit;
        }

        T checkDeferred() {
            if (this.deferCleared && !this.queue.isEmpty()) {
                return this.queue.pop();
            }
            return null;
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        boolean activate() {
            try {
                boolean bl = this.deferCleared;
                return bl;
            }
            finally {
                this.deferCleared = false;
            }
        }

        synchronized boolean clear() {
            try {
                this.notifyAll();
                boolean bl = this.deferCleared;
                return bl;
            }
            finally {
                this.deferCleared = true;
            }
        }

        boolean offer(T msg) {
            if (!this.deferCleared || !this.queue.isEmpty()) {
                this.queue.add(msg);
                if (this.queue.size() == this.limit) {
                    this.pause();
                }
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                T msg;

                @Override
                public boolean hasNext() {
                    this.msg = this.checkDeferred();
                    return this.msg != null;
                }

                @Override
                public T next() {
                    return this.msg;
                }
            };
        }

        private synchronized void pause() {
            boolean interrupted = false;
            while (!this.deferCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class SchedulingRunnable
    implements Runnable {
        private final ServerEntityRequest request;
        private final MessagePayload payload;
        private final Runnable original;
        private final int concurrency;
        private ActivePassiveAckWaiter waitFor;

        public SchedulingRunnable(ServerEntityRequest request, MessagePayload payload, Runnable r, int concurrency) {
            this.request = request;
            this.payload = payload;
            this.original = r;
            this.concurrency = concurrency;
        }

        private synchronized void start() {
            ExecutionStrategy.Location loc;
            if (this.concurrency == 0) {
                ManagedEntityImpl.this.runnables.activate();
            }
            boolean replicate = this.payload.shouldReplicate();
            switch (this.request.getAction()) {
                case CREATE_ENTITY: 
                case DESTROY_ENTITY: 
                case FETCH_ENTITY: 
                case RECONFIGURE_ENTITY: 
                case RELEASE_ENTITY: {
                    if (!replicate && ManagedEntityImpl.this.isInActiveState) {
                        logger.warn((Object)("Ignoring replication flag. All lifecycle operations are replicated " + (Object)((Object)this.request.getAction())));
                    }
                    replicate = true;
                    break;
                }
            }
            if (ManagedEntityImpl.this.isActive() && this.request.getAction() == ServerEntityAction.INVOKE_ACTION && (loc = ManagedEntityImpl.this.executionStrategy.getExecutionLocation(this.payload.decodeRawMessage(raw -> ManagedEntityImpl.this.codec.decodeMessage(raw)))) != ExecutionStrategy.Location.IGNORE) {
                replicate = loc.runOnPassive();
            }
            this.waitFor = ManagedEntityImpl.this.executor.scheduleRequest(ManagedEntityImpl.this.id, ManagedEntityImpl.this.version, ManagedEntityImpl.this.fetchID, this.request, this.payload, this, replicate, this.concurrency);
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                this.original.run();
            }
            finally {
                this.end();
            }
        }

        private void end() {
            if (this.concurrency == 0) {
                ManagedEntityImpl.this.runnables.clear();
                ServerEntityAction action = this.request.getAction();
                if (this.request.getAction() == ServerEntityAction.CREATE_ENTITY && ManagedEntityImpl.this.isDestroyed()) {
                    action = ServerEntityAction.DESTROY_ENTITY;
                }
                ManagedEntityImpl.this.flushLocalPipeline.completed(ManagedEntityImpl.this.id, ManagedEntityImpl.this.fetchID, action);
            }
        }

        private synchronized ActivePassiveAckWaiter waitForPassives() {
            try {
                while (this.waitFor == null) {
                    this.wait();
                }
                return this.waitFor;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PassiveSyncServerEntityRequest
    implements ServerEntityRequest {
        private final NodeID passive;
        private final ServerEntityAction action = ServerEntityAction.REQUEST_SYNC_ENTITY;

        public PassiveSyncServerEntityRequest(NodeID passive) {
            this.passive = passive;
        }

        @Override
        public ClientID getNodeID() {
            return ClientID.NULL_ID;
        }

        @Override
        public boolean requiresReceived() {
            return false;
        }

        @Override
        public Set<NodeID> replicateTo(Set<NodeID> passives) {
            return this.passive == null ? Collections.emptySet() : Collections.singleton(this.passive);
        }

        @Override
        public ClientInstanceID getClientInstance() {
            return null;
        }

        @Override
        public ServerEntityAction getAction() {
            return this.action;
        }

        @Override
        public TransactionID getTransaction() {
            return TransactionID.NULL_ID;
        }

        @Override
        public TransactionID getOldestTransactionOnClient() {
            return TransactionID.NULL_ID;
        }
    }

    private static interface CodecHelper<R> {
        public R run() throws MessageCodecException;
    }
}

