/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.objectserver.entity.MessageDecoder;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.MessageCodecException;

public class MessagePayload {
    private final byte[] raw;
    private EntityMessage message;
    private final int concurrency;
    private final int referenceCount;
    private final boolean replicate;
    private final boolean canBeBusy;
    private String debugId;

    public static final MessagePayload emptyPayload() {
        return new MessagePayload(new byte[0], null, 0, 0, true, true);
    }

    public static final MessagePayload rawDataOnly(byte[] raw) {
        return new MessagePayload(raw, null, 0, 0, false, false);
    }

    public static final MessagePayload commonMessagePayloadBusy(byte[] raw, EntityMessage message, boolean replicate) {
        return new MessagePayload(raw, message, 0, 0, replicate, true);
    }

    public static final MessagePayload commonMessagePayloadNotBusy(byte[] raw, EntityMessage message, boolean replicate) {
        return new MessagePayload(raw, message, 0, 0, replicate, false);
    }

    public static final MessagePayload syncPayloadNormal(byte[] raw, int concurrencyKey) {
        return new MessagePayload(raw, null, concurrencyKey, 0, false, false);
    }

    public static final MessagePayload syncPayloadCreation(byte[] raw, int referenceCount) {
        return new MessagePayload(raw, null, 0, referenceCount, false, false);
    }

    private MessagePayload(byte[] raw, EntityMessage message, int concurrency, int referenceCount, boolean replicate, boolean canBeBusy) {
        this.raw = raw;
        this.message = message;
        this.debugId = message != null ? message.toString() : "";
        this.concurrency = concurrency;
        this.referenceCount = referenceCount;
        this.replicate = replicate;
        this.canBeBusy = canBeBusy;
    }

    public byte[] getRawPayload() {
        return this.raw;
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public boolean canBeBusy() {
        return this.canBeBusy;
    }

    public EntityMessage decodeRawMessage(MessageDecoder codec) {
        try {
            return this.decodeMessage(codec);
        }
        catch (MessageCodecException mce) {
            throw new RuntimeException(mce);
        }
    }

    public EntityMessage decodeMessage(MessageDecoder codec) throws MessageCodecException {
        if (this.message == null) {
            this.message = codec.decode(this.raw);
            this.setDebugId(this.message.toString());
        }
        return this.message;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public boolean shouldReplicate() {
        return this.replicate;
    }

    public String toString() {
        return "MessagePayload{debugId=" + this.debugId + '}';
    }
}

