/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Sink;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.NoReplicationBroker;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;

public class RequestProcessor {
    private PassiveReplicationBroker passives;
    private final Sink<Runnable> requestExecution;
    private boolean isActive = false;
    private static final TCLogger PLOGGER = TCLogging.getLogger(MessagePayload.class);
    private static final EnumMap<ServerEntityAction, SyncReplicationActivity.ActivityType> typeMap = new EnumMap(ServerEntityAction.class);

    public RequestProcessor(Sink<Runnable> requestExecution) {
        this.requestExecution = requestExecution;
    }

    public void enterActiveState() {
        this.passives.enterActiveState();
        this.isActive = true;
    }

    public Set<NodeID> passives() {
        return this.passives.passives();
    }

    public ActivePassiveAckWaiter scheduleSync(SyncReplicationActivity activity, NodeID passive) {
        return this.passives.replicateActivity(activity, Collections.singleton(passive));
    }

    public void setReplication(PassiveReplicationBroker passives) {
        Assert.assertNull((Object)this.passives);
        this.passives = passives;
    }

    public synchronized ActivePassiveAckWaiter scheduleRequest(EntityID eid, long version, FetchID fetchID, ServerEntityRequest request, MessagePayload payload, Runnable call, boolean replicate, int concurrencyKey) {
        Set<NodeID> replicateTo;
        ServerEntityAction requestAction = request.getAction();
        boolean isActionReplicated = ServerEntityAction.LOCAL_FLUSH != requestAction && ServerEntityAction.MANAGED_ENTITY_GC != requestAction && ServerEntityAction.LOCAL_FLUSH_AND_SYNC != requestAction;
        Set<NodeID> set = replicateTo = this.isActive && isActionReplicated && this.passives != null ? request.replicateTo(this.passives.passives()) : Collections.emptySet();
        if (!replicateTo.isEmpty() && !replicate) {
            if (request.requiresReceived()) {
                requestAction = ServerEntityAction.ORDER_PLACEHOLDER_ONLY;
            } else {
                replicateTo = Collections.emptySet();
            }
        }
        ActivePassiveAckWaiter token = !replicateTo.isEmpty() ? this.passives.replicateActivity(RequestProcessor.createReplicationActivity(eid, version, fetchID, request.getNodeID(), requestAction, request.getTransaction(), request.getOldestTransactionOnClient(), payload, concurrencyKey), replicateTo) : NoReplicationBroker.NOOP_WAITER;
        EntityRequest entityRequest = new EntityRequest(eid, call, concurrencyKey);
        if (PLOGGER.isDebugEnabled()) {
            PLOGGER.debug((Object)("SCHEDULING:" + payload.getDebugId() + " on " + eid + ":" + concurrencyKey));
        }
        this.requestExecution.addMultiThreaded((Object)entityRequest);
        return token;
    }

    private static SyncReplicationActivity createReplicationActivity(EntityID id, long version, FetchID fetchID, ClientID src, ServerEntityAction type, TransactionID tid, TransactionID oldest, MessagePayload payload, int concurrency) {
        SyncReplicationActivity.ActivityType actionCode = typeMap.get((Object)type);
        Assert.assertNotNull((Object)actionCode);
        SyncReplicationActivity activity = null;
        activity = SyncReplicationActivity.ActivityType.ORDERING_PLACEHOLDER == actionCode ? SyncReplicationActivity.createOrderingPlaceholder((FetchID)fetchID, (ClientID)src, (TransactionID)tid, (TransactionID)oldest, (String)payload.getDebugId()) : (SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN == actionCode ? SyncReplicationActivity.createStartEntityKeyMessage((EntityID)id, (long)version, (FetchID)fetchID, (int)concurrency) : (SyncReplicationActivity.ActivityType.INVOKE_ACTION == actionCode ? SyncReplicationActivity.createInvokeMessage((FetchID)fetchID, (ClientID)src, (TransactionID)tid, (TransactionID)oldest, (SyncReplicationActivity.ActivityType)actionCode, (byte[])payload.getRawPayload(), (int)concurrency, (String)payload.getDebugId()) : SyncReplicationActivity.createLifecycleMessage((EntityID)id, (long)version, (FetchID)fetchID, (ClientID)src, (TransactionID)tid, (TransactionID)oldest, (SyncReplicationActivity.ActivityType)actionCode, (byte[])payload.getRawPayload())));
        return activity;
    }

    static {
        typeMap.put(ServerEntityAction.CREATE_ENTITY, SyncReplicationActivity.ActivityType.CREATE_ENTITY);
        typeMap.put(ServerEntityAction.RECONFIGURE_ENTITY, SyncReplicationActivity.ActivityType.RECONFIGURE_ENTITY);
        typeMap.put(ServerEntityAction.DESTROY_ENTITY, SyncReplicationActivity.ActivityType.DESTROY_ENTITY);
        typeMap.put(ServerEntityAction.FETCH_ENTITY, SyncReplicationActivity.ActivityType.FETCH_ENTITY);
        typeMap.put(ServerEntityAction.INVOKE_ACTION, SyncReplicationActivity.ActivityType.INVOKE_ACTION);
        typeMap.put(ServerEntityAction.ORDER_PLACEHOLDER_ONLY, SyncReplicationActivity.ActivityType.ORDERING_PLACEHOLDER);
        typeMap.put(ServerEntityAction.RELEASE_ENTITY, SyncReplicationActivity.ActivityType.RELEASE_ENTITY);
        typeMap.put(ServerEntityAction.REQUEST_SYNC_ENTITY, SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN);
    }

    public static class EntityRequest
    implements MultiThreadedEventContext,
    Runnable {
        private final EntityID entity;
        private final Runnable invoke;
        private final int key;

        public EntityRequest(EntityID entity, Runnable runnable, int key) {
            this.entity = entity;
            this.invoke = runnable;
            this.key = key;
        }

        public Object getSchedulingKey() {
            if (this.key == Integer.MIN_VALUE) {
                return null;
            }
            return this.key ^ this.entity.hashCode();
        }

        @Override
        public void run() {
            this.invoke();
        }

        void invoke() {
            this.invoke.run();
        }

        public boolean flush() {
            return this.key == 0;
        }
    }
}

