/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.classloader.PermanentEntity;
import com.tc.classloader.ServiceLocator;
import com.tc.entity.VoltronEntityMessage;
import com.tc.objectserver.impl.PermanentEntityParser;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.PassiveServerEntity;

public class ServerEntityFactory {
    public static <T extends EntityServerService<? extends ActiveServerEntity, ? extends PassiveServerEntity>> T getService(String typeName) throws ClassNotFoundException {
        return ServerEntityFactory.getService(typeName, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends EntityServerService<? extends EntityMessage, ? extends EntityResponse>> T getService(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        List<Class<EntityServerService>> serviceLoader = ServiceLocator.getImplementations(EntityServerService.class, classLoader);
        for (Class<EntityServerService> serverService : serviceLoader) {
            try {
                EntityServerService instance = serverService.newInstance();
                if (!instance.handlesEntityType(typeName)) continue;
                return (T)instance;
            }
            catch (IllegalAccessException | InstantiationException i) {
                throw new RuntimeException(i);
            }
        }
        throw new ClassNotFoundException(typeName);
    }

    public static List<VoltronEntityMessage> getAnnotatedEntities(ClassLoader classLoader) {
        ArrayList<VoltronEntityMessage> msgs = new ArrayList<VoltronEntityMessage>();
        List<Class<EntityServerService>> serviceLoader = ServiceLocator.getImplementations(EntityServerService.class, classLoader);
        for (Class<EntityServerService> serverService : serviceLoader) {
            if (!serverService.isAnnotationPresent(PermanentEntity.class)) continue;
            PermanentEntity pe = serverService.getAnnotation(PermanentEntity.class);
            String type = pe.type();
            String[] names = pe.names();
            int version = pe.version();
            for (String name : names) {
                msgs.add(PermanentEntityParser.createMessage(type, name, version, new byte[0]));
            }
        }
        return msgs;
    }
}

