/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.entity.AbstractServerEntityRequestResponse;
import com.tc.util.Assert;
import java.util.Optional;
import java.util.function.Supplier;
import org.terracotta.exception.EntityException;

public class ServerEntityRequestResponse
extends AbstractServerEntityRequestResponse {
    private final EntityDescriptor descriptor;
    protected final Supplier<Optional<MessageChannel>> returnChannel;
    private final boolean isReplicatedMessage;
    private final boolean requiresReceived;

    public ServerEntityRequestResponse(EntityDescriptor descriptor, ServerEntityAction action, TransactionID transaction, TransactionID oldest, ClientID src, Supplier<Optional<MessageChannel>> returnChannel, boolean requiresReceived, boolean isReplicatedMessage) {
        super(action, transaction, oldest, src);
        this.descriptor = descriptor;
        this.returnChannel = returnChannel;
        this.requiresReceived = requiresReceived;
        this.isReplicatedMessage = isReplicatedMessage;
    }

    @Override
    public Optional<MessageChannel> getReturnChannel() {
        return this.returnChannel.get();
    }

    @Override
    public synchronized void complete(byte[] value) {
        if (this.isComplete()) {
            throw new AssertionError((Object)("Double-sending response " + (Object)((Object)this.getAction())));
        }
        if (value == null) {
            super.complete();
        } else {
            super.complete(value);
        }
    }

    @Override
    public synchronized void complete() {
        if (this.isComplete()) {
            throw new AssertionError((Object)("Double-sending response " + (Object)((Object)this.getAction())));
        }
        super.complete();
    }

    @Override
    public synchronized void failure(EntityException e) {
        if (this.isComplete()) {
            throw new AssertionError("Double-sending response " + (Object)((Object)this.getAction()), e);
        }
        super.failure(e);
    }

    public void setAutoRetire() {
        super.autoRetire(true);
    }

    @Override
    public boolean requiresReceived() {
        return this.requiresReceived;
    }

    @Override
    public synchronized void retired() {
        Assert.assertFalse((boolean)this.isReplicatedMessage);
        if (this.isRetired()) {
            throw new AssertionError((Object)("Double-sending retire " + (Object)((Object)this.getAction())));
        }
        super.retired();
    }

    @Override
    public ClientInstanceID getClientInstance() {
        return this.descriptor.getClientInstanceID();
    }

    public String toString() {
        return "ServerEntityRequestResponse{action=" + (Object)((Object)this.getAction()) + ", descriptor=" + this.descriptor.getEntityID() + '}';
    }
}

