/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.Sink;
import com.tc.entity.MessageCodecSupplier;
import com.tc.entity.NetworkVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageSink;

public class VoltronMessageSink
implements TCMessageSink {
    private final Sink<VoltronEntityMessage> destSink;
    private final Sink<HydrateContext> hydrateSink;
    private final MessageCodecSupplier codecSupplier;

    public VoltronMessageSink(Sink<VoltronEntityMessage> destSink, Sink<HydrateContext> hydrateSink, MessageCodecSupplier codecSupplier) {
        this.destSink = destSink;
        this.hydrateSink = hydrateSink;
        this.codecSupplier = codecSupplier;
    }

    public void putMessage(TCMessage message) {
        if (message instanceof NetworkVoltronEntityMessage) {
            ((NetworkVoltronEntityMessage)message).setMessageCodecSupplier(this.codecSupplier);
        }
        HydrateContext context = new HydrateContext(message, this.destSink);
        this.hydrateSink.addMultiThreaded((Object)context);
    }
}

