/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.EventHandlerException;
import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Sink;
import com.tc.async.api.SpecializedEventContext;
import com.tc.async.api.StageManager;
import com.tc.async.impl.InBandMoveToNextSink;
import com.tc.entity.VoltronEntityMessage;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.util.ProductID;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ChannelLifeCycleHandler
implements DSOChannelManagerEventListener {
    private final CommunicationsManager commsManager;
    private final DSOChannelManager channelMgr;
    private final StateManager coordinator;
    private final ClientEntityStateManager clientEvents;
    private final ManagementTopologyEventCollector collector;
    private final Set<ClientID> knownClients = new HashSet<ClientID>();
    private static final TCLogger logger = TCLogging.getLogger(ChannelLifeCycleHandler.class);
    private final Sink<HydrateContext> hydrateSink;
    private final Sink<VoltronEntityMessage> processTransactionSink;
    private final Sink<ReplicationMessage> replicatedTransactionSink;
    private final Sink<Runnable> requestProcessorSink;

    public ChannelLifeCycleHandler(CommunicationsManager commsManager, StageManager stageManager, DSOChannelManager channelManager, ClientEntityStateManager chain, StateManager coordinator, ManagementTopologyEventCollector collector) {
        this.commsManager = commsManager;
        this.channelMgr = channelManager;
        this.coordinator = coordinator;
        this.clientEvents = chain;
        this.collector = collector;
        this.hydrateSink = stageManager.getStage("hydrate_message_stage", HydrateContext.class).getSink();
        this.processTransactionSink = stageManager.getStage("voltron_message_stage", VoltronEntityMessage.class).getSink();
        this.replicatedTransactionSink = stageManager.getStage("passive_replication_stage", ReplicationMessage.class).getSink();
        this.requestProcessorSink = stageManager.getStage("request_processor_stage", Runnable.class).getSink();
    }

    private void nodeDisconnected(NodeID nodeID, ProductID productId, boolean wasActive) {
        if (1 == nodeID.getNodeType()) {
            ClientID clientID = (ClientID)nodeID;
            if (this.coordinator.isActiveCoordinator()) {
                this.broadcastClientClusterMembershipMessage(1, clientID, productId);
                List<VoltronEntityMessage> msg = this.clientEvents.clientDisconnected(clientID);
                if (!msg.isEmpty()) {
                    this.collector.expectedReleases(clientID, msg.stream().map(m -> m.getEntityDescriptor()).collect(Collectors.toList()));
                    msg.forEach(m -> this.processTransactionSink.addSingleThreaded(m));
                }
                if (wasActive) {
                    this.notifyClientRemoved(clientID);
                }
            }
        }
        if (this.commsManager.isInShutdown()) {
            logger.info((Object)("Ignoring transport disconnect for " + nodeID + " while shutting down."));
        } else {
            logger.info((Object)(": Received transport disconnect.  Shutting down client " + nodeID));
        }
    }

    private void nodeConnected(NodeID nodeID, ProductID productId) {
        if (1 == nodeID.getNodeType()) {
            ClientID clientID = (ClientID)nodeID;
            if (this.coordinator.isActiveCoordinator()) {
                this.broadcastClientClusterMembershipMessage(0, clientID, productId);
            }
        }
    }

    private void broadcastClientClusterMembershipMessage(int eventType, ClientID clientID, ProductID productId) {
        MessageChannel[] channels;
        for (MessageChannel channel : channels = this.channelMgr.getActiveChannels()) {
            if (this.channelMgr.getClientIDFor(channel.getChannelID()).equals((Object)clientID)) continue;
            ClusterMembershipMessage cmm = (ClusterMembershipMessage)channel.createMessage(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE);
            cmm.initialize(eventType, (NodeID)clientID, productId);
            cmm.send();
        }
    }

    public void channelCreated(MessageChannel channel) {
        ClientID clientID = (ClientID)channel.getRemoteNodeID();
        this.clientCreated(clientID, channel.getProductId());
        if (this.coordinator.isActiveCoordinator()) {
            this.notifyClientAdded(channel, clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientAdded(MessageChannel channel, ClientID clientID) {
        Set<ClientID> set = this.knownClients;
        synchronized (set) {
            this.collector.clientDidConnect(channel, clientID);
            this.knownClients.add(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientRemoved(ClientID clientID) {
        Set<ClientID> set = this.knownClients;
        synchronized (set) {
            if (this.knownClients.contains(clientID)) {
                this.collector.clientDidDisconnect(clientID);
                this.knownClients.remove(clientID);
            }
        }
    }

    public void clientCreated(ClientID client, ProductID product) {
        this.nodeConnected((NodeID)client, product);
    }

    public void clientDropped(final ClientID clientID, final ProductID product, final boolean wasActive) {
        ClientID inBandSchedulerKey = clientID;
        SpecializedEventContext sec = new SpecializedEventContext(){

            public void execute() throws EventHandlerException {
                ChannelLifeCycleHandler.this.requestProcessorSink.addMultiThreaded((Object)new FlushThenDisconnect(clientID, product, wasActive));
            }

            public Object getSchedulingKey() {
                return 0;
            }

            public boolean flush() {
                return true;
            }
        };
        InBandMoveToNextSink context3 = new InBandMoveToNextSink(null, sec, this.coordinator.isActiveCoordinator() ? this.processTransactionSink : this.replicatedTransactionSink, (NodeID)inBandSchedulerKey, false);
        this.hydrateSink.addSpecialized((SpecializedEventContext)context3);
    }

    public void channelRemoved(MessageChannel channel, boolean wasActive) {
        ClientID clientID = (ClientID)channel.getRemoteNodeID();
        ProductID product = channel.getProductId();
        this.clientDropped(clientID, product, wasActive);
    }

    private class FlushThenDisconnect
    implements MultiThreadedEventContext,
    Runnable {
        private final ClientID clientID;
        private final ProductID product;
        private final boolean wasActive;

        public FlushThenDisconnect(ClientID client, ProductID product, boolean wasActive) {
            this.clientID = client;
            this.product = product;
            this.wasActive = wasActive;
        }

        public Object getSchedulingKey() {
            return 0;
        }

        public boolean flush() {
            return true;
        }

        @Override
        public void run() {
            ChannelLifeCycleHandler.this.nodeDisconnected((NodeID)this.clientID, this.product, this.wasActive);
        }
    }
}

