/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handshakemanager.ClientHandshakeException;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import com.tc.objectserver.handshakemanager.ServerClientModeInCompatibleException;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventFactory;
import com.tc.properties.TCPropertiesImpl;

public class ClientHandshakeHandler
extends AbstractEventHandler<ClientHandshakeMessage> {
    protected static final String OPEN_SOURCE = "Opensource";
    protected static final String ENTERPRISE = "Enterprise";
    public static final String LAGS = "lags";
    public static final String LEADS = "leads";
    private static final int SYSTEM_TIME_DIFF_THRESHOLD = TCPropertiesImpl.getProperties().getInt("tc.time.sync.threshold", 30) * 1000;
    private static final TCLogger LOGGER = TCLogging.getLogger(ClientHandshakeHandler.class);
    private ServerClientHandshakeManager handshakeManager;
    private StateManager stateManager;
    private final String serverName;
    private final EntityManager entityManager;
    private final ProcessTransactionHandler transactionHandler;

    public ClientHandshakeHandler(String serverName, EntityManager entityManager, ProcessTransactionHandler transactionHandler) {
        this.serverName = serverName;
        this.entityManager = entityManager;
        this.transactionHandler = transactionHandler;
    }

    public void handleEvent(ClientHandshakeMessage clientMsg) {
        try {
            if (clientMsg.diagnosticClient()) {
                this.handshakeManager.notifyDiagnosticClient(clientMsg);
            } else if (this.stateManager.isActiveCoordinator()) {
                NodeID remoteNodeID = clientMsg.getChannel().getRemoteNodeID();
                this.checkCompatibility(clientMsg.enterpriseClient(), remoteNodeID);
                this.checkTimeDifference(remoteNodeID, clientMsg.getLocalTimeMills());
                this.handshakeManager.notifyClientConnect(clientMsg, this.entityManager, this.transactionHandler);
            } else {
                this.handshakeManager.notifyClientRefused(clientMsg, "do not handshake with passive");
            }
        }
        catch (ClientHandshakeException e) {
            this.getLogger().error((Object)"Handshake Error : ", (Throwable)e);
            MessageChannel c = clientMsg.getChannel();
            this.getLogger().error((Object)("Closing channel " + c.getChannelID() + " because of previous errors"));
            c.close();
        }
        catch (ServerClientModeInCompatibleException e) {
            this.getLogger().error((Object)"Handshake Error : ", (Throwable)e);
            this.handshakeManager.notifyClientRefused(clientMsg, e.getMessage());
        }
    }

    protected void checkCompatibility(boolean isEnterpriseClient, NodeID remoteNodeID) throws ServerClientModeInCompatibleException {
        if (isEnterpriseClient) {
            TerracottaOperatorEvent handshakeRefusedEvent = TerracottaOperatorEventFactory.createHandShakeRejectedEvent((String)ENTERPRISE, (NodeID)remoteNodeID, (String)OPEN_SOURCE);
            this.logEvent(handshakeRefusedEvent);
            throw new ServerClientModeInCompatibleException("An Enterprise client can not connect to an Opensource Server, Connection refused.");
        }
    }

    protected void logEvent(TerracottaOperatorEvent event) {
        switch (event.getEventLevel()) {
            case INFO: {
                LOGGER.info((Object)event.getEventMessage());
                break;
            }
            case WARN: {
                LOGGER.warn((Object)event.getEventMessage());
                break;
            }
            case ERROR: {
                LOGGER.error((Object)event.getEventMessage());
                break;
            }
            case DEBUG: {
                LOGGER.debug((Object)event.getEventMessage());
                break;
            }
            case CRITICAL: {
                LOGGER.fatal((Object)event.getEventMessage());
                break;
            }
        }
    }

    private void checkTimeDifference(NodeID remoteNodeID, long localTimeMills) {
        long timeDiff = System.currentTimeMillis() - localTimeMills;
        if (Math.abs(timeDiff) > (long)SYSTEM_TIME_DIFF_THRESHOLD) {
            if (timeDiff > 0L) {
                this.logEvent(TerracottaOperatorEventFactory.createSystemTimeDifferentEvent((NodeID)remoteNodeID, (String)LAGS, (String)this.serverName, (long)(Math.abs(timeDiff) / 1000L)));
            } else {
                this.logEvent(TerracottaOperatorEventFactory.createSystemTimeDifferentEvent((NodeID)remoteNodeID, (String)LEADS, (String)this.serverName, (long)(Math.abs(timeDiff) / 1000L)));
            }
        }
    }

    public void initialize(ConfigurationContext ctxt) {
        super.initialize(ctxt);
        ServerConfigurationContext scc = (ServerConfigurationContext)ctxt;
        this.handshakeManager = scc.getClientHandshakeManager();
        this.stateManager = scc.getL2Coordinator().getStateManager();
    }
}

