/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.net.ClientID;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.util.Assert;
import org.terracotta.exception.EntityException;

public class EntityExistenceHelpers {
    public static boolean createEntityReturnWasCached(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, long consumerID, byte[] configuration, boolean canDelete) throws EntityException {
        boolean resultWasCached = false;
        Assert.assertNotNull((Object)clientID);
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        if (!clientID.isNull() && entityPersistor.wasEntityCreatedInJournal(clientID, transactionID)) {
            resultWasCached = true;
        } else {
            entityManager.createEntity(entityID, version, consumerID, canDelete);
        }
        return resultWasCached;
    }

    public static void recordEntityCreate(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, long consumerID, byte[] configuration, boolean canDelete, EntityException exception) {
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        if (!clientID.isNull()) {
            if (exception == null) {
                entityPersistor.entityCreated(clientID, transactionID, oldestTransactionOnClient, entityID, version, consumerID, canDelete, configuration);
            } else {
                entityPersistor.entityCreateFailed(clientID, transactionID, oldestTransactionOnClient, exception);
            }
        }
    }

    public static boolean destroyEntityReturnWasCached(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID) throws EntityException {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        return entityPersistor.wasEntityDestroyedInJournal(clientID, transactionID);
    }

    public static void recordDestroyEntity(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, EntityException exception) {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        if (exception == null) {
            entityPersistor.entityDestroyed(clientID, transactionID, oldestTransactionOnClient, entityID);
        } else {
            entityPersistor.entityDestroyFailed(clientID, transactionID, oldestTransactionOnClient, exception);
        }
    }

    public static boolean doesExist(EntityPersistor entityPersistor, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID) {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        return entityPersistor.containsEntity(clientID, transactionID, oldestTransactionOnClient, entityID);
    }

    public static void recordReconfigureEntity(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, byte[] configuration, EntityException exception) {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        if (exception == null) {
            entityPersistor.entityReconfigureSucceeded(clientID, transactionID, oldestTransactionOnClient, entityID, version, configuration);
        } else {
            entityPersistor.entityReconfigureFailed(clientID, transactionID, oldestTransactionOnClient, exception);
        }
    }

    public static byte[] reconfigureEntityReturnCachedResult(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, byte[] configuration) throws EntityException {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        return entityPersistor.reconfiguredResultInJournal(clientID, transactionID);
    }
}

