/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.l2.msg.IBatchableGroupMessage;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;

public class GroupMessageBatchContext<M extends IBatchableGroupMessage<E>, E> {
    private final IBatchableMessageFactory<M, E> messageFactory;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final NodeID target;
    private final int maximumBatchSize;
    private final int idealMessagesInFlight;
    private final Runnable networkDoneTarget;
    private int messagesInFlight;
    private M cachedMessage;
    private long nextReplicationID;
    private GroupException mostRecentException;
    private final Runnable handleMessageSend = new Runnable(){

        @Override
        public void run() {
            GroupMessageBatchContext.this.handleNetworkDone();
        }
    };

    public GroupMessageBatchContext(IBatchableMessageFactory<M, E> messageFactory, GroupManager<AbstractGroupMessage> groupManager, NodeID target, int maximumBatchSize, int idealMessagesInFlight, Runnable networkDoneTarget) {
        this.messageFactory = messageFactory;
        this.groupManager = groupManager;
        this.target = target;
        this.maximumBatchSize = maximumBatchSize;
        this.idealMessagesInFlight = idealMessagesInFlight;
        this.networkDoneTarget = networkDoneTarget;
    }

    public synchronized boolean batchMessage(E activity) throws GroupException {
        if (null != this.mostRecentException) {
            throw this.mostRecentException;
        }
        boolean didCreateNewBatch = false;
        if (null != this.cachedMessage) {
            this.cachedMessage.addToBatch(activity);
        } else {
            this.cachedMessage = this.messageFactory.createNewBatch(activity, this.nextReplicationID++);
            didCreateNewBatch = true;
        }
        return didCreateNewBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatch() throws GroupException {
        Object messageToSend = null;
        GroupMessageBatchContext groupMessageBatchContext = this;
        synchronized (groupMessageBatchContext) {
            if (null != this.cachedMessage && (0 == this.idealMessagesInFlight || this.messagesInFlight < this.idealMessagesInFlight || this.cachedMessage.getBatchSize() >= this.maximumBatchSize)) {
                messageToSend = this.cachedMessage;
                this.cachedMessage = null;
                ++this.messagesInFlight;
            }
        }
        if (null != messageToSend) {
            try {
                this.groupManager.sendToWithSentCallback(this.target, messageToSend.asAbstractGroupMessage(), this.handleMessageSend);
            }
            catch (GroupException e) {
                GroupMessageBatchContext groupMessageBatchContext2 = this;
                synchronized (groupMessageBatchContext2) {
                    this.mostRecentException = e;
                    --this.messagesInFlight;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNetworkDone() {
        GroupMessageBatchContext groupMessageBatchContext = this;
        synchronized (groupMessageBatchContext) {
            --this.messagesInFlight;
        }
        this.networkDoneTarget.run();
    }

    public static interface IBatchableMessageFactory<N extends IBatchableGroupMessage<E>, E> {
        public N createNewBatch(E var1, long var2);
    }
}

