/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.NoSuchChannelException;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.Retiree;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.ReconnectListener;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.objectserver.entity.ServerEntityRequestResponse;
import com.tc.objectserver.handler.EntityExistenceHelpers;
import com.tc.objectserver.handler.RetirementManager;
import com.tc.objectserver.persistence.EntityData;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.objectserver.persistence.TransactionOrderPersistor;
import com.tc.util.Assert;
import com.tc.util.SparseList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityUserException;

public class ProcessTransactionHandler
implements ReconnectListener {
    private static final TCLogger LOGGER = TCLogging.getLogger(ProcessTransactionHandler.class);
    private final EntityPersistor entityPersistor;
    private final TransactionOrderPersistor transactionOrderPersistor;
    private final Runnable stateManagerCleanup;
    private final EntityManager entityManager;
    private final DSOChannelManager dsoChannelManager;
    private List<ReferenceMessage> references;
    private SparseList<ResendVoltronEntityMessage> resendReplayList;
    private List<ResendVoltronEntityMessage> resendNewList;
    private boolean reconnecting = true;
    private Sink<TCMessage> multiSend;
    private ConcurrentHashMap<ClientID, TCMessage> invokeReturn = new ConcurrentHashMap();
    private ConcurrentHashMap<TransactionID, Future<Void>> transactionOrderPersistenceFutures = new ConcurrentHashMap();
    private final AbstractEventHandler<TCMessage> multiSender = new AbstractEventHandler<TCMessage>(){

        public void handleEvent(TCMessage context) throws EventHandlerException {
            NodeID destinationID = context.getDestinationNodeID();
            ProcessTransactionHandler.this.invokeReturn.remove((ClientID)destinationID, context);
            if (context instanceof VoltronEntityMultiResponse) {
                VoltronEntityMultiResponse voltronEntityMultiResponse = (VoltronEntityMultiResponse)context;
                voltronEntityMultiResponse.stopAdding();
                for (TransactionID transactionID : voltronEntityMultiResponse.getReceivedTransactions()) {
                    ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(transactionID);
                }
            } else if (context instanceof VoltronEntityAppliedResponse) {
                ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(((VoltronEntityAppliedResponse)context).getTransactionID());
            } else {
                Assert.fail((String)("Unexpected message type: " + context.getClass()));
            }
            boolean didSend = context.send();
            if (!didSend) {
                LOGGER.warn((Object)("Failed to send message to: " + destinationID));
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("sent " + context));
            }
        }
    };
    private final AbstractEventHandler<VoltronEntityMessage> voltronHandler = new AbstractEventHandler<VoltronEntityMessage>(){

        public void handleEvent(VoltronEntityMessage message) throws EventHandlerException {
            ProcessTransactionHandler.this.processAllResends(message);
            ClientID sourceNodeID = message.getSource();
            EntityDescriptor descriptor = message.getEntityDescriptor();
            ServerEntityAction action = ProcessTransactionHandler.decodeMessageType(message.getVoltronType());
            EntityMessage entityMessage = message.getEntityMessage();
            byte[] extendedData = message.getExtendedData();
            TransactionID transactionID = message.getTransactionID();
            boolean doesRequireReplication = message.doesRequireReplication();
            TransactionID oldestTransactionOnClient = message.getOldestTransactionOnClient();
            boolean requestedReceived = message.doesRequestReceived();
            ProcessTransactionHandler.this.addMessage(sourceNodeID, descriptor, action, MessagePayload.commonMessagePayloadBusy(extendedData, entityMessage, doesRequireReplication), transactionID, oldestTransactionOnClient, requestedReceived);
        }

        protected void initialize(ConfigurationContext context) {
            super.initialize(context);
            ServerConfigurationContext server = (ServerConfigurationContext)context;
            server.getL2Coordinator().getReplicatedClusterStateManager().setCurrentState(server.getL2Coordinator().getStateManager().getCurrentState());
            server.getL2Coordinator().getReplicatedClusterStateManager().goActiveAndSyncState();
            Stage mss = server.getStage("respond_to_request_stage", TCMessage.class);
            ProcessTransactionHandler.this.multiSend = mss.getSink();
            ProcessTransactionHandler.this.entityManager.enterActiveState();
            server.getClientHandshakeManager().addReconnectListener(ProcessTransactionHandler.this);
        }
    };

    private void sendMultiResponse(VoltronEntityMultiResponse response) {
        this.multiSend.addSingleThreaded((Object)response);
    }

    @Override
    public synchronized void reconnectComplete() {
        this.reconnecting = false;
        this.notify();
    }

    public AbstractEventHandler<TCMessage> getMultiResponseSender() {
        return this.multiSender;
    }

    public AbstractEventHandler<VoltronEntityMessage> getVoltronMessageHandler() {
        return this.voltronHandler;
    }

    public ProcessTransactionHandler(EntityPersistor entityPersistor, TransactionOrderPersistor transactionOrderPersistor, DSOChannelManager channelManager, EntityManager entityManager, Runnable stateManagerCleanup) {
        this.entityPersistor = entityPersistor;
        this.transactionOrderPersistor = transactionOrderPersistor;
        this.dsoChannelManager = channelManager;
        this.entityManager = entityManager;
        this.stateManagerCleanup = stateManagerCleanup;
        this.references = new LinkedList<ReferenceMessage>();
        this.resendReplayList = new SparseList();
        this.resendNewList = new LinkedList<ResendVoltronEntityMessage>();
    }

    public Iterable<ManagedEntity> snapshotEntityList(Consumer<List<ManagedEntity>> runFirst) {
        return this.entityManager.snapshot(runFirst);
    }

    private void addSequentially(ClientID target, Predicate<VoltronEntityMultiResponse> adder) {
        boolean handled = false;
        while (!handled) {
            TCMessage old = this.invokeReturn.get(target);
            if (old instanceof VoltronEntityMultiResponse) {
                handled = adder.test((VoltronEntityMultiResponse)old);
            }
            if (handled) continue;
            Optional<MessageChannel> channel = this.safeGetChannel((NodeID)target);
            if (channel.isPresent()) {
                VoltronEntityMultiResponse vmr = (VoltronEntityMultiResponse)channel.get().createMessage(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE);
                old = this.invokeReturn.putIfAbsent(target, (TCMessage)vmr);
                if (old instanceof VoltronEntityMultiResponse) {
                    handled = adder.test((VoltronEntityMultiResponse)old);
                    continue;
                }
                handled = adder.test(vmr);
                Assert.assertTrue((boolean)handled);
                this.sendMultiResponse(vmr);
                continue;
            }
            handled = true;
        }
    }

    private static void retireMessagesForEntity(ManagedEntity entity, EntityMessage message) {
        List<Retiree> readyToRetire = entity.getRetirementManager().retireForCompletion(message);
        for (Retiree toRetire : readyToRetire) {
            if (null == toRetire) continue;
            toRetire.retired();
        }
    }

    private void addMessage(final ClientID sourceNodeID, EntityDescriptor descriptor, ServerEntityAction action, MessagePayload entityMessage, TransactionID transactionID, TransactionID oldestTransactionOnClient, boolean requiresReceived) {
        boolean isReplicatedMessage = false;
        final ServerEntityRequestResponse serverEntityRequest = new ServerEntityRequestResponse(descriptor, action, transactionID, oldestTransactionOnClient, sourceNodeID, () -> this.safeGetChannel((NodeID)sourceNodeID), requiresReceived, isReplicatedMessage);
        Future<Void> transactionOrderPersistenceFuture = null;
        if (!ClientID.NULL_ID.equals((Object)sourceNodeID)) {
            if (null != oldestTransactionOnClient) {
                transactionOrderPersistenceFuture = this.transactionOrderPersistor.updateWithNewMessage(sourceNodeID, transactionID, oldestTransactionOnClient);
                serverEntityRequest.setTransactionOrderPersistenceFuture(transactionOrderPersistenceFuture);
            } else {
                this.transactionOrderPersistor.removeTrackingForClient(sourceNodeID);
                this.entityPersistor.removeTrackingForClient(sourceNodeID);
            }
        }
        if (ServerEntityAction.CREATE_ENTITY == action) {
            long consumerID = this.entityPersistor.getNextConsumerID();
            serverEntityRequest.setAutoRetire();
            try {
                boolean canDelete = !sourceNodeID.isNull();
                EntityID entityID = descriptor.getEntityID();
                ManagedEntity temp = this.entityManager.createEntity(entityID, descriptor.getClientSideVersion(), consumerID, canDelete);
                temp.addRequestMessage(serverEntityRequest, entityMessage, serverEntityRequest::received, result -> {
                    if (!sourceNodeID.isNull()) {
                        this.entityPersistor.entityCreated(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), entityID, descriptor.getClientSideVersion(), consumerID, true, entityMessage.getRawPayload());
                        serverEntityRequest.complete();
                    } else {
                        this.entityPersistor.entityCreatedNoJournal(entityID, descriptor.getClientSideVersion(), consumerID, true, entityMessage.getRawPayload());
                        serverEntityRequest.complete();
                    }
                }, exception -> {
                    this.entityPersistor.entityCreateFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), (EntityException)((Object)exception));
                    serverEntityRequest.failure((EntityException)((Object)exception));
                });
            }
            catch (EntityException ee) {
                if (!sourceNodeID.isNull()) {
                    this.entityPersistor.entityCreateFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), ee);
                }
                serverEntityRequest.failure(ee);
            }
        } else {
            ManagedEntity entity = null;
            try {
                Optional<ManagedEntity> optionalEntity = this.entityManager.getEntity(descriptor);
                if (!optionalEntity.isPresent()) {
                    if (!descriptor.isIndexed()) {
                        throw new EntityNotFoundException(descriptor.getEntityID().getClassName(), descriptor.getEntityID().getEntityName());
                    }
                    throw new AssertionError((Object)"fetched entity not found");
                }
                entity = optionalEntity.get();
                if (ServerEntityAction.INVOKE_ACTION == action) {
                    ManagedEntity locked = entity;
                    try {
                        if (transactionOrderPersistenceFuture != null) {
                            this.transactionOrderPersistenceFutures.put(transactionID, transactionOrderPersistenceFuture);
                        }
                        EntityMessage message = entityMessage.decodeMessage(raw -> locked.getCodec().decodeMessage(raw));
                        locked.addRequestMessage(serverEntityRequest, entityMessage, () -> this.addSequentially(sourceNodeID, addto -> addto.addReceived(transactionID)), result -> {
                            this.addSequentially(sourceNodeID, addTo -> addTo.addResult(transactionID, result));
                            RetirementManager retirementManager = locked.getRetirementManager();
                            retirementManager.updateWithRetiree(message, new Retiree(){

                                @Override
                                public void retired() {
                                    ProcessTransactionHandler.this.addSequentially(sourceNodeID, addTo -> addTo.addRetired(serverEntityRequest.getTransaction()));
                                }

                                @Override
                                public TransactionID getTransaction() {
                                    return serverEntityRequest.getTransaction();
                                }
                            });
                            ProcessTransactionHandler.retireMessagesForEntity(locked, message);
                        }, fail -> {
                            this.safeGetChannel((NodeID)sourceNodeID).ifPresent(channel -> {
                                VoltronEntityAppliedResponse failMessage = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
                                failMessage.setFailure(transactionID, fail, false);
                                this.invokeReturn.put(sourceNodeID, (TCMessage)failMessage);
                                this.multiSend.addSingleThreaded((Object)failMessage);
                            });
                            locked.getRetirementManager().updateWithRetiree(message, new Retiree(){

                                @Override
                                public void retired() {
                                    ProcessTransactionHandler.this.addSequentially(sourceNodeID, addTo -> addTo.addRetired(serverEntityRequest.getTransaction()));
                                }

                                @Override
                                public TransactionID getTransaction() {
                                    return serverEntityRequest.getTransaction();
                                }
                            });
                            ProcessTransactionHandler.retireMessagesForEntity(locked, message);
                        });
                    }
                    catch (MessageCodecException codec) {
                        serverEntityRequest.failure((EntityException)new EntityUserException(locked.getID().getClassName(), locked.getID().getEntityName(), (Throwable)codec));
                        serverEntityRequest.retired();
                    }
                } else if (ServerEntityAction.RECONFIGURE_ENTITY == action) {
                    serverEntityRequest.setAutoRetire();
                    entity.addRequestMessage(serverEntityRequest, entityMessage, serverEntityRequest::received, result -> {
                        EntityExistenceHelpers.recordReconfigureEntity(this.entityPersistor, this.entityManager, serverEntityRequest.getNodeID(), serverEntityRequest.getTransaction(), serverEntityRequest.getOldestTransactionOnClient(), descriptor.getEntityID(), descriptor.getClientSideVersion(), entityMessage.getRawPayload(), null);
                        serverEntityRequest.complete((byte[])result);
                    }, exception -> {
                        EntityExistenceHelpers.recordReconfigureEntity(this.entityPersistor, this.entityManager, serverEntityRequest.getNodeID(), serverEntityRequest.getTransaction(), serverEntityRequest.getOldestTransactionOnClient(), descriptor.getEntityID(), descriptor.getClientSideVersion(), entityMessage.getRawPayload(), exception);
                        serverEntityRequest.failure((EntityException)((Object)exception));
                    });
                } else if (ServerEntityAction.DESTROY_ENTITY == action) {
                    serverEntityRequest.setAutoRetire();
                    entity.addRequestMessage(serverEntityRequest, entityMessage, serverEntityRequest::received, result -> {
                        EntityExistenceHelpers.recordDestroyEntity(this.entityPersistor, this.entityManager, sourceNodeID, transactionID, oldestTransactionOnClient, descriptor.getEntityID(), null);
                        serverEntityRequest.complete();
                    }, exception -> {
                        EntityExistenceHelpers.recordDestroyEntity(this.entityPersistor, this.entityManager, sourceNodeID, transactionID, oldestTransactionOnClient, descriptor.getEntityID(), exception);
                        serverEntityRequest.failure((EntityException)((Object)exception));
                    });
                } else if (ServerEntityAction.FETCH_ENTITY == action || ServerEntityAction.RELEASE_ENTITY == action) {
                    serverEntityRequest.setAutoRetire();
                    entity.addRequestMessage(serverEntityRequest, entityMessage, serverEntityRequest::received, result -> serverEntityRequest.complete((byte[])result), exception -> serverEntityRequest.failure((EntityException)((Object)exception)));
                } else if (ServerEntityAction.MANAGED_ENTITY_GC == action && entity.isRemoveable()) {
                    LOGGER.debug((Object)("removing " + entity.getID()));
                    this.entityManager.removeDestroyed(descriptor.getFetchID());
                } else {
                    serverEntityRequest.setAutoRetire();
                    entity.addRequestMessage(serverEntityRequest, entityMessage, serverEntityRequest::received, serverEntityRequest::complete, serverEntityRequest::failure);
                }
            }
            catch (EntityException ee) {
                serverEntityRequest.failure(ee);
                serverEntityRequest.retired();
            }
        }
    }

    private void waitForTransactionOrderPersistenceFuture(TransactionID transactionID) {
        Future<Void> future = this.transactionOrderPersistenceFutures.get(transactionID);
        if (future != null) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.transactionOrderPersistenceFutures.remove(transactionID);
            }
        }
    }

    public void loadExistingEntities() {
        ArrayList<EntityData.Value> sortingList = new ArrayList<EntityData.Value>(this.entityPersistor.loadEntityData());
        Collections.sort(sortingList, new Comparator<EntityData.Value>(){

            @Override
            public int compare(EntityData.Value o1, EntityData.Value o2) {
                long firstID = o1.consumerID;
                long secondID = o2.consumerID;
                Assert.assertTrue((firstID != secondID ? 1 : 0) != 0);
                return firstID > secondID ? 1 : -1;
            }
        });
        for (EntityData.Value entityValue : sortingList) {
            Assert.assertTrue((entityValue.version > 0L ? 1 : 0) != 0);
            Assert.assertTrue((entityValue.consumerID > 0L ? 1 : 0) != 0);
            EntityID entityID = new EntityID(entityValue.className, entityValue.entityName);
            try {
                this.entityManager.loadExisting(entityID, entityValue.version, entityValue.consumerID, entityValue.canDelete, entityValue.configuration);
            }
            catch (EntityException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void handleResentReferenceMessage(ReferenceMessage msg) {
        this.references.add(msg);
    }

    public void handleResentMessage(ResendVoltronEntityMessage resentMessage) {
        boolean cached = false;
        byte[] result = null;
        int index = -1;
        try {
            switch (resentMessage.getVoltronType()) {
                case CREATE_ENTITY: {
                    cached = this.entityPersistor.wasEntityCreatedInJournal(resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    break;
                }
                case DESTROY_ENTITY: {
                    cached = this.entityPersistor.wasEntityDestroyedInJournal(resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    break;
                }
                case RECONFIGURE_ENTITY: {
                    result = this.entityPersistor.reconfiguredResultInJournal(resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    if (result == null) break;
                    cached = true;
                    break;
                }
                default: {
                    index = this.transactionOrderPersistor.getIndexToReplay(resentMessage.getSource(), resentMessage.getTransactionID());
                }
            }
            if (cached) {
                ServerEntityRequestResponse response = new ServerEntityRequestResponse(EntityDescriptor.NULL_ID, ServerEntityAction.CREATE_ENTITY, resentMessage.getTransactionID(), resentMessage.getOldestTransactionOnClient(), resentMessage.getSource(), () -> this.safeGetChannel((NodeID)resentMessage.getSource()), false, false);
                response.received();
                if (result != null) {
                    response.complete(result);
                } else {
                    response.complete();
                }
                response.retired();
            } else if (index >= 0) {
                this.resendReplayList.insert(index, resentMessage);
            } else {
                this.resendNewList.add(resentMessage);
            }
        }
        catch (EntityException ee) {
            ServerEntityRequestResponse response = new ServerEntityRequestResponse(EntityDescriptor.NULL_ID, ServerEntityAction.CREATE_ENTITY, resentMessage.getTransactionID(), resentMessage.getOldestTransactionOnClient(), resentMessage.getSource(), () -> this.safeGetChannel((NodeID)resentMessage.getSource()), false, false);
            response.received();
            response.failure(ee);
            response.retired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllResends(VoltronEntityMessage trigger) {
        if (this.references == null && this.resendReplayList == null && this.resendNewList == null) {
            return;
        }
        LOGGER.debug((Object)"RESENDS:START");
        Iterator<ResendVoltronEntityMessage> iterator = this;
        synchronized (iterator) {
            while (this.reconnecting) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        this.stateManagerCleanup.run();
        this.transactionOrderPersistor.clearAllRecords();
        for (ReferenceMessage msg : this.references) {
            LOGGER.debug((Object)("RESENDS:" + msg));
            try {
                EntityID eid = this.entityManager.getEntity(msg.getEntityDescriptor()).get().getID();
                Assert.assertEquals((Object)eid, (Object)msg.getEntityDescriptor().getEntityID());
            }
            catch (EntityException ee) {
                throw new RuntimeException(ee);
            }
            this.executeResend(msg);
        }
        this.references = null;
        for (ResendVoltronEntityMessage message : this.resendReplayList) {
            LOGGER.debug((Object)("RESENDS:" + message));
            this.executeResend((VoltronEntityMessage)message);
        }
        this.resendReplayList = null;
        for (ResendVoltronEntityMessage message : this.resendNewList) {
            LOGGER.debug((Object)("RESENDS:" + message));
            this.executeResend((VoltronEntityMessage)message);
        }
        this.entityPersistor.removeTrackingForClient(ClientID.NULL_ID);
        LOGGER.debug((Object)"RESENDS:END");
        this.resendNewList = null;
    }

    private Optional<MessageChannel> safeGetChannel(NodeID id) {
        try {
            return Optional.of(this.dsoChannelManager.getActiveChannel(id));
        }
        catch (NoSuchChannelException e) {
            return Optional.empty();
        }
    }

    private void executeResend(VoltronEntityMessage message) {
        ClientID sourceNodeID = message.getSource();
        EntityDescriptor descriptor = message.getEntityDescriptor();
        ServerEntityAction action = ProcessTransactionHandler.decodeMessageType(message.getVoltronType());
        EntityMessage entityMessage = message.getEntityMessage();
        Assert.assertNull((Object)entityMessage);
        byte[] extendedData = message.getExtendedData();
        TransactionID transactionID = message.getTransactionID();
        boolean doesRequireReplication = message.doesRequireReplication();
        TransactionID oldestTransactionOnClient = message.getOldestTransactionOnClient();
        MessagePayload payload = MessagePayload.commonMessagePayloadNotBusy(extendedData, entityMessage, doesRequireReplication);
        payload.setDebugId(message.toString());
        this.addMessage(sourceNodeID, descriptor, action, payload, transactionID, oldestTransactionOnClient, false);
    }

    private static ServerEntityAction decodeMessageType(VoltronEntityMessage.Type type) {
        ServerEntityAction action = null;
        switch (type) {
            case FETCH_ENTITY: {
                action = ServerEntityAction.FETCH_ENTITY;
                break;
            }
            case RELEASE_ENTITY: {
                action = ServerEntityAction.RELEASE_ENTITY;
                break;
            }
            case CREATE_ENTITY: {
                action = ServerEntityAction.CREATE_ENTITY;
                break;
            }
            case RECONFIGURE_ENTITY: {
                action = ServerEntityAction.RECONFIGURE_ENTITY;
                break;
            }
            case DESTROY_ENTITY: {
                action = ServerEntityAction.DESTROY_ENTITY;
                break;
            }
            case INVOKE_ACTION: {
                action = ServerEntityAction.INVOKE_ACTION;
                break;
            }
            case LOCAL_PIPELINE_FLUSH: {
                action = ServerEntityAction.LOCAL_FLUSH;
                break;
            }
            case LOCAL_ENTITY_GC: {
                action = ServerEntityAction.MANAGED_ENTITY_GC;
                break;
            }
            default: {
                Assert.fail();
            }
        }
        return action;
    }
}

