/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.l2.msg.ReplicationAckTuple;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.l2.msg.ReplicationMessageAck;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.entity.BarrierCompletion;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.PlatformEntity;
import com.tc.objectserver.handler.GroupMessageBatchContext;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.objectserver.persistence.TransactionOrderPersistor;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.terracotta.exception.EntityException;

public class ReplicatedTransactionHandler {
    private static final int DEFAULT_BATCH_LIMIT = 64;
    private static final int DEFAULT_INFLIGHT_MESSAGES = 1;
    private static final TCLogger PLOGGER = TCLogging.getLogger(MessagePayload.class);
    private static final TCLogger LOGGER = TCLogging.getLogger(ReplicatedTransactionHandler.class);
    private final EntityManager entityManager;
    private final EntityPersistor entityPersistor;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final TransactionOrderPersistor orderedTransactions;
    private final StateManager stateManager;
    private final ManagedEntity platform;
    private final SyncState state = new SyncState();
    private NodeID cachedMessageAckFrom;
    private GroupMessageBatchContext<ReplicationMessageAck, ReplicationAckTuple> cachedBatchAck;
    private final Runnable handleMessageSend = new Runnable(){

        @Override
        public void run() {
            ReplicatedTransactionHandler.this.outgoingResponseSink.addSingleThreaded((Object)ReplicatedTransactionHandler.this.selfMessageToken);
        }
    };
    private final EventHandler<ReplicationMessage> eventHorizon = new AbstractEventHandler<ReplicationMessage>(){

        public void handleEvent(ReplicationMessage message) throws EventHandlerException {
            try {
                ReplicatedTransactionHandler.this.processMessage(message);
            }
            catch (Throwable t) {
                throw Assert.failure((Object)"Unexpected exception executing replicated message", (Throwable)t);
            }
        }

        protected void initialize(ConfigurationContext context) {
            ServerConfigurationContext scxt = (ServerConfigurationContext)context;
            scxt.getL2Coordinator().getReplicatedClusterStateManager().setCurrentState(scxt.getL2Coordinator().getStateManager().getCurrentState());
            if (ReplicatedTransactionHandler.this.stateManager.getCurrentState().equals((Object)StateManager.PASSIVE_UNINITIALIZED)) {
                ReplicatedTransactionHandler.this.requestPassiveSync();
            }
        }

        public void destroy() {
            ServerEntityRequest req = new ServerEntityRequest(){

                @Override
                public ServerEntityAction getAction() {
                    return ServerEntityAction.LOCAL_FLUSH;
                }

                @Override
                public ClientID getNodeID() {
                    return ClientID.NULL_ID;
                }

                @Override
                public TransactionID getTransaction() {
                    return TransactionID.NULL_ID;
                }

                @Override
                public TransactionID getOldestTransactionOnClient() {
                    return TransactionID.NULL_ID;
                }

                @Override
                public ClientInstanceID getClientInstance() {
                    return ClientInstanceID.NULL_ID;
                }

                @Override
                public boolean requiresReceived() {
                    return false;
                }

                @Override
                public Set<NodeID> replicateTo(Set<NodeID> passives) {
                    return Collections.emptySet();
                }
            };
            for (ManagedEntity me : ReplicatedTransactionHandler.this.entityManager.getAll()) {
                BarrierCompletion latch = new BarrierCompletion();
                me.clearQueue();
                me.addRequestMessage(req, MessagePayload.emptyPayload(), null, result -> latch.complete(), exception -> Assert.fail());
                latch.waitForCompletion();
            }
            BarrierCompletion latch = new BarrierCompletion();
            ReplicatedTransactionHandler.this.platform.addRequestMessage(req, MessagePayload.emptyPayload(), null, result -> latch.complete(), null);
            latch.waitForCompletion();
        }
    };
    private final EventHandler<SedaToken> outgoingResponseHandler = new AbstractEventHandler<SedaToken>(){

        public void handleEvent(SedaToken ignored) throws EventHandlerException {
            try {
                ReplicatedTransactionHandler.this.cachedBatchAck.flushBatch();
            }
            catch (GroupException e) {
                LOGGER.error((Object)"Exception flushing ack batch context", (Throwable)e);
            }
        }
    };
    private Sink<SedaToken> outgoingResponseSink;
    private final SedaToken selfMessageToken = new SedaToken();

    public ReplicatedTransactionHandler(StateManager state, TransactionOrderPersistor transactionOrderPersistor, EntityManager manager, EntityPersistor entityPersistor, GroupManager<AbstractGroupMessage> groupManager) {
        this.stateManager = state;
        this.entityManager = manager;
        this.entityPersistor = entityPersistor;
        this.groupManager = groupManager;
        this.orderedTransactions = transactionOrderPersistor;
        try {
            this.platform = this.entityManager.getEntity(EntityDescriptor.createDescriptorForLifecycle((EntityID)PlatformEntity.PLATFORM_ID, (long)PlatformEntity.VERSION)).get();
        }
        catch (EntityException ee) {
            throw new RuntimeException(ee);
        }
    }

    public EventHandler<ReplicationMessage> getEventHandler() {
        return this.eventHorizon;
    }

    public EventHandler<SedaToken> getOutgoingResponseHandler() {
        return this.outgoingResponseHandler;
    }

    public void setOutgoingResponseSink(Sink<SedaToken> sink) {
        Assert.assertNull(this.outgoingResponseSink);
        this.outgoingResponseSink = sink;
    }

    private void processMessage(ReplicationMessage rep) throws EntityException {
        if (PLOGGER.isDebugEnabled()) {
            PLOGGER.debug((Object)("RECEIVED:" + rep.getDebugId()));
        }
        ServerID activeSender = (ServerID)rep.messageFrom();
        for (SyncReplicationActivity activity : rep.getActivities()) {
            if (activity.isSyncActivity()) {
                if (SyncReplicationActivity.ActivityType.SYNC_BEGIN == activity.getActivityType()) {
                    this.syncBeginEntityListReceived(activeSender, activity);
                    continue;
                }
                this.syncActivityReceived(activeSender, activity);
                continue;
            }
            if (this.state.ignore(activity)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Ignoring:" + rep));
                }
                this.acknowledge(activeSender, activity, ReplicationResultCode.NONE);
                continue;
            }
            if (this.state.defer(activeSender, activity)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Deferring:" + rep));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Applying:" + rep));
            }
            this.replicatedActivityReceived(activeSender, activity);
        }
    }

    private void syncBeginEntityListReceived(ServerID activeSender, SyncReplicationActivity activity) throws EntityException {
        this.ackReceived(activeSender, activity, null);
        this.beforeSyncAction(activity);
        SyncReplicationActivity.EntityCreationTuple[] entityTuples = activity.getEntitiesToCreateForSync();
        Assert.assertNotNull((Object)entityTuples);
        for (SyncReplicationActivity.EntityCreationTuple tuple : entityTuples) {
            EntityID eid = tuple.id;
            long version = tuple.version;
            long consumerID = tuple.consumerID;
            byte[] config = tuple.configPayload;
            boolean canDelete = tuple.canDelete;
            if (!this.entityManager.getEntity(EntityDescriptor.createDescriptorForLifecycle((EntityID)eid, (long)version)).isPresent()) {
                this.entityManager.createEntity(eid, version, consumerID, canDelete);
                this.entityPersistor.entityCreatedNoJournal(eid, version, consumerID, canDelete, config);
                continue;
            }
            Assert.fail((String)"this entity should not be here");
        }
        this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
    }

    private void replicatedActivityReceived(ServerID activeSender, SyncReplicationActivity activity) throws EntityException {
        ClientID sourceNodeID = activity.getSource();
        TransactionID transactionID = activity.getTransactionID();
        TransactionID oldestTransactionOnClient = activity.getOldestTransactionOnClient();
        Future<Void> tmpFuture = null;
        if (!ClientInstanceID.NULL_ID.equals((Object)sourceNodeID)) {
            if (!oldestTransactionOnClient.isNull()) {
                tmpFuture = this.orderedTransactions.updateWithNewMessage(sourceNodeID, transactionID, oldestTransactionOnClient);
            } else {
                this.orderedTransactions.removeTrackingForClient(sourceNodeID);
                this.entityPersistor.removeTrackingForClient(sourceNodeID);
            }
        }
        Future<Void> transactionOrderPersistenceFuture = tmpFuture;
        byte[] extendedData = activity.getExtendedData();
        ServerEntityRequest request = this.activityToLocalRequest(activity);
        if (request.getAction() == ServerEntityAction.CREATE_ENTITY) {
            this.entityPersistor.setNextConsumerID(activity.getFetchID().toLong());
            try {
                boolean canDelete = !sourceNodeID.isNull();
                ManagedEntity temp = this.entityManager.createEntity(activity.getEntityID(), activity.getVersion(), activity.getFetchID().toLong(), canDelete);
                Assert.assertTrue((Object)(temp.getConsumerID() + " == " + activity.getFetchID().toLong()), (temp.getConsumerID() == activity.getFetchID().toLong() ? 1 : 0) != 0);
                temp.addRequestMessage(request, MessagePayload.rawDataOnly(extendedData), () -> this.ackReceived(activeSender, activity, transactionOrderPersistenceFuture), result -> {
                    if (!sourceNodeID.isNull()) {
                        this.entityPersistor.entityCreated(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), activity.getEntityID(), activity.getVersion(), activity.getFetchID().toLong(), true, extendedData);
                        this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                    } else {
                        this.entityPersistor.entityCreatedNoJournal(activity.getEntityID(), activity.getVersion(), activity.getFetchID().toLong(), true, extendedData);
                        this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                    }
                }, exception -> {
                    this.entityPersistor.entityCreateFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), (EntityException)((Object)exception));
                    this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
                });
            }
            catch (EntityException ee) {
                this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
                if (!sourceNodeID.isNull()) {
                    this.entityPersistor.entityCreateFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), ee);
                }
            }
        } else {
            Assert.assertFalse((boolean)activity.getFetchID().isNull());
            EntityDescriptor desp = EntityDescriptor.createDescriptorForInvoke((FetchID)activity.getFetchID(), (ClientInstanceID)ClientInstanceID.NULL_ID);
            Optional<ManagedEntity> entity = this.entityManager.getEntity(desp);
            if (entity.isPresent()) {
                ManagedEntity entityInstance = entity.get();
                MessagePayload payload = MessagePayload.syncPayloadNormal(extendedData, activity.getConcurrency());
                if (null != request.getAction()) {
                    switch (request.getAction()) {
                        case RECONFIGURE_ENTITY: {
                            entity.get().addRequestMessage(request, payload, () -> this.ackReceived(activeSender, activity, transactionOrderPersistenceFuture), result -> {
                                this.entityPersistor.entityReconfigureSucceeded(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), entityInstance.getID(), entityInstance.getVersion(), (byte[])result);
                                this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                            }, exception -> {
                                this.entityPersistor.entityReconfigureFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), (EntityException)((Object)exception));
                                this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
                            });
                            break;
                        }
                        case DESTROY_ENTITY: {
                            entityInstance.addRequestMessage(request, payload, () -> this.ackReceived(activeSender, activity, transactionOrderPersistenceFuture), result -> {
                                this.entityPersistor.entityDestroyed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), entityInstance.getID());
                                this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                            }, exception -> {
                                this.entityPersistor.entityDestroyFailed(sourceNodeID, transactionID.toLong(), oldestTransactionOnClient.toLong(), (EntityException)((Object)exception));
                                this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
                            });
                            break;
                        }
                        case FETCH_ENTITY: 
                        case RELEASE_ENTITY: {
                            entityInstance.addRequestMessage(request, payload, () -> this.ackReceived(activeSender, activity, transactionOrderPersistenceFuture), result -> this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS), exception -> {
                                LOGGER.warn((Object)("fetch/release fail:" + activity));
                                this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
                            });
                            break;
                        }
                        case MANAGED_ENTITY_GC: {
                            if (entityInstance.isRemoveable()) {
                                LOGGER.debug((Object)("removing " + entityInstance.getID()));
                                this.entityManager.removeDestroyed(activity.getFetchID());
                                break;
                            }
                        }
                        case ORDER_PLACEHOLDER_ONLY: {
                            this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                            break;
                        }
                        default: {
                            entityInstance.addRequestMessage(request, payload, () -> this.ackReceived(activeSender, activity, transactionOrderPersistenceFuture), result -> this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS), exception -> this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL));
                        }
                    }
                }
            } else {
                this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL);
            }
        }
    }

    private void establishNewPassive() {
        this.entityManager.resetReferences();
    }

    private void requestPassiveSync() {
        NodeID node = this.stateManager.getActiveNodeID();
        Assert.assertTrue((boolean)this.entityManager.getAll().stream().allMatch(e -> e.getID().equals((Object)PlatformEntity.PLATFORM_ID)));
        this.moveToPassiveUnitialized(node);
        try {
            LOGGER.info((Object)("Requesting Passive Sync from " + node));
            this.groupManager.sendTo(node, (AbstractGroupMessage)ReplicationMessageAck.createSyncRequestMessage());
        }
        catch (GroupException ge) {
            LOGGER.warn((Object)"can't request passive sync", (Throwable)ge);
        }
    }

    private void syncActivityReceived(ServerID activeSender, SyncReplicationActivity activity) {
        MessagePayload payload;
        SyncReplicationActivity.ActivityType thisActivityType = activity.getActivityType();
        FetchID fetch = activity.getFetchID();
        EntityDescriptor descriptor = EntityDescriptor.createDescriptorForInvoke((FetchID)fetch, (ClientInstanceID)ClientInstanceID.NULL_ID);
        Assert.assertTrue((SyncReplicationActivity.ActivityType.SYNC_BEGIN != thisActivityType ? 1 : 0) != 0);
        this.beforeSyncAction(activity);
        if (SyncReplicationActivity.ActivityType.SYNC_ENTITY_BEGIN == thisActivityType && !fetch.isNull()) {
            try {
                Assert.assertTrue((boolean)this.entityManager.getEntity(descriptor).isPresent());
                int referenceCount = activity.getReferenceCount();
                payload = MessagePayload.syncPayloadCreation(activity.getExtendedData(), referenceCount);
                BasicServerEntityRequest request = new BasicServerEntityRequest(ServerEntityAction.RECEIVE_SYNC_CREATE_ENTITY, activity.getSource(), activity.getTransactionID(), activity.getOldestTransactionOnClient());
                this.entityManager.getEntity(descriptor).get().addRequestMessage(request, payload, null, result -> {}, exception -> this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL));
            }
            catch (EntityException exception2) {
                LOGGER.warn((Object)"entity has already been created", (Throwable)exception2);
            }
        }
        try {
            Optional<ManagedEntity> entity = this.entityManager.getEntity(descriptor);
            if (entity.isPresent()) {
                payload = null;
                if (SyncReplicationActivity.ActivityType.SYNC_ENTITY_BEGIN == thisActivityType) {
                    payload = MessagePayload.emptyPayload();
                } else if (SyncReplicationActivity.ActivityType.SYNC_BEGIN == thisActivityType) {
                    payload = MessagePayload.emptyPayload();
                } else {
                    int concurrencyKey = activity.getConcurrency();
                    payload = MessagePayload.syncPayloadNormal(activity.getExtendedData(), concurrencyKey);
                }
                entity.get().addRequestMessage(this.activityToLocalRequest(activity), payload, null, result -> this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS), exception -> this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL));
            } else {
                Assert.assertFalse((SyncReplicationActivity.ActivityType.SYNC_ENTITY_BEGIN == thisActivityType ? 1 : 0) != 0);
                Assert.assertFalse((SyncReplicationActivity.ActivityType.ORDERING_PLACEHOLDER == thisActivityType ? 1 : 0) != 0);
                if (!fetch.isNull()) {
                    throw new AssertionError();
                }
                payload = MessagePayload.syncPayloadNormal(activity.getExtendedData(), activity.getConcurrency());
                this.platform.addRequestMessage(this.activityToLocalRequest(activity), payload, null, result -> {
                    if (SyncReplicationActivity.ActivityType.SYNC_END == thisActivityType) {
                        try {
                            this.entityPersistor.layer(new ObjectInputStream(new ByteArrayInputStream(payload.getRawPayload())));
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                        this.moveToPassiveStandBy();
                    }
                    this.acknowledge(activeSender, activity, ReplicationResultCode.SUCCESS);
                }, exception -> this.acknowledge(activeSender, activity, ReplicationResultCode.FAIL));
            }
        }
        catch (EntityException ee) {
            throw new RuntimeException(ee);
        }
    }

    private void start() {
        this.state.start();
    }

    private void start(FetchID fetch) {
        this.state.startEntity(fetch);
    }

    private void start(FetchID fetch, int concurrency) {
        this.state.startConcurrency(fetch, concurrency);
    }

    private void finish() {
        this.state.finish();
    }

    private void finish(FetchID fetch) {
        this.state.endEntity(fetch);
    }

    private void finish(FetchID fetch, int concurrency) {
        this.scheduleDeferred(this.state.endConcurrency(fetch, concurrency));
    }

    private void scheduleDeferred(Deque<DeferredContainer> deferred) {
        if (deferred != null) {
            while (!deferred.isEmpty()) {
                DeferredContainer r = deferred.pop();
                try {
                    this.replicatedActivityReceived(r.activeSender, r.activity);
                }
                catch (EntityException ee) {
                    throw new RuntimeException(ee);
                }
            }
        }
    }

    private void moveToPassiveUnitialized(NodeID connectedTo) {
        if (!this.stateManager.isActiveCoordinator()) {
            this.stateManager.moveToPassiveSyncing(connectedTo);
        }
    }

    private void moveToPassiveStandBy() {
        if (!this.stateManager.isActiveCoordinator()) {
            this.stateManager.moveToPassiveStandbyState();
        }
    }

    private ServerEntityRequest activityToLocalRequest(SyncReplicationActivity activity) {
        SyncReplicationActivity.ActivityType activityType = activity.getActivityType();
        ClientID source = activity.getSource();
        TransactionID transactionID = activity.getTransactionID();
        TransactionID oldestTransactionID = activity.getOldestTransactionOnClient();
        Assert.assertTrue((SyncReplicationActivity.ActivityType.SYNC_BEGIN != activityType ? 1 : 0) != 0);
        return new BasicServerEntityRequest(ReplicatedTransactionHandler.decodeReplicationType(activityType), source, transactionID, oldestTransactionID);
    }

    private void beforeSyncAction(SyncReplicationActivity activity) {
        switch (activity.getActivityType()) {
            case SYNC_START: {
                this.establishNewPassive();
                break;
            }
            case SYNC_BEGIN: {
                this.start();
                break;
            }
            case SYNC_END: {
                this.finish();
                break;
            }
            case SYNC_ENTITY_BEGIN: {
                this.start(activity.getFetchID());
                break;
            }
            case SYNC_ENTITY_END: {
                this.finish(activity.getFetchID());
                break;
            }
            case SYNC_ENTITY_CONCURRENCY_BEGIN: {
                this.start(activity.getFetchID(), activity.getConcurrency());
                break;
            }
            case SYNC_ENTITY_CONCURRENCY_END: {
                this.finish(activity.getFetchID(), activity.getConcurrency());
                break;
            }
        }
    }

    private void ackReceived(ServerID activeSender, SyncReplicationActivity activity, Future<Void> future) {
        if (!activeSender.equals((Object)ServerID.NULL_ID)) {
            if (future != null) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Caught exception while persisting transaction order", e);
                }
            }
            this.prepareAckForSend((NodeID)activeSender, activity.getActivityID(), ReplicationResultCode.RECEIVED);
        }
    }

    private void acknowledge(ServerID activeSender, SyncReplicationActivity activity, ReplicationResultCode code) {
        if (!activeSender.equals((Object)ServerID.NULL_ID)) {
            this.prepareAckForSend((NodeID)activeSender, activity.getActivityID(), code);
        }
    }

    private synchronized void prepareAckForSend(NodeID sender, SyncReplicationActivity.ActivityID respondTo, ReplicationResultCode code) {
        if (!sender.equals(this.cachedMessageAckFrom)) {
            int maximumBatchSize = TCPropertiesImpl.getProperties().getInt("passive-active.batchsize", 64);
            int idealMessagesInFlight = TCPropertiesImpl.getProperties().getInt("passive-active.inflight", 1);
            GroupMessageBatchContext.IBatchableMessageFactory<ReplicationMessageAck, ReplicationAckTuple> factory = new GroupMessageBatchContext.IBatchableMessageFactory<ReplicationMessageAck, ReplicationAckTuple>(){

                @Override
                public ReplicationMessageAck createNewBatch(ReplicationAckTuple initialActivity, long id) {
                    ReplicationMessageAck message = ReplicationMessageAck.createBatchAck();
                    message.addToBatch(initialActivity);
                    return message;
                }
            };
            this.cachedMessageAckFrom = sender;
            this.cachedBatchAck = new GroupMessageBatchContext<ReplicationMessageAck, ReplicationAckTuple>(factory, this.groupManager, this.cachedMessageAckFrom, maximumBatchSize, idealMessagesInFlight, this.handleMessageSend);
        }
        boolean didCreate = false;
        try {
            didCreate = this.cachedBatchAck.batchMessage(new ReplicationAckTuple(respondTo, code));
        }
        catch (GroupException e) {
            LOGGER.debug((Object)"active died on ack", (Throwable)e);
        }
        if (didCreate) {
            this.outgoingResponseSink.addSingleThreaded((Object)this.selfMessageToken);
        }
    }

    private static ServerEntityAction decodeReplicationType(SyncReplicationActivity.ActivityType networkType) {
        switch (networkType) {
            case SYNC_BEGIN: {
                throw Assert.failure((Object)"Shouldn't decode this type into an internal action");
            }
            case SYNC_START: 
            case SYNC_END: 
            case ORDERING_PLACEHOLDER: {
                return ServerEntityAction.ORDER_PLACEHOLDER_ONLY;
            }
            case LOCAL_ENTITY_GC: {
                return ServerEntityAction.MANAGED_ENTITY_GC;
            }
            case FLUSH_LOCAL_PIPELINE: {
                return ServerEntityAction.LOCAL_FLUSH;
            }
            case CREATE_ENTITY: {
                return ServerEntityAction.CREATE_ENTITY;
            }
            case RECONFIGURE_ENTITY: {
                return ServerEntityAction.RECONFIGURE_ENTITY;
            }
            case INVOKE_ACTION: {
                return ServerEntityAction.INVOKE_ACTION;
            }
            case DESTROY_ENTITY: {
                return ServerEntityAction.DESTROY_ENTITY;
            }
            case FETCH_ENTITY: {
                return ServerEntityAction.FETCH_ENTITY;
            }
            case RELEASE_ENTITY: {
                return ServerEntityAction.RELEASE_ENTITY;
            }
            case SYNC_ENTITY_BEGIN: {
                return ServerEntityAction.RECEIVE_SYNC_ENTITY_START_SYNCING;
            }
            case SYNC_ENTITY_CONCURRENCY_BEGIN: {
                return ServerEntityAction.RECEIVE_SYNC_ENTITY_KEY_START;
            }
            case SYNC_ENTITY_CONCURRENCY_PAYLOAD: {
                return ServerEntityAction.RECEIVE_SYNC_PAYLOAD;
            }
            case SYNC_ENTITY_CONCURRENCY_END: {
                return ServerEntityAction.RECEIVE_SYNC_ENTITY_KEY_END;
            }
            case SYNC_ENTITY_END: {
                return ServerEntityAction.RECEIVE_SYNC_ENTITY_END;
            }
        }
        throw new AssertionError((Object)("bad replication type: " + networkType));
    }

    public static class SedaToken {
    }

    private static class DeferredContainer {
        public final ServerID activeSender;
        public final SyncReplicationActivity activity;

        public DeferredContainer(ServerID activeSender, SyncReplicationActivity activity) {
            this.activeSender = activeSender;
            this.activity = activity;
        }
    }

    public static class BasicServerEntityRequest
    implements ServerEntityRequest {
        private final ServerEntityAction action;
        private final ClientID source;
        private final TransactionID transaction;
        private final TransactionID oldest;

        public BasicServerEntityRequest(ServerEntityAction action, ClientID source, TransactionID transaction, TransactionID oldest) {
            this.action = action;
            this.source = source;
            this.transaction = transaction;
            this.oldest = oldest;
        }

        @Override
        public ServerEntityAction getAction() {
            return this.action;
        }

        @Override
        public ClientID getNodeID() {
            return this.source;
        }

        @Override
        public TransactionID getTransaction() {
            return this.transaction;
        }

        @Override
        public TransactionID getOldestTransactionOnClient() {
            return this.oldest;
        }

        @Override
        public ClientInstanceID getClientInstance() {
            return ClientInstanceID.NULL_ID;
        }

        @Override
        public boolean requiresReceived() {
            return false;
        }

        @Override
        public Set<NodeID> replicateTo(Set<NodeID> passives) {
            return Collections.emptySet();
        }
    }

    private class SyncState {
        private LinkedList<DeferredContainer> defer = new LinkedList();
        private final Set<FetchID> syncdFetches = new HashSet<FetchID>();
        private final Set<Integer> syncdKeys = new HashSet<Integer>();
        private FetchID syncingFetch = FetchID.NULL_ID;
        private int currentKey = -1;
        private boolean finished = false;
        private boolean started = false;

        private SyncState() {
        }

        private void start() {
            this.started = true;
        }

        private void startEntity(FetchID fetch) {
            this.assertStarted(null);
            Assert.assertTrue((boolean)this.syncingFetch.isNull());
            this.syncingFetch = fetch;
            this.syncdKeys.add(0);
            this.syncdKeys.add(Integer.MIN_VALUE);
            LOGGER.debug((Object)("Starting " + fetch));
        }

        private void endEntity(FetchID fetch) {
            this.assertStarted(null);
            Assert.assertEquals((Object)this.syncingFetch, (Object)fetch);
            this.syncdFetches.add(fetch);
            this.syncdKeys.clear();
            this.syncingFetch = FetchID.NULL_ID;
            LOGGER.debug((Object)("Ending " + fetch));
        }

        private void startConcurrency(FetchID fetch, int concurrency) {
            this.assertStarted(null);
            Assert.assertEquals((Object)this.syncingFetch, (Object)fetch);
            this.currentKey = concurrency;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Starting " + fetch + "/" + this.currentKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Deque<DeferredContainer> endConcurrency(FetchID fetch, int concurrency) {
            this.assertStarted(null);
            try {
                Assert.assertEquals((Object)this.syncingFetch, (Object)fetch);
                Assert.assertEquals((int)this.currentKey, (int)concurrency);
                this.syncdKeys.add(concurrency);
                this.currentKey = -1;
                LinkedList<DeferredContainer> linkedList = this.defer;
                return linkedList;
            }
            finally {
                this.defer = new LinkedList();
            }
        }

        private void finish() {
            this.assertStarted(null);
            this.syncdFetches.clear();
            this.finished = true;
        }

        private boolean ignore(SyncReplicationActivity activity) {
            if (!this.started) {
                return true;
            }
            if (this.finished) {
                return false;
            }
            return false;
        }

        private boolean defer(ServerID activeSender, SyncReplicationActivity activity) {
            this.assertStarted(activity);
            if (this.finished) {
                return false;
            }
            FetchID fetch = activity.getFetchID();
            if (this.syncdFetches.contains(fetch)) {
                return false;
            }
            SyncReplicationActivity.ActivityType activityType = activity.getActivityType();
            if (fetch.equals((Object)this.syncingFetch)) {
                int concurrencyKey = activity.getConcurrency();
                if (this.syncdKeys.contains(concurrencyKey)) {
                    return false;
                }
                if (SyncReplicationActivity.ActivityType.CREATE_ENTITY == activityType) {
                    return false;
                }
                if (SyncReplicationActivity.ActivityType.ORDERING_PLACEHOLDER == activityType) {
                    return false;
                }
                if (SyncReplicationActivity.ActivityType.DESTROY_ENTITY == activityType) {
                    Assert.fail((String)("destroy received during a sync of an entity " + activity));
                    return false;
                }
                if (this.currentKey == concurrencyKey) {
                    this.defer.add(new DeferredContainer(activeSender, activity));
                    return true;
                }
            }
            return false;
        }

        private void assertStarted(SyncReplicationActivity activity) {
            Assert.assertTrue((Object)activity, (boolean)this.started);
        }
    }
}

