/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.object.FetchID;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.handler.GroupMessageBatchContext;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReplicationSender
extends AbstractEventHandler<NodeID> {
    private static final int DEFAULT_BATCH_LIMIT = 64;
    private static final int DEFAULT_INFLIGHT_MESSAGES = 1;
    private final GroupManager<AbstractGroupMessage> group;
    private final Map<NodeID, SyncState> filtering = new HashMap<NodeID, SyncState>();
    private static final TCLogger logger = TCLogging.getLogger(ReplicationSender.class);
    private static final TCLogger PLOGGER = TCLogging.getLogger(MessagePayload.class);
    private static final boolean debugLogging = logger.isDebugEnabled();
    private static final boolean debugMessaging = PLOGGER.isDebugEnabled();
    private final Map<NodeID, GroupMessageBatchContext<ReplicationMessage, SyncReplicationActivity>> batchContexts = new HashMap<NodeID, GroupMessageBatchContext<ReplicationMessage, SyncReplicationActivity>>();
    private Sink<NodeID> selfSink;

    public ReplicationSender(GroupManager<AbstractGroupMessage> group) {
        this.group = group;
    }

    public void setSelfSink(Sink<NodeID> sink) {
        this.selfSink = sink;
    }

    public void removePassive(NodeID dest) {
        this.filtering.remove(dest);
        this.batchContexts.remove(dest);
    }

    public void addPassive(NodeID dest, SyncReplicationActivity activity) {
        this.createAndRegisterSyncState(dest);
        try {
            this.doSendActivity(dest, activity);
        }
        catch (GroupException e) {
            throw Assert.failure((Object)"Unexpected GroupException while adding new passive", (Throwable)e);
        }
        this.selfSink.addSingleThreaded((Object)dest);
    }

    public boolean replicateMessage(NodeID dest, SyncReplicationActivity activity) {
        SyncState syncing = this.getSyncState(dest, activity);
        boolean didSend = false;
        boolean shouldRemoveFromStream = this.shouldRemoveActivityFromReplicationStream(activity, syncing);
        if (!shouldRemoveFromStream) {
            syncing.validateSending(activity);
            try {
                this.doSendActivity(dest, activity);
                didSend = true;
            }
            catch (GroupException e) {
                logger.error((Object)("Replication to node " + dest + " failed due to previous flush exception"), (Throwable)e);
            }
            if (didSend) {
                this.selfSink.addSingleThreaded((Object)dest);
            }
        } else if (debugLogging) {
            logger.debug((Object)("FILTERING:" + activity));
        }
        return didSend;
    }

    public void handleEvent(NodeID nodeToFlush) throws EventHandlerException {
        try {
            this.batchContexts.get(nodeToFlush).flushBatch();
        }
        catch (GroupException e) {
            logger.error((Object)"Exception flushing batch context", (Throwable)e);
        }
    }

    private boolean shouldRemoveActivityFromReplicationStream(SyncReplicationActivity activity, SyncState syncing) {
        boolean shouldRemoveFromStream = true;
        if (syncing != null) {
            shouldRemoveFromStream = !syncing.hasSyncFinished() && !syncing.shouldMessageBeReplicated(activity) && syncing.hasSyncBegun();
        }
        return shouldRemoveFromStream;
    }

    private void doSendActivity(NodeID nodeid, SyncReplicationActivity activity) throws GroupException {
        if (debugLogging) {
            logger.debug((Object)("WIRE:" + activity));
        }
        if (debugMessaging) {
            PLOGGER.debug((Object)("SENDING:" + activity.getDebugID()));
        }
        this.batchContexts.get(nodeid).batchMessage(activity);
    }

    private void createAndRegisterSyncState(final NodeID nodeid) {
        Assert.assertTrue((!this.filtering.containsKey(nodeid) ? 1 : 0) != 0);
        Assert.assertTrue((!this.batchContexts.containsKey(nodeid) ? 1 : 0) != 0);
        SyncState state = new SyncState();
        this.filtering.put(nodeid, state);
        int maximumBatchSize = TCPropertiesImpl.getProperties().getInt("active-passive.batchsize", 64);
        int idealMessagesInFlight = TCPropertiesImpl.getProperties().getInt("active-passive.inflight", 1);
        logger.info((Object)("Created batch context for passive " + nodeid + " with max batch size " + maximumBatchSize + " and ideal messages in flight " + idealMessagesInFlight));
        Runnable networkDoneTarget = new Runnable(){

            @Override
            public void run() {
                ReplicationSender.this.selfSink.addSingleThreaded((Object)nodeid);
            }
        };
        GroupMessageBatchContext.IBatchableMessageFactory<ReplicationMessage, SyncReplicationActivity> factory = new GroupMessageBatchContext.IBatchableMessageFactory<ReplicationMessage, SyncReplicationActivity>(){

            @Override
            public ReplicationMessage createNewBatch(SyncReplicationActivity initialActivity, long id) {
                ReplicationMessage message = ReplicationMessage.createActivityContainer((SyncReplicationActivity)initialActivity);
                message.setReplicationID(id);
                return message;
            }
        };
        this.batchContexts.put(nodeid, new GroupMessageBatchContext<ReplicationMessage, SyncReplicationActivity>(factory, this.group, nodeid, maximumBatchSize, idealMessagesInFlight, networkDoneTarget));
    }

    private SyncState getSyncState(NodeID nodeid, SyncReplicationActivity activity) {
        SyncState state = this.filtering.get(nodeid);
        if (null == state) {
            this.dropActivityForDisconnectedServer(nodeid, activity);
        }
        return state;
    }

    private void dropActivityForDisconnectedServer(NodeID nodeid, SyncReplicationActivity activity) {
        Assert.assertFalse((Object)("node is not connected for:" + activity), (boolean)this.group.isNodeConnected(nodeid));
        logger.info((Object)("ignoring " + activity + " target " + nodeid + " no longer exists"));
    }

    boolean isSyncOccuring(NodeID origin) {
        SyncState state = this.filtering.get(origin);
        if (state != null) {
            return state.isSyncOccuring();
        }
        return false;
    }

    protected void initialize(ConfigurationContext context) {
        super.initialize(context);
    }

    private static class SyncState {
        private final Set<FetchID> liveFetch = new HashSet<FetchID>();
        private final Set<Integer> syncdID = new HashSet<Integer>();
        private FetchID syncingFetch = FetchID.NULL_ID;
        private int syncingConcurrency = -1;
        boolean begun = false;
        boolean complete = false;
        private SyncReplicationActivity.ActivityType lastSeen;
        private SyncReplicationActivity.ActivityType lastSent;

        private SyncState() {
        }

        public boolean isSyncOccuring() {
            return this.begun && !this.complete;
        }

        public boolean hasSyncBegun() {
            return this.begun;
        }

        public boolean hasSyncFinished() {
            return this.complete;
        }

        public boolean shouldMessageBeReplicated(SyncReplicationActivity activity) {
            switch (this.validateInput(activity)) {
                case SYNC_BEGIN: {
                    this.begun = true;
                    return true;
                }
                case SYNC_ENTITY_BEGIN: {
                    if (this.liveFetch.contains(activity.getFetchID())) {
                        return false;
                    }
                    this.syncingFetch = activity.getFetchID();
                    this.syncdID.clear();
                    this.syncdID.add(0);
                    this.syncdID.add(Integer.MIN_VALUE);
                    this.syncingConcurrency = 0;
                    return true;
                }
                case SYNC_ENTITY_CONCURRENCY_BEGIN: {
                    if (this.syncingFetch.equals((Object)activity.getFetchID())) {
                        Assert.assertEquals((int)this.syncingConcurrency, (int)0);
                        this.syncingConcurrency = activity.getConcurrency();
                        return true;
                    }
                    return false;
                }
                case SYNC_ENTITY_CONCURRENCY_PAYLOAD: {
                    return this.syncingFetch.equals((Object)activity.getFetchID());
                }
                case SYNC_ENTITY_CONCURRENCY_END: {
                    if (this.syncingFetch.equals((Object)activity.getFetchID())) {
                        this.syncdID.add(this.syncingConcurrency);
                        this.syncingConcurrency = 0;
                        return true;
                    }
                    return false;
                }
                case SYNC_ENTITY_END: {
                    if (this.syncingFetch.equals((Object)activity.getFetchID())) {
                        this.liveFetch.add(this.syncingFetch);
                        this.syncingFetch = FetchID.NULL_ID;
                        return true;
                    }
                    return false;
                }
                case SYNC_END: {
                    this.complete = true;
                    this.liveFetch.clear();
                    this.syncdID.clear();
                    this.syncingFetch = FetchID.NULL_ID;
                    return true;
                }
                case CREATE_ENTITY: {
                    if (this.begun) {
                        this.liveFetch.add(activity.getFetchID());
                    }
                }
                case RECONFIGURE_ENTITY: 
                case FETCH_ENTITY: 
                case RELEASE_ENTITY: 
                case DESTROY_ENTITY: {
                    return this.begun;
                }
                case INVOKE_ACTION: {
                    if (this.liveFetch.contains(activity.getFetchID())) {
                        return true;
                    }
                    if (this.syncingFetch.equals((Object)activity.getFetchID())) {
                        int concurrencyKey = activity.getConcurrency();
                        if (this.syncingConcurrency == concurrencyKey) {
                            return true;
                        }
                        return this.syncdID.contains(concurrencyKey);
                    }
                    return false;
                }
                case LOCAL_ENTITY_GC: 
                case FLUSH_LOCAL_PIPELINE: 
                case ORDERING_PLACEHOLDER: {
                    return false;
                }
            }
            throw new AssertionError((Object)("unknown replication activity:" + activity));
        }

        public SyncReplicationActivity.ActivityType validateInput(SyncReplicationActivity activity) {
            SyncReplicationActivity.ActivityType type = activity.getActivityType();
            if (activity.isSyncActivity()) {
                this.lastSeen = this.validate(type, this.lastSeen);
            }
            return type;
        }

        public void validateSending(SyncReplicationActivity activity) {
            if (activity.isSyncActivity()) {
                this.lastSent = this.validate(activity.getActivityType(), this.lastSent);
            }
        }

        private SyncReplicationActivity.ActivityType validate(SyncReplicationActivity.ActivityType type, SyncReplicationActivity.ActivityType compare) {
            switch (type) {
                case SYNC_BEGIN: {
                    Assert.assertNull((Object)compare);
                    break;
                }
                case SYNC_ENTITY_BEGIN: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_BEGIN, SyncReplicationActivity.ActivityType.SYNC_ENTITY_END).contains(compare));
                    break;
                }
                case SYNC_ENTITY_CONCURRENCY_BEGIN: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_ENTITY_BEGIN, SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_END).contains(compare));
                    break;
                }
                case SYNC_ENTITY_CONCURRENCY_PAYLOAD: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN, SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD).contains(compare));
                    break;
                }
                case SYNC_ENTITY_CONCURRENCY_END: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN, SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD).contains(compare));
                    break;
                }
                case SYNC_ENTITY_END: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_ENTITY_BEGIN, SyncReplicationActivity.ActivityType.SYNC_ENTITY_CONCURRENCY_END).contains(compare));
                    break;
                }
                case SYNC_END: {
                    Assert.assertTrue((Object)(type + " " + compare), (boolean)EnumSet.of(SyncReplicationActivity.ActivityType.SYNC_ENTITY_END, SyncReplicationActivity.ActivityType.SYNC_BEGIN).contains(compare));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unexpected message type");
                }
            }
            return type;
        }
    }
}

