/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.object.locks.LockID;
import com.tc.object.locks.RecallBatchContext;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.LockRequestMessage;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.locks.LockManager;
import java.util.Collection;
import java.util.LinkedList;

public class RequestLockUnLockHandler
extends AbstractEventHandler<LockRequestMessage> {
    private static final TCLogger logger = TCLogging.getLogger(RequestLockUnLockHandler.class);
    private LockManager lockManager;

    public void handleEvent(LockRequestMessage lrm) {
        LockID lid = lrm.getLockID();
        NodeID cid = lrm.getSourceNodeID();
        ThreadID tid = lrm.getThreadID();
        switch (lrm.getRequestType()) {
            case LOCK: {
                this.lockManager.lock(lid, (ClientID)cid, tid, lrm.getLockLevel());
                return;
            }
            case TRY_LOCK: {
                this.lockManager.tryLock(lid, (ClientID)cid, tid, lrm.getLockLevel(), lrm.getTimeout());
                return;
            }
            case UNLOCK: {
                this.lockManager.unlock(lid, (ClientID)cid, tid);
                return;
            }
            case WAIT: {
                this.lockManager.wait(lid, (ClientID)cid, tid, lrm.getTimeout());
                return;
            }
            case RECALL_COMMIT: {
                Collection contexts = lrm.getContexts();
                this.lockManager.recallCommit(lid, (ClientID)cid, contexts);
                return;
            }
            case QUERY: {
                this.lockManager.queryLock(lid, (ClientID)cid, tid);
                return;
            }
            case INTERRUPT_WAIT: {
                this.lockManager.interrupt(lid, (ClientID)cid, tid);
                return;
            }
            case BATCHED_RECALL_COMMIT: {
                LinkedList recallContexts = lrm.getRecallBatchedContexts();
                for (RecallBatchContext recallContext : recallContexts) {
                    Collection lockState = recallContext.getContexts();
                    this.lockManager.recallCommit(recallContext.getLockID(), (ClientID)cid, lockState);
                }
                return;
            }
        }
        logger.error((Object)("Unexpected lock request type: " + lrm.getRequestType()));
    }

    public void initialize(ConfigurationContext context) {
        super.initialize(context);
        ServerConfigurationContext oscc = (ServerConfigurationContext)context;
        this.lockManager = oscc.getLockManager();
    }
}

