/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.logging.TCLogger;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.LockResponseMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.NoSuchChannelException;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.locks.LockResponseContext;
import java.util.Collection;

public class RespondToRequestLockHandler
extends AbstractEventHandler<LockResponseContext> {
    private DSOChannelManager channelManager;
    private TCLogger logger;

    public void handleEvent(LockResponseContext lrc) {
        NodeID cid = lrc.getNodeID();
        try {
            LockResponseMessage responseMessage = null;
            if (lrc.isLockAward()) {
                responseMessage = this.createMessage(lrc, TCMessageType.NOOP_MESSAGE);
                responseMessage.initializeAward(lrc.getLockID(), lrc.getThreadID(), lrc.getLockLevel());
            } else if (lrc.isLockNotAwarded()) {
                responseMessage = this.createMessage(lrc, TCMessageType.NOOP_MESSAGE);
                responseMessage.initializeRefuse(lrc.getLockID(), lrc.getThreadID(), lrc.getLockLevel());
            } else if (lrc.isLockRecall()) {
                responseMessage = this.createMessage(lrc, TCMessageType.NOOP_MESSAGE);
                responseMessage.initializeRecallWithTimeout(lrc.getLockID(), lrc.getThreadID(), lrc.getLockLevel(), lrc.getAwardLeaseTime());
            } else if (lrc.isLockWaitTimeout()) {
                responseMessage = this.createMessage(lrc, TCMessageType.NOOP_MESSAGE);
                responseMessage.initializeWaitTimeout(lrc.getLockID(), lrc.getThreadID(), lrc.getLockLevel());
            } else if (lrc.isLockInfo()) {
                responseMessage = this.createMessage(lrc, TCMessageType.NOOP_MESSAGE);
                responseMessage.initializeLockInfo(lrc.getLockID(), lrc.getThreadID(), lrc.getLockLevel());
                Collection<ClientServerExchangeLockContext> list = lrc.getGlobalLockInfo();
                for (ClientServerExchangeLockContext clientServerExchangeLockContext : list) {
                    responseMessage.addContext(clientServerExchangeLockContext);
                }
                for (int i = 0; i < lrc.getNumberOfPendingRequests(); ++i) {
                    responseMessage.addContext(new ClientServerExchangeLockContext(lrc.getLockID(), (NodeID)ClientID.NULL_ID, ThreadID.NULL_ID, ServerLockContext.State.PENDING_READ));
                }
            } else {
                throw new AssertionError((Object)("Unknown lock response context : " + lrc));
            }
            this.send(responseMessage);
        }
        catch (NoSuchChannelException e) {
            this.logger.info((Object)("Failed to send lock message:" + lrc + " to:" + cid + " because the session is dead."));
            return;
        }
    }

    protected LockResponseMessage createMessage(LockResponseContext lrc, TCMessageType messageType) throws NoSuchChannelException {
        NodeID cid = lrc.getNodeID();
        MessageChannel channel = this.channelManager.getActiveChannel(cid);
        return (LockResponseMessage)channel.createMessage(messageType);
    }

    public void initialize(ConfigurationContext context) {
        super.initialize(context);
        ServerConfigurationContext oscc = (ServerConfigurationContext)context;
        this.channelManager = oscc.getChannelManager();
        this.logger = oscc.getLogger(((Object)((Object)this)).getClass());
    }

    protected void send(LockResponseMessage responseMessage) {
        responseMessage.send();
    }
}

