/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.objectserver.api.Retiree;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.terracotta.entity.EntityMessage;

public class RetirementManager {
    private final Map<EntityMessage, LogicalSequence> currentlyRunning = new HashMap<EntityMessage, LogicalSequence>();
    private final Map<EntityMessage, LogicalSequence> waitingForDeferredRegistration = new HashMap<EntityMessage, LogicalSequence>();
    private final Map<Integer, LogicalSequence> mostRecentRegisteredToKey = new HashMap<Integer, LogicalSequence>();

    public synchronized void updateWithRetiree(EntityMessage invokeMessage, Retiree response) {
        LogicalSequence seq = this.currentlyRunning.get(invokeMessage);
        if (seq == null) {
            response.retired();
        } else {
            seq.updateWithRetiree(response);
        }
    }

    public synchronized void registerWithMessage(EntityMessage invokeMessage, int concurrencyKey) {
        LogicalSequence toUpdateWithReference;
        LogicalSequence newWrapper = new LogicalSequence(invokeMessage);
        if (concurrencyKey != Integer.MIN_VALUE) {
            LogicalSequence lastInKey = this.mostRecentRegisteredToKey.remove(concurrencyKey);
            if (null != lastInKey && !lastInKey.isRetired) {
                lastInKey.nextInKey = newWrapper;
                newWrapper.isWaitingForPreviousInKey = true;
            }
            this.mostRecentRegisteredToKey.put(concurrencyKey, newWrapper);
        }
        if (null != (toUpdateWithReference = this.waitingForDeferredRegistration.remove(invokeMessage))) {
            Assert.assertTrue((boolean)toUpdateWithReference.isWaitingForExplicitDeferOf(invokeMessage));
            newWrapper.deferNotify = toUpdateWithReference;
        }
        LogicalSequence previous = this.currentlyRunning.put(invokeMessage, newWrapper);
        Assert.assertNull((Object)previous);
    }

    public synchronized List<Retiree> retireForCompletion(EntityMessage completedMessage) {
        ArrayList<Retiree> toRetire = new ArrayList<Retiree>();
        LogicalSequence completedRequest = this.currentlyRunning.remove(completedMessage);
        Assert.assertNotNull((Object)completedRequest);
        Assert.assertFalse((boolean)completedRequest.isCompleted);
        completedRequest.isCompleted = true;
        this.traverseDependencyGraph(toRetire, completedRequest);
        return toRetire;
    }

    private void traverseDependencyGraph(List<Retiree> toRetire, LogicalSequence completedRequest) {
        Stack<LogicalSequence> requestStack = new Stack<LogicalSequence>();
        requestStack.add(completedRequest);
        while (!requestStack.isEmpty()) {
            LogicalSequence currentRequest = (LogicalSequence)requestStack.pop();
            Assert.assertFalse((boolean)currentRequest.isRetired);
            if (!currentRequest.isCompleted) continue;
            if (!currentRequest.isWaitingForExplicitDefer() && !currentRequest.isWaitingForPreviousInKey) {
                toRetire.add(currentRequest.response);
                currentRequest.isRetired = true;
                if (currentRequest.nextInKey != null) {
                    currentRequest.nextInKey.isWaitingForPreviousInKey = false;
                    requestStack.push(currentRequest.nextInKey);
                    currentRequest.nextInKey = null;
                }
            }
            if (currentRequest.deferNotify == null) continue;
            currentRequest.deferNotify.entityMessageCompleted(currentRequest.entityMessage);
            requestStack.push(currentRequest.deferNotify);
            currentRequest.deferNotify = null;
        }
    }

    public synchronized void deferRetirement(EntityMessage invokeMessageToDefer, EntityMessage laterMessage) {
        LogicalSequence myRequest = this.currentlyRunning.get(invokeMessageToDefer);
        Assert.assertNotNull((Object)myRequest);
        myRequest.retirementDeferredBy(laterMessage);
        LogicalSequence previous = this.waitingForDeferredRegistration.put(laterMessage, myRequest);
        Assert.assertNull((Object)previous);
    }

    public synchronized void entityWasDestroyed() {
        Assert.assertTrue((boolean)this.currentlyRunning.isEmpty());
        Assert.assertTrue((boolean)this.waitingForDeferredRegistration.isEmpty());
    }

    private static class LogicalSequence {
        public Retiree response;
        public final EntityMessage entityMessage;
        public LogicalSequence nextInKey;
        public LogicalSequence deferNotify;
        public boolean isWaitingForPreviousInKey;
        public boolean isCompleted;
        public boolean isRetired;
        private Set<EntityMessage> entityMessagesDeferringRetirement = new HashSet<EntityMessage>();

        public LogicalSequence(EntityMessage entityMessage) {
            this.entityMessage = entityMessage;
        }

        public void updateWithRetiree(Retiree response) {
            this.response = response;
        }

        public void retirementDeferredBy(EntityMessage entityMessage) {
            this.entityMessagesDeferringRetirement.add(entityMessage);
        }

        public void entityMessageCompleted(EntityMessage entityMessage) {
            this.entityMessagesDeferringRetirement.remove(entityMessage);
        }

        public boolean isWaitingForExplicitDefer() {
            return this.entityMessagesDeferringRetirement.size() != 0;
        }

        public boolean isWaitingForExplicitDeferOf(EntityMessage entityMessage) {
            return this.entityMessagesDeferringRetirement.contains(entityMessage);
        }
    }
}

