/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.ManagementEventListener;
import com.tc.management.ManagementResponseListener;
import com.tc.management.TCManagementEvent;
import com.tc.management.TerracottaManagement;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.TCSocketAddress;
import com.tc.object.management.ManagementRequestID;
import com.tc.object.msg.AbstractManagementMessage;
import com.tc.object.msg.InvokeRegisteredServiceResponseMessage;
import com.tc.object.msg.ListRegisteredServicesResponseMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class ServerManagementHandler {
    private static final TCLogger logger = TCLogging.getLogger(ServerManagementHandler.class);
    private static final int MAX_UNFIRED_EVENT_COUNT = 15;
    private static final int MAX_UNFIRED_EVENT_RETENTION_MILLIS = 30000;
    private final Map<ManagementRequestID, ManagementResponseListener> responseListenerMap = new ConcurrentHashMap<ManagementRequestID, ManagementResponseListener>();
    private final List<ManagementEventListener> eventListeners = new CopyOnWriteArrayList<ManagementEventListener>();
    private final List<EventHolder> unfiredEvents = new CopyOnWriteArrayList<EventHolder>(){

        @Override
        public boolean add(EventHolder eventHolder) {
            if (this.size() >= ServerManagementHandler.this.maxUnfiredEventCount()) {
                this.remove(0);
            }
            return super.add(eventHolder);
        }
    };
    private final AbstractEventHandler<ListRegisteredServicesResponseMessage> listHandler = new AbstractEventHandler<ListRegisteredServicesResponseMessage>(){

        public void handleEvent(ListRegisteredServicesResponseMessage response) throws EventHandlerException {
            ManagementRequestID managementRequestID = response.getManagementRequestID();
            ManagementResponseListener responseListener = (ManagementResponseListener)ServerManagementHandler.this.responseListenerMap.get(managementRequestID);
            if (responseListener != null) {
                try {
                    responseListener.onResponse((AbstractManagementMessage)response);
                }
                catch (RuntimeException re) {
                    this.getLogger().warn((Object)"response listener threw RuntimeException", (Throwable)re);
                }
            } else {
                this.getLogger().warn((Object)("no listener registered for response " + managementRequestID + " - dropping it"));
            }
        }
    };
    private final AbstractEventHandler<InvokeRegisteredServiceResponseMessage> invokeHandler = new AbstractEventHandler<InvokeRegisteredServiceResponseMessage>(){

        public void handleEvent(InvokeRegisteredServiceResponseMessage response) throws EventHandlerException {
            NodeID sourceNodeID = response.getSourceNodeID();
            ManagementRequestID managementRequestID = response.getManagementRequestID();
            if (managementRequestID == null) {
                for (ManagementEventListener eventListener : ServerManagementHandler.this.eventListeners) {
                    try {
                        HashMap<String, String> contextMap = new HashMap<String, String>();
                        ClientID clientID = (ClientID)sourceNodeID;
                        contextMap.put("CONTEXT_SOURCE_NODE_NAME", Long.toString(clientID.toLong()));
                        contextMap.put("CONTEXT_SOURCE_JMX_ID", TerracottaManagement.buildNodeId((TCSocketAddress)response.getChannel().getRemoteAddress()));
                        TCManagementEvent event = (TCManagementEvent)response.getResponseHolder().getResponse(eventListener.getClassLoader());
                        eventListener.onEvent(event, contextMap);
                    }
                    catch (RuntimeException re) {
                        this.getLogger().warn((Object)"event listener threw RuntimeException", (Throwable)re);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.getLogger().warn((Object)"received event of an unknown class", (Throwable)cnfe);
                    }
                }
            } else {
                ManagementResponseListener responseListener = (ManagementResponseListener)ServerManagementHandler.this.responseListenerMap.get(managementRequestID);
                if (responseListener != null) {
                    try {
                        responseListener.onResponse((AbstractManagementMessage)response);
                    }
                    catch (RuntimeException re) {
                        this.getLogger().warn((Object)"response listener threw RuntimeException", (Throwable)re);
                    }
                } else {
                    this.getLogger().warn((Object)("no listener registered for response " + managementRequestID + " - dropping it"));
                }
            }
        }
    };

    public AbstractEventHandler<ListRegisteredServicesResponseMessage> getListHandler() {
        return this.listHandler;
    }

    public AbstractEventHandler<InvokeRegisteredServiceResponseMessage> getInvokeHandler() {
        return this.invokeHandler;
    }

    public void registerResponseListener(ManagementRequestID managementRequestID, ManagementResponseListener responseListener) {
        this.responseListenerMap.put(managementRequestID, responseListener);
    }

    public void unregisterResponseListener(ManagementRequestID managementRequestID) {
        this.responseListenerMap.remove(managementRequestID);
    }

    public void registerEventListener(ManagementEventListener eventListener) {
        boolean empty = this.eventListeners.isEmpty();
        this.eventListeners.add(eventListener);
        if (empty) {
            for (EventHolder eventHolder : this.unfiredEvents) {
                if (eventHolder.isExpired()) continue;
                eventListener.onEvent(eventHolder.event, eventHolder.context);
            }
            this.unfiredEvents.clear();
        }
    }

    public void unregisterEventListener(ManagementEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void fireEvent(TCManagementEvent event, Map<String, Object> context) {
        if (this.eventListeners.isEmpty()) {
            this.unfiredEvents.add(new EventHolder(event, context));
        } else {
            for (ManagementEventListener listener : this.eventListeners) {
                try {
                    listener.onEvent(event, context);
                }
                catch (RuntimeException re) {
                    logger.warn((Object)"Management event listener error", (Throwable)re);
                }
            }
        }
    }

    int maxUnfiredEventRetentionMillis() {
        return 30000;
    }

    int maxUnfiredEventCount() {
        return 15;
    }

    private final class EventHolder {
        TCManagementEvent event;
        Map<String, Object> context;
        long fireTime;

        private EventHolder(TCManagementEvent event, Map<String, Object> context) {
            this.event = event;
            this.context = context;
            this.fireTime = System.nanoTime();
        }

        boolean isExpired() {
            long now = System.nanoTime();
            return TimeUnit.NANOSECONDS.toMillis(now - this.fireTime) >= (long)ServerManagementHandler.this.maxUnfiredEventRetentionMillis();
        }
    }
}

