/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handshakemanager;

import com.tc.async.api.StageManager;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.logging.TCLogger;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.ReconnectListener;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handshakemanager.ClientHandshakeException;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.terracotta.exception.EntityException;

public class ServerClientHandshakeManager {
    static final int RECONNECT_WARN_INTERVAL = 15000;
    private State state = State.INIT;
    private List<ReconnectListener> waitingForReconnect = new ArrayList<ReconnectListener>();
    private final Timer timer;
    private final ReconnectTimerTask reconnectTimerTask;
    private final StageManager stageManager;
    private final long reconnectTimeout;
    private final DSOChannelManager channelManager;
    private final TCLogger logger;
    private final Set<ClientID> existingUnconnectedClients = new HashSet<ClientID>();
    private final boolean persistent;
    private final TCLogger consoleLogger;

    public ServerClientHandshakeManager(TCLogger logger, DSOChannelManager channelManager, StageManager stageManager, Timer timer, long reconnectTimeout, boolean persistent, TCLogger consoleLogger) {
        this.logger = logger;
        this.channelManager = channelManager;
        this.stageManager = stageManager;
        this.reconnectTimeout = reconnectTimeout;
        this.timer = timer;
        this.persistent = persistent;
        this.consoleLogger = consoleLogger;
        this.reconnectTimerTask = new ReconnectTimerTask(this, timer);
    }

    public synchronized boolean isStarting() {
        return this.state == State.STARTING;
    }

    public synchronized boolean isStarted() {
        return this.state == State.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientConnect(ClientHandshakeMessage handshake, EntityManager entityManager, ProcessTransactionHandler transactionHandler) throws ClientHandshakeException {
        ClientID clientID = (ClientID)handshake.getSourceNodeID();
        ServerClientHandshakeManager serverClientHandshakeManager = this;
        synchronized (serverClientHandshakeManager) {
            this.logger.info((Object)("Handling client handshake for " + clientID));
            handshake.getChannel().addAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT, (Object)new ClientHandshakeMonitoringInfo(handshake.getClientPID(), handshake.getUUID(), handshake.getName()), false);
            if (this.state == State.STARTED) {
                this.sendAckMessageFor(clientID);
            } else if (this.state == State.STARTING) {
                this.channelManager.makeChannelActiveNoAck(handshake.getChannel());
                for (ClientEntityReferenceContext referenceContext : handshake.getReconnectReferences()) {
                    Optional<ManagedEntity> entity = null;
                    EntityDescriptor descriptor = EntityDescriptor.createDescriptorForFetch((EntityID)referenceContext.getEntityID(), (long)referenceContext.getEntityVersion(), (ClientInstanceID)referenceContext.getClientInstanceID());
                    try {
                        entity = entityManager.getEntity(descriptor);
                    }
                    catch (EntityException e) {
                        throw Assert.failure((Object)"Unexpected failure to get entity in handshake", (Throwable)e);
                    }
                    if (entity.isPresent()) {
                        byte[] extendedReconnectData = referenceContext.getExtendedReconnectData();
                        ReferenceMessage msg = new ReferenceMessage(clientID, true, descriptor, extendedReconnectData);
                        transactionHandler.handleResentReferenceMessage(msg);
                        continue;
                    }
                    throw Assert.failure((Object)"entity not found");
                }
                for (ResendVoltronEntityMessage resentMessage : handshake.getResendMessages()) {
                    this.logger.debug((Object)("RESENT:" + resentMessage.getVoltronType() + " " + resentMessage.getEntityDescriptor()));
                    transactionHandler.handleResentMessage(resentMessage);
                }
                this.logger.debug((Object)("Removing client " + clientID + " from set of existing unconnected clients."));
                this.existingUnconnectedClients.remove(clientID);
                if (this.existingUnconnectedClients.isEmpty()) {
                    this.logger.debug((Object)("Last existing unconnected client (" + clientID + ") now connected.  Cancelling timer"));
                    this.timer.cancel();
                    this.start();
                }
            } else {
                Assert.fail();
            }
        }
    }

    public void notifyClientRefused(ClientHandshakeMessage clientMsg, String message) {
        ClientID clientID = (ClientID)clientMsg.getSourceNodeID();
        this.channelManager.makeChannelRefuse(clientID, message);
    }

    public void notifyDiagnosticClient(ClientHandshakeMessage clientMsg) {
        ClientID clientID = (ClientID)clientMsg.getSourceNodeID();
        ClientHandshakeAckMessage ack = (ClientHandshakeAckMessage)clientMsg.getChannel().createMessage(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE);
        ack.initialize(false, Collections.emptySet(), clientID, ProductInfo.getInstance().version());
        ack.send();
    }

    private void sendAckMessageFor(ClientID clientID) {
        this.logger.info((Object)("Sending handshake acknowledgement to " + clientID));
        this.channelManager.makeChannelActive(clientID, this.persistent);
    }

    public synchronized void notifyTimeout() {
        if (!this.isStarted()) {
            this.logger.info((Object)("Reconnect window closing.  Killing any previously connected clients that failed to connect in time: " + this.existingUnconnectedClients));
            this.channelManager.closeAll(this.existingUnconnectedClients);
            this.existingUnconnectedClients.clear();
            this.consoleLogger.info((Object)"Reconnect window closed. All dead clients removed.");
            this.start();
        } else {
            this.consoleLogger.info((Object)"Reconnect window closed, but server already started.");
        }
    }

    private void start() {
        this.logger.info((Object)"Starting TSA services...");
        Set<NodeID> cids = Collections.unmodifiableSet(this.channelManager.getAllClientIDs());
        for (NodeID nid : cids) {
            ClientID clientID = (ClientID)nid;
            if (!this.channelManager.isActiveID((NodeID)clientID)) continue;
            this.sendAckMessageFor(clientID);
        }
        this.state = State.STARTED;
        this.notifyComplete();
        this.stageManager.getStage("voltron_message_stage", VoltronEntityMessage.class).getSink().addSingleThreaded((Object)new LocalPipelineFlushMessage(EntityDescriptor.NULL_ID, false));
    }

    public void notifyComplete() {
        this.waitingForReconnect.forEach(ReconnectListener::reconnectComplete);
    }

    public void addReconnectListener(ReconnectListener rl) {
        this.waitingForReconnect.add(rl);
    }

    public synchronized void setStarting(Set<ClientID> existingClients) {
        this.assertInit();
        this.state = State.STARTING;
        if (existingClients.isEmpty()) {
            this.start();
        } else {
            for (ClientID connID : existingClients) {
                this.existingUnconnectedClients.add(connID);
            }
        }
    }

    public void startReconnectWindow() {
        String message = "Starting reconnect window: " + this.reconnectTimeout + " ms. Waiting for " + this.existingUnconnectedClients.size() + " clients to connect.";
        if (this.existingUnconnectedClients.size() <= 10) {
            message = message + " Unconnected Clients - " + this.existingUnconnectedClients;
        }
        this.consoleLogger.info((Object)message);
        if (this.reconnectTimeout < 15000L) {
            this.timer.schedule((TimerTask)this.reconnectTimerTask, this.reconnectTimeout);
        } else {
            this.timer.schedule((TimerTask)this.reconnectTimerTask, 15000L, 15000L);
        }
    }

    private void assertInit() {
        if (this.state != State.INIT) {
            throw new AssertionError((Object)("Should be in STARTING state: " + (Object)((Object)this.state)));
        }
    }

    synchronized int getUnconnectedClientsSize() {
        return this.existingUnconnectedClients.size();
    }

    synchronized Set<ClientID> getUnconnectedClients() {
        return this.existingUnconnectedClients;
    }

    private static class ReconnectTimerTask
    extends TimerTask {
        private final Timer timer;
        private final ServerClientHandshakeManager handshakeManager;
        private long timeToWait;

        private ReconnectTimerTask(ServerClientHandshakeManager handshakeManager, Timer timer) {
            this.handshakeManager = handshakeManager;
            this.timer = timer;
            this.timeToWait = handshakeManager.reconnectTimeout;
        }

        public void setTimeToWait(long timeToWait) {
            this.timeToWait = timeToWait;
        }

        @Override
        public void run() {
            this.timeToWait -= 15000L;
            if (this.timeToWait > 0L && this.handshakeManager.getUnconnectedClientsSize() > 0) {
                String message = "Reconnect window active.  Waiting for " + this.handshakeManager.getUnconnectedClientsSize() + " clients to connect. " + this.timeToWait + " ms remaining.";
                if (this.handshakeManager.getUnconnectedClientsSize() <= 10) {
                    message = message + " Unconnected Clients - " + this.handshakeManager.getUnconnectedClients();
                }
                this.handshakeManager.consoleLogger.info((Object)message);
                if (this.timeToWait < 15000L) {
                    this.cancel();
                    ReconnectTimerTask task = new ReconnectTimerTask(this.handshakeManager, this.timer);
                    task.setTimeToWait(this.timeToWait);
                    this.timer.schedule((TimerTask)task, this.timeToWait);
                }
            } else {
                this.timer.cancel();
                this.handshakeManager.notifyTimeout();
            }
        }
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED;

    }
}

