/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.net.ClientID;
import com.tc.net.StripeID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import com.tc.util.sequence.MutableSequence;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectionIDFactoryImpl
implements ConnectionIDFactory,
DSOChannelManagerEventListener {
    private final MutableSequence connectionIDSequence;
    private StripeID stripe;
    private final List<ConnectionIDFactoryListener> listeners = new CopyOnWriteArrayList<ConnectionIDFactoryListener>();

    public ConnectionIDFactoryImpl(ClientStatePersistor clientStateStore) {
        this.connectionIDSequence = clientStateStore.getConnectionIDSequence();
    }

    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        if (!new ChannelID(connectionID.getChannelID()).isValid()) {
            return this.nextConnectionId(connectionID.getJvmID(), connectionID.getProductId());
        }
        return this.makeConnectionId(connectionID.getJvmID(), connectionID.getChannelID(), connectionID.getProductId());
    }

    private ConnectionID nextConnectionId(String clientJvmID, ProductID productId) {
        return this.buildConnectionId(clientJvmID, this.connectionIDSequence.next(), productId);
    }

    private ConnectionID buildConnectionId(String jvmID, long channelID, ProductID productId) {
        Assert.assertNotNull((Object)this.stripe);
        ConnectionID rv = new ConnectionID(jvmID, channelID, this.stripe.getName(), null, null, productId);
        this.fireCreationEvent(rv);
        return rv;
    }

    private ConnectionID makeConnectionId(String clientJvmID, long channelID, ProductID productId) {
        Assert.assertTrue((channelID != ChannelID.NULL_ID.toLong() ? 1 : 0) != 0);
        return this.buildConnectionId(clientJvmID, channelID, productId);
    }

    public void restoreConnectionId(ConnectionID rv) {
        this.fireCreationEvent(rv);
    }

    private void fireCreationEvent(ConnectionID rv) {
        for (ConnectionIDFactoryListener listener : this.listeners) {
            listener.connectionIDCreated(rv);
        }
    }

    private void fireDestroyedEvent(ConnectionID connectionID) {
        for (ConnectionIDFactoryListener listener : this.listeners) {
            listener.connectionIDDestroyed(connectionID);
        }
    }

    public void activate(StripeID stripeID, long nextAvailChannelID) {
        this.stripe = stripeID;
        if (nextAvailChannelID >= 0L) {
            this.connectionIDSequence.setNext(nextAvailChannelID);
        }
    }

    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void channelCreated(MessageChannel channel) {
    }

    public void channelRemoved(MessageChannel channel, boolean wasActive) {
        Assert.assertNotNull((Object)this.stripe);
        ChannelID channelID = channel.getChannelID();
        this.fireDestroyedEvent(new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", channelID.toLong(), this.stripe.getName()));
    }

    public long getCurrentConnectionID() {
        return this.connectionIDSequence.current();
    }

    public ConnectionID buildConnectionID(ClientID client) {
        Assert.assertNotNull((Object)this.stripe);
        return new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", client.getChannelID().toLong(), this.stripe.getName());
    }
}

