/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.entity.DiagnosticMessage;
import com.tc.entity.DiagnosticResponse;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageSink;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnsupportedMessageTypeException;
import com.tc.objectserver.impl.DistributedObjectServer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class DiagnosticsHandler
implements TCMessageSink {
    private final TCLogger logger = TCLogging.getLogger(DiagnosticsHandler.class);
    private final DistributedObjectServer server;

    public DiagnosticsHandler(DistributedObjectServer server) {
        this.server = server;
    }

    public void putMessage(TCMessage message) throws UnsupportedMessageTypeException {
        Charset set = Charset.forName("UTF-8");
        MessageChannel channel = message.getChannel();
        try {
            message.hydrate();
        }
        catch (Exception e) {
            this.logger.warn((Object)"trouble with diagnostics", (Throwable)e);
        }
        DiagnosticMessage msg = (DiagnosticMessage)message;
        byte[] data = msg.getExtendedData();
        String cmd = new String(data, set);
        byte[] result = null;
        try {
            switch (cmd) {
                case "getState": {
                    result = this.server.getContext().getL2Coordinator().getStateManager().getCurrentState().getName().getBytes(set);
                    break;
                }
                case "getClusterState": {
                    result = this.server.getClusterState(set);
                    break;
                }
                default: {
                    result = "UNKNOWN CMD".getBytes(set);
                }
            }
            DiagnosticResponse resp = (DiagnosticResponse)channel.createMessage(TCMessageType.DIAGNOSTIC_RESPONSE);
            resp.setResponse(msg.getTransactionID(), result);
            resp.send();
        }
        catch (RuntimeException runtime) {
            this.logger.warn((Object)"diagnostic", (Throwable)runtime);
            DiagnosticResponse resp = (DiagnosticResponse)channel.createMessage(TCMessageType.DIAGNOSTIC_RESPONSE);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, set);
            PrintWriter pw = new PrintWriter(writer);
            runtime.printStackTrace(pw);
            resp.setResponse(msg.getTransactionID(), out.toByteArray());
            resp.send();
        }
    }
}

