/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.PostInit;
import com.tc.async.api.SEDA;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.async.impl.OrderedSink;
import com.tc.async.impl.StageController;
import com.tc.config.HaConfig;
import com.tc.config.HaConfigImpl;
import com.tc.config.NodesStore;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.entity.DiagnosticMessageImpl;
import com.tc.entity.DiagnosticResponseImpl;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.ServerEntityMessageImpl;
import com.tc.entity.ServerEntityResponseMessage;
import com.tc.entity.ServerEntityResponseMessageImpl;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityMultiResponseImpl;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.exception.TCRuntimeException;
import com.tc.exception.TCServerRestartException;
import com.tc.exception.TCShutdownServerException;
import com.tc.exception.ZapDirtyDbServerNodeException;
import com.tc.exception.ZapServerNodeException;
import com.tc.handler.CallbackDumpAdapter;
import com.tc.handler.CallbackDumpHandler;
import com.tc.handler.CallbackGroupExceptionHandler;
import com.tc.handler.CallbackZapDirtyDbExceptionAdapter;
import com.tc.handler.CallbackZapServerNodeExceptionAdapter;
import com.tc.handler.LockInfoDumpHandler;
import com.tc.l2.api.L2Coordinator;
import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.ha.ChannelWeightGenerator;
import com.tc.l2.ha.ConnectionIDWeightGenerator;
import com.tc.l2.ha.HASettingsChecker;
import com.tc.l2.ha.InitialStateWeightGenerator;
import com.tc.l2.ha.RandomWeightGenerator;
import com.tc.l2.ha.ServerUptimeWeightGenerator;
import com.tc.l2.ha.StripeIDStateManagerImpl;
import com.tc.l2.ha.TransactionCountWeightGenerator;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.handler.GroupEvent;
import com.tc.l2.handler.GroupEventsDispatchHandler;
import com.tc.l2.handler.L2StateChangeHandler;
import com.tc.l2.handler.L2StateMessageHandler;
import com.tc.l2.handler.PlatformInfoRequestHandler;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.msg.PlatformInfoRequest;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.l2.msg.ReplicationMessageAck;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.l2.operatorevent.OperatorEventsPassiveServerConnectionListener;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.l2.state.StateManagerImpl;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.CustomerLogging;
import com.tc.logging.DumpHandlerStore;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.logging.ThreadDumpHandler;
import com.tc.management.RemoteManagement;
import com.tc.management.RemoteManagementImpl;
import com.tc.management.TSAManagementEventPayload;
import com.tc.management.TerracottaManagement;
import com.tc.management.TerracottaRemoteManagement;
import com.tc.management.beans.L2DumperMBean;
import com.tc.management.beans.L2MBeanNames;
import com.tc.management.beans.TCDumper;
import com.tc.management.beans.TCServerInfoMBean;
import com.tc.net.AddressChecker;
import com.tc.net.ClientID;
import com.tc.net.NIOWorkarounds;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.Node;
import com.tc.net.protocol.HttpConnectionContext;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OOONetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.HydrateHandler;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageSink;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.HealthCheckerConfigImpl;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorNullHandler;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.config.schema.L2Config;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.msg.InvokeRegisteredServiceMessage;
import com.tc.object.msg.InvokeRegisteredServiceResponseMessage;
import com.tc.object.msg.ListRegisteredServicesMessage;
import com.tc.object.msg.ListRegisteredServicesResponseMessage;
import com.tc.object.msg.LockRequestMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.object.net.DSOChannelManagerImpl;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.object.session.NullSessionManager;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.core.api.GlobalServerStatsImpl;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.entity.ActiveToPassiveReplication;
import com.tc.objectserver.entity.ClientEntityStateManagerImpl;
import com.tc.objectserver.entity.EntityManagerImpl;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.RequestProcessorHandler;
import com.tc.objectserver.entity.ServerEntityFactory;
import com.tc.objectserver.entity.VoltronMessageSink;
import com.tc.objectserver.handler.ChannelLifeCycleHandler;
import com.tc.objectserver.handler.ClientHandshakeHandler;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handler.ReplicatedTransactionHandler;
import com.tc.objectserver.handler.ReplicationSender;
import com.tc.objectserver.handler.RequestLockUnLockHandler;
import com.tc.objectserver.handler.RespondToRequestLockHandler;
import com.tc.objectserver.handler.ServerManagementHandler;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import com.tc.objectserver.impl.ChannelStatsImpl;
import com.tc.objectserver.impl.ConnectionIDFactoryImpl;
import com.tc.objectserver.impl.DiagnosticsHandler;
import com.tc.objectserver.impl.ObjectInstanceMonitorImpl;
import com.tc.objectserver.impl.PermanentEntityParser;
import com.tc.objectserver.impl.ServerBuilder;
import com.tc.objectserver.impl.ServerNameProvider;
import com.tc.objectserver.impl.ServerPersistenceVersionChecker;
import com.tc.objectserver.impl.StandardServerBuilder;
import com.tc.objectserver.impl.ThisServerNodeId;
import com.tc.objectserver.locks.LockManagerImpl;
import com.tc.objectserver.locks.LockResponseContext;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.objectserver.persistence.NullPlatformStorageProviderConfiguration;
import com.tc.objectserver.persistence.NullPlatformStorageServiceProvider;
import com.tc.objectserver.persistence.Persistor;
import com.tc.operatorevent.NodeNameProvider;
import com.tc.operatorevent.OperatorEventHistoryProviderImpl;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventCallback;
import com.tc.operatorevent.TerracottaOperatorEventHistoryProvider;
import com.tc.operatorevent.TerracottaOperatorEventLogging;
import com.tc.properties.L1ReconnectConfigImpl;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.runtime.MemoryEventsListener;
import com.tc.runtime.TCMemoryManagerImpl;
import com.tc.runtime.logging.LongGCLogger;
import com.tc.server.ServerConnectionValidator;
import com.tc.server.TCServer;
import com.tc.server.TCServerMain;
import com.tc.services.CommunicatorResponseHandler;
import com.tc.services.CommunicatorService;
import com.tc.services.DelegatingServiceRegistry;
import com.tc.services.EntityMessengerProvider;
import com.tc.services.LocalMonitoringProducer;
import com.tc.services.LogBasedStateDumper;
import com.tc.services.PlatformConfigurationImpl;
import com.tc.services.PlatformServiceProvider;
import com.tc.services.SingleThreadedTimer;
import com.tc.services.TerracottaServiceProviderRegistryImpl;
import com.tc.stats.counter.CounterConfig;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.SampledCumulativeCounter;
import com.tc.stats.counter.sampled.SampledCumulativeCounterConfig;
import com.tc.stats.counter.sampled.derived.SampledRateCounter;
import com.tc.stats.counter.sampled.derived.SampledRateCounterConfig;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.text.PrettyPrinterImpl;
import com.tc.util.Assert;
import com.tc.util.CommonShutDownHook;
import com.tc.util.ProductInfo;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.runtime.LockInfoByThreadID;
import com.tc.util.runtime.NullThreadIDMapImpl;
import com.tc.util.runtime.ThreadIDMap;
import com.tc.util.startuplock.FileNotCreatedException;
import com.tc.util.startuplock.LocationNotCreatedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.terracotta.config.TcConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.PlatformServer;
import org.terracotta.persistence.IPlatformPersistence;

public class DistributedObjectServer
implements TCDumper,
LockInfoDumpHandler,
ServerConnectionValidator,
DumpHandlerStore {
    private final ConnectionPolicy connectionPolicy;
    private final TCServer server;
    private final ServerBuilder serverBuilder;
    protected final L2ConfigurationSetupManager configSetupManager;
    protected final HaConfigImpl haConfig;
    private static final TCLogger logger = CustomerLogging.getDSOGenericLogger();
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private ServerID thisServerNodeID = ServerID.NULL_ID;
    protected NetworkListener l1Listener;
    protected NetworkListener l1Diagnostics;
    private TerracottaOperatorEventHistoryProvider operatorEventHistoryProvider;
    private CommunicationsManager communicationsManager;
    private ServerConfigurationContext context;
    private CounterManager sampledCounterManager;
    private LockManagerImpl lockManager;
    private ServerManagementContext managementContext;
    private Persistor persistor;
    private L2Coordinator l2Coordinator;
    private TCProperties tcProperties;
    private ConnectionIDFactoryImpl connectionIdFactory;
    private final TCThreadGroup threadGroup;
    private final SEDA<HttpConnectionContext> seda;
    private ReconnectConfig l1ReconnectConfig;
    private GroupManager<AbstractGroupMessage> groupCommManager;
    private Stage<HydrateContext> hydrateStage;
    private StripeIDStateManagerImpl stripeIDStateManager;
    private final CallbackDumpHandler dumpHandler = new CallbackDumpHandler();
    protected final TCSecurityManager tcSecurityManager;
    private final SingleThreadedTimer timer;
    private final TerracottaServiceProviderRegistryImpl serviceRegistry;
    private WeightGeneratorFactory globalWeightGeneratorFactory;
    private EntityManager entityManager;

    public DistributedObjectServer(L2ConfigurationSetupManager configSetupManager, TCThreadGroup threadGroup, ConnectionPolicy connectionPolicy, TCServerInfoMBean tcServerInfoMBean) {
        this(configSetupManager, threadGroup, connectionPolicy, (SEDA<HttpConnectionContext>)new SEDA(threadGroup), null, null);
    }

    public DistributedObjectServer(L2ConfigurationSetupManager configSetupManager, TCThreadGroup threadGroup, ConnectionPolicy connectionPolicy, SEDA<HttpConnectionContext> seda, TCServer server, TCSecurityManager securityManager) {
        Assert.assertEquals((Object)threadGroup, (Object)Thread.currentThread().getThreadGroup());
        this.tcSecurityManager = securityManager;
        if (configSetupManager.isSecure()) {
            Assert.assertNotNull((Object)"Security is turned on, but TCSecurityManager", (Object)this.tcSecurityManager);
            consoleLogger.info((Object)"Security enabled, turning on SSL");
        }
        this.configSetupManager = configSetupManager;
        this.haConfig = new HaConfigImpl(this.configSetupManager);
        this.connectionPolicy = connectionPolicy;
        this.threadGroup = threadGroup;
        this.seda = seda;
        this.server = server;
        this.serverBuilder = this.createServerBuilder(this.haConfig, logger, server, configSetupManager.dsoL2Config());
        this.timer = new SingleThreadedTimer(null);
        this.timer.start();
        this.serviceRegistry = new TerracottaServiceProviderRegistryImpl();
    }

    protected ServerBuilder createServerBuilder(HaConfig config, TCLogger tcLogger, TCServer server, L2Config l2dsoConfig) {
        return new StandardServerBuilder(config, tcLogger, this.tcSecurityManager);
    }

    protected ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public byte[] getClusterState(Charset set) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bytes, set);
        PrintWriter gather = new PrintWriter(writer);
        PrettyPrinterImpl pp = new PrettyPrinterImpl(gather){

            public void flush() {
                this.println();
            }
        };
        this.seda.getStageManager().prettyPrint((PrettyPrinter)pp);
        pp.println();
        this.persistor.prettyPrint((PrettyPrinter)pp);
        pp.println();
        this.groupCommManager.prettyPrint((PrettyPrinter)pp);
        pp.println();
        this.l2Coordinator.prettyPrint((PrettyPrinter)pp);
        pp.println();
        this.entityManager.prettyPrint((PrettyPrinter)pp);
        pp.println();
        this.serviceRegistry.prettyPrint((PrettyPrinter)pp);
        pp.println();
        return bytes.toByteArray();
    }

    public void dump() {
        this.dumpHandler.dump();
        this.serverBuilder.dump();
        LogBasedStateDumper stateDumper = new LogBasedStateDumper("platform");
        this.entityManager.dumpStateTo(stateDumper.subStateDumper("entities"));
        this.serviceRegistry.dumpStateTo(stateDumper.subStateDumper("services"));
        stateDumper.logState();
    }

    public synchronized void start() throws IOException, LocationNotCreatedException, FileNotCreatedException {
        InetAddress jmxBind;
        AddressChecker addressChecker;
        String bindAddress;
        this.threadGroup.addCallbackOnExitDefaultHandler((CallbackOnExitHandler)new ThreadDumpHandler((LockInfoDumpHandler)this));
        this.threadGroup.addCallbackOnExitDefaultHandler((CallbackOnExitHandler)this.dumpHandler);
        this.threadGroup.addCallbackOnExitExceptionHandler(TCServerRestartException.class, new CallbackOnExitHandler(){

            public void callbackOnExit(CallbackOnExitState state) {
                state.setRestartNeeded();
            }
        });
        this.threadGroup.addCallbackOnExitExceptionHandler(TCShutdownServerException.class, new CallbackOnExitHandler(){

            public void callbackOnExit(CallbackOnExitState state) {
                Throwable t = state.getThrowable();
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                consoleLogger.error((Object)("Server exiting: " + t.getMessage()));
            }
        });
        this.thisServerNodeID = this.makeServerNodeID(this.configSetupManager.dsoL2Config());
        ThisServerNodeId.setThisServerNodeId(this.thisServerNodeID);
        TerracottaOperatorEventLogging.setNodeNameProvider((NodeNameProvider)new ServerNameProvider(this.configSetupManager.dsoL2Config().serverName()));
        ArrayList<PostInit> toInit = new ArrayList<PostInit>();
        L2Config l2DSOConfig = this.configSetupManager.dsoL2Config();
        TCLogging.setLogLocationAndType((URI)this.configSetupManager.commonl2Config().logsPath().toURI(), (TCLogging.ProcessType)TCLogging.ProcessType.SERVER);
        String host = l2DSOConfig.host();
        InetAddress ip = InetAddress.getByName(host);
        if (!ip.isLoopbackAddress() && NetworkInterface.getByInetAddress(ip) == null) {
            String msg = "Unable to find local network interface for " + host;
            consoleLogger.error((Object)msg);
            logger.error((Object)msg, (Throwable)new TCRuntimeException(msg));
            System.exit(-1);
        }
        if ((bindAddress = this.configSetupManager.commonl2Config().tsaPort().getBind()) == null) {
            bindAddress = "0.0.0.0";
        }
        if (!(addressChecker = new AddressChecker()).isLegalBindAddress(jmxBind = InetAddress.getByName(bindAddress))) {
            throw new IOException("Invalid bind address [" + jmxBind + "]. Local addresses are " + addressChecker.getAllLocalAddresses());
        }
        NIOWorkarounds.solaris10Workaround();
        this.tcProperties = TCPropertiesImpl.getProperties();
        this.l1ReconnectConfig = new L1ReconnectConfigImpl();
        String serverName = this.configSetupManager.dsoL2Config().serverName();
        serverName = serverName.replace('.', '-');
        serverName = serverName.replace(':', '$');
        int maxStageSize = TCPropertiesImpl.getProperties().getInt("l2.seda.stage.sink.capacity");
        StageManager stageManager = this.seda.getStageManager();
        NullSessionManager sessionManager = new NullSessionManager();
        this.dumpHandler.registerForDump(new CallbackDumpAdapter((PrettyPrintable)stageManager));
        this.sampledCounterManager = new CounterManagerImpl();
        SampledCounterConfig sampledCounterConfig = new SampledCounterConfig(1, 300, true, 0L);
        TcConfiguration base = (TcConfiguration)this.configSetupManager.commonl2Config().getBean();
        PlatformConfigurationImpl platformConfiguration = new PlatformConfigurationImpl(this.configSetupManager.getL2Identifier(), base);
        this.serviceRegistry.initialize(platformConfiguration, base, Thread.currentThread().getContextClassLoader());
        this.serviceRegistry.registerImplementationProvided(new PlatformServiceProvider(this));
        EntityMessengerProvider messengerProvider = new EntityMessengerProvider(this.timer);
        this.serviceRegistry.registerImplementationProvided(messengerProvider);
        CommunicatorService communicatorService = new CommunicatorService();
        this.serviceRegistry.registerImplementationProvided(communicatorService);
        boolean serverIsRestartable = this.serviceRegistry.hasUserProvidedServiceProvider(IPlatformPersistence.class);
        if (!serverIsRestartable) {
            NullPlatformStorageServiceProvider nullPlatformStorageServiceProvider = new NullPlatformStorageServiceProvider();
            nullPlatformStorageServiceProvider.initialize(new NullPlatformStorageProviderConfiguration(), platformConfiguration);
            this.serviceRegistry.registerExternal(nullPlatformStorageServiceProvider);
        }
        logger.debug((Object)("persistent: " + serverIsRestartable));
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int serverPort = l2DSOConfig.tsaPort().getValue();
        ProductInfo pInfo = ProductInfo.getInstance();
        PlatformServer thisServer = new PlatformServer(this.server.getL2Identifier(), host, hostAddress, bindAddress, serverPort, l2DSOConfig.tsaGroupPort().getValue(), pInfo.buildVersion(), pInfo.buildID(), TCServerMain.getServer().getStartTime());
        LocalMonitoringProducer monitoringShimService = new LocalMonitoringProducer(this.serviceRegistry, thisServer, this.timer);
        this.serviceRegistry.registerImplementationProvided(monitoringShimService);
        long platformConsumerID = 0L;
        DelegatingServiceRegistry platformServiceRegistry = this.serviceRegistry.subRegistry(platformConsumerID);
        this.persistor = this.serverBuilder.createPersistor(platformServiceRegistry);
        this.persistor.start();
        if (!this.persistor.wasDBClean()) {
            this.persistor.close();
            this.serviceRegistry.clearServiceProvidersState();
            this.persistor = this.serverBuilder.createPersistor(platformServiceRegistry);
            this.persistor.start();
        }
        this.dumpHandler.registerForDump(new CallbackDumpAdapter((PrettyPrintable)this.persistor));
        new ServerPersistenceVersionChecker(this.persistor.getClusterStatePersistor()).checkAndSetVersion();
        this.operatorEventHistoryProvider = new OperatorEventHistoryProviderImpl();
        this.threadGroup.addCallbackOnExitExceptionHandler(ZapDirtyDbServerNodeException.class, (CallbackOnExitHandler)new CallbackZapDirtyDbExceptionAdapter(logger, consoleLogger, this.persistor.getClusterStatePersistor()));
        this.threadGroup.addCallbackOnExitExceptionHandler(ZapServerNodeException.class, (CallbackOnExitHandler)new CallbackZapServerNodeExceptionAdapter(logger, consoleLogger, this.persistor.getClusterStatePersistor()));
        int commWorkerThreadCount = L2Utils.getOptimalCommWorkerThreads();
        int stageWorkerThreadCount = L2Utils.getOptimalStageWorkerThreads();
        boolean useOOOLayer = this.l1ReconnectConfig.getReconnectEnabled();
        Object networkStackHarnessFactory = useOOOLayer ? new OOONetworkStackHarnessFactory((OnceAndOnlyOnceProtocolNetworkLayerFactory)new OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl(), this.l1ReconnectConfig) : new PlainNetworkStackHarnessFactory();
        MessageMonitor mm = MessageMonitorImpl.createMonitor((TCProperties)TCPropertiesImpl.getProperties(), (TCLogger)logger);
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        this.communicationsManager = new CommunicationsManagerImpl("L2_L1", mm, (TCMessageRouter)messageRouter, (NetworkStackHarnessFactory)networkStackHarnessFactory, this.connectionPolicy, commWorkerThreadCount, (HealthCheckerConfig)new HealthCheckerConfigImpl(this.tcProperties.getPropertiesFor("l2.healthcheck.l1"), "TSA Server"), this.thisServerNodeID, (TransportHandshakeErrorHandler)new TransportHandshakeErrorNullHandler(), this.getMessageTypeClassMappings(), Collections.emptyMap(), this.tcSecurityManager);
        SampledCumulativeCounterConfig sampledCumulativeCounterConfig = new SampledCumulativeCounterConfig(1, 300, true, 0L);
        TCMemoryManagerImpl tcMemManager = new TCMemoryManagerImpl(this.threadGroup);
        long timeOut = TCPropertiesImpl.getProperties().getLong("logging.longgc.threshold");
        LongGCLogger gcLogger = this.serverBuilder.createLongGCLogger(timeOut);
        tcMemManager.registerForMemoryEvents((MemoryEventsListener)gcLogger);
        tcMemManager.checkGarbageCollectors();
        ClientStatePersistor clientStateStore = this.persistor.getClientStatePersistor();
        this.connectionIdFactory = new ConnectionIDFactoryImpl(clientStateStore);
        String dsoBind = l2DSOConfig.tsaPort().getBind();
        this.l1Listener = this.communicationsManager.createListener(new TCSocketAddress(dsoBind, serverPort), true, (ConnectionIDFactory)this.connectionIdFactory);
        this.l1Diagnostics = this.communicationsManager.createListener(new TCSocketAddress(dsoBind, serverPort), true, () -> {
            ServerID server1 = (ServerID)this.l2Coordinator.getStateManager().getActiveNodeID();
            if (!server1.isNull()) {
                return server1.getName();
            }
            return null;
        });
        this.stripeIDStateManager = new StripeIDStateManagerImpl(this.persistor.getClusterStatePersistor());
        this.dumpHandler.registerForDump(new CallbackDumpAdapter((PrettyPrintable)this.stripeIDStateManager));
        DSOChannelManagerImpl channelManager = new DSOChannelManagerImpl(this.l1Listener.getChannelManager(), this.communicationsManager.getConnectionManager(), pInfo.version());
        channelManager.addEventListener((DSOChannelManagerEventListener)this.connectionIdFactory);
        WeightGeneratorFactory weightGeneratorFactory = new WeightGeneratorFactory();
        TransactionCountWeightGenerator transactionCountWeightGenerator = new TransactionCountWeightGenerator(this.persistor.getTransactionOrderPersistor());
        weightGeneratorFactory.add(transactionCountWeightGenerator);
        ChannelWeightGenerator connectedClientCountWeightGenerator = new ChannelWeightGenerator((DSOChannelManager)channelManager);
        weightGeneratorFactory.add(connectedClientCountWeightGenerator);
        ConnectionIDWeightGenerator connectionsMade = new ConnectionIDWeightGenerator(this.connectionIdFactory);
        weightGeneratorFactory.add(connectionsMade);
        InitialStateWeightGenerator initialState = new InitialStateWeightGenerator(this.persistor.getClusterStatePersistor());
        weightGeneratorFactory.add(initialState);
        ServerUptimeWeightGenerator serverUptimeWeightGenerator = new ServerUptimeWeightGenerator();
        weightGeneratorFactory.add(serverUptimeWeightGenerator);
        RandomWeightGenerator randomWeightGenerator = new RandomWeightGenerator(new SecureRandom());
        weightGeneratorFactory.add(randomWeightGenerator);
        this.globalWeightGeneratorFactory = weightGeneratorFactory;
        ChannelStatsImpl channelStats = new ChannelStatsImpl(this.sampledCounterManager, (DSOChannelManager)channelManager);
        channelManager.addEventListener((DSOChannelManagerEventListener)channelStats);
        communicatorService.setChannelManager((DSOChannelManager)channelManager);
        Stage communicatorResponseStage = stageManager.createStage("server_entity_response_message_stage", ServerEntityResponseMessage.class, (EventHandler)new CommunicatorResponseHandler(communicatorService), 1, maxStageSize);
        Stage respondToLockStage = stageManager.createStage("respond_to_lock_request_stage", LockResponseContext.class, (EventHandler)new RespondToRequestLockHandler(), 1, maxStageSize);
        this.lockManager = new LockManagerImpl(respondToLockStage.getSink(), (DSOChannelManager)channelManager);
        CallbackDumpAdapter lockDumpAdapter = new CallbackDumpAdapter((PrettyPrintable)this.lockManager);
        this.dumpHandler.registerForDump(lockDumpAdapter);
        ObjectInstanceMonitorImpl instanceMonitor = new ObjectInstanceMonitorImpl();
        SampledCounter globalTxnCounter = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledCounter globalOperationCounter = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledCounter broadcastCounter = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledCounter globalObjectFaultCounter = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledCounter globalLockRecallCounter = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledRateCounterConfig sampledRateCounterConfig = new SampledRateCounterConfig(1, 300, true);
        SampledRateCounter changesPerBroadcast = (SampledRateCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledRateCounterConfig);
        SampledRateCounter transactionSizeCounter = (SampledRateCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledRateCounterConfig);
        SampledCounter globalLockCount = (SampledCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCounterConfig);
        SampledCumulativeCounter globalServerMapGetSizeRequestsCounter = (SampledCumulativeCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCumulativeCounterConfig);
        SampledCumulativeCounter globalServerMapGetValueRequestsCounter = (SampledCumulativeCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCumulativeCounterConfig);
        SampledCumulativeCounter globalServerMapGetSnapshotRequestsCounter = (SampledCumulativeCounter)this.sampledCounterManager.createCounter((CounterConfig)sampledCumulativeCounterConfig);
        IMonitoringProducer serviceInterface = (IMonitoringProducer)platformServiceRegistry.getService((ServiceConfiguration)new ServiceConfiguration<IMonitoringProducer>(){

            public Class<IMonitoringProducer> getServiceType() {
                return IMonitoringProducer.class;
            }
        });
        long reconnectTimeout = l2DSOConfig.clientReconnectWindow();
        logger.debug((Object)("Client Reconnect Window: " + reconnectTimeout + " seconds"));
        ServerClientHandshakeManager clientHandshakeManager = new ServerClientHandshakeManager(TCLogging.getLogger(ServerClientHandshakeManager.class), (DSOChannelManager)channelManager, stageManager, new Timer("Reconnect timer", true), reconnectTimeout *= 1000L, serverIsRestartable, consoleLogger);
        Stage requestProcessorStage = stageManager.createStage("request_processor_stage", Runnable.class, (EventHandler)new RequestProcessorHandler(), L2Utils.getOptimalApplyStageWorkerThreads(true), maxStageSize);
        Sink requestProcessorSink = requestProcessorStage.getSink();
        RequestProcessor processor = new RequestProcessor((Sink<Runnable>)requestProcessorSink);
        ManagementTopologyEventCollector eventCollector = new ManagementTopologyEventCollector(serviceInterface);
        ClientEntityStateManagerImpl clientEntityStateManager = new ClientEntityStateManagerImpl();
        this.entityManager = new EntityManagerImpl(this.serviceRegistry, clientEntityStateManager, eventCollector, processor, this::flushLocalPipeline);
        ProcessTransactionHandler processTransactionHandler = new ProcessTransactionHandler(this.persistor.getEntityPersistor(), this.persistor.getTransactionOrderPersistor(), (DSOChannelManager)channelManager, this.entityManager, () -> this.l2Coordinator.getStateManager().cleanupKnownServers());
        Stage processTransactionStage_voltron = stageManager.createStage("voltron_message_stage", VoltronEntityMessage.class, processTransactionHandler.getVoltronMessageHandler(), 1, maxStageSize);
        Stage multiRespond = stageManager.createStage("respond_to_request_stage", TCMessage.class, processTransactionHandler.getMultiResponseSender(), 1, maxStageSize);
        Sink voltronMessageSink = processTransactionStage_voltron.getSink();
        messengerProvider.setMessageSink((Sink<VoltronEntityMessage>)voltronMessageSink);
        if (serverIsRestartable) {
            processTransactionHandler.loadExistingEntities();
        }
        Stage requestLock = stageManager.createStage("request_lock_stage", LockRequestMessage.class, (EventHandler)new RequestLockUnLockHandler(), 1, maxStageSize);
        Stage clientHandshake = stageManager.createStage("client_handshake_stage", ClientHandshakeMessage.class, (EventHandler)this.createHandShakeHandler(this.entityManager, processTransactionHandler), 1, maxStageSize);
        this.hydrateStage = stageManager.createStage("hydrate_message_stage", HydrateContext.class, (EventHandler)new HydrateHandler(), stageWorkerThreadCount, maxStageSize);
        Sink hydrateSink = this.hydrateStage.getSink();
        messageRouter.routeMessageType(TCMessageType.NOOP_MESSAGE, requestLock.getSink(), hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, clientHandshake.getSink(), hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_MESSAGE, (TCMessageSink)new VoltronMessageSink((Sink<VoltronEntityMessage>)voltronMessageSink, (Sink<HydrateContext>)hydrateSink, this.entityManager));
        messageRouter.routeMessageType(TCMessageType.SERVER_ENTITY_RESPONSE_MESSAGE, communicatorResponseStage.getSink(), hydrateSink);
        messageRouter.routeMessageType(TCMessageType.DIAGNOSTIC_REQUEST, (TCMessageSink)new DiagnosticsHandler(this));
        HASettingsChecker haChecker = new HASettingsChecker(this.configSetupManager, TCPropertiesImpl.getProperties());
        haChecker.validateHealthCheckSettingsForHighAvailability();
        this.groupCommManager = this.serverBuilder.createGroupCommManager(this.configSetupManager, stageManager, this.thisServerNodeID, this.stripeIDStateManager, this.globalWeightGeneratorFactory);
        this.dumpHandler.registerForDump(new CallbackDumpAdapter(this.groupCommManager));
        L2StateChangeHandler stateHandler = new L2StateChangeHandler(this.createStageController(monitoringShimService), eventCollector);
        Stage stateChange = stageManager.createStage("l2_state_change_stage", StateChangedEvent.class, (EventHandler)stateHandler, 1, maxStageSize);
        StateManagerImpl state = new StateManagerImpl(consoleLogger, this.groupCommManager, (Sink<StateChangedEvent>)stateChange.getSink(), stageManager, this.configSetupManager.getActiveServerGroupForThisL2().getMembers().length, this.configSetupManager.getActiveServerGroupForThisL2().getElectionTimeInSecs(), weightGeneratorFactory, this.persistor.getClusterStatePersistor());
        state.registerForStateChangeEvents(this.server);
        ReplicatedTransactionHandler replicatedTransactionHandler = new ReplicatedTransactionHandler(state, this.persistor.getTransactionOrderPersistor(), this.entityManager, this.persistor.getEntityPersistor(), this.groupCommManager);
        Stage replicationStage = stageManager.createStage("passive_replication_stage", ReplicationMessage.class, replicatedTransactionHandler.getEventHandler(), 1, maxStageSize);
        Stage replicationResponseStage = stageManager.createStage("passive_outgoing_response_stage", ReplicatedTransactionHandler.SedaToken.class, replicatedTransactionHandler.getOutgoingResponseHandler(), 1, maxStageSize);
        replicatedTransactionHandler.setOutgoingResponseSink((Sink<ReplicatedTransactionHandler.SedaToken>)replicationResponseStage.getSink());
        ChannelLifeCycleHandler channelLifeCycleHandler = new ChannelLifeCycleHandler(this.communicationsManager, stageManager, (DSOChannelManager)channelManager, clientEntityStateManager, state, eventCollector);
        channelManager.addEventListener((DSOChannelManagerEventListener)channelLifeCycleHandler);
        this.l2Coordinator = this.serverBuilder.createL2HACoordinator(consoleLogger, this, stageManager, state, this.groupCommManager, this.persistor, this.globalWeightGeneratorFactory, this.configSetupManager, this.stripeIDStateManager, channelLifeCycleHandler);
        this.connectServerStateToReplicatedState(state, this.l2Coordinator.getReplicatedClusterStateManager());
        ReplicationSender replicationSender = new ReplicationSender(this.groupCommManager);
        Stage replicationSenderStage = stageManager.createStage("active_to_passive_driver_stage", NodeID.class, (EventHandler)replicationSender, 1, maxStageSize);
        replicationSender.setSelfSink((Sink<NodeID>)replicationSenderStage.getSink());
        final ActiveToPassiveReplication passives = new ActiveToPassiveReplication(processTransactionHandler, this.l2Coordinator.getReplicatedClusterStateManager().getPassives(), this.persistor.getEntityPersistor(), replicationSender, this.getGroupManager());
        processor.setReplication(passives);
        Stage replicationStageAck = stageManager.createStage("passive_replication_ack_stage", ReplicationMessageAck.class, (EventHandler)new AbstractEventHandler<ReplicationMessageAck>(){

            public void handleEvent(ReplicationMessageAck context) throws EventHandlerException {
                switch (context.getType()) {
                    case 5: {
                        passives.batchAckReceived(context);
                        break;
                    }
                    case 4: {
                        passives.startPassiveSync(context.messageFrom());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("bad message " + context));
                    }
                }
            }
        }, 1, maxStageSize);
        Sink stateMessageSink = stageManager.createStage("l2_state_message_handler_stage", L2StateMessage.class, (EventHandler)new L2StateMessageHandler(), 1, maxStageSize).getSink();
        this.groupCommManager.routeMessages(L2StateMessage.class, stateMessageSink);
        GroupEventsDispatchHandler dispatchHandler = new GroupEventsDispatchHandler();
        dispatchHandler.addListener(this.l2Coordinator);
        dispatchHandler.addListener(passives);
        Stage groupEvents = stageManager.createStage("group_events_dispatch_stage", GroupEvent.class, (EventHandler)dispatchHandler, 1, maxStageSize);
        this.groupCommManager.registerForGroupEvents(dispatchHandler.createDispatcher((Sink<GroupEvent>)groupEvents.getSink()));
        OrderedSink replication = new OrderedSink(logger, replicationStage.getSink());
        this.groupCommManager.routeMessages(ReplicationMessage.class, replication);
        this.groupCommManager.routeMessages(ReplicationMessageAck.class, replicationStageAck.getSink());
        Sink<PlatformInfoRequest> info = this.createPlatformInformationStages(stageManager, maxStageSize, monitoringShimService);
        dispatchHandler.addListener(this.connectPassiveOperatorEvents(info, this.haConfig.getNodesStore(), monitoringShimService));
        this.dumpHandler.registerForDump(new CallbackDumpAdapter((PrettyPrintable)this.l2Coordinator));
        GlobalServerStatsImpl serverStats = new GlobalServerStatsImpl(globalObjectFaultCounter, globalTxnCounter, broadcastCounter, globalLockRecallCounter, changesPerBroadcast, transactionSizeCounter, globalLockCount, globalOperationCounter);
        serverStats.serverMapGetSizeRequestsCounter(globalServerMapGetSizeRequestsCounter).serverMapGetValueRequestsCounter(globalServerMapGetValueRequestsCounter).serverMapGetSnapshotRequestsCounter(globalServerMapGetSnapshotRequestsCounter);
        this.context = this.serverBuilder.createServerConfigurationContext(stageManager, this.lockManager, (DSOChannelManager)channelManager, channelStats, this.l2Coordinator, clientHandshakeManager, serverStats, this.connectionIdFactory, maxStageSize, this.l1Listener.getChannelManager(), this);
        toInit.add(this.serverBuilder);
        this.startStages(stageManager, toInit);
        ServerManagementHandler serverManagementHandler = new ServerManagementHandler();
        final RemoteManagementImpl remoteManagement = new RemoteManagementImpl((DSOChannelManager)channelManager, serverManagementHandler, this.haConfig.getNodesStore().getServerNameFromNodeName(this.thisServerNodeID.getName()));
        TerracottaRemoteManagement.setRemoteManagementInstance((RemoteManagement)remoteManagement);
        TerracottaOperatorEventLogging.getEventLogger().registerEventCallback(new TerracottaOperatorEventCallback(){

            public void logOperatorEvent(TerracottaOperatorEvent event) {
                TSAManagementEventPayload payload = new TSAManagementEventPayload("TSA.OPERATOR_EVENT." + event.getEventTypeAsString());
                payload.getAttributes().put("OperatorEvent.CollapseString", event.getCollapseString());
                payload.getAttributes().put("OperatorEvent.EventLevel", event.getEventLevelAsString());
                payload.getAttributes().put("OperatorEvent.EventMessage", event.getEventMessage());
                payload.getAttributes().put("OperatorEvent.EventSubsystem", event.getEventSubsystemAsString());
                payload.getAttributes().put("OperatorEvent.EventType", event.getEventTypeAsString());
                payload.getAttributes().put("OperatorEvent.EventTime", event.getEventTime().getTime());
                payload.getAttributes().put("OperatorEvent.NodeName", event.getNodeName());
                remoteManagement.sendEvent(payload.toManagementEvent());
            }
        });
        this.managementContext = new ServerManagementContext(this.lockManager, (DSOChannelManagerMBean)channelManager, serverStats, channelStats, instanceMonitor, this.connectionPolicy, remoteManagement);
        CallbackGroupExceptionHandler handler = new CallbackGroupExceptionHandler(logger, consoleLogger);
        this.threadGroup.addCallbackOnExitExceptionHandler(GroupException.class, (CallbackOnExitHandler)handler);
        this.startGroupManagers();
        this.l2Coordinator.start();
        this.startDiagnosticListener();
        this.setLoggerOnExit();
    }

    private Sink<PlatformInfoRequest> createPlatformInformationStages(StageManager stageManager, int maxStageSize, LocalMonitoringProducer monitoringSupport) {
        Stage stage = stageManager.createStage("platform_information_request", PlatformInfoRequest.class, new PlatformInfoRequestHandler(this.groupCommManager, monitoringSupport).getEventHandler(), 1, maxStageSize);
        this.groupCommManager.routeMessages(PlatformInfoRequest.class, stage.getSink());
        return stage.getSink();
    }

    private void startStages(StageManager stageManager, List<PostInit> toInit) {
        stageManager.startAll((ConfigurationContext)this.context, toInit, new String[]{"voltron_message_stage", "respond_to_request_stage", "active_to_passive_driver_stage", "passive_replication_stage", "passive_outgoing_response_stage", "passive_replication_ack_stage", "respond_to_lock_request_stage", "request_lock_stage"});
    }

    private void flushLocalPipeline(EntityID eid, FetchID fetch, ServerEntityAction action) {
        boolean forDestroy;
        switch (action) {
            case CREATE_ENTITY: 
            case DESTROY_ENTITY: 
            case FETCH_ENTITY: 
            case RECONFIGURE_ENTITY: 
            case RELEASE_ENTITY: {
                logger.info((Object)("completed lifecycle " + (Object)((Object)action) + " on " + eid));
                break;
            }
            default: {
                logger.debug((Object)("completed mgmt " + (Object)((Object)action) + " on " + eid));
            }
        }
        boolean bl = forDestroy = action == ServerEntityAction.DESTROY_ENTITY;
        if (!this.l2Coordinator.getStateManager().isActiveCoordinator()) {
            try {
                this.seda.getStageManager().getStage("passive_replication_stage", ReplicationMessage.class).getSink().addSingleThreaded((Object)ReplicationMessage.createLocalContainer((SyncReplicationActivity)SyncReplicationActivity.createFlushLocalPipelineMessage((FetchID)fetch, (boolean)forDestroy)));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.seda.getStageManager().getStage("voltron_message_stage", VoltronEntityMessage.class).getSink().addSingleThreaded((Object)new LocalPipelineFlushMessage(EntityDescriptor.createDescriptorForInvoke((FetchID)fetch, (ClientInstanceID)ClientInstanceID.NULL_ID), forDestroy));
    }

    private StageController createStageController(LocalMonitoringProducer monitoringSupport) {
        StageController control = new StageController();
        control.addStageToState(StateManager.PASSIVE_UNINITIALIZED, "passive_replication_stage");
        control.addStageToState(StateManager.PASSIVE_UNINITIALIZED, "passive_outgoing_response_stage");
        control.addStageToState(StateManager.PASSIVE_SYNCING, "passive_replication_stage");
        control.addStageToState(StateManager.PASSIVE_SYNCING, "passive_outgoing_response_stage");
        control.addStageToState(StateManager.PASSIVE_STANDBY, "passive_replication_stage");
        control.addStageToState(StateManager.PASSIVE_STANDBY, "passive_outgoing_response_stage");
        control.addStageToState(StateManager.ACTIVE_COORDINATOR, "active_to_passive_driver_stage");
        control.addStageToState(StateManager.ACTIVE_COORDINATOR, "voltron_message_stage");
        control.addStageToState(StateManager.ACTIVE_COORDINATOR, "respond_to_request_stage");
        control.addStageToState(StateManager.ACTIVE_COORDINATOR, "passive_replication_ack_stage");
        control.addTriggerToState(StateManager.ACTIVE_COORDINATOR, () -> {
            this.server.updateActivateTime();
            monitoringSupport.serverIsActive();
            PlatformInfoRequest req = PlatformInfoRequest.createEmptyRequest();
            this.groupCommManager.sendAll((AbstractGroupMessage)req);
        });
        return control;
    }

    private GroupEventsListener connectPassiveOperatorEvents(final Sink<PlatformInfoRequest> infoHandler, NodesStore nodesStore, final LocalMonitoringProducer monitoringShimService) {
        final OperatorEventsPassiveServerConnectionListener delegate = new OperatorEventsPassiveServerConnectionListener(nodesStore);
        return new GroupEventsListener(){

            @Override
            public void nodeJoined(NodeID nodeID) {
                if (DistributedObjectServer.this.l2Coordinator.getStateManager().isActiveCoordinator()) {
                    delegate.passiveServerJoined((ServerID)nodeID);
                    if (monitoringShimService.isReadyToReceiveRemoteEvents()) {
                        PlatformInfoRequest req = PlatformInfoRequest.createEmptyRequest();
                        try {
                            DistributedObjectServer.this.groupCommManager.sendTo(nodeID, req);
                        }
                        catch (GroupException g) {
                            logger.error((Object)"Failed to send PlatformInfoRequest to new passive", (Throwable)g);
                        }
                    } else {
                        logger.warn((Object)("Deferring PlatformInfoRequest to new passive: " + nodeID));
                    }
                }
            }

            @Override
            public void nodeLeft(NodeID nodeID) {
                if (DistributedObjectServer.this.l2Coordinator.getStateManager().isActiveCoordinator()) {
                    delegate.passiveServerLeft((ServerID)nodeID);
                    PlatformInfoRequest fake = PlatformInfoRequest.createServerInfoRemoveMessage((ServerID)((ServerID)nodeID));
                    fake.setMessageOrginator(nodeID);
                    infoHandler.addSingleThreaded((Object)fake);
                }
            }
        };
    }

    private void connectServerStateToReplicatedState(StateManager mgr, final ReplicatedClusterStateManager rcs) {
        mgr.registerForStateChangeEvents(new StateChangeListener(){

            @Override
            public void l2StateChanged(StateChangedEvent sce) {
                rcs.setCurrentState(sce.getCurrentState());
                Set<ClientID> existingConnections = Collections.unmodifiableSet(DistributedObjectServer.this.persistor.getClientStatePersistor().loadClientIDs());
                DistributedObjectServer.this.persistor.getEntityPersistor().removeOrphanedClientsFromJournal(existingConnections);
                if (sce.movedToActive()) {
                    DistributedObjectServer.this.startActiveMode(sce.getOldState().equals((Object)StateManager.PASSIVE_STANDBY));
                    try {
                        DistributedObjectServer.this.startL1Listener(existingConnections);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        });
    }

    public void startGroupManagers() {
        try {
            NodeID myNodeId = this.groupCommManager.join(this.haConfig.getThisNode(), this.haConfig.getNodesStore());
            logger.info((Object)("This L2 Node ID = " + myNodeId));
        }
        catch (GroupException e) {
            logger.error((Object)"Caught Exception :", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void reloadConfiguration() throws ConfigurationSetupException {
        throw new UnsupportedOperationException();
    }

    private HashMap<TCMessageType, Class<? extends TCMessage>> getMessageTypeClassMappings() {
        HashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_MESSAGE, ListRegisteredServicesMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_RESPONSE_MESSAGE, ListRegisteredServicesResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_MESSAGE, InvokeRegisteredServiceMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_RESPONSE_MESSAGE, InvokeRegisteredServiceResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, VoltronEntityMultiResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_MESSAGE, ServerEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_RESPONSE_MESSAGE, ServerEntityResponseMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_REQUEST, DiagnosticMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_RESPONSE, DiagnosticResponseImpl.class);
        return messageTypeClassMapping;
    }

    protected TCLogger getLogger() {
        return logger;
    }

    private ServerID makeServerNodeID(L2Config l2DSOConfig) {
        String host = l2DSOConfig.tsaGroupPort().getBind();
        if ("0.0.0.0".equals(host)) {
            host = l2DSOConfig.host();
        }
        Node node = new Node(host, l2DSOConfig.tsaPort().getValue());
        ServerID aNodeID = new ServerID(node.getServerNodeName(), UUID.getUUID().toString().getBytes());
        logger.info((Object)("Creating server nodeID: " + aNodeID));
        return aNodeID;
    }

    public ServerID getServerNodeID() {
        return this.thisServerNodeID;
    }

    public ChannelManager getChannelManager() {
        return this.l1Listener.getChannelManager();
    }

    private void setLoggerOnExit() {
        CommonShutDownHook.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"L2 Exiting...");
            }
        });
    }

    public void startActiveMode(boolean wasStandby) {
        if (!wasStandby && this.persistor.getClusterStatePersistor().getInitialState() == null) {
            Sink msgSink = this.seda.getStageManager().getStage("voltron_message_stage", VoltronEntityMessage.class).getSink();
            HashMap<EntityID, VoltronEntityMessage> checkdups = new HashMap<EntityID, VoltronEntityMessage>();
            List<VoltronEntityMessage> annotated = ServerEntityFactory.getAnnotatedEntities(this.entityManager.getEntityLoader());
            for (VoltronEntityMessage vem : annotated) {
                checkdups.put(vem.getEntityDescriptor().getEntityID(), vem);
            }
            List<VoltronEntityMessage> msgs = PermanentEntityParser.parseEntities(((TcConfiguration)this.configSetupManager.commonl2Config().getBean()).getPlatformConfiguration());
            for (VoltronEntityMessage vem : msgs) {
                checkdups.put(vem.getEntityDescriptor().getEntityID(), vem);
            }
            for (VoltronEntityMessage vem : checkdups.values()) {
                msgSink.addSingleThreaded((Object)vem);
            }
        }
    }

    public void startL1Listener(Set<ClientID> existingConnections) throws IOException {
        try {
            this.l1Diagnostics.stop(0L);
        }
        catch (TCTimeoutException to) {
            throw Assert.failure((Object)"no timeout set!", (Throwable)to);
        }
        this.context.getClientHandshakeManager().setStarting(existingConnections);
        this.l1Listener.start(existingConnections);
        if (!existingConnections.isEmpty()) {
            this.context.getClientHandshakeManager().startReconnectWindow();
        }
        consoleLogger.info((Object)("Terracotta Server instance has started up as ACTIVE node on " + DistributedObjectServer.format(this.l1Listener) + " successfully, and is now ready for work."));
    }

    public void startDiagnosticListener() throws IOException {
        this.l1Diagnostics.start(Collections.emptySet());
    }

    private static String format(NetworkListener listener) {
        StringBuilder sb = new StringBuilder(listener.getBindAddress().getHostAddress());
        sb.append(':');
        sb.append(listener.getBindPort());
        return sb.toString();
    }

    public boolean stopActiveMode() throws TCTimeoutException {
        consoleLogger.info((Object)("Stopping ACTIVE Terracotta Server instance on " + DistributedObjectServer.format(this.l1Listener) + "."));
        this.l1Listener.stop(10000L);
        this.l1Listener.getChannelManager().closeAllChannels();
        return true;
    }

    public int getListenPort() {
        L2Config l2DSOConfig = this.configSetupManager.dsoL2Config();
        int configValue = l2DSOConfig.tsaPort().getValue();
        if (configValue != 0) {
            return configValue;
        }
        if (this.l1Listener != null) {
            try {
                return this.l1Listener.getBindPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return -1;
    }

    public InetAddress getListenAddr() {
        return this.l1Listener.getBindAddress();
    }

    public int getGroupPort() {
        L2Config l2DSOConfig = this.configSetupManager.dsoL2Config();
        int configValue = l2DSOConfig.tsaGroupPort().getValue();
        if (configValue != 0) {
            return configValue;
        }
        return -1;
    }

    public ConnectionIDFactory getConnectionIdFactory() {
        return this.connectionIdFactory;
    }

    public ServerConfigurationContext getContext() {
        return this.context;
    }

    public ServerManagementContext getManagementContext() {
        return this.managementContext;
    }

    public TerracottaOperatorEventHistoryProvider getOperatorEventsHistoryProvider() {
        return this.operatorEventHistoryProvider;
    }

    public void addAllLocksTo(LockInfoByThreadID lockInfo) {
    }

    public ThreadIDMap getThreadIDMap() {
        return new NullThreadIDMapImpl();
    }

    protected GroupManager<AbstractGroupMessage> getGroupManager() {
        return this.groupCommManager;
    }

    public void registerForDump(CallbackDumpAdapter dumpAdapter) {
        this.dumpHandler.registerForDump(dumpAdapter);
    }

    public boolean isAlive(String name) {
        throw new UnsupportedOperationException();
    }

    protected ClientHandshakeHandler createHandShakeHandler(EntityManager entities, ProcessTransactionHandler processTransactionHandler) {
        return new ClientHandshakeHandler(this.configSetupManager.dsoL2Config().serverName(), entities, processTransactionHandler);
    }

    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    public void dumpClusterState() {
        try {
            L2DumperMBean mbean = (L2DumperMBean)TerracottaManagement.findMBean((ObjectName)L2MBeanNames.DUMPER, L2DumperMBean.class, (MBeanServerConnection)ManagementFactory.getPlatformMBeanServer());
            mbean.dumpClusterState();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not take Cluster dump, hence taking server dump only");
            this.dump();
        }
    }
}

