/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.objectserver.api.ObjectInstanceMonitor;
import com.tc.objectserver.api.ObjectInstanceMonitorMBean;
import java.util.HashMap;
import java.util.Map;

public class ObjectInstanceMonitorImpl
implements ObjectInstanceMonitor,
ObjectInstanceMonitorMBean {
    private final Map<String, Integer> instanceCounts = new HashMap<String, Integer>();

    @Override
    public synchronized void instanceCreated(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Integer value = this.instanceCounts.get(type);
        if (value == null) {
            this.instanceCounts.put(type, 1);
        } else {
            this.instanceCounts.put(type, value + 1);
        }
    }

    @Override
    public synchronized void instanceDestroyed(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Integer value = this.instanceCounts.get(type);
        if (value == null) {
            throw new IllegalStateException("No count available for type " + type);
        }
        this.instanceCounts.put(type, value - 1);
        if (this.instanceCounts.get(type) <= 0) {
            this.instanceCounts.remove(type);
        }
    }

    @Override
    public synchronized Map<String, Integer> getInstanceCounts() {
        HashMap<String, Integer> rv = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.instanceCounts.entrySet()) {
            rv.put(entry.getKey(), entry.getValue());
        }
        return rv;
    }
}

