/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.entity.VoltronEntityMessage;
import com.tc.object.EntityID;
import com.tc.objectserver.entity.CreateSystemEntityMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.terracotta.config.Entities;
import org.terracotta.config.Entity;
import org.terracotta.config.TcConfig;
import org.w3c.dom.Element;

public class PermanentEntityParser {
    public static List<VoltronEntityMessage> parseEntities(TcConfig config) {
        Entities e = config.getEntities();
        List<VoltronEntityMessage> msgs = null;
        if (e != null) {
            msgs = new ArrayList<VoltronEntityMessage>(e.getEntity().size());
            for (Entity b : e.getEntity()) {
                byte[] data;
                String name = b.getName();
                String type = b.getType();
                int version = b.getVersion();
                Entity.Configuration c = b.getConfiguration();
                if (c != null) {
                    Entity.Configuration.Properties m = c.getProperties();
                    if (m != null) {
                        Properties prop = new Properties();
                        List list = m.getAny();
                        for (Element pe : list) {
                            prop.setProperty(pe.getTagName(), pe.getTextContent());
                        }
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            prop.store(bos, null);
                            data = bos.toByteArray();
                        }
                        catch (IOException ioe) {
                            data = new byte[]{};
                        }
                    } else {
                        Element any = c.getAny();
                        if (any != null) {
                            try {
                                TransformerFactory transFactory = TransformerFactory.newInstance();
                                Transformer transformer = transFactory.newTransformer();
                                StringWriter buffer = new StringWriter();
                                transformer.setOutputProperty("omit-xml-declaration", "yes");
                                transformer.transform(new DOMSource(any), new StreamResult(buffer));
                                String str = buffer.toString();
                                data = str.getBytes();
                            }
                            catch (TransformerException te) {
                                data = new byte[]{};
                            }
                        } else {
                            data = new byte[]{};
                        }
                    }
                } else {
                    data = new byte[]{};
                }
                msgs.add(PermanentEntityParser.createMessage(type, name, version, data));
            }
        } else {
            msgs = Collections.emptyList();
        }
        return msgs;
    }

    public static VoltronEntityMessage createMessage(String type, String name, int version, byte[] data) {
        return new CreateSystemEntityMessage(new EntityID(type, name), version, data);
    }
}

