/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.util.ProductInfo;
import com.tc.util.version.Version;
import com.tc.util.version.VersionCompatibility;

public class ServerPersistenceVersionChecker {
    private static final TCLogger LOGGER = TCLogging.getLogger(ServerPersistenceVersionChecker.class);
    private final ClusterStatePersistor clusterStatePersistor;
    private final ProductInfo productInfo;
    private final VersionCompatibility versionCompatibility;

    public ServerPersistenceVersionChecker(ClusterStatePersistor clusterStatePersistor) {
        this(clusterStatePersistor, ProductInfo.getInstance(), new VersionCompatibility());
    }

    ServerPersistenceVersionChecker(ClusterStatePersistor clusterStatePersistor, ProductInfo productInfo, VersionCompatibility versionCompatibility) {
        this.clusterStatePersistor = clusterStatePersistor;
        this.productInfo = productInfo;
        this.versionCompatibility = versionCompatibility;
    }

    private boolean checkVersion(Version persisted, Version current) {
        if (persisted != null) {
            return this.versionCompatibility.isCompatibleServerPersistence(persisted, current);
        }
        return true;
    }

    public void checkAndSetVersion() {
        Version currentVersion = new Version(this.productInfo.version());
        Version persistedVersion = this.clusterStatePersistor.getVersion();
        if (this.checkVersion(this.clusterStatePersistor.getVersion(), currentVersion)) {
            if (persistedVersion == null || currentVersion.compareTo(persistedVersion) > 0) {
                this.clusterStatePersistor.setVersion(currentVersion);
            }
        } else {
            LOGGER.error((Object)("Incompatible data format detected. Found data for version " + persistedVersion + " expecting data for version " + currentVersion + "."));
            LOGGER.error((Object)"Verify that the correct data is in the server data path, and try again.");
            throw new IllegalStateException("Incompatible data format version. Got " + persistedVersion + " expected " + currentVersion);
        }
    }
}

