/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.StageManager;
import com.tc.config.HaConfig;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.l2.api.L2Coordinator;
import com.tc.l2.ha.L2HACoordinator;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.StateManager;
import com.tc.logging.DumpHandlerStore;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ServerID;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.net.groups.TCGroupManagerImpl;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.core.api.GlobalServerStats;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ServerConfigurationContextImpl;
import com.tc.objectserver.handler.ChannelLifeCycleHandler;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import com.tc.objectserver.impl.ChannelStatsImpl;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.impl.ServerBuilder;
import com.tc.objectserver.locks.LockManager;
import com.tc.objectserver.persistence.Persistor;
import com.tc.runtime.logging.LongGCLogger;
import com.tc.util.Assert;
import com.tc.util.runtime.ThreadDumpUtil;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.persistence.IPlatformPersistence;

public class StandardServerBuilder
implements ServerBuilder {
    private final HaConfig haConfig;
    protected final TCSecurityManager securityManager;
    protected final TCLogger logger;

    public StandardServerBuilder(HaConfig haConfig, TCLogger logger, TCSecurityManager securityManager) {
        this.logger = logger;
        this.securityManager = securityManager;
        this.logger.info((Object)"Standard TSA Server created");
        this.haConfig = haConfig;
    }

    @Override
    public GroupManager<AbstractGroupMessage> createGroupCommManager(L2ConfigurationSetupManager configManager, StageManager stageManager, ServerID serverNodeID, StripeIDStateManager stripeStateManager, WeightGeneratorFactory weightGeneratorFactory) {
        return new TCGroupManagerImpl(configManager, stageManager, serverNodeID, this.haConfig.getThisNode(), this.haConfig.getNodesStore(), this.securityManager, weightGeneratorFactory);
    }

    @Override
    public ServerConfigurationContext createServerConfigurationContext(StageManager stageManager, LockManager lockMgr, DSOChannelManager channelManager, ChannelStatsImpl channelStats, L2Coordinator coordinator, ServerClientHandshakeManager clientHandshakeManager, GlobalServerStats serverStats, ConnectionIDFactory connectionIdFactory, int maxStageSize, ChannelManager genericChannelManager, DumpHandlerStore dumpHandlerStore) {
        return new ServerConfigurationContextImpl(stageManager, lockMgr, channelManager, clientHandshakeManager, channelStats, coordinator);
    }

    public void dump() {
        TCLogging.getDumpLogger().info((Object)ThreadDumpUtil.getThreadDump());
    }

    public void initializeContext(ConfigurationContext context) {
    }

    @Override
    public L2Coordinator createL2HACoordinator(TCLogger consoleLogger, DistributedObjectServer server, StageManager stageManager, StateManager stateMgr, GroupManager<AbstractGroupMessage> groupCommsManager, Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, L2ConfigurationSetupManager configurationSetupManager, StripeIDStateManager stripeStateManager, ChannelLifeCycleHandler clm) {
        return new L2HACoordinator(consoleLogger, server, stageManager, stateMgr, groupCommsManager, persistor, weightGeneratorFactory, configurationSetupManager, stripeStateManager, clm);
    }

    @Override
    public LongGCLogger createLongGCLogger(long gcTimeOut) {
        return new LongGCLogger(gcTimeOut);
    }

    @Override
    public Persistor createPersistor(ServiceRegistry serviceRegistry) {
        IPlatformPersistence platformPersistence = (IPlatformPersistence)serviceRegistry.getService((ServiceConfiguration)new BasicServiceConfiguration(IPlatformPersistence.class));
        Assert.assertNotNull((Object)platformPersistence);
        return new Persistor(platformPersistence);
    }
}

