/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.exception.TCLockUpgradeNotSupportedError;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.locks.LockHelper;
import com.tc.objectserver.locks.LockMBean;
import com.tc.objectserver.locks.LockMBeanImpl;
import com.tc.objectserver.locks.LockResponseContext;
import com.tc.objectserver.locks.LockResponseContextFactory;
import com.tc.objectserver.locks.LockStore;
import com.tc.objectserver.locks.NotifiedWaiters;
import com.tc.objectserver.locks.ServerLock;
import com.tc.objectserver.locks.ServerLockContextBean;
import com.tc.objectserver.locks.TCIllegalMonitorStateException;
import com.tc.objectserver.locks.context.LinkedServerLockContext;
import com.tc.objectserver.locks.context.SingleServerLockContext;
import com.tc.objectserver.locks.context.WaitServerLockContext;
import com.tc.objectserver.locks.timer.LockTimer;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.SinglyLinkedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.TimerTask;

public abstract class AbstractServerLock
extends SinglyLinkedList<ServerLockContext>
implements ServerLock,
PrettyPrintable {
    private static final EnumSet<ServerLockContext.Type> SET_OF_TRY_PENDING_OR_WAITERS = EnumSet.of(ServerLockContext.Type.TRY_PENDING, ServerLockContext.Type.WAITER);
    private static final EnumSet<ServerLockContext.Type> SET_OF_WAITERS = EnumSet.of(ServerLockContext.Type.WAITER);
    private static final EnumSet<ServerLockContext.Type> SET_OF_HOLDERS = EnumSet.of(ServerLockContext.Type.HOLDER, ServerLockContext.Type.GREEDY_HOLDER);
    protected static final TCLogger logger = TCLogging.getLogger(AbstractServerLock.class);
    protected final LockID lockID;

    public AbstractServerLock(LockID lockID) {
        this.lockID = lockID;
    }

    @Override
    public void lock(ClientID cid, ThreadID tid, ServerLockLevel level, LockHelper helper) {
        this.validateAndGetNumberOfPending(cid, tid, level);
        this.requestLock(cid, tid, level, ServerLockContext.Type.PENDING, -1L, helper);
    }

    @Override
    public void tryLock(ClientID cid, ThreadID tid, ServerLockLevel level, long timeout, LockHelper helper) {
        this.validateAndGetNumberOfPending(cid, tid, level);
        if (timeout <= 0L && !this.canAwardRequest(level)) {
            this.refuseTryRequestWithNoTimeout(cid, tid, level, helper);
            return;
        }
        this.requestLock(cid, tid, level, ServerLockContext.Type.TRY_PENDING, timeout, helper);
    }

    @Override
    public void queryLock(ClientID cid, ThreadID tid, LockHelper helper) {
        ArrayList<ClientServerExchangeLockContext> holdersAndWaiters = new ArrayList<ClientServerExchangeLockContext>();
        int pendingCount = 0;
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        block5: while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)singlyLinkedListIterator.next();
            ClientServerExchangeLockContext cselc = null;
            ServerLockContext.Type type = context.getState().getType();
            switch (type) {
                case GREEDY_HOLDER: 
                case HOLDER: {
                    cselc = new ClientServerExchangeLockContext(this.lockID, (NodeID)context.getClientID(), context.getThreadID(), context.getState());
                    holdersAndWaiters.add(cselc);
                    continue block5;
                }
                case WAITER: {
                    cselc = new ClientServerExchangeLockContext(this.lockID, (NodeID)context.getClientID(), context.getThreadID(), context.getState(), ((WaitServerLockContext)context).getTimeout());
                    holdersAndWaiters.add(cselc);
                    continue block5;
                }
                case PENDING: 
                case TRY_PENDING: {
                    ++pendingCount;
                    continue block5;
                }
            }
            throw new AssertionError(type);
        }
        LockResponseContext lrc = LockResponseContextFactory.createLockQueriedResponseContext(this.lockID, (NodeID)cid, tid, this.holderLevel(), holdersAndWaiters, pendingCount);
        helper.getLockSink().addMultiThreaded((Object)lrc);
    }

    @Override
    public void interrupt(ClientID cid, ThreadID tid, LockHelper helper) {
        ServerLockContext context = this.remove(cid, tid, SET_OF_WAITERS);
        if (context == null) {
            logger.warn((Object)("Cannot interrupt: " + cid + "," + tid + " is not waiting."));
            return;
        }
        this.moveWaiterToPending(context, helper);
        this.processPendingRequests(helper);
    }

    @Override
    public NotifiedWaiters notify(ClientID cid, ThreadID tid, ServerLock.NotifyAction action, NotifiedWaiters addNotifiedWaitersTo, LockHelper helper) throws TCIllegalMonitorStateException {
        ServerLockContext holder = this.getNotifyHolder(cid, tid);
        this.validateWaitNotifyState(cid, tid, holder, helper);
        List<ServerLockContext> waiters = this.removeWaiters(action);
        for (ServerLockContext waiter : waiters) {
            this.moveWaiterToPending(waiter, helper);
            ClientServerExchangeLockContext cselc = new ClientServerExchangeLockContext(this.lockID, (NodeID)waiter.getClientID(), waiter.getThreadID(), ServerLockContext.State.WAITER);
            addNotifiedWaitersTo.addNotification(cselc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notify " + cid + " " + tid + " " + addNotifiedWaitersTo));
        }
        return addNotifiedWaitersTo;
    }

    @Override
    public void wait(ClientID cid, ThreadID tid, long timeout, LockHelper helper) {
        this.moveFromHolderToWaiter(cid, tid, timeout, helper);
        this.processPendingRequests(helper);
    }

    @Override
    public void unlock(ClientID cid, ThreadID tid, LockHelper helper) {
        ServerLockContext context = this.remove(cid, tid, SET_OF_HOLDERS);
        if (context == null) {
            return;
        }
        Assert.assertTrue((boolean)context.isHolder());
        if (this.clearLockIfRequired(helper)) {
            return;
        }
        this.processPendingRequests(helper);
    }

    @Override
    public void reestablishState(ClientServerExchangeLockContext cselc, LockHelper helper) {
        Assert.assertFalse((boolean)this.checkDuplicate((ClientID)cselc.getNodeID(), cselc.getThreadID()));
        switch (cselc.getState().getType()) {
            case GREEDY_HOLDER: 
            case HOLDER: {
                if (!this.canAwardRequest(cselc.getState().getLockLevel())) {
                    throw new AssertionError((Object)("Lock could not be awarded as it is already held " + cselc));
                }
                this.reestablishLock(cselc, helper);
                break;
            }
            case WAITER: {
                ServerLockContext context = this.createWaiterAndScheduleTask(cselc, helper);
                this.addWaiter(context, helper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Called with wrong type = " + cselc.getState().getType());
            }
        }
    }

    @Override
    public LockMBean getMBean(DSOChannelManager channelManager) {
        ArrayList<ServerLockContextBean> contextsPresent = new ArrayList<ServerLockContextBean>();
        SinglyLinkedList.SinglyLinkedListIterator contexts = this.iterator();
        while (contexts.hasNext()) {
            ServerLockContext context = (ServerLockContext)contexts.next();
            ServerLockContextBean clonedContext = null;
            String client = channelManager.getChannelAddress((NodeID)context.getClientID());
            switch (context.getState().getType()) {
                case GREEDY_HOLDER: 
                case HOLDER: 
                case PENDING: {
                    clonedContext = new ServerLockContextBean(client, context.getThreadID(), context.getState());
                    break;
                }
                case WAITER: 
                case TRY_PENDING: {
                    clonedContext = new ServerLockContextBean(client, context.getThreadID(), context.getState(), ((WaitServerLockContext)context).getTimeout());
                    break;
                }
                default: {
                    logger.warn((Object)("unexpected lock type: " + context.getState().getType()));
                }
            }
            if (clonedContext == null) continue;
            contextsPresent.add(clonedContext);
        }
        LockMBeanImpl bean = new LockMBeanImpl(this.lockID, contextsPresent.toArray(new ServerLockContextBean[contextsPresent.size()]));
        return bean;
    }

    @Override
    public LockID getLockID() {
        return this.lockID;
    }

    @Override
    public boolean clearStateForNode(ClientID cid, LockHelper helper) {
        this.clearContextsForClient(cid, helper);
        this.processPendingRequests(helper);
        return this.isEmpty();
    }

    @Override
    public void timerTimeout(LockTimer.LockTimerContext lockTimerContext) {
        ClientID cid = lockTimerContext.getClientID();
        ThreadID tid = lockTimerContext.getThreadID();
        LockHelper helper = lockTimerContext.getHelper();
        ServerLockContext context = this.remove(cid, tid, SET_OF_TRY_PENDING_OR_WAITERS);
        if (context == null) {
            return;
        }
        if (context.isWaiter()) {
            this.waitTimeout(context, helper);
        } else {
            this.tryLockTimeout(context, helper);
        }
    }

    @Override
    public void recallCommit(ClientID cid, Collection<ClientServerExchangeLockContext> serverLockContexts, LockHelper helper) {
    }

    private void tryLockTimeout(ServerLockContext context, LockHelper helper) {
        Assert.assertTrue((boolean)context.isTryPending());
        this.cannotAward(context.getClientID(), context.getThreadID(), context.getState().getLockLevel(), helper);
        this.processPendingRequests(helper);
    }

    private void waitTimeout(ServerLockContext context, LockHelper helper) {
        Assert.assertTrue((boolean)context.isWaiter());
        LockResponseContext lrc = LockResponseContextFactory.createLockWaitTimeoutResponseContext(this.lockID, (NodeID)context.getClientID(), context.getThreadID(), context.getState().getLockLevel());
        helper.getLockSink().addMultiThreaded((Object)lrc);
        this.lock(context.getClientID(), context.getThreadID(), ServerLockLevel.WRITE, helper);
    }

    protected ServerLockContext createWaiterAndScheduleTask(ClientServerExchangeLockContext cselc, LockHelper helper) {
        WaitServerLockContext context = this.createWaitOrTryPendingServerLockContext((ClientID)cselc.getNodeID(), cselc.getThreadID(), cselc.getState(), cselc.timeout(), helper);
        if (cselc.timeout() > 0L) {
            LockTimer.LockTimerContext ltc = new LockTimer.LockTimerContext(this.lockID, cselc.getThreadID(), (ClientID)cselc.getNodeID(), helper);
            TimerTask task = helper.getLockTimer().scheduleTimer(helper.getTimerCallback(), cselc.timeout(), ltc);
            context.setTimerTask(task);
        }
        return context;
    }

    protected boolean clearLockIfRequired(LockHelper helper) {
        if (this.isEmpty()) {
            LockStore store = helper.getLockStore();
            store.remove(this.lockID);
            return true;
        }
        return false;
    }

    protected void reestablishLock(ClientServerExchangeLockContext cselc, LockHelper helper) {
        this.awardLock(helper, this.createPendingContext((ClientID)cselc.getNodeID(), cselc.getThreadID(), cselc.getState().getLockLevel(), helper), false);
    }

    protected void moveFromHolderToWaiter(ClientID cid, ThreadID tid, long timeout, LockHelper helper) {
        ServerLockContext holder = this.remove(cid, tid, SET_OF_HOLDERS);
        this.validateWaitNotifyState(cid, tid, holder, helper);
        WaitServerLockContext waiter = this.createWaitOrTryPendingServerLockContext(cid, tid, ServerLockContext.State.WAITER, timeout, helper);
        if (timeout > 0L) {
            LockTimer.LockTimerContext ltc = new LockTimer.LockTimerContext(this.lockID, tid, cid, helper);
            TimerTask task = helper.getLockTimer().scheduleTimer(helper.getTimerCallback(), timeout, ltc);
            waiter.setTimerTask(task);
        }
        this.addWaiter(waiter, helper);
    }

    private void validateWaitNotifyState(ClientID cid, ThreadID tid, ServerLockContext holder, LockHelper helper) {
        if (holder == null) {
            throw new TCIllegalMonitorStateException("No holder present for when trying to wait/notify " + cid + "," + tid + " for lock = " + this.toString());
        }
        if (holder.getState() != ServerLockContext.State.HOLDER_WRITE && holder.getState() != ServerLockContext.State.GREEDY_HOLDER_WRITE) {
            String message = "Holder not in correct state while wait/notify " + this.lockID + " " + holder;
            throw new TCIllegalMonitorStateException(message);
        }
    }

    protected void queue(ClientID cid, ThreadID tid, ServerLockLevel level, ServerLockContext.Type type, long timeout, LockHelper helper) {
        switch (type) {
            case TRY_PENDING: {
                WaitServerLockContext waitContext = this.createTryPendingServerLockContext(cid, tid, level, timeout, helper);
                if (timeout > 0L) {
                    TimerTask task;
                    LockTimer.LockTimerContext ltc = new LockTimer.LockTimerContext(this.lockID, tid, cid, helper);
                    try {
                        task = helper.getLockTimer().scheduleTimer(helper.getTimerCallback(), timeout, ltc);
                    }
                    catch (IllegalArgumentException e) {
                        if (timeout + System.currentTimeMillis() < 0L) {
                            this.queue(cid, tid, level, ServerLockContext.Type.PENDING, -1L, helper);
                            return;
                        }
                        throw e;
                    }
                    waitContext.setTimerTask(task);
                }
                this.addTryPending(waitContext, helper);
                break;
            }
            case PENDING: {
                ServerLockContext pendingContext = this.createPendingContext(cid, tid, level, helper);
                this.addPending(pendingContext, helper);
                break;
            }
            default: {
                throw new IllegalStateException("Only pending and try pending state should be passed = " + type);
            }
        }
    }

    protected void requestLock(ClientID cid, ThreadID tid, ServerLockLevel level, ServerLockContext.Type type, long timeout, LockHelper helper) {
        this.queue(cid, tid, level, type, timeout, helper);
        this.processPendingRequests(helper);
    }

    protected int validateAndGetNumberOfPending(ClientID cid, ThreadID tid, ServerLockLevel reqLevel) {
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        int noOfPendingRequests = 0;
        while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            switch (context.getState().getType()) {
                case GREEDY_HOLDER: 
                case HOLDER: {
                    if (this.isUpgradeRequest(cid, tid, reqLevel, context)) {
                        throw new TCLockUpgradeNotSupportedError("Lock upgrade is not supported." + context + " lock = " + this.lockID);
                    }
                    if (this.isAlreadyHeldBySameContext(cid, tid, reqLevel, context)) {
                        throw new AssertionError((Object)("Client requesting already held lock!" + context + " lock = " + this.lockID));
                    }
                    break;
                }
                case PENDING: 
                case TRY_PENDING: {
                    ++noOfPendingRequests;
                    break;
                }
                case WAITER: {
                    if (context.getClientID().equals((Object)cid) && context.getThreadID().equals((Object)tid)) {
                        throw new AssertionError((Object)("This thread is already in wait state for " + this.lockID));
                    }
                    break;
                }
            }
        }
        return noOfPendingRequests;
    }

    protected void clearContextsForClient(ClientID cid, LockHelper helper) {
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            ServerLockContext context = (ServerLockContext)iter.next();
            if (!context.getClientID().equals((Object)cid)) continue;
            iter.remove();
            switch (context.getState().getType()) {
                case WAITER: 
                case TRY_PENDING: {
                    WaitServerLockContext waitContext = (WaitServerLockContext)context;
                    if (waitContext.getTimerTask() == null) break;
                    waitContext.getTimerTask().cancel();
                    break;
                }
            }
        }
    }

    private boolean isUpgradeRequest(ClientID cid, ThreadID tid, ServerLockLevel reqLevel, ServerLockContext holder) {
        return reqLevel == ServerLockLevel.WRITE && this.isRead() && holder.getClientID().equals((Object)cid) && holder.getThreadID().equals((Object)tid);
    }

    protected ServerLockContext getNotifyHolder(ClientID cid, ThreadID tid) {
        return this.get(cid, tid);
    }

    private boolean isAlreadyHeldBySameContext(ClientID cid, ThreadID tid, ServerLockLevel reqLevel, ServerLockContext context) {
        return reqLevel == context.getState().getLockLevel() && context.getClientID().equals((Object)cid) && context.getThreadID().equals((Object)tid);
    }

    protected void moveWaiterToPending(ServerLockContext waiter, LockHelper helper) {
        this.cancelTryLockOrWaitTimer(waiter, helper);
        this.queue(waiter.getClientID(), waiter.getThreadID(), waiter.getState().getLockLevel(), ServerLockContext.Type.PENDING, -1L, helper);
    }

    protected abstract void processPendingRequests(LockHelper var1);

    protected void awardLock(LockHelper helper, ServerLockContext request) {
        this.awardLock(helper, request, true);
    }

    protected void awardLock(LockHelper helper, ServerLockContext request, boolean toRespond) {
        ServerLockContext.State state = null;
        ServerLockLevel lockLevel = request.getState().getLockLevel();
        switch (lockLevel) {
            case READ: {
                state = ServerLockContext.State.HOLDER_READ;
                break;
            }
            case WRITE: {
                state = ServerLockContext.State.HOLDER_WRITE;
                break;
            }
            default: {
                throw new AssertionError(lockLevel);
            }
        }
        this.awardLock(helper, request, state, toRespond);
    }

    protected void awardLock(LockHelper helper, ServerLockContext request, ServerLockContext.State state, boolean toRespond) {
        this.cancelTryLockOrWaitTimer(request, helper);
        request = this.changeStateToHolder(request, state, helper);
        this.addHolder(request, helper);
        if (toRespond) {
            LockResponseContext lrc = LockResponseContextFactory.createLockAwardResponseContext(this.lockID, (NodeID)request.getClientID(), request.getThreadID(), request.getState().getLockLevel());
            helper.getLockSink().addMultiThreaded((Object)lrc);
        }
    }

    protected void refuseTryRequestWithNoTimeout(ClientID cid, ThreadID tid, ServerLockLevel level, LockHelper helper) {
        this.cannotAward(cid, tid, level, helper);
    }

    protected void cannotAward(ClientID cid, ThreadID tid, ServerLockLevel requestedLockLevel, LockHelper helper) {
        LockResponseContext lrc = LockResponseContextFactory.createLockRejectedResponseContext(this.lockID, (NodeID)cid, tid, requestedLockLevel);
        helper.getLockSink().addMultiThreaded((Object)lrc);
    }

    protected void add(ServerLockContext request, LockHelper helper) {
        switch (request.getState().getType()) {
            case GREEDY_HOLDER: 
            case HOLDER: {
                this.addHolder(request, helper);
                break;
            }
            case WAITER: {
                this.addWaiter(request, helper);
                break;
            }
            case PENDING: {
                this.addPending(request, helper);
                break;
            }
            case TRY_PENDING: {
                this.addTryPending(request, helper);
                break;
            }
            default: {
                throw new AssertionError(request.getState().getType());
            }
        }
    }

    protected void addHolder(ServerLockContext request, LockHelper helper) {
        this.preStepsForAdd(helper);
        Assert.assertFalse((boolean)this.checkDuplicate(request));
        this.addFirst((SinglyLinkedList.LinkedNode)request);
    }

    protected void addTryPending(ServerLockContext request, LockHelper helper) {
        this.preStepsForAdd(helper);
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        block4: while (iter.hasNext()) {
            ServerLockContext.Type type = ((ServerLockContext)iter.next()).getState().getType();
            switch (type) {
                case GREEDY_HOLDER: 
                case HOLDER: 
                case PENDING: 
                case TRY_PENDING: {
                    continue block4;
                }
                case WAITER: {
                    iter.addPrevious((SinglyLinkedList.LinkedNode)request);
                    return;
                }
            }
            throw new AssertionError(type);
        }
        this.addLast((SinglyLinkedList.LinkedNode)request);
    }

    protected void addPending(ServerLockContext request, LockHelper helper) {
        this.preStepsForAdd(helper);
        if (this.checkDuplicate(request)) {
            logger.debug((Object)("Ignoring existing Request " + request + " in Lock " + this.lockID));
            return;
        }
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        block4: while (iter.hasNext()) {
            ServerLockContext.Type type = ((ServerLockContext)iter.next()).getState().getType();
            switch (type) {
                case GREEDY_HOLDER: 
                case HOLDER: 
                case PENDING: 
                case TRY_PENDING: {
                    continue block4;
                }
                case WAITER: {
                    iter.addPrevious((SinglyLinkedList.LinkedNode)request);
                    return;
                }
            }
            throw new AssertionError(type);
        }
        this.addLast((SinglyLinkedList.LinkedNode)request);
    }

    protected void addWaiter(ServerLockContext request, LockHelper helper) {
        this.preStepsForAdd(helper);
        if (this.checkDuplicate(request)) {
            logger.info((Object)("Ignoring adding of waiter for same context " + request));
            return;
        }
        this.addLast((SinglyLinkedList.LinkedNode)request);
    }

    protected void preStepsForAdd(LockHelper helper) {
        if (this.isEmpty() || !this.isEmpty() && (((ServerLockContext)this.getFirst()).getNext() != null || this.getFirst() instanceof LinkedServerLockContext)) {
            return;
        }
        SingleServerLockContext context = (SingleServerLockContext)this.removeFirst();
        LinkedServerLockContext newContext = null;
        ServerLockContext.Type type = context.getState().getType();
        switch (type) {
            case GREEDY_HOLDER: 
            case HOLDER: 
            case PENDING: {
                newContext = new LinkedServerLockContext(context.getClientID(), context.getThreadID());
                newContext.setState(helper.getContextStateMachine(), context.getState());
                break;
            }
            case WAITER: 
            case TRY_PENDING: {
                throw new AssertionError((Object)"waiters/try pending are all linked server contexts");
            }
            default: {
                throw new AssertionError(type);
            }
        }
        this.addFirst((SinglyLinkedList.LinkedNode)newContext);
    }

    protected boolean checkDuplicate(ClientID cid, ThreadID tid) {
        return this.checkDuplicate(new SingleServerLockContext(cid, tid));
    }

    protected boolean checkDuplicate(ServerLockContext context) {
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            ServerLockContext temp = (ServerLockContext)iter.next();
            if (!context.equals((Object)temp)) continue;
            return true;
        }
        return false;
    }

    protected boolean canAwardRequest(ServerLockLevel requestLevel) {
        switch (requestLevel) {
            case READ: {
                return !this.hasHolders() || this.isRead();
            }
            case WRITE: {
                return !this.hasHolders();
            }
        }
        throw new AssertionError(requestLevel);
    }

    protected ServerLockContext getNextRequestIfCanAward(LockHelper helper) {
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            ServerLockContext request = (ServerLockContext)iter.next();
            switch (request.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    if (this.canAwardRequest(request.getState().getLockLevel())) {
                        iter.remove();
                        return request;
                    }
                    return null;
                }
                case WAITER: {
                    return null;
                }
            }
        }
        return null;
    }

    protected void cancelTryLockOrWaitTimer(ServerLockContext request, LockHelper helper) {
        WaitServerLockContext waitRequest;
        if ((request.isTryPending() || request.isWaiter()) && (waitRequest = (WaitServerLockContext)request).getTimerTask() != null) {
            waitRequest.getTimerTask().cancel();
        }
    }

    protected ServerLockContext changeStateToHolder(ServerLockContext request, ServerLockContext.State state, LockHelper helper) {
        request = this.changeFromWaitContextIfRequired(request, helper);
        request.setState(helper.getContextStateMachine(), state);
        Assert.assertTrue((boolean)request.isHolder());
        return request;
    }

    private ServerLockContext changeFromWaitContextIfRequired(ServerLockContext request, LockHelper helper) {
        switch (request.getState().getType()) {
            case WAITER: 
            case TRY_PENDING: {
                request = this.createSingleOrLinkedServerLockContext(request.getClientID(), request.getThreadID(), request.getState(), helper);
                break;
            }
        }
        return request;
    }

    protected WaitServerLockContext createTryPendingServerLockContext(ClientID cid, ThreadID tid, ServerLockLevel level, long timeout, LockHelper helper) {
        ServerLockContext.State state = null;
        switch (level) {
            case READ: {
                state = ServerLockContext.State.TRY_PENDING_READ;
                break;
            }
            case WRITE: {
                state = ServerLockContext.State.TRY_PENDING_WRITE;
                break;
            }
            default: {
                throw new AssertionError(level);
            }
        }
        return this.createWaitOrTryPendingServerLockContext(cid, tid, state, timeout, helper);
    }

    protected ServerLockContext createPendingContext(ClientID cid, ThreadID tid, ServerLockLevel level, LockHelper helper) {
        ServerLockContext.State state = null;
        switch (level) {
            case READ: {
                state = ServerLockContext.State.PENDING_READ;
                break;
            }
            case WRITE: {
                state = ServerLockContext.State.PENDING_WRITE;
                break;
            }
            default: {
                throw new AssertionError(level);
            }
        }
        return this.createSingleOrLinkedServerLockContext(cid, tid, state, helper);
    }

    private ServerLockContext createSingleOrLinkedServerLockContext(ClientID cid, ThreadID tid, ServerLockContext.State state, LockHelper helper) {
        ServerLockContext context = null;
        context = this.isEmpty() ? new SingleServerLockContext(cid, tid) : new LinkedServerLockContext(cid, tid);
        context.setState(helper.getContextStateMachine(), state);
        return context;
    }

    protected WaitServerLockContext createWaitOrTryPendingServerLockContext(ClientID cid, ThreadID tid, ServerLockContext.State state, long timeout, LockHelper helper) {
        WaitServerLockContext context = new WaitServerLockContext(cid, tid, timeout);
        context.setState(helper.getContextStateMachine(), state);
        return context;
    }

    protected boolean hasHolders() {
        return !this.isEmpty() && ((ServerLockContext)this.getFirst()).isHolder();
    }

    protected boolean hasOnlyReadHolders() {
        return this.isRead();
    }

    protected boolean hasWaiters() {
        return !this.isEmpty() && ((ServerLockContext)this.getLast()).isWaiter();
    }

    protected boolean hasPendingRequests() {
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)singlyLinkedListIterator.next();
            switch (context.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    return true;
                }
                case WAITER: {
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean hasPendingWrites() {
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)singlyLinkedListIterator.next();
            switch (context.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    if (context.getState().getLockLevel() != ServerLockLevel.WRITE) break;
                    return true;
                }
                case WAITER: {
                    return false;
                }
            }
        }
        return false;
    }

    protected List<ServerLockContext> removeAllPendingReadRequests(LockHelper helper) {
        ArrayList<ServerLockContext> requests = new ArrayList<ServerLockContext>();
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            switch (context.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    if (context.getState().getLockLevel() != ServerLockLevel.READ) break;
                    iterator.remove();
                    requests.add(context);
                    break;
                }
                case WAITER: {
                    return requests;
                }
            }
        }
        return requests;
    }

    protected boolean hasPendingRequestsFromOtherClients(ClientID cid) {
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)singlyLinkedListIterator.next();
            switch (context.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    if (context.getClientID().equals((Object)cid)) break;
                    return true;
                }
                case WAITER: {
                    return false;
                }
            }
        }
        return false;
    }

    protected int getNoOfPendingRequests() {
        int count = 0;
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)singlyLinkedListIterator.next();
            switch (context.getState().getType()) {
                case PENDING: 
                case TRY_PENDING: {
                    ++count;
                    break;
                }
                case WAITER: {
                    return count;
                }
            }
        }
        return count;
    }

    protected ServerLockLevel holderLevel() {
        if (!this.hasHolders()) {
            return null;
        }
        ServerLockContext holder = (ServerLockContext)this.getFirst();
        return holder.getState().getLockLevel();
    }

    protected boolean isRead() {
        return this.holderLevel() == ServerLockLevel.READ;
    }

    protected boolean isWrite() {
        return this.holderLevel() == ServerLockLevel.WRITE;
    }

    protected ServerLockContext remove(ClientID cid, ThreadID tid, EnumSet<ServerLockContext.Type> set) {
        ServerLockContext temp = null;
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            temp = (ServerLockContext)iter.next();
            if (!temp.getClientID().equals((Object)cid) || !temp.getThreadID().equals((Object)tid) || !set.contains(temp.getState().getType())) continue;
            iter.remove();
            return temp;
        }
        return null;
    }

    protected ServerLockContext get(ClientID cid, ThreadID tid) {
        SinglyLinkedList.SinglyLinkedListIterator singlyLinkedListIterator = this.iterator();
        while (singlyLinkedListIterator.hasNext()) {
            ServerLockContext temp = (ServerLockContext)singlyLinkedListIterator.next();
            if (!temp.getClientID().equals((Object)cid) || !temp.getThreadID().equals((Object)tid)) continue;
            return temp;
        }
        return null;
    }

    private List<ServerLockContext> removeWaiters(ServerLock.NotifyAction action) {
        ArrayList<ServerLockContext> contexts = new ArrayList<ServerLockContext>();
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            switch (context.getState().getType()) {
                case WAITER: {
                    iterator.remove();
                    contexts.add(context);
                    if (action != ServerLock.NotifyAction.ONE) break;
                    return contexts;
                }
            }
        }
        return contexts;
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print((Object)"Lock Info").flush();
        out.print((Object)this.lockID).flush();
        out.print((Object)"Contexts [ ");
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            out.print((Object)((ServerLockContext)iter.next()).toString());
            if (!iter.hasNext()) continue;
            out.print((Object)" , ");
        }
        out.print((Object)" ]").flush();
        return out;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Lock Info");
        builder.append("\n");
        builder.append(this.lockID);
        builder.append("\n");
        builder.append("Contexts [ ");
        SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
        while (iter.hasNext()) {
            builder.append(((ServerLockContext)iter.next()).toString());
            if (!iter.hasNext()) continue;
            builder.append(" , ");
        }
        builder.append(" ]");
        return builder.toString();
    }
}

