/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.async.api.Sink;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.objectserver.locks.AbstractServerLock;
import com.tc.objectserver.locks.LockFactory;
import com.tc.objectserver.locks.LockHelper;
import com.tc.objectserver.locks.LockMBean;
import com.tc.objectserver.locks.LockManager;
import com.tc.objectserver.locks.LockManagerMBean;
import com.tc.objectserver.locks.LockResponseContext;
import com.tc.objectserver.locks.LockStore;
import com.tc.objectserver.locks.NotifiedWaiters;
import com.tc.objectserver.locks.ServerLock;
import com.tc.objectserver.locks.factory.ServerLockFactoryImpl;
import com.tc.objectserver.locks.timer.LockTimer;
import com.tc.objectserver.locks.timer.TimerCallback;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockManagerImpl
implements LockManager,
PrettyPrintable,
LockManagerMBean,
TimerCallback,
DSOChannelManagerEventListener {
    private final LockStore lockStore;
    private final DSOChannelManager channelManager;
    private final LockHelper lockHelper;
    private final ReentrantReadWriteLock statusLock = new ReentrantReadWriteLock();
    private boolean isStarted = false;
    private final LinkedBlockingQueue<RequestLockContext> lockRequestQueue = new LinkedBlockingQueue();
    private static final TCLogger logger = TCLogging.getLogger(LockManagerImpl.class);

    public LockManagerImpl(Sink lockSink, DSOChannelManager channelManager) {
        this(lockSink, channelManager, new ServerLockFactoryImpl());
    }

    public LockManagerImpl(Sink lockSink, DSOChannelManager channelManager, LockFactory factory) {
        this.lockStore = new LockStore(factory);
        this.channelManager = channelManager;
        this.lockHelper = new LockHelper((Sink<LockResponseContext>)lockSink, this.lockStore, this);
        channelManager.addEventListener((DSOChannelManagerEventListener)this);
    }

    public void channelCreated(MessageChannel channel) {
    }

    public void channelRemoved(MessageChannel channel, boolean wasActive) {
        this.clearAllLocksFor((ClientID)channel.getRemoteNodeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(LockID lid, ClientID cid, ThreadID tid, ServerLockLevel level) {
        if (!this.queueIfNecessary(lid, cid, tid, level, RequestType.LOCK)) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.lock(cid, tid, level, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryLock(LockID lid, ClientID cid, ThreadID tid, ServerLockLevel level, long timeout) {
        if (!this.queueIfNecessary(lid, cid, tid, level, RequestType.TRY_LOCK, timeout)) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.tryLock(cid, tid, level, timeout, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(LockID lid, ClientID cid, ThreadID tid) {
        if (!this.queueIfNecessary(lid, cid, tid, ServerLockLevel.WRITE, RequestType.UNLOCK)) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.unlock(cid, tid, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryLock(LockID lid, ClientID cid, ThreadID tid) {
        if (!this.isValidStateFor(lid, cid, tid, "QueryLock")) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.queryLock(cid, tid, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(LockID lid, ClientID cid, ThreadID tid) {
        if (!this.isValidStateFor(lid, cid, tid, "Interrupt")) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.interrupt(cid, tid, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recallCommit(LockID lid, ClientID cid, Collection<ClientServerExchangeLockContext> serverLockContexts) {
        if (!this.isStarted()) {
            logger.info((Object)("Ignoring recall commit messages from Client " + cid + " for Lock " + lid));
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.recallCommit(cid, serverLockContexts, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifiedWaiters notify(LockID lid, ClientID cid, ThreadID tid, ServerLock.NotifyAction action, NotifiedWaiters addNotifiedWaitersTo) {
        if (!this.isValidStateFor(lid, cid, tid, "Notify")) {
            return addNotifiedWaitersTo;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                NotifiedWaiters notifiedWaiters = addNotifiedWaitersTo;
                return notifiedWaiters;
            }
            NotifiedWaiters notifiedWaiters = lock.notify(cid, tid, action, addNotifiedWaitersTo, this.lockHelper);
            return notifiedWaiters;
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(LockID lid, ClientID cid, ThreadID tid, long timeout) {
        if (!this.queueIfNecessary(lid, cid, tid, ServerLockLevel.WRITE, RequestType.WAIT, timeout)) {
            return;
        }
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            if (!this.isClientAlive(cid)) {
                return;
            }
            lock.wait(cid, tid, timeout, this.lockHelper);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reestablishState(ClientID cid, Collection<ClientServerExchangeLockContext> serverLockContexts) {
        this.assertStateIsStarting("Reestablish was called after the LockManager was started.");
        block8: for (ClientServerExchangeLockContext cselc : serverLockContexts) {
            LockID lid = cselc.getLockID();
            ServerLockContext.Type type = cselc.getState().getType();
            switch (type) {
                case GREEDY_HOLDER: 
                case HOLDER: 
                case WAITER: {
                    ServerLock lock = this.lockStore.checkOut(lid);
                    try {
                        lock.reestablishState(cselc, this.lockHelper);
                        continue block8;
                    }
                    finally {
                        this.lockStore.checkIn(lock);
                        continue block8;
                    }
                }
                case PENDING: {
                    this.lock(lid, (ClientID)cselc.getNodeID(), cselc.getThreadID(), cselc.getState().getLockLevel());
                    break;
                }
                case TRY_PENDING: {
                    this.tryLock(lid, (ClientID)cselc.getNodeID(), cselc.getThreadID(), cselc.getState().getLockLevel(), cselc.timeout());
                    break;
                }
                default: {
                    throw new AssertionError(type);
                }
            }
        }
    }

    @Override
    public void clearAllLocksFor(ClientID cid) {
        LockStore.LockIterator iter = this.lockStore.iterator();
        ServerLock lock = iter.getNextLock(null);
        while (lock != null) {
            if (lock.clearStateForNode(cid, this.lockHelper)) {
                iter.remove();
            }
            lock = iter.getNextLock(lock);
        }
    }

    @Override
    public LockMBean[] getAllLocks() {
        ArrayList<LockMBean> beansList = new ArrayList<LockMBean>();
        LockStore.LockIterator iter = this.lockStore.iterator();
        ServerLock lock = iter.getNextLock(null);
        while (lock != null) {
            beansList.add(lock.getMBean(this.channelManager));
            lock = iter.getNextLock(lock);
        }
        return beansList.toArray(new LockMBean[beansList.size()]);
    }

    @Override
    public void start() {
        this.statusLock.writeLock().lock();
        try {
            Assert.assertTrue((!this.isStarted ? 1 : 0) != 0);
            this.isStarted = true;
            this.lockHelper.getLockTimer().start();
            this.processPendingRequests();
        }
        finally {
            this.statusLock.writeLock().unlock();
        }
    }

    private void processPendingRequests() {
        RequestLockContext ctxt = null;
        block6: while ((ctxt = this.lockRequestQueue.poll()) != null) {
            switch (ctxt.getType()) {
                case LOCK: {
                    this.lock(ctxt.getLockID(), ctxt.getClientID(), ctxt.getThreadID(), ctxt.getRequestedLockLevel());
                    continue block6;
                }
                case TRY_LOCK: {
                    this.tryLock(ctxt.getLockID(), ctxt.getClientID(), ctxt.getThreadID(), ctxt.getRequestedLockLevel(), ctxt.getTimeout());
                    continue block6;
                }
                case WAIT: {
                    this.wait(ctxt.getLockID(), ctxt.getClientID(), ctxt.getThreadID(), ctxt.getTimeout());
                    continue block6;
                }
                case UNLOCK: {
                    this.unlock(ctxt.getLockID(), ctxt.getClientID(), ctxt.getThreadID());
                    continue block6;
                }
            }
            throw new AssertionError((Object)ctxt.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerTimeout(LockTimer.LockTimerContext lockTimerContext) {
        LockID lid = lockTimerContext.getLockID();
        ServerLock lock = this.lockStore.checkOut(lid);
        try {
            lock.timerTimeout(lockTimerContext);
        }
        finally {
            this.lockStore.checkIn(lock);
        }
    }

    private void queueRequest(LockID lid, ClientID cid, ThreadID tid, ServerLockLevel level, RequestType type, long timeout) {
        RequestLockContext context = new RequestLockContext(lid, cid, tid, level, type, timeout);
        try {
            this.lockRequestQueue.put(context);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean queueIfNecessary(LockID lid, ClientID cid, ThreadID tid, ServerLockLevel level, RequestType type) {
        return this.queueIfNecessary(lid, cid, tid, level, type, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueIfNecessary(LockID lid, ClientID cid, ThreadID tid, ServerLockLevel level, RequestType type, long timeout) {
        this.statusLock.readLock().lock();
        try {
            if (!this.isStarted) {
                this.queueRequest(lid, cid, tid, level, type, timeout);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    private boolean isClientAlive(ClientID cid) {
        if (!this.channelManager.isActiveID((NodeID)cid)) {
            logger.warn((Object)("Lock Manager ignoring message received from dead client:" + cid));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidStateFor(LockID lid, ClientID cid, ThreadID tid, String callType) {
        this.statusLock.readLock().lock();
        try {
            if (!this.isStarted) {
                throw new AssertionError((Object)(callType + " message received when lock manager was starting Message Context: [LockID=" + lid + ", NodeID=" + cid + ", ThreadID=" + tid + "]"));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    private boolean isStarted() {
        this.statusLock.readLock().lock();
        try {
            boolean bl = this.isStarted;
            return bl;
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print((Object)this.getClass().getName()).flush();
        int size = 0;
        LockStore.LockIterator iter = this.lockStore.iterator();
        ServerLock lock = iter.getNextLock(null);
        while (lock != null) {
            out.visit((Object)lock);
            ++size;
            lock = iter.getNextLock(lock);
        }
        out.indent().print((Object)("locks: " + size)).println().flush();
        return out;
    }

    private void assertStateIsStarting(String errMessage) {
        this.statusLock.readLock().lock();
        try {
            Assert.assertTrue((Object)errMessage, (!this.isStarted ? 1 : 0) != 0);
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    public int getLockCount() {
        int size = 0;
        ServerLock oldLock = null;
        LockStore.LockIterator iter = this.lockStore.iterator();
        ServerLock lock = iter.getNextLock(oldLock);
        while (lock != null) {
            oldLock = lock;
            ++size;
            lock = iter.getNextLock(oldLock);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending(LockID lid) {
        AbstractServerLock lock = (AbstractServerLock)this.lockStore.checkOut(lid);
        boolean result = false;
        try {
            result = lock.hasPendingRequests();
        }
        finally {
            this.lockStore.checkIn(lock);
        }
        return result;
    }

    public LockHelper getHelper() {
        return this.lockHelper;
    }

    private static class RequestLockContext {
        private final LockID lockID;
        private final ClientID nodeID;
        private final ThreadID threadID;
        private final ServerLockLevel requestedLockLevel;
        private final RequestType type;
        private final long timeout;

        public RequestLockContext(LockID lockID, ClientID nodeID, ThreadID threadID, ServerLockLevel requestedLockLevel, RequestType type, long timeout) {
            this.lockID = lockID;
            this.nodeID = nodeID;
            this.threadID = threadID;
            this.requestedLockLevel = requestedLockLevel;
            this.type = type;
            this.timeout = timeout;
        }

        public LockID getLockID() {
            return this.lockID;
        }

        public ClientID getClientID() {
            return this.nodeID;
        }

        public ThreadID getThreadID() {
            return this.threadID;
        }

        public ServerLockLevel getRequestedLockLevel() {
            return this.requestedLockLevel;
        }

        public RequestType getType() {
            return this.type;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return "RequestLockContext [ " + this.lockID + "," + this.nodeID + "," + this.threadID + "," + this.requestedLockLevel + ", " + (Object)((Object)this.type) + ", " + this.timeout + " ]";
        }
    }

    private static enum RequestType {
        LOCK,
        TRY_LOCK,
        WAIT,
        UNLOCK;

    }
}

