/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.async.api.MultiThreadedEventContext;
import com.tc.net.NodeID;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.util.Assert;
import java.util.Collection;

public class LockResponseContext
implements MultiThreadedEventContext {
    private static final int LOCK_NO_LEASE = 0;
    public static final int LOCK_AWARD = 1;
    public static final int LOCK_RECALL = 2;
    public static final int LOCK_WAIT_TIMEOUT = 3;
    public static final int LOCK_INFO = 4;
    public static final int LOCK_NOT_AWARDED = 5;
    private final LockID lockID;
    private final ThreadID threadID;
    private final ServerLockLevel level;
    private final NodeID nodeID;
    private final int responseType;
    private final Collection<ClientServerExchangeLockContext> contexts;
    private final int noOfPendingRequests;
    private int leaseTimeInMs = 0;

    public LockResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level, Collection<ClientServerExchangeLockContext> contexts, int numberOfPending, int type) {
        this(lockID, nodeID, threadID, level, contexts, numberOfPending, type, 0);
    }

    public LockResponseContext(LockID lockID, NodeID nodeID, ThreadID sourceID, ServerLockLevel level, int type) {
        this(lockID, nodeID, sourceID, level, null, 0, type, 0);
    }

    public LockResponseContext(LockID lockID, NodeID nodeID, ThreadID sourceID, ServerLockLevel level, int type, int leaseTimeInMs) {
        this(lockID, nodeID, sourceID, level, null, 0, type, leaseTimeInMs);
    }

    public LockResponseContext(LockID lockID, NodeID nodeID, ThreadID sourceID, ServerLockLevel level, int type, int traceDepth, int gatherInterval) {
        this(lockID, nodeID, sourceID, level, null, 0, type, 0);
    }

    private LockResponseContext(LockID lockID, NodeID nodeID, ThreadID sourceID, ServerLockLevel level, Collection<ClientServerExchangeLockContext> contexts, int noOfPendingRequests, int type, int leaseTimeInMs) {
        this.lockID = lockID;
        this.nodeID = nodeID;
        this.threadID = sourceID;
        this.level = level;
        this.responseType = type;
        this.contexts = contexts;
        this.noOfPendingRequests = noOfPendingRequests;
        this.leaseTimeInMs = leaseTimeInMs;
        Assert.assertTrue((this.responseType == 1 || this.responseType == 2 || this.responseType == 3 || this.responseType == 4 || this.responseType == 5 ? 1 : 0) != 0);
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    public ThreadID getThreadID() {
        return this.threadID;
    }

    public ServerLockLevel getLockLevel() {
        return this.level;
    }

    public Collection<ClientServerExchangeLockContext> getGlobalLockInfo() {
        return this.contexts;
    }

    public int getNumberOfPendingRequests() {
        return this.noOfPendingRequests;
    }

    public boolean isLockAward() {
        return this.responseType == 1;
    }

    public boolean isLockRecall() {
        return this.responseType == 2;
    }

    public boolean isLockWaitTimeout() {
        return this.responseType == 3;
    }

    public boolean isLockInfo() {
        return this.responseType == 4;
    }

    public boolean isLockNotAwarded() {
        return this.responseType == 5;
    }

    public int getAwardLeaseTime() {
        return this.leaseTimeInMs;
    }

    public String toString() {
        return "LockResponseContext(" + this.lockID + "," + this.nodeID + "," + this.threadID + ", " + this.level + " , " + LockResponseContext.toString(this.responseType) + ")";
    }

    private static String toString(int responseType2) {
        switch (responseType2) {
            case 1: {
                return "LOCK_AWARD";
            }
            case 2: {
                return "LOCK_RECALL";
            }
            case 3: {
                return "LOCK_WAIT_TIMEOUT";
            }
            case 4: {
                return "LOCK_INFO";
            }
            case 5: {
                return "LOCK_NOT_AWARDED";
            }
        }
        return "UNKNOWN";
    }

    public Object getSchedulingKey() {
        return this.nodeID;
    }

    public boolean flush() {
        return true;
    }
}

