/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.net.NodeID;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.objectserver.locks.LockResponseContext;
import com.tc.properties.TCPropertiesImpl;
import java.util.Collection;

public class LockResponseContextFactory {
    private static final int LOCK_LEASE_TIME = TCPropertiesImpl.getProperties().getInt("l2.lockmanager.greedy.lease.leaseTimeInMillis");
    private static final boolean LOCK_LEASE_ENABLE = TCPropertiesImpl.getProperties().getBoolean("l2.lockmanager.greedy.lease.enabled");

    public static LockResponseContext createLockRejectedResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level) {
        return new LockResponseContext(lockID, nodeID, threadID, level, 5);
    }

    public static LockResponseContext createLockAwardResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level) {
        LockResponseContext lrc = new LockResponseContext(lockID, nodeID, threadID, level, 1);
        return lrc;
    }

    public static LockResponseContext createLockRecallResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level) {
        if (LOCK_LEASE_ENABLE) {
            return new LockResponseContext(lockID, nodeID, threadID, level, 2, LOCK_LEASE_TIME);
        }
        return new LockResponseContext(lockID, nodeID, threadID, level, 2);
    }

    public static LockResponseContext createLockWaitTimeoutResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level) {
        return new LockResponseContext(lockID, nodeID, threadID, level, 3);
    }

    public static LockResponseContext createLockQueriedResponseContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockLevel level, Collection<ClientServerExchangeLockContext> contexts, int numberOfPendingRequests) {
        return new LockResponseContext(lockID, nodeID, threadID, level, contexts, numberOfPendingRequests, 4);
    }
}

