/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.object.locks.LockID;
import com.tc.objectserver.locks.LockFactory;
import com.tc.objectserver.locks.ServerLock;
import com.tc.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class LockStore {
    private static final int DEFAULT_SEGMENTS = 32;
    private final Map<LockID, ServerLock>[] segments;
    private final ReentrantLock[] guards;
    private final int segmentShift;
    private final int segmentMask;
    private final LockFactory lockFactory;

    public LockStore(LockFactory factory) {
        this(32, factory);
    }

    public LockStore(int numberOfSegments, LockFactory factory) {
        int ssize;
        if (numberOfSegments <= 0) {
            throw new IllegalArgumentException();
        }
        this.lockFactory = factory;
        int sshift = 0;
        for (ssize = 1; ssize < numberOfSegments; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        numberOfSegments = ssize;
        this.segments = LockStore.initSegments(numberOfSegments);
        this.guards = new ReentrantLock[numberOfSegments];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new HashMap<LockID, ServerLock>();
            this.guards[i] = new ReentrantLock();
        }
    }

    private static Map<LockID, ServerLock>[] initSegments(int numberOfSegments) {
        return new Map[numberOfSegments];
    }

    public ServerLock checkOut(LockID lockID) {
        int index = this.indexFor(lockID);
        this.guards[index].lock();
        ServerLock lock = this.segments[index].get(lockID);
        if (lock == null) {
            lock = this.lockFactory.createLock(lockID);
            this.segments[index].put(lockID, lock);
        }
        return lock;
    }

    public ServerLock remove(LockID lockID) {
        int index = this.indexFor(lockID);
        Assert.assertTrue((boolean)this.guards[index].isHeldByCurrentThread());
        ServerLock lock = this.segments[index].remove(lockID);
        return lock;
    }

    public void checkIn(ServerLock lock) {
        LockID lockID = lock.getLockID();
        int index = this.indexFor(lockID);
        if (!this.guards[index].isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Server Lock " + lock + " was not checked out by the same thread"));
        }
        this.guards[index].unlock();
    }

    private final int indexFor(Object o) {
        int hash = LockStore.hash(o);
        return hash >>> this.segmentShift & this.segmentMask;
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public void clear() {
        for (int i = 0; i < this.guards.length; ++i) {
            this.guards[i].lock();
            try {
                this.segments[i].clear();
                continue;
            }
            finally {
                this.guards[i].unlock();
            }
        }
    }

    public LockIterator iterator() {
        return new LockIterator();
    }

    public class LockIterator {
        private Iterator<Map.Entry<LockID, ServerLock>> currentIter;
        private int currentIndex = -1;
        private ServerLock oldLock;

        public ServerLock getNextLock(ServerLock lock) {
            this.validateOldLock(lock);
            while (this.currentIter == null || !this.currentIter.hasNext()) {
                Map<LockID, ServerLock> nextSegment = this.fetchNextSegment();
                if (nextSegment == null) {
                    return null;
                }
                this.currentIter = nextSegment.entrySet().iterator();
            }
            Assert.assertNotNull(this.currentIter);
            this.oldLock = this.currentIter.next().getValue();
            return this.oldLock;
        }

        public void remove() {
            Assert.assertNotNull(this.currentIter);
            this.currentIter.remove();
        }

        public void checkIn(ServerLock lock) {
            Assert.assertEquals((Object)this.oldLock, (Object)lock);
            LockStore.this.checkIn(lock);
        }

        private void validateOldLock(ServerLock lock) {
            if (this.oldLock != null) {
                Assert.assertSame((Object)this.oldLock, (Object)lock);
            } else {
                Assert.assertNull((Object)lock);
            }
        }

        private Map<LockID, ServerLock> fetchNextSegment() {
            if (this.currentIndex >= 0 && this.currentIndex < LockStore.this.segments.length) {
                LockStore.this.guards[this.currentIndex].unlock();
            }
            ++this.currentIndex;
            if (this.currentIndex >= LockStore.this.segments.length) {
                return null;
            }
            LockStore.this.guards[this.currentIndex].lock();
            return LockStore.this.segments[this.currentIndex];
        }
    }
}

