/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.objectserver.locks.AbstractServerLock;
import com.tc.objectserver.locks.LockHelper;
import java.util.List;

public final class NonGreedyServerLock
extends AbstractServerLock {
    public NonGreedyServerLock(LockID lockID) {
        super(lockID);
    }

    @Override
    protected void processPendingRequests(LockHelper helper) {
        ServerLockContext request = this.getNextRequestIfCanAward(helper);
        if (request == null) {
            return;
        }
        ServerLockLevel lockLevel = request.getState().getLockLevel();
        switch (lockLevel) {
            case READ: {
                this.add(request, helper);
                this.awardAllReads(helper, request);
                break;
            }
            case WRITE: {
                this.awardLock(helper, request);
                break;
            }
            default: {
                throw new AssertionError(lockLevel);
            }
        }
    }

    private void awardAllReads(LockHelper helper, ServerLockContext request) {
        List<ServerLockContext> contexts = this.removeAllPendingReadRequests(helper);
        for (ServerLockContext context : contexts) {
            this.awardLock(helper, context);
        }
    }
}

