/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks;

import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.objectserver.locks.AbstractServerLock;
import com.tc.objectserver.locks.LockHelper;
import com.tc.objectserver.locks.LockResponseContext;
import com.tc.objectserver.locks.LockResponseContextFactory;
import com.tc.objectserver.locks.context.LinkedServerLockContext;
import com.tc.objectserver.locks.context.SingleServerLockContext;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.SinglyLinkedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public final class ServerLockImpl
extends AbstractServerLock {
    private static final EnumSet<ServerLockContext.Type> SET_OF_GREEDY_HOLDERS = EnumSet.of(ServerLockContext.Type.GREEDY_HOLDER);
    private boolean isRecalled = false;

    public ServerLockImpl(LockID lockID) {
        super(lockID);
    }

    @Override
    protected void requestLock(ClientID cid, ThreadID tid, ServerLockLevel level, ServerLockContext.Type type, long timeout, LockHelper helper) {
        ServerLockContext greedyHold = this.getGreedyHolder(cid);
        if (!ServerLockImpl.canAwardGreedilyOnTheClient(level, greedyHold)) {
            if (this.isRecalled && type.equals((Object)ServerLockContext.Type.TRY_PENDING) && timeout <= 0L) {
                this.cannotAward(cid, tid, level, helper);
            } else {
                super.requestLock(cid, tid, level, type, timeout, helper);
            }
        }
    }

    @Override
    protected void queue(ClientID cid, ThreadID tid, ServerLockLevel level, ServerLockContext.Type type, long timeout, LockHelper helper) {
        if (!this.canAwardRequest(level) && this.hasGreedyHolders()) {
            this.recall(level, helper);
        }
        super.queue(cid, tid, level, type, timeout, helper);
    }

    @Override
    public boolean clearStateForNode(ClientID cid, LockHelper helper) {
        this.clearContextsForClient(cid, helper);
        if (!this.hasGreedyHolders()) {
            this.isRecalled = false;
        }
        this.processPendingRequests(helper);
        return this.isEmpty();
    }

    @Override
    protected void reestablishLock(ClientServerExchangeLockContext cselc, LockHelper helper) {
        if (cselc.getThreadID().equals((Object)ThreadID.VM_ID)) {
            this.awardLockGreedily(helper, this.createPendingContext((ClientID)cselc.getNodeID(), cselc.getThreadID(), cselc.getState().getLockLevel(), helper), false);
        } else {
            super.reestablishLock(cselc, helper);
        }
    }

    @Override
    protected void processPendingRequests(LockHelper helper) {
        if (this.isRecalled) {
            return;
        }
        ServerLockContext request = this.getNextRequestIfCanAward(helper);
        if (request == null) {
            return;
        }
        ServerLockLevel lockLevel = request.getState().getLockLevel();
        switch (lockLevel) {
            case READ: {
                this.add(request, helper);
                this.awardAllReadsGreedily(helper, request);
                break;
            }
            case WRITE: {
                if (this.hasWaiters()) {
                    this.awardLock(helper, request);
                    break;
                }
                this.awardLockGreedily(helper, request);
                if (!this.hasPendingRequestsFromOtherClients(request.getClientID())) break;
                if (this.hasPendingWrites()) {
                    this.recall(ServerLockLevel.WRITE, helper);
                    break;
                }
                this.recall(ServerLockLevel.READ, helper);
                break;
            }
            default: {
                throw new AssertionError(lockLevel);
            }
        }
    }

    @Override
    protected void addHolder(ServerLockContext request, LockHelper helper) {
        this.preStepsForAdd(helper);
        Assert.assertFalse((boolean)this.checkDuplicate(request));
        switch (request.getState().getType()) {
            case GREEDY_HOLDER: {
                this.addFirst((SinglyLinkedList.LinkedNode)request);
                return;
            }
            case HOLDER: {
                SinglyLinkedList.SinglyLinkedListIterator iter = this.iterator();
                block7: while (iter.hasNext()) {
                    switch (((ServerLockContext)iter.next()).getState().getType()) {
                        case GREEDY_HOLDER: {
                            continue block7;
                        }
                    }
                    iter.addPrevious((SinglyLinkedList.LinkedNode)request);
                    return;
                }
                this.addLast((SinglyLinkedList.LinkedNode)request);
                break;
            }
            default: {
                throw new IllegalStateException("Only holders context should be passed " + request.getState());
            }
        }
    }

    private void awardAllReadsGreedily(LockHelper helper, ServerLockContext request) {
        ArrayList<ServerLockContext> contexts = new ArrayList<ServerLockContext>();
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        boolean hasPendingWrite = false;
        block4: while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            if (!context.isPending()) continue;
            ServerLockLevel lockLevel = context.getState().getLockLevel();
            switch (lockLevel) {
                case READ: {
                    iterator.remove();
                    contexts.add(context);
                    continue block4;
                }
                case WRITE: {
                    hasPendingWrite = true;
                    continue block4;
                }
            }
            throw new AssertionError(lockLevel);
        }
        ArrayList<ClientID> listOfClients = new ArrayList<ClientID>();
        for (ServerLockContext context : contexts) {
            if (listOfClients.contains(context.getClientID())) continue;
            this.awardLockGreedily(helper, context);
            listOfClients.add(context.getClientID());
        }
        if (hasPendingWrite) {
            this.recall(ServerLockLevel.WRITE, helper);
        }
    }

    private static boolean canAwardGreedilyOnTheClient(ServerLockLevel level, ServerLockContext holder) {
        return holder != null && (holder.getState().getLockLevel() == ServerLockLevel.WRITE || level == ServerLockLevel.READ);
    }

    @Override
    public void recallCommit(ClientID cid, Collection<ClientServerExchangeLockContext> serverLockContexts, LockHelper helper) {
        ServerLockContext greedyHolder = this.remove(cid, ThreadID.VM_ID, SET_OF_GREEDY_HOLDERS);
        if (greedyHolder == null) {
            throw new AssertionError((Object)("No Greedy Holder Exists For " + cid + " on " + this.lockID + " Lock State: " + this.toString()));
        }
        boolean hasGreedyReadHolder = false;
        block7: for (ClientServerExchangeLockContext cselc : serverLockContexts) {
            ServerLockContext.Type type = cselc.getState().getType();
            switch (type) {
                case GREEDY_HOLDER: {
                    Assert.assertEquals((Object)ServerLockContext.State.GREEDY_HOLDER_READ, (Object)cselc.getState());
                    hasGreedyReadHolder = true;
                    LinkedServerLockContext request = new LinkedServerLockContext(cid, ThreadID.VM_ID);
                    request.setState(helper.getContextStateMachine(), ServerLockContext.State.PENDING_READ);
                    this.awardLockGreedily(helper, request, false);
                    this.processPendingRequests(helper);
                    continue block7;
                }
                case HOLDER: {
                    Assert.assertFalse((boolean)hasGreedyReadHolder);
                    this.awardLock(helper, this.createPendingContext(cid, cselc.getThreadID(), cselc.getState().getLockLevel(), helper), false);
                    continue block7;
                }
                case PENDING: {
                    Assert.assertFalse((boolean)hasGreedyReadHolder);
                    this.queue(cid, cselc.getThreadID(), cselc.getState().getLockLevel(), ServerLockContext.Type.PENDING, -1L, helper);
                    continue block7;
                }
                case TRY_PENDING: {
                    if (this.checkDuplicate(new SingleServerLockContext(cid, cselc.getThreadID()))) continue block7;
                    Assert.assertFalse((boolean)hasGreedyReadHolder);
                    if (cselc.timeout() <= 0L) {
                        this.cannotAward(cid, cselc.getThreadID(), cselc.getState().getLockLevel(), helper);
                        continue block7;
                    }
                    this.queue(cid, cselc.getThreadID(), cselc.getState().getLockLevel(), ServerLockContext.Type.TRY_PENDING, cselc.timeout(), helper);
                    continue block7;
                }
                case WAITER: {
                    ServerLockContext context = this.get((ClientID)cselc.getNodeID(), cselc.getThreadID());
                    if (context != null) {
                        Assert.assertTrue((context.isWaiter() || context.isPending() ? 1 : 0) != 0);
                        continue block7;
                    }
                    ServerLockContext waiter = this.createWaiterAndScheduleTask(cselc, helper);
                    this.addWaiter(waiter, helper);
                    continue block7;
                }
            }
            throw new AssertionError(type);
        }
        if (this.hasGreedyHolders() && !this.isRecalled && this.hasPendingRequests()) {
            if (this.hasPendingWrites()) {
                this.recall(ServerLockLevel.WRITE, helper);
            } else {
                this.recall(ServerLockLevel.READ, helper);
            }
        }
        if (this.clearLockIfRequired(helper)) {
            return;
        }
        this.processPendingRequests(helper);
    }

    private void recall(ServerLockLevel level, LockHelper helper) {
        if (this.isRecalled) {
            return;
        }
        List<ServerLockContext> greedyHolders = this.getGreedyHolders();
        for (ServerLockContext greedyHolder : greedyHolders) {
            LockResponseContext lrc = LockResponseContextFactory.createLockRecallResponseContext(this.lockID, (NodeID)greedyHolder.getClientID(), greedyHolder.getThreadID(), level);
            helper.getLockSink().addMultiThreaded((Object)lrc);
            this.isRecalled = true;
        }
    }

    private void awardLockGreedily(LockHelper helper, ServerLockContext request) {
        this.awardLockGreedily(helper, request, true);
    }

    private void awardLockGreedily(LockHelper helper, ServerLockContext request, boolean toRespond) {
        ServerLockContext.State state = null;
        ServerLockLevel lockLevel = request.getState().getLockLevel();
        switch (lockLevel) {
            case READ: {
                state = ServerLockContext.State.GREEDY_HOLDER_READ;
                break;
            }
            case WRITE: {
                state = ServerLockContext.State.GREEDY_HOLDER_WRITE;
                break;
            }
            default: {
                throw new AssertionError(lockLevel);
            }
        }
        this.removeNonGreedyHoldersAndPendingOfSameClient(request, helper);
        this.awardLock(helper, request, state, toRespond);
    }

    @Override
    protected void refuseTryRequestWithNoTimeout(ClientID cid, ThreadID tid, ServerLockLevel level, LockHelper helper) {
        ServerLockContext holder = this.getGreedyHolder(cid);
        if (this.hasGreedyHolders() && holder == null) {
            this.recall(level, helper);
        }
        if (!ServerLockImpl.canAwardGreedilyOnTheClient(level, holder)) {
            this.cannotAward(cid, tid, level, helper);
        }
    }

    @Override
    protected ServerLockContext getNotifyHolder(ClientID cid, ThreadID tid) {
        ServerLockContext context = this.get(cid, tid);
        if (context == null) {
            context = this.get(cid, ThreadID.VM_ID);
        }
        return context;
    }

    @Override
    protected ServerLockContext remove(ClientID cid, ThreadID tid, EnumSet<ServerLockContext.Type> set) {
        ServerLockContext temp = super.remove(cid, tid, set);
        if (!this.hasGreedyHolders()) {
            this.isRecalled = false;
        }
        return temp;
    }

    @Override
    protected ServerLockContext changeStateToHolder(ServerLockContext request, ServerLockContext.State state, LockHelper helper) {
        if ((request = super.changeStateToHolder(request, state, helper)).getState().getType() == ServerLockContext.Type.GREEDY_HOLDER) {
            request.setThreadID(ThreadID.VM_ID);
        }
        return request;
    }

    private boolean hasGreedyHolders() {
        return !this.isEmpty() && ((ServerLockContext)this.getFirst()).isGreedyHolder();
    }

    private List<ServerLockContext> getGreedyHolders() {
        ArrayList<ServerLockContext> contexts = new ArrayList<ServerLockContext>();
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        block3: while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            switch (context.getState().getType()) {
                case GREEDY_HOLDER: {
                    contexts.add(context);
                    continue block3;
                }
            }
            return contexts;
        }
        return contexts;
    }

    private ServerLockContext getGreedyHolder(ClientID cid) {
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        block3: while (iterator.hasNext()) {
            ServerLockContext context = (ServerLockContext)iterator.next();
            switch (context.getState().getType()) {
                case GREEDY_HOLDER: {
                    if (!context.getClientID().equals((Object)cid)) continue block3;
                    return context;
                }
            }
            return null;
        }
        return null;
    }

    private void removeNonGreedyHoldersAndPendingOfSameClient(ServerLockContext context, LockHelper helper) {
        ClientID cid = context.getClientID();
        SinglyLinkedList.SinglyLinkedListIterator iterator = this.iterator();
        block6: while (iterator.hasNext()) {
            ServerLockContext next = (ServerLockContext)iterator.next();
            ServerLockContext.Type type = next.getState().getType();
            switch (type) {
                case GREEDY_HOLDER: {
                    continue block6;
                }
                case TRY_PENDING: {
                    if (!cid.equals((Object)next.getClientID())) continue block6;
                    this.cancelTryLockOrWaitTimer(next, helper);
                    iterator.remove();
                    continue block6;
                }
                case HOLDER: 
                case PENDING: {
                    if (!cid.equals((Object)next.getClientID())) continue block6;
                    iterator.remove();
                    continue block6;
                }
                case WAITER: {
                    return;
                }
            }
            throw new AssertionError(type);
        }
    }

    @Override
    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out = super.prettyPrint(out);
        out.print((Object)("isRecalled=" + this.isRecalled)).flush();
        return out;
    }

    @Override
    public String toString() {
        String rv = super.toString();
        rv = rv + "\nisRecalled=" + this.isRecalled;
        return rv;
    }
}

