/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.locks.timer;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ThreadID;
import com.tc.objectserver.locks.LockHelper;
import com.tc.objectserver.locks.timer.TimerCallback;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class LockTimer {
    private static final TCLogger logger = TCLogging.getLogger(LockTimer.class);
    private final Timer timer = new Timer("DSO Lock Object.wait() timer", true);
    private boolean started = false;
    private boolean shutdown = false;
    private LinkedList<TaskImpl> taskQueue = new LinkedList();

    public Timer getTimer() {
        return this.timer;
    }

    public synchronized void start() {
        this.started = true;
        this.scheduleQueuedTasks();
        this.taskQueue = null;
    }

    private void scheduleQueuedTasks() {
        for (TaskImpl task : this.taskQueue) {
            long timeDelay = task.getScheduleDelay() - (System.currentTimeMillis() - task.scheduledAt());
            timeDelay = timeDelay < 0L ? 0L : timeDelay;
            this.timer.schedule((TimerTask)task, timeDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerTask scheduleTimer(TimerCallback callback, long timeInMillis, LockTimerContext callbackObject) {
        TaskImpl rv = new TaskImpl(callback, timeInMillis, callbackObject);
        LockTimer lockTimer = this;
        synchronized (lockTimer) {
            if (!this.started) {
                this.taskQueue.addLast(rv);
                return rv;
            }
        }
        this.timer.schedule((TimerTask)rv, timeInMillis);
        return rv;
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.timer.cancel();
    }

    public static class LockTimerContext {
        private final LockID lockID;
        private final ThreadID tid;
        private final ClientID cid;
        private final LockHelper helper;

        public LockTimerContext(LockID lockID, ThreadID tid, ClientID cid, LockHelper helper) {
            this.lockID = lockID;
            this.tid = tid;
            this.cid = cid;
            this.helper = helper;
        }

        public LockID getLockID() {
            return this.lockID;
        }

        public ThreadID getThreadID() {
            return this.tid;
        }

        public ClientID getClientID() {
            return this.cid;
        }

        public LockHelper getHelper() {
            return this.helper;
        }
    }

    private static class TaskImpl
    extends TimerTask {
        private final TimerCallback callback;
        private final LockTimerContext callbackObject;
        private final long scheduleDelayInMillis;
        private final long scheduledAt;

        TaskImpl(TimerCallback callback, long timeInMillis, LockTimerContext callbackObject) {
            this.callback = callback;
            this.callbackObject = callbackObject;
            this.scheduleDelayInMillis = timeInMillis;
            this.scheduledAt = System.currentTimeMillis();
        }

        public long getScheduleDelay() {
            return this.scheduleDelayInMillis;
        }

        public long scheduledAt() {
            return this.scheduledAt;
        }

        @Override
        public void run() {
            try {
                this.callback.timerTimeout(this.callbackObject);
            }
            catch (Exception e) {
                logger.error((Object)("Error processing wait timeout for " + this.callbackObject), (Throwable)e);
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }
}

