/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.object.EntityID;
import com.tc.objectserver.persistence.EntityData;
import com.tc.util.Assert;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.terracotta.exception.EntityException;
import org.terracotta.persistence.IPlatformPersistence;

public class EntityPersistor {
    private static final TCLogger LOGGER = TCLogging.getLogger(EntityPersistor.class);
    private static final String ENTITIES_ALIVE_FILE_NAME = "entities_alive.map";
    private static final String JOURNAL_CONTAINER_FILE_NAME = "journal_container.map";
    private static final String COUNTERS_FILE_NAME = "counters.map";
    private static final String COUNTERS_CONSUMER_ID = "counters:consumerID";
    private final IPlatformPersistence storageManager;
    private final HashMap<EntityData.Key, EntityData.Value> entities;
    private final HashMap<ClientID, List<EntityData.JournalEntry>> entityLifeJournal;
    private final HashMap<String, Long> counters;

    public EntityPersistor(IPlatformPersistence storageManager) {
        this.storageManager = storageManager;
        try {
            HashMap entities = (HashMap)this.storageManager.loadDataElement(ENTITIES_ALIVE_FILE_NAME);
            this.entities = null != entities ? entities : new HashMap();
            HashMap entityLifeJournal = (HashMap)this.storageManager.loadDataElement(JOURNAL_CONTAINER_FILE_NAME);
            this.entityLifeJournal = null != entityLifeJournal ? entityLifeJournal : new HashMap();
            HashMap counters = (HashMap)this.storageManager.loadDataElement(COUNTERS_FILE_NAME);
            HashMap hashMap = this.counters = null != counters ? counters : new HashMap();
            if (!this.counters.containsKey(COUNTERS_CONSUMER_ID)) {
                this.counters.put(COUNTERS_CONSUMER_ID, new Long(1L));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading EntityPersistor map files", e);
        }
    }

    public synchronized void clear() {
        this.entities.clear();
        this.entityLifeJournal.clear();
        this.counters.clear();
        if (!this.counters.containsKey(COUNTERS_CONSUMER_ID)) {
            this.counters.put(COUNTERS_CONSUMER_ID, new Long(1L));
        }
        try {
            this.storageManager.storeDataElement(ENTITIES_ALIVE_FILE_NAME, null);
            this.storageManager.storeDataElement(JOURNAL_CONTAINER_FILE_NAME, null);
            this.storageManager.storeDataElement(COUNTERS_FILE_NAME, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing EntityPersistor map files", e);
        }
    }

    public Collection<EntityData.Value> loadEntityData() {
        return this.entities.values();
    }

    public boolean containsEntity(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id) {
        LOGGER.debug((Object)("containsEntity " + clientID + " " + transactionID + " " + id));
        EntityData.Key key = new EntityData.Key();
        key.className = id.getClassName();
        key.entityName = id.getEntityName();
        Assert.assertNotNull((Object)key.className);
        Assert.assertNotNull((Object)key.entityName);
        return this.entities.containsKey(key);
    }

    public boolean wasEntityCreatedInJournal(ClientID clientID, long transactionID) throws EntityException {
        boolean didSucceed = false;
        LOGGER.debug((Object)("wasEntityCreatedInJournal " + clientID + " " + transactionID));
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                didSucceed = true;
            } else {
                throw entry.failure;
            }
        }
        return didSucceed;
    }

    public void entityCreateFailed(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityException error) {
        LOGGER.debug((Object)("createFailed " + clientID + " " + transactionID), (Throwable)error);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.CREATE, null, error);
    }

    public void entityCreated(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        LOGGER.debug((Object)("entityCreated " + clientID + " " + transactionID + " " + id + " " + version));
        this.addNewEntityToMap(id, version, consumerID, canDelete, configuration);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.CREATE, null, null);
    }

    public void entityCreatedNoJournal(EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        LOGGER.debug((Object)("entityCreatedNoJournal " + id));
        this.addNewEntityToMap(id, version, consumerID, canDelete, configuration);
    }

    public boolean wasEntityDestroyedInJournal(ClientID clientID, long transactionID) throws EntityException {
        LOGGER.debug((Object)("wasEntityDestroyedInJournal " + clientID + " " + transactionID));
        boolean didSucceed = false;
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                didSucceed = true;
            } else {
                throw entry.failure;
            }
        }
        return didSucceed;
    }

    public void entityDestroyFailed(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityException error) {
        LOGGER.debug((Object)("entityDestroyFailed " + clientID + " " + transactionID));
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.DESTROY, null, error);
    }

    public void entityDestroyed(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id) {
        LOGGER.debug((Object)("entityDestroyed " + clientID + " " + transactionID + " " + id));
        EntityData.Key key = new EntityData.Key();
        key.className = id.getClassName();
        key.entityName = id.getEntityName();
        Assert.assertTrue((boolean)this.entities.containsKey(key));
        this.entities.remove(key);
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.DESTROY, null, null);
    }

    public byte[] reconfiguredResultInJournal(ClientID clientID, long transactionID) throws EntityException {
        LOGGER.debug((Object)("reconfiguredResultInJournal " + clientID + " " + transactionID));
        byte[] cachedResult = null;
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                Assert.assertNotNull((Object)entry.reconfigureResponse);
                cachedResult = entry.reconfigureResponse;
            } else {
                throw entry.failure;
            }
        }
        return cachedResult;
    }

    public void entityReconfigureFailed(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityException error) {
        LOGGER.debug((Object)("entityReconfigureFailed " + clientID + " " + transactionID));
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.RECONFIGURE, null, error);
    }

    public byte[] entityReconfigureSucceeded(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id, long version, byte[] configuration) {
        LOGGER.debug((Object)("entityReconfigureSucceeded " + clientID + " " + transactionID));
        String className = id.getClassName();
        String entityName = id.getEntityName();
        EntityData.Key key = new EntityData.Key();
        key.className = className;
        key.entityName = entityName;
        EntityData.Value val = this.entities.get(key);
        byte[] previousConfiguration = val.configuration;
        Assert.assertNotNull((Object)previousConfiguration);
        val.configuration = configuration;
        Assert.assertEquals((long)version, (long)val.version);
        this.entities.put(key, val);
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.RECONFIGURE, previousConfiguration, null);
        return previousConfiguration;
    }

    public long getNextConsumerID() {
        long consumerID = this.counters.get(COUNTERS_CONSUMER_ID);
        this.counters.put(COUNTERS_CONSUMER_ID, new Long(consumerID + 1L));
        this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
        return consumerID;
    }

    public void setNextConsumerID(long consumerID) {
        long checkID = this.counters.get(COUNTERS_CONSUMER_ID);
        if (consumerID >= checkID) {
            this.counters.put(COUNTERS_CONSUMER_ID, new Long(consumerID + 1L));
            this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
        }
    }

    public synchronized void removeTrackingForClient(ClientID sourceNodeID) {
        this.entityLifeJournal.remove(sourceNodeID);
    }

    private List<EntityData.JournalEntry> filterJournal(List<EntityData.JournalEntry> list, long oldestTransactionOnClient) {
        Assert.assertNotNull(list);
        Vector<EntityData.JournalEntry> newList = new Vector<EntityData.JournalEntry>();
        for (EntityData.JournalEntry entry : list) {
            if (entry.transactionID < oldestTransactionOnClient) continue;
            newList.add(entry);
        }
        return newList;
    }

    private synchronized void addToJournal(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityData.Operation operation, byte[] reconfigureResult, EntityException error) {
        List<EntityData.JournalEntry> rawJournal = this.entityLifeJournal.get(clientID);
        if (null == rawJournal) {
            rawJournal = new Vector<EntityData.JournalEntry>();
        }
        List<EntityData.JournalEntry> clientJournal = this.filterJournal(rawJournal, oldestTransactionOnClient);
        EntityData.JournalEntry newEntry = new EntityData.JournalEntry();
        newEntry.operation = operation;
        newEntry.transactionID = transactionID;
        newEntry.failure = error;
        newEntry.reconfigureResponse = reconfigureResult;
        clientJournal.add(newEntry);
        this.entityLifeJournal.put(clientID, clientJournal);
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
    }

    private synchronized EntityData.JournalEntry getEntryForTransaction(ClientID clientID, long transactionID) {
        EntityData.JournalEntry foundEntry = null;
        List<EntityData.JournalEntry> clientJournal = this.entityLifeJournal.get(clientID);
        LOGGER.debug((Object)("checking " + clientID + " " + clientJournal));
        if (null != clientJournal) {
            for (EntityData.JournalEntry entry : clientJournal) {
                if (entry.transactionID != transactionID) continue;
                foundEntry = entry;
                break;
            }
        }
        return foundEntry;
    }

    private void addNewEntityToMap(EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        String className = id.getClassName();
        String entityName = id.getEntityName();
        EntityData.Key key = new EntityData.Key();
        EntityData.Value value = new EntityData.Value();
        key.className = className;
        key.entityName = entityName;
        value.className = className;
        value.version = version;
        value.consumerID = consumerID;
        value.canDelete = canDelete;
        value.entityName = entityName;
        value.configuration = configuration;
        this.entities.put(key, value);
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
    }

    public synchronized void removeOrphanedClientsFromJournal(Set<ClientID> connectedClients) {
        this.entityLifeJournal.entrySet().removeIf(e -> !connectedClients.contains(e.getKey()));
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
    }

    public synchronized void serialize(ObjectOutput bucket) throws IOException {
        Set<ClientID> locals = this.entityLifeJournal.keySet();
        int size = locals.size();
        bucket.writeInt(size);
        for (ClientID local : locals) {
            bucket.writeObject(local);
            bucket.writeObject(this.entityLifeJournal.get(local));
        }
        bucket.writeLong(this.counters.get(COUNTERS_CONSUMER_ID));
    }

    public synchronized void layer(ObjectInput bucket) throws IOException {
        try {
            int size = bucket.readInt();
            LOGGER.debug((Object)("log size " + size));
            for (int x = 0; x < size; ++x) {
                ClientID key = (ClientID)bucket.readObject();
                List journal = (List)bucket.readObject();
                List<EntityData.JournalEntry> check = this.entityLifeJournal.get(key);
                if (check == null) {
                    this.entityLifeJournal.put(key, journal);
                    LOGGER.debug((Object)(key + " putting " + journal));
                    continue;
                }
                int pos = 0;
                for (EntityData.JournalEntry je : journal) {
                    while (pos < check.size() && check.get((int)pos).transactionID < je.transactionID) {
                        ++pos;
                    }
                    if (pos != check.size() && check.get((int)pos).transactionID == je.transactionID) continue;
                    check.add(pos, je);
                }
                LOGGER.debug((Object)(key + " layering " + journal + " " + check));
                this.entityLifeJournal.put(key, check);
            }
        }
        catch (ClassNotFoundException cnf) {
            throw new IOException(cnf);
        }
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
        long nextConsumer = bucket.readLong();
        this.counters.put(COUNTERS_CONSUMER_ID, nextConsumer);
        this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
    }

    private void storeToDisk(String dataName, Serializable dataElement) {
        try {
            this.storageManager.storeDataElement(dataName, dataElement);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing EntityPersistor map file", e);
        }
    }
}

