/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.terracotta.entity.StateDumpable;
import org.terracotta.entity.StateDumper;
import org.terracotta.persistence.IPlatformPersistence;

public class NullPlatformPersistentStorage
implements IPlatformPersistence,
StateDumpable {
    final Map<String, Serializable> nameToDataMap = new ConcurrentHashMap<String, Serializable>();
    final Map<Long, List<IPlatformPersistence.SequenceTuple>> fastSequenceCache = new HashMap<Long, List<IPlatformPersistence.SequenceTuple>>();

    public Serializable loadDataElement(String name) throws IOException {
        return this.nameToDataMap.get(name);
    }

    public Serializable loadDataElementInLoader(String name, ClassLoader loader) throws IOException {
        return this.nameToDataMap.get(name);
    }

    public void storeDataElement(String name, Serializable element) throws IOException {
        if (null == element) {
            this.nameToDataMap.remove(name);
        } else {
            this.nameToDataMap.put(name, element);
        }
    }

    public synchronized Future<Void> fastStoreSequence(long sequenceIndex, IPlatformPersistence.SequenceTuple newEntry, long oldestValidSequenceID) {
        List<IPlatformPersistence.SequenceTuple> sequence = this.fastSequenceCache.get(sequenceIndex);
        if (sequence == null) {
            sequence = new LinkedList<IPlatformPersistence.SequenceTuple>();
            this.fastSequenceCache.put(sequenceIndex, sequence);
        }
        if (!sequence.isEmpty()) {
            Iterator<IPlatformPersistence.SequenceTuple> tuple = sequence.iterator();
            while (tuple.hasNext() && tuple.next().localSequenceID < oldestValidSequenceID) {
                tuple.remove();
            }
        }
        sequence.add(newEntry);
        return CompletableFuture.completedFuture(null);
    }

    public synchronized List<IPlatformPersistence.SequenceTuple> loadSequence(long sequenceIndex) {
        return this.fastSequenceCache.get(sequenceIndex);
    }

    public synchronized void deleteSequence(long sequenceIndex) {
        this.fastSequenceCache.remove(sequenceIndex);
    }

    public void dumpStateTo(StateDumper stateDumper) {
        for (Map.Entry<String, Serializable> entry : this.nameToDataMap.entrySet()) {
            stateDumper.dumpState("key", entry.getKey());
        }
    }
}

