/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.objectserver.persistence.TransactionOrderPersistor;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import org.terracotta.persistence.IPlatformPersistence;

public class Persistor
implements PrettyPrintable {
    private final IPlatformPersistence persistentStorage;
    private boolean wasDBClean;
    private volatile boolean started = false;
    private final ClusterStatePersistor clusterStatePersistor;
    private ClientStatePersistor clientStatePersistor;
    private final EntityPersistor entityPersistor;
    private TransactionOrderPersistor transactionOrderPersistor;

    public Persistor(IPlatformPersistence persistentStorage) {
        this.persistentStorage = persistentStorage;
        this.clusterStatePersistor = new ClusterStatePersistor(persistentStorage);
        this.entityPersistor = new EntityPersistor(persistentStorage);
    }

    public void start() {
        this.clientStatePersistor = new ClientStatePersistor(this.persistentStorage);
        this.transactionOrderPersistor = new TransactionOrderPersistor(this.persistentStorage, this.clientStatePersistor.loadClientIDs());
        this.wasDBClean = this.clusterStatePersistor.isDBClean();
        this.started = true;
    }

    public void close() {
    }

    public ClientStatePersistor getClientStatePersistor() {
        this.checkStarted();
        return this.clientStatePersistor;
    }

    public ClusterStatePersistor getClusterStatePersistor() {
        return this.clusterStatePersistor;
    }

    public EntityPersistor getEntityPersistor() {
        return this.entityPersistor;
    }

    public TransactionOrderPersistor getTransactionOrderPersistor() {
        return this.transactionOrderPersistor;
    }

    protected final void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Persistor is not yet started.");
        }
    }

    public boolean wasDBClean() {
        return this.wasDBClean;
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print((Object)this.getClass().getName()).flush();
        if (!this.started) {
            out.indent().print((Object)"PersistorImpl not started.").flush();
        } else {
            out.println((Object)this.persistentStorage);
        }
        return out;
    }
}

