/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.net.ClientID;
import com.tc.object.tx.TransactionID;
import com.tc.util.AbstractIdentifier;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.terracotta.persistence.IPlatformPersistence;

public class TransactionOrderPersistor {
    private final IPlatformPersistence storageManager;
    private Long receivedTransactionCount = new Long(0L);
    private List<ClientTransaction> globalList = null;
    private final Set<Long> clientNodeIDs;

    public TransactionOrderPersistor(IPlatformPersistence storageManager, Set<ClientID> clients) {
        this.storageManager = storageManager;
        this.clientNodeIDs = new HashSet<Long>();
        for (ClientID oneClient : clients) {
            this.clientNodeIDs.add(oneClient.toLong());
        }
    }

    public synchronized Future<Void> updateWithNewMessage(ClientID source, TransactionID transactionID, TransactionID oldestTransactionOnClient) {
        if (null == oldestTransactionOnClient || null == transactionID) {
            throw new IllegalArgumentException("Transactions cannot be null");
        }
        if (oldestTransactionOnClient.compareTo((AbstractIdentifier)transactionID) > 0) {
            throw new IllegalArgumentException("Oldest transaction cannot come after new transaction");
        }
        this.globalList = null;
        this.clientNodeIDs.add(source.toLong());
        TransactionOrderPersistor transactionOrderPersistor = this;
        transactionOrderPersistor.receivedTransactionCount = transactionOrderPersistor.receivedTransactionCount + 1L;
        IPlatformPersistence.SequenceTuple transaction = new IPlatformPersistence.SequenceTuple();
        transaction.localSequenceID = transactionID.toLong();
        transaction.globalSequenceID = this.receivedTransactionCount;
        if (!source.isNull()) {
            return this.storageManager.fastStoreSequence(source.toLong(), transaction, oldestTransactionOnClient.toLong());
        }
        return null;
    }

    public synchronized void removeTrackingForClient(ClientID source) {
        long sourceID = source.toLong();
        try {
            this.storageManager.deleteSequence(sourceID);
        }
        catch (IOException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.clientNodeIDs.remove(sourceID);
    }

    private List<ClientTransaction> buildGlobalListIfNessessary() {
        if (null == this.globalList) {
            TreeMap<Long, ClientTransaction> sortMap = new TreeMap<Long, ClientTransaction>();
            for (long clientID : this.clientNodeIDs) {
                List transactions = null;
                try {
                    transactions = this.storageManager.loadSequence(clientID);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getLocalizedMessage());
                }
                for (IPlatformPersistence.SequenceTuple tuple : transactions) {
                    ClientTransaction transaction = new ClientTransaction();
                    transaction.clientID = clientID;
                    transaction.localTransactionID = tuple.localSequenceID;
                    transaction.globalTransactionID = tuple.globalSequenceID;
                    sortMap.put(tuple.globalSequenceID, transaction);
                }
            }
            this.globalList = Collections.unmodifiableList(new ArrayList(sortMap.values()));
            this.receivedTransactionCount = sortMap.size() != 0 ? (Long)sortMap.lastKey() : new Long(0L);
        }
        return this.globalList;
    }

    public int getIndexToReplay(ClientID source, TransactionID transaction) {
        long sourceID = source.toLong();
        long transactionID = transaction.toLong();
        int index = -1;
        List<ClientTransaction> list = this.buildGlobalListIfNessessary();
        int seek = 0;
        for (ClientTransaction oneTransaction : list) {
            if (oneTransaction.clientID == sourceID && oneTransaction.localTransactionID == transactionID) {
                index = seek;
                break;
            }
            ++seek;
        }
        return index;
    }

    public void clearAllRecords() {
        this.globalList = null;
        for (long nodeID : this.clientNodeIDs) {
            try {
                this.storageManager.deleteSequence(nodeID);
            }
            catch (IOException e) {
                Assert.fail((String)e.getLocalizedMessage());
            }
        }
        this.clientNodeIDs.clear();
    }

    public long getReceivedTransactionCount() {
        return this.receivedTransactionCount;
    }

    private static class ClientTransaction {
        public long clientID;
        public long localTransactionID;
        public long globalTransactionID;

        private ClientTransaction() {
        }

        public int hashCode() {
            return (int)(7L * this.clientID ^ 5L * this.localTransactionID ^ this.globalTransactionID);
        }

        public boolean equals(Object obj) {
            boolean isEqual;
            boolean bl = isEqual = obj == this;
            if (!isEqual && obj instanceof ClientTransaction) {
                ClientTransaction other = (ClientTransaction)obj;
                isEqual = this.clientID == other.clientID && this.localTransactionID == other.localTransactionID && this.globalTransactionID == other.globalTransactionID;
            }
            return isEqual;
        }
    }
}

