/*
 * Decompiled with CFR 0.152.
 */
package com.tc.operatorevent;

import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventHistoryProvider;
import com.tc.operatorevent.TerracottaOperatorEventImpl;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.concurrent.CircularLossyQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperatorEventHistoryProviderImpl
implements TerracottaOperatorEventHistoryProvider {
    private final CircularLossyQueue<TerracottaOperatorEvent> operatorEventHistory = new CircularLossyQueue(TCPropertiesImpl.getProperties().getInt("l2.operator.events.store", 1500));
    private final HashMap<String, Integer> unreadCounts = new HashMap();

    public OperatorEventHistoryProviderImpl() {
        for (TerracottaOperatorEvent.EventLevel severity : TerracottaOperatorEvent.EventLevel.values()) {
            this.unreadCounts.put(severity.name(), 0);
        }
    }

    public synchronized void push(TerracottaOperatorEvent event) {
        this.updateUnreadCounts(event, (TerracottaOperatorEvent)this.operatorEventHistory.push((Object)event));
    }

    public List<TerracottaOperatorEvent> getOperatorEvents() {
        Object[] operatorEvents = new TerracottaOperatorEventImpl[this.operatorEventHistory.depth()];
        this.operatorEventHistory.toArray(operatorEvents);
        return Arrays.asList(operatorEvents);
    }

    public List<TerracottaOperatorEvent> getOperatorEvents(long sinceTimestamp) {
        Date dateSince = new Date(sinceTimestamp);
        ArrayList<TerracottaOperatorEvent> eventList = new ArrayList<TerracottaOperatorEvent>();
        Object[] operatorEvents = new TerracottaOperatorEventImpl[this.operatorEventHistory.depth()];
        this.operatorEventHistory.toArray(operatorEvents);
        for (Object e : operatorEvents) {
            if (e == null || !e.getEventTime().after(dateSince)) continue;
            eventList.add((TerracottaOperatorEvent)e);
        }
        return eventList;
    }

    private void updateUnreadCounts(TerracottaOperatorEvent newEvent, TerracottaOperatorEvent removedEvent) {
        if (removedEvent != null && !removedEvent.isRead()) {
            this.incrementUnread(removedEvent, -1);
        }
        this.incrementUnread(newEvent, 1);
    }

    private void incrementUnread(TerracottaOperatorEvent operatorEvent, int count) {
        String eventLevelName = operatorEvent.getEventLevel().name();
        Integer value = this.unreadCounts.get(eventLevelName);
        this.unreadCounts.put(eventLevelName, value + count);
    }

    public Map<String, Integer> getUnreadCounts() {
        return new HashMap<String, Integer>(this.unreadCounts);
    }

    private boolean markRead(TerracottaOperatorEvent operatorEvent, boolean read) {
        if (read) {
            if (!operatorEvent.isRead()) {
                operatorEvent.markRead();
                this.incrementUnread(operatorEvent, -1);
                return true;
            }
            return false;
        }
        if (operatorEvent.isRead()) {
            operatorEvent.markUnread();
            this.incrementUnread(operatorEvent, 1);
            return true;
        }
        return false;
    }

    public synchronized boolean markOperatorEvent(TerracottaOperatorEvent operatorEvent, boolean read) {
        List<TerracottaOperatorEvent> operatorEvents = this.getOperatorEvents();
        for (TerracottaOperatorEvent event : operatorEvents) {
            if (!event.equals(operatorEvent)) continue;
            return this.markRead(event, read);
        }
        return false;
    }
}

