/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.async.api.SEDA;
import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.CommonL2Config;
import com.tc.config.schema.L2Info;
import com.tc.config.schema.ServerGroupInfo;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.lang.StartupHelper;
import com.tc.lang.TCThreadGroup;
import com.tc.lang.ThrowableHandler;
import com.tc.lang.ThrowableHandlerImpl;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.beans.L2Dumper;
import com.tc.management.beans.L2MBeanNames;
import com.tc.management.beans.TCDumper;
import com.tc.management.beans.TCServerInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.HttpConnectionContext;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.ConnectionPolicyImpl;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.operatorevent.TerracottaOperatorEventHistoryProvider;
import com.tc.server.TCServer;
import com.tc.server.TCServerActivationListener;
import com.tc.stats.DSO;
import com.tc.text.StringUtils;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import com.tc.util.State;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.io.IOUtils;

public class TCServerImpl
extends SEDA<HttpConnectionContext>
implements TCServer,
StateChangeListener {
    public static final String CONNECTOR_NAME_TERRACOTTA = "terracotta";
    private static final TCLogger logger = TCLogging.getLogger(TCServer.class);
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private volatile long startTime = -1L;
    private volatile long activateTime = -1L;
    protected DistributedObjectServer dsoServer;
    private final Object stateLock = new Object();
    private State serverState = StateManager.START_STATE;
    private final L2ConfigurationSetupManager configurationSetupManager;
    protected final ConnectionPolicy connectionPolicy;
    private boolean shutdown = false;
    protected final TCSecurityManager securityManager;
    private TCServerActivationListener activationListener;

    public TCServerImpl(L2ConfigurationSetupManager configurationSetupManager) {
        this(configurationSetupManager, new TCThreadGroup((ThrowableHandler)new ThrowableHandlerImpl(TCLogging.getLogger(TCServer.class))));
    }

    public TCServerImpl(L2ConfigurationSetupManager configurationSetupManager, TCThreadGroup threadGroup) {
        this(configurationSetupManager, threadGroup, (ConnectionPolicy)new ConnectionPolicyImpl(Integer.MAX_VALUE));
    }

    public TCServerImpl(L2ConfigurationSetupManager manager, TCThreadGroup group, ConnectionPolicy connectionPolicy) {
        super(group);
        this.connectionPolicy = connectionPolicy;
        Assert.assertNotNull((Object)manager);
        this.configurationSetupManager = manager;
        this.securityManager = this.configurationSetupManager.isSecure() ? null : null;
    }

    public synchronized void setState(State state) {
        if (!this.validateState(state)) {
            throw new AssertionError((Object)("Unrecognized server state: [" + state.getName() + "]"));
        }
        this.serverState = state;
    }

    private boolean validateState(State state) {
        return StateManager.VALID_STATES.contains(state);
    }

    @Override
    public ServerGroupInfo getStripeInfo() {
        L2Info[] l2Infos = this.infoForAllL2s();
        ActiveServerGroupConfig groupInfo = this.configurationSetupManager.getActiveServerGroupForThisL2();
        ArrayList<L2Info> memberList = new ArrayList<L2Info>();
        for (L2Info l2Info : l2Infos) {
            if (!groupInfo.isMember(l2Info.name())) continue;
            memberList.add(l2Info);
        }
        return new ServerGroupInfo(memberList.toArray(new L2Info[0]), groupInfo.getGroupName(), true);
    }

    @Override
    public L2Info[] infoForAllL2s() {
        String[] allKnownL2s = this.configurationSetupManager.allCurrentlyKnownServers();
        L2Info[] out = new L2Info[allKnownL2s.length];
        for (int i = 0; i < out.length; ++i) {
            try {
                String host;
                CommonL2Config config = this.configurationSetupManager.commonL2ConfigFor(allKnownL2s[i]);
                String name = allKnownL2s[i];
                if (name == null) {
                    name = "localhost";
                }
                if ("0.0.0.0".equals(host = config.tsaPort().getBind())) {
                    host = config.host();
                }
                if (StringUtils.isBlank((String)host)) {
                    host = name;
                }
                out[i] = new L2Info(name, host, config.tsaPort().getValue() + 10, config.tsaPort().getValue(), config.tsaGroupPort().getBind(), config.tsaGroupPort().getValue(), config.tsaGroupPort().getValue() + 1, "");
                continue;
            }
            catch (ConfigurationSetupException cse) {
                throw Assert.failure((Object)"This should be impossible here", (Throwable)cse);
            }
        }
        return out;
    }

    @Override
    public String getL2Identifier() {
        return this.configurationSetupManager.getL2Identifier();
    }

    @Override
    public String getDescriptionOfCapabilities() {
        if (ProductInfo.getInstance().isEnterprise()) {
            return "Enterprise capabilities";
        }
        return "Open source capabilities";
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("Management can no longer request a server shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isStarted()) {
                try {
                    this.startServer();
                }
                catch (Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            } else {
                logger.warn((Object)("Server in incorrect state (" + this.serverState + ") to be started."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canShutdown() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.serverState.equals((Object)StateManager.PASSIVE_STANDBY) || this.serverState.equals((Object)StateManager.ACTIVE_COORDINATOR) || this.serverState.equals((Object)StateManager.PASSIVE_UNINITIALIZED) || this.serverState.equals((Object)StateManager.PASSIVE_SYNCING);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.canShutdown()) {
            this.setState(StateManager.STOP_STATE);
            consoleLogger.info((Object)"Server exiting...");
            this.notifyShutdown();
            Runtime.getRuntime().exit(0);
        } else {
            logger.warn((Object)("Server in incorrect state (" + this.serverState + ") to be shutdown."));
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void updateActivateTime() {
        if (this.activateTime == -1L) {
            this.activateTime = System.currentTimeMillis();
        }
    }

    @Override
    public long getActivateTime() {
        return this.activateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfig() {
        InputStream is = null;
        try {
            is = this.configurationSetupManager.rawConfigFile();
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
        catch (IOException ioe) {
            String string = ioe.getLocalizedMessage();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Override
    public int getTSAListenPort() {
        if (this.dsoServer != null) {
            return this.dsoServer.getListenPort();
        }
        throw new IllegalStateException("TSA Server not running");
    }

    @Override
    public int getTSAGroupPort() {
        if (this.dsoServer != null) {
            return this.dsoServer.getGroupPort();
        }
        throw new IllegalStateException("TSA Server not running");
    }

    public DistributedObjectServer getDSOServer() {
        return this.dsoServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        Object object = this.stateLock;
        synchronized (object) {
            return !this.serverState.equals((Object)StateManager.START_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.serverState.equals((Object)StateManager.ACTIVE_COORDINATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStopped() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.serverState.equals((Object)StateManager.START_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPassiveUnitialized() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.serverState.equals((Object)StateManager.PASSIVE_UNINITIALIZED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPassiveStandby() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.serverState.equals((Object)StateManager.PASSIVE_STANDBY);
        }
    }

    @Override
    public State getState() {
        return this.serverState;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Server: ").append(super.toString()).append("\n");
        if (this.isActive()) {
            buf.append("Active since ").append(new Date(this.getStartTime())).append("\n");
        } else if (this.isStarted()) {
            buf.append("Started at ").append(new Date(this.getStartTime())).append("\n");
        } else {
            buf.append("Server is stopped").append("\n");
        }
        return buf.toString();
    }

    protected void startServer() throws Exception {
        new StartupHelper((ThreadGroup)this.getThreadGroup(), (StartupHelper.StartupAction)new StartAction()).startUp();
    }

    private void startDSOServer() throws Exception {
        Assert.assertTrue((boolean)this.isStopped());
        this.dsoServer = this.createDistributedObjectServer(this.configurationSetupManager, this.connectionPolicy, this);
        this.dsoServer.start();
        this.registerDSOServer(this.dsoServer);
    }

    protected DistributedObjectServer createDistributedObjectServer(L2ConfigurationSetupManager configSetupManager, ConnectionPolicy policy, TCServerImpl serverImpl) {
        DistributedObjectServer dso = new DistributedObjectServer(configSetupManager, this.getThreadGroup(), policy, this, this, this.securityManager);
        try {
            this.registerServerMBeans(dso, ManagementFactory.getPlatformMBeanServer());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException exp) {
            throw new RuntimeException(exp);
        }
        return dso;
    }

    @Override
    public void dump() {
        if (this.dsoServer != null) {
            this.dsoServer.dump();
        }
    }

    private void registerDSOServer(TCDumper dumper) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, NullPointerException {
        ServerManagementContext mgmtContext = this.dsoServer.getManagementContext();
        ServerConfigurationContext configContext = this.dsoServer.getContext();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerDSOMBeans(mgmtContext, configContext, dumper, mBeanServer);
    }

    protected void registerServerMBeans(TCDumper tcDumper, MBeanServer mBeanServer) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        mBeanServer.registerMBean(new TCServerInfo(this), L2MBeanNames.TC_SERVER_INFO);
        mBeanServer.registerMBean(new L2Dumper(tcDumper, mBeanServer), L2MBeanNames.DUMPER);
    }

    protected void unregisterServerMBeans(MBeanServer mbs) throws MBeanRegistrationException, InstanceNotFoundException {
        mbs.unregisterMBean(L2MBeanNames.TC_SERVER_INFO);
        mbs.unregisterMBean(L2MBeanNames.DUMPER);
    }

    protected void registerDSOMBeans(ServerManagementContext mgmtContext, ServerConfigurationContext configContext, TCDumper tcDumper, MBeanServer mBeanServer) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        TerracottaOperatorEventHistoryProvider operatorEventHistoryProvider = this.dsoServer.getOperatorEventsHistoryProvider();
        DSO dso = new DSO(mgmtContext, configContext, mBeanServer, operatorEventHistoryProvider);
        mBeanServer.registerMBean(dso, L2MBeanNames.DSO);
    }

    protected void unregisterDSOMBeans(MBeanServer mbs) throws MBeanRegistrationException, InstanceNotFoundException {
        mbs.unregisterMBean(L2MBeanNames.DSO);
    }

    public void setActivationListener(TCServerActivationListener listener) {
        this.activationListener = listener;
    }

    private synchronized void notifyShutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    @Override
    public synchronized void waitUntilShutdown() {
        while (!this.shutdown) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public void reloadConfiguration() throws ConfigurationSetupException {
        this.dsoServer.reloadConfiguration();
    }

    @Override
    public String[] processArguments() {
        return this.configurationSetupManager.processArguments();
    }

    @Override
    public void dumpClusterState() {
        if (this.dsoServer != null) {
            this.dsoServer.dumpClusterState();
        }
    }

    @Override
    public String getResourceState() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void l2StateChanged(StateChangedEvent sce) {
        Object object = this.stateLock;
        synchronized (object) {
            this.serverState = sce.getCurrentState();
        }
    }

    private class StartAction
    implements StartupHelper.StartupAction {
        private StartAction() {
        }

        public void execute() throws Throwable {
            String l2Identifier;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Starting Terracotta server instance...");
            }
            TCServerImpl.this.startTime = System.currentTimeMillis();
            if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
                consoleLogger.info((Object)("Available Max Runtime Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB"));
            }
            TCServerImpl.this.startDSOServer();
            if (TCServerImpl.this.isActive()) {
                TCServerImpl.this.updateActivateTime();
                if (TCServerImpl.this.activationListener != null) {
                    TCServerImpl.this.activationListener.serverActivated();
                }
            }
            if ((l2Identifier = TCServerImpl.this.configurationSetupManager.getL2Identifier()) != null) {
                logger.info((Object)("Server started as " + l2Identifier));
            }
        }
    }
}

