/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.classloader.ServiceLocator;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.config.schema.setup.StandardConfigurationSetupManagerFactory;
import com.tc.lang.TCThreadGroup;
import com.tc.lang.ThrowableHandler;
import com.tc.lang.ThrowableHandlerImpl;
import com.tc.logging.TCLogging;
import com.tc.server.ServerFactory;
import com.tc.server.ServiceClassLoader;
import com.tc.server.TCServer;
import org.terracotta.config.service.ServiceConfigParser;

public class TCServerMain {
    public static TCServer server;
    public static L2ConfigurationSetupManager setup;

    public static void main(String[] args) {
        ThrowableHandlerImpl throwableHandler = new ThrowableHandlerImpl(TCLogging.getLogger(TCServerMain.class));
        try {
            TCThreadGroup threadGroup = new TCThreadGroup((ThrowableHandler)throwableHandler);
            StandardConfigurationSetupManagerFactory factory = new StandardConfigurationSetupManagerFactory(args, StandardConfigurationSetupManagerFactory.ConfigMode.L2, null);
            ClassLoader systemLoader = ServiceLocator.getPlatformLoader();
            Thread.currentThread().setContextClassLoader(systemLoader);
            setup = factory.createL2TVSConfigurationSetupManager(null, new ServiceClassLoader(ServiceLocator.getImplementations(ServiceConfigParser.class, systemLoader)));
            server = ServerFactory.createServer(setup, threadGroup);
            server.start();
            server.waitUntilShutdown();
        }
        catch (Throwable t) {
            throwableHandler.handleThrowable(Thread.currentThread(), t);
        }
    }

    public static TCServer getServer() {
        return server;
    }

    public static L2ConfigurationSetupManager getSetupManager() {
        return setup;
    }
}

