/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.entity.ServerEntityMessage;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ClientInstanceID;
import com.tc.services.ResponseWaiter;
import java.util.HashMap;
import java.util.Map;

public class ClientAccount {
    private final MessageChannel channel;
    private final Map<Long, ResponseWaiter> waitingResponse = new HashMap<Long, ResponseWaiter>();
    private volatile boolean open = true;
    private long responseId = 0L;

    ClientAccount(MessageChannel channel) {
        this.channel = channel;
    }

    synchronized ResponseWaiter send(ClientInstanceID clientInstance, byte[] payload) {
        ResponseWaiter responseWaiter = new ResponseWaiter();
        if (!this.open) {
            responseWaiter.done();
        } else {
            this.waitingResponse.put(this.responseId, responseWaiter);
            ServerEntityMessage message = (ServerEntityMessage)this.channel.createMessage(TCMessageType.SERVER_ENTITY_MESSAGE);
            message.setMessage(clientInstance, payload, this.responseId++);
            if (!message.send() && this.waitingResponse.remove(this.responseId, responseWaiter)) {
                responseWaiter.done();
            }
        }
        return responseWaiter;
    }

    synchronized void sendNoResponse(ClientInstanceID clientInstance, byte[] payload) {
        if (this.open) {
            ServerEntityMessage message = (ServerEntityMessage)this.channel.createMessage(TCMessageType.SERVER_ENTITY_MESSAGE);
            message.setMessage(clientInstance, payload);
            if (!message.send()) {
                // empty if block
            }
        }
    }

    synchronized void close() {
        this.open = false;
        for (ResponseWaiter responseWaiter : this.waitingResponse.values()) {
            responseWaiter.done();
        }
    }

    synchronized void response(long responseId) {
        ResponseWaiter responseWaiter;
        if (this.open && (responseWaiter = this.waitingResponse.remove(responseId)) != null) {
            responseWaiter.done();
        }
    }
}

